/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dynamiccon;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.util.APIEnums;
import jet.server.api.admin.DynamicConnectionRecord;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;

public class DynamicConnectionTable
extends TableImpl {
    public static final int VERSION = 2;
    public static final int OLD_VERSION_1 = 1;
    public static final String TABLE_NAME = "DYNAMIC_CONNECTIONS_2";
    private static final String[] BLOB = new String[]{"CONN_ID", "ORG_NAME", "CATALOG", "DATASOURCRE", "CONNECTION_NAME", "CONN_PROPERTIES"};
    private static final int EMPTY = 0;
    private static final int INTEGER = 1;
    private static final int SEDU = 2;
    private static final int VARCHAR = 3;
    private static final int add = 4;
    private static final int append = 5;

    public DynamicConnectionTable(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BLOB[0], JDBCType.INTEGER, 0, 11, 0));
        super.append(new FieldImpl(this.getName(), BLOB[1], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), BLOB[2], JDBCType.VARCHAR, 512, 1, 0));
        super.append(new FieldImpl(this.getName(), BLOB[3], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), BLOB[4], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), BLOB[5], JDBCType.BLOB, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public void initID() throws InstantiationException, SQLException {
        int n = this.BLOB();
        if (n == Integer.MIN_VALUE) {
            n = -1;
        }
        this.adapter.setID(this, this.fields(BLOB[0]), n + 1);
    }

    @Override
    public void mergeOldTable(Table table, int n) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields(BLOB[0]).getValue());
            fieldValueArray[1].setValue(recordset.fields(BLOB[1]).getValue());
            fieldValueArray[2].setValue(recordset.fields(BLOB[2]).getValue());
            fieldValueArray[3].setValue(recordset.fields(BLOB[3]).getValue());
            fieldValueArray[4].setValue(null);
            fieldValueArray[5].setValue(recordset.fields(BLOB[5]).getValue());
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    private int BLOB() {
        try {
            return super.queryMaxValue(BLOB[0], null, ParameterMetaInfo.EMPTY, true).intValue();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    int nextRecordId() throws SQLException {
        return this.adapter.getID(this, this.fields(BLOB[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getDynamicConnections(String string, String string2, String string3, String string4) throws SQLException, IOException {
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        StringBuilder stringBuilder = new StringBuilder().append("WHERE 0=0");
        if (string != null) {
            stringBuilder.append(" AND ").append(this.fields(1).getName()).append("=?");
            parameterMetaInfo.add("orgName", string);
        }
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(" AND ").append(this.fields(2).getName()).append("=?");
            parameterMetaInfo.add("catalog", string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            stringBuilder.append(" AND ").append(this.fields(3).getName()).append("=?");
            parameterMetaInfo.add("datasource", string3);
        }
        if (string4 != null && !string4.isEmpty()) {
            stringBuilder.append(" AND ").append(this.fields(4).getName()).append("=?");
            parameterMetaInfo.add("connectionName", string4);
        }
        parameterMetaInfo = parameterMetaInfo.getParameterCount() == 0 ? ParameterMetaInfo.EMPTY : parameterMetaInfo;
        ArrayList<DynamicConnectionRecord> arrayList = new ArrayList<DynamicConnectionRecord>();
        Recordset recordset = super.query(this.fields().toArray(), stringBuilder.toString(), parameterMetaInfo, false, 1, 1003);
        try {
            while (recordset.next()) {
                DynamicConnectionRecord dynamicConnectionRecord = new DynamicConnectionRecord();
                dynamicConnectionRecord.setRecordId(recordset.getInt(0));
                dynamicConnectionRecord.setOrgName(recordset.getString(1));
                dynamicConnectionRecord.setCatalog(recordset.getString(2));
                dynamicConnectionRecord.setDatasource(recordset.getString(3));
                dynamicConnectionRecord.setConnectionName(recordset.getString(4));
                byte[] byArray = recordset.getBytes(5);
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(byArray));
                DynamicConnectionTable.SEDU(dynamicConnectionRecord, properties);
                arrayList.add(dynamicConnectionRecord);
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    void insertDynamicConnection(DynamicConnectionRecord dynamicConnectionRecord) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Properties properties = DynamicConnectionTable.INTEGER(dynamicConnectionRecord);
        properties.store(byteArrayOutputStream, "");
        FieldValue[] fieldValueArray = this.fields().values();
        fieldValueArray[0].setValue(dynamicConnectionRecord.getRecordId());
        fieldValueArray[1].setValue(dynamicConnectionRecord.getOrgName());
        fieldValueArray[2].setValue(dynamicConnectionRecord.getCatalog());
        fieldValueArray[3].setValue(dynamicConnectionRecord.getDatasource());
        fieldValueArray[4].setValue(dynamicConnectionRecord.getConnectionName());
        fieldValueArray[5].setValue(byteArrayOutputStream.toByteArray());
        super.insert(fieldValueArray);
    }

    boolean updateDynamicConnection(DynamicConnectionRecord dynamicConnectionRecord) throws IOException, SQLException {
        StringBuilder stringBuilder = new StringBuilder().append("WHERE ").append(this.fields(0).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("connectionId", dynamicConnectionRecord.getRecordId());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Properties properties = DynamicConnectionTable.INTEGER(dynamicConnectionRecord);
        properties.store(byteArrayOutputStream, "");
        FieldValue[] fieldValueArray = new FieldValue[]{this.fields(2).createFieldValue(), this.fields(3).createFieldValue(), this.fields(4).createFieldValue(), this.fields(5).createFieldValue(), this.fields(1).createFieldValue()};
        fieldValueArray[0].setValue(dynamicConnectionRecord.getCatalog());
        fieldValueArray[1].setValue(dynamicConnectionRecord.getDatasource());
        fieldValueArray[2].setValue(dynamicConnectionRecord.getConnectionName());
        fieldValueArray[3].setValue(byteArrayOutputStream.toByteArray());
        fieldValueArray[4].setValue(dynamicConnectionRecord.getOrgName());
        return super.update(fieldValueArray, stringBuilder.toString(), parameterMetaInfo) == 1;
    }

    void deleteDynamicConnection(int n) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder().append("WHERE ").append(this.fields(0).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("connectionId", n);
        super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    private static void EMPTY(Properties properties, String string, Object object) {
        if (object != null) {
            if (object instanceof Enum) {
                object = ((Enum)object).name();
            }
            properties.setProperty(string, object.toString());
        }
    }

    private static Properties INTEGER(DynamicConnectionRecord dynamicConnectionRecord) {
        Properties properties = new Properties();
        DynamicConnectionTable.EMPTY(properties, "name", dynamicConnectionRecord.getName());
        DynamicConnectionTable.EMPTY(properties, "desc", dynamicConnectionRecord.getDescription());
        DynamicConnectionTable.EMPTY(properties, "isJndiDatasource", dynamicConnectionRecord.isJndiDatasource());
        DynamicConnectionTable.EMPTY(properties, "jndiDatasourceName", dynamicConnectionRecord.getJndiDatasourceName());
        DynamicConnectionTable.EMPTY(properties, "url", dynamicConnectionRecord.getURL());
        DynamicConnectionTable.EMPTY(properties, "jdbcDriver", dynamicConnectionRecord.getJdbcDriver());
        DynamicConnectionTable.EMPTY(properties, "dateFormat", dynamicConnectionRecord.getDateFormat());
        DynamicConnectionTable.EMPTY(properties, "namePattern", (Object)dynamicConnectionRecord.getNamePattern());
        DynamicConnectionTable.EMPTY(properties, "readOnly", (Object)dynamicConnectionRecord.getReadOnly());
        DynamicConnectionTable.EMPTY(properties, "timeFormat", dynamicConnectionRecord.getTimeFormat());
        DynamicConnectionTable.EMPTY(properties, "timestampFormat", dynamicConnectionRecord.getTimestampFormat());
        DynamicConnectionTable.EMPTY(properties, "transactionIsolation", (Object)dynamicConnectionRecord.getTransactionIsolation());
        DynamicConnectionTable.EMPTY(properties, "extraCharacters", dynamicConnectionRecord.getExtraCharacters());
        DynamicConnectionTable.EMPTY(properties, "quoteCharacter", dynamicConnectionRecord.getQuoteCharacter());
        DynamicConnectionTable.EMPTY(properties, "databaseUser", dynamicConnectionRecord.getDatabaseUser());
        DynamicConnectionTable.EMPTY(properties, "databasePassword", dynamicConnectionRecord.getDatabasePassword());
        return properties;
    }

    private static void SEDU(DynamicConnectionRecord dynamicConnectionRecord, Properties properties) {
        dynamicConnectionRecord.setName(properties.getProperty("name"));
        dynamicConnectionRecord.setDescription(properties.getProperty("desc"));
        dynamicConnectionRecord.setIsJndiDatasource(properties.getProperty("isJndiDatasource") == null ? null : Boolean.valueOf(CSUtil.getBoolean(properties.getProperty("isJndiDatasource"))));
        dynamicConnectionRecord.setJndiDatasourceName(properties.getProperty("jndiDatasourceName"));
        dynamicConnectionRecord.setURL(properties.getProperty("url"));
        dynamicConnectionRecord.setJdbcDriver(properties.getProperty("jdbcDriver"));
        dynamicConnectionRecord.setDateFormat(properties.getProperty("dateFormat"));
        try {
            dynamicConnectionRecord.setNamePattern(APIEnums.ConnectionNamePattern.valueOf(properties.getProperty("namePattern")));
        }
        catch (Exception exception) {
            dynamicConnectionRecord.setNamePattern(null);
        }
        try {
            dynamicConnectionRecord.setReadOnly(APIEnums.ConnectionReadOnly.valueOf(properties.getProperty("readOnly")));
        }
        catch (Exception exception) {
            dynamicConnectionRecord.setReadOnly(null);
        }
        dynamicConnectionRecord.setTimeFormat(properties.getProperty("timeFormat"));
        dynamicConnectionRecord.setTimestampFormat(properties.getProperty("timestampFormat"));
        try {
            dynamicConnectionRecord.setTransactionIsolation(APIEnums.ConnectionTransactionIsolation.valueOf(properties.getProperty("transactionIsolation")));
        }
        catch (Exception exception) {
            dynamicConnectionRecord.setTransactionIsolation(null);
        }
        dynamicConnectionRecord.setExtraCharacters(properties.getProperty("extraCharacters"));
        dynamicConnectionRecord.setQuoteCharacter(properties.getProperty("quoteCharacter"));
        dynamicConnectionRecord.setDatabaseUser(properties.getProperty("databaseUser"));
        dynamicConnectionRecord.setDatabasePassword(properties.getProperty("databasePassword"));
    }

    public void dropTable(Table table) throws SQLException {
        this.adapter.dropTable(table);
    }
}

