/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dynamiccon;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jet.cs.Base64Ex;
import jet.cs.util.APIEnums;
import jet.server.api.admin.DynamicConnectionRecord;
import jet.server.api.admin.DynamicConnectionUserMapping;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.dynamiccon.DynamicConnectionTable;

public class DynamicConnectionUserMappingTable
extends TableImpl {
    public static final int VERSION = 2;
    public static final int OLD_VERSION = 1;
    public static final String TABLE_NAME = "DYNAMIC_CONNECTIONS_MAPPING_2";
    private static final String[] EMPTY = new String[]{"CONN_ID", "PRINCIPAL", "PRINCIPAL_TYPE", "DB_USER", "DB_PASSWORD"};
    private static final int INTEGER = 0;
    private static final int SEDU = 1;
    private static final int USER = 2;
    private static final int VARCHAR = 3;
    private static final int add = 4;
    private static final String append = new Character('\u0000').toString();
    private static final String close = "UTF-8";

    public DynamicConnectionUserMappingTable(Database database, DynamicConnectionTable dynamicConnectionTable, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), EMPTY[0], JDBCType.INTEGER, 0, 41, 0, dynamicConnectionTable.getName()));
        super.append(new FieldImpl(this.getName(), EMPTY[1], JDBCType.VARCHAR, 512, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[2], JDBCType.VARCHAR, 64, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[3], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[4], JDBCType.VARCHAR, 256, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    @Override
    public void mergeOldTable(Table table, int n) throws SQLException {
        super.mergeOldTable(table, n);
    }

    private static String EMPTY(String string) {
        string = string == null ? append : string;
        try {
            byte[] byArray = Base64Ex.encode(string.getBytes(close));
            return new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String INTEGER(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = Base64Ex.decode(string);
            String string2 = new String(byArray, close);
            return append.equals(string2) ? null : string2;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDynamicConnectionMappings(List list) throws SQLException {
        if (list == null || list.isEmpty()) {
            return;
        }
        HashMap<Integer, DynamicConnectionRecord> hashMap = new HashMap<Integer, DynamicConnectionRecord>();
        for (DynamicConnectionRecord dynamicConnectionRecord : list) {
            hashMap.put(dynamicConnectionRecord.getRecordId(), dynamicConnectionRecord);
        }
        Recordset recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
        try {
            while (recordset.next()) {
                DynamicConnectionRecord dynamicConnectionRecord;
                dynamicConnectionRecord = (DynamicConnectionRecord)hashMap.get(recordset.getInt(0));
                if (dynamicConnectionRecord == null) continue;
                DynamicConnectionUserMapping dynamicConnectionUserMapping = new DynamicConnectionUserMapping();
                dynamicConnectionUserMapping.setPrincipal(recordset.getString(1));
                try {
                    dynamicConnectionUserMapping.setPrincipalType(APIEnums.PrincipalType.valueOf(recordset.getString(2)));
                }
                catch (Exception exception) {
                    dynamicConnectionUserMapping.setPrincipalType(APIEnums.PrincipalType.USER);
                }
                dynamicConnectionUserMapping.setDatabaseUser(recordset.getString(3));
                dynamicConnectionUserMapping.setDatabasePassword(DynamicConnectionUserMappingTable.INTEGER(recordset.getString(4)));
                dynamicConnectionRecord.getUserMapping().add(dynamicConnectionUserMapping);
            }
        }
        finally {
            recordset.close();
        }
    }

    void insertDynamicConnectionMappings(DynamicConnectionRecord dynamicConnectionRecord) throws IOException, SQLException {
        if (dynamicConnectionRecord.getUserMapping().isEmpty()) {
            return;
        }
        ArrayList<FieldValue[]> arrayList = new ArrayList<FieldValue[]>();
        for (DynamicConnectionUserMapping dynamicConnectionUserMapping : dynamicConnectionRecord.getUserMapping()) {
            FieldValue[] fieldValueArray = this.fields().values();
            fieldValueArray[0].setValue(dynamicConnectionRecord.getRecordId());
            fieldValueArray[1].setValue(dynamicConnectionUserMapping.getPrincipal());
            fieldValueArray[2].setValue(dynamicConnectionUserMapping.getPrincipalType().name());
            fieldValueArray[3].setValue(dynamicConnectionUserMapping.getDatabaseUser());
            fieldValueArray[4].setValue(DynamicConnectionUserMappingTable.EMPTY(dynamicConnectionUserMapping.getDatabasePassword()));
            arrayList.add(fieldValueArray);
        }
        super.insert(arrayList);
    }

    void deleteDynamicConnectionMappings(int n) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder().append("WHERE ").append(this.fields(0).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("connectionId", n);
        super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    public void dropTable(Table table) throws SQLException {
        this.adapter.dropTable(table);
    }
}

