/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.event;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.db.event.RecordEventListener;
import jet.server.db.event.RecordEventType;
import jet.server.db.event.VersionRecordEvent;
import jet.server.db.version.AbstractVersionRecord;
import jet.server.intf.jrs.VersionService;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.ResourceInfo;
import jet.server.jrc.resource.ResourceImpl;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;

public class VersionEventListener
extends MapListenerAdapter
implements RecordEventListener {
    private Storage HISTORY;
    private VersionService SEDU;
    private Map add;
    private ClusterMap afterPut;

    VersionEventListener() {
        try {
            this.HISTORY = StorageEnv.getStorage();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
    }

    private void HISTORY(AbstractVersionRecord abstractVersionRecord) {
        Node node = (Node)this.add.get(abstractVersionRecord.getResourceID());
        if (node != null && node instanceof ResourceImpl) {
            ResourceImpl resourceImpl = (ResourceImpl)node;
            ResourceInfo resourceInfo = this.SEDU.getLatestVersion(node.getID(), resourceImpl.getResourceType());
            resourceImpl.setEntity(resourceInfo);
        }
    }

    public void onChanged(VersionRecordEvent versionRecordEvent) {
        RecordEventType recordEventType = versionRecordEvent.getType();
        try {
            if (recordEventType == RecordEventType.deleted) {
                this.delete(versionRecordEvent.getFilePath());
            } else if (recordEventType == RecordEventType.inserted) {
                this.add(versionRecordEvent.getFilePath());
            }
            AbstractVersionRecord abstractVersionRecord = versionRecordEvent.getVersionRecord();
            if (recordEventType == RecordEventType.updated || recordEventType == RecordEventType.deleted) {
                this.HISTORY(abstractVersionRecord);
                this.afterPut.put((Object)0, abstractVersionRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
    }

    private String SEDU(String string) throws IOException, StorageException {
        String string2 = StorageEnv.getStorageEnv(StorageEnv.getThreadMember()).relativeStoragePath(Storage.StorageRoot.HISTORY, string, 2);
        ServiceLogger.logDebug(6690072, new Object[]{string, string2}, 6);
        return string2;
    }

    public File get(String string) throws IOException, StorageException {
        return this.HISTORY.get(Storage.StorageRoot.HISTORY, this.SEDU(string));
    }

    public void delete(String string) throws IOException, StorageException {
        if (string != null) {
            this.HISTORY.delete(Storage.StorageRoot.HISTORY, this.SEDU(string));
        }
    }

    public void add(String string) throws IOException, StorageException {
        this.HISTORY.add(Storage.StorageRoot.HISTORY, this.SEDU(string), StorageEnv.getThreadMember(), true);
    }

    public void afterPut(String string, int n, Integer n2, AbstractVersionRecord abstractVersionRecord, AbstractVersionRecord abstractVersionRecord2, MapFlags mapFlags) {
        if (VersionEventListener.isLocalEvent(n)) {
            return;
        }
        this.HISTORY(abstractVersionRecord);
    }

    public VersionService getVersionService() {
        return this.SEDU;
    }

    public void setVersionService(VersionService versionService) {
        this.SEDU = versionService;
    }

    public Map getNodeIdMap() {
        return this.add;
    }

    public void setNodeIdMap(Map map) {
        this.add = map;
    }

    public ClusterMap getVersionRecordMap() {
        return this.afterPut;
    }

    public void setVersionRecordMap(ClusterMap clusterMap) {
        this.afterPut = clusterMap;
    }
}

