/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.nls;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.nls.NLSType;
import jet.server.api.nls.TextNLSEntry;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.jrc.resource.nls.GlobalNLSRecord;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class GlobalNLSTextTable
extends TableImpl {
    public static final int VERSION = 1;
    public static final String TABLE_NAME = "GLOBAL_NLS_TEXT_1";
    private static final String[] EMPTY = new String[]{"LOC", "NLS_TYPE", "KEY_TEXT", "VALUE_TEXT"};
    private static final int INTEGER = 0;
    private static final int SEDU = 1;
    private static final int VARCHAR = 2;
    private static final int add = 3;
    private static final int append = -1;
    private static final String appendSystemTable = "__PLACE_HOLD";

    GlobalNLSTextTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), EMPTY[0], JDBCType.VARCHAR, 10, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[1], JDBCType.INTEGER, 0, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[2], JDBCType.VARCHAR, 255, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[3], JDBCType.VARCHAR, 512, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        ((DatabaseImpl)database).appendSystemTable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryNLSLocales() throws SQLException {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        Recordset recordset = super.query(new Field[]{super.fields(0)}, null, ParameterMetaInfo.EMPTY, true);
        try {
            while (recordset.next()) {
                Locale locale = ServerUtil.getLocale(recordset.getString(0));
                if (locale == null) continue;
                arrayList.add(locale);
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryNLS(Locale locale) throws SQLException {
        ArrayList<TextNLSEntry> arrayList = new ArrayList<TextNLSEntry>();
        StringBuilder stringBuilder = new StringBuilder("where ").append(EMPTY[0]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        Recordset recordset = super.query(new Field[]{this.fields(1), this.fields(2), this.fields(3)}, stringBuilder.toString(), parameterMetaInfo, true);
        try {
            while (recordset.next()) {
                int n = recordset.getInt(0);
                if (n == -1) {
                    ServiceLogger.logDebug("Ignore placehold GlobalNLS item: " + locale);
                    continue;
                }
                String string = recordset.getString(1);
                String string2 = recordset.getString(2);
                NLSType nLSType = GlobalNLSRecord.getTypeByIntValue(n);
                if (nLSType == null) {
                    ServiceLogger.logDebug("Invalid GlobalNLS text type: " + n);
                    continue;
                }
                arrayList.add(new TextNLSEntry(nLSType, string, string2));
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryNLS(Locale locale, TextNLSEntry textNLSEntry) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("where ").append(EMPTY[0]).append("=?").append(" and ").append(EMPTY[1]).append("=?").append(" and ").append(EMPTY[2]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        parameterMetaInfo.add(this.fields(1).getName(), GlobalNLSRecord.getTypeIntValue(textNLSEntry.getType()), 4);
        parameterMetaInfo.add(this.fields(2).getName(), textNLSEntry.getKeyText(), 12);
        Recordset recordset = super.query(new Field[]{this.fields(3)}, stringBuilder.toString(), parameterMetaInfo, true);
        try {
            if (recordset.next()) {
                String string = recordset.getString(0);
                textNLSEntry.setValueText(string);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            recordset.close();
        }
        return false;
    }

    public int saveNLS(final Locale locale, final List list) throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("delete from ").append(super.getName()).append(" WHERE ").append(EMPTY[0]).append("=?");
        final StringBuilder stringBuilder2 = new StringBuilder("insert into ").append(super.getName()).append("(").append(EMPTY[0]).append(",").append(EMPTY[1]).append(",").append(EMPTY[2]).append(",").append(EMPTY[3]).append(")values(").append("?,?,?,?").append(")");
        try {
            Integer n = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n = 0;
                    PreparedStatement preparedStatement = null;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        preparedStatement.setString(1, locale.toString());
                        preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder2.toString());
                        if (list.isEmpty()) {
                            ServiceLogger.logDebug("Add placehold GlobalNLS item: " + locale);
                            preparedStatement.setString(1, locale.toString());
                            preparedStatement.setInt(2, -1);
                            preparedStatement.setString(3, GlobalNLSTextTable.appendSystemTable);
                            preparedStatement.setString(4, GlobalNLSTextTable.appendSystemTable);
                            preparedStatement.execute();
                            Integer n2 = 0;
                            return n2;
                        }
                        Object object = list.iterator();
                        while (object.hasNext()) {
                            TextNLSEntry textNLSEntry = (TextNLSEntry)object.next();
                            preparedStatement.setString(1, locale.toString());
                            preparedStatement.setInt(2, GlobalNLSRecord.getTypeIntValue(textNLSEntry.getType()));
                            preparedStatement.setString(3, textNLSEntry.getKeyText());
                            preparedStatement.setString(4, textNLSEntry.getValueText());
                            preparedStatement.addBatch();
                        }
                        for (Object object2 : object = (Object)preparedStatement.executeBatch()) {
                            n += object2;
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return n;
                }
            });
            return n;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public int deleteNLS(Locale locale) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("where ").append(this.fields(0).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }
}

