/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.nls;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.db.nls.ResourceNLSRecord;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class ResourceNLSTable
extends TableImpl {
    public static final int VERSION = 1;
    public static final String TABLE_NAME = "RESOURCENLS_1";
    private static final String[] EMPTY = new String[]{"LOC", "FOLDER_ID", "KEY_TEXT", "VALUE_TEXT", "ORGANIZATION"};
    private static final int INTEGER = 0;
    private static final int SEDU = 1;
    private static final int VARCHAR = 2;
    private static final int add = 3;
    private static final int append = 4;
    private static final int close = -99;
    private static final String contains = "__PLACE_HOLD";

    public static ResourceNLSTable newInstance(Database database) throws InstantiationException, SQLException {
        return new ResourceNLSTable(database);
    }

    private ResourceNLSTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), EMPTY[0], JDBCType.VARCHAR, 10, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[1], JDBCType.INTEGER, 0, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[2], JDBCType.VARCHAR, 256, 9, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[3], JDBCType.VARCHAR, 512, 1, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[4], JDBCType.VARCHAR, 32, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap queryNLSLocales() throws SQLException {
        HashMap<String, ArrayList<Locale>> hashMap = new HashMap<String, ArrayList<Locale>>();
        Recordset recordset = super.query(new Field[]{super.fields(0), super.fields(4)}, null, ParameterMetaInfo.EMPTY, true);
        try {
            while (recordset.next()) {
                Locale locale = ServerUtil.getLocale(recordset.getString(0));
                String string = recordset.getString(1);
                ArrayList<Locale> arrayList = (ArrayList<Locale>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Locale>();
                    hashMap.put(string, arrayList);
                }
                if (locale == null) continue;
                arrayList.add(locale);
            }
        }
        finally {
            recordset.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryNLS(Locale locale, String string) throws SQLException {
        ArrayList<ResourceNLSRecord> arrayList = new ArrayList<ResourceNLSRecord>();
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(EMPTY[0]).append("=? AND ").append(EMPTY[4]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        parameterMetaInfo.add(this.fields(4).getName(), string, 12);
        Recordset recordset = super.query(new Field[]{this.fields(1), this.fields(2), this.fields(3)}, stringBuilder.toString(), parameterMetaInfo, true);
        try {
            while (recordset.next()) {
                int n = recordset.getInt(0);
                if (n == -99) {
                    ServiceLogger.logDebug("Ignore placehold ResourceNLS item: " + locale);
                    continue;
                }
                String string2 = recordset.getString(1);
                String string3 = recordset.getString(2);
                arrayList.add(new ResourceNLSRecord(locale, n, string2, string3));
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryNLS(Locale locale, int n, String string) throws SQLException {
        ArrayList<ResourceNLSRecord> arrayList = new ArrayList<ResourceNLSRecord>();
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(EMPTY[0]).append("=? AND ").append(EMPTY[1]).append("=? AND ").append(EMPTY[4]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        parameterMetaInfo.add(this.fields(1).getName(), n, 4);
        parameterMetaInfo.add(this.fields(4).getName(), string, 12);
        Recordset recordset = super.query(new Field[]{this.fields(2), this.fields(3)}, stringBuilder.toString(), parameterMetaInfo, true);
        try {
            while (recordset.next()) {
                String string2 = recordset.getString(0);
                String string3 = recordset.getString(1);
                arrayList.add(new ResourceNLSRecord(locale, n, string2, string3));
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    public int saveNLS(final Locale locale, final String string, final int n, final List list) throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("delete from ").append(super.getName()).append(" WHERE ").append(EMPTY[0]).append("=? AND ").append(EMPTY[1]).append("=?");
        final StringBuilder stringBuilder2 = new StringBuilder("insert into ").append(super.getName()).append("(").append(EMPTY[0]).append(",").append(EMPTY[1]).append(",").append(EMPTY[2]).append(",").append(EMPTY[3]).append(",").append(EMPTY[4]).append(")values(").append("?,?,?,?,?").append(")");
        try {
            Integer n2 = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n3 = 0;
                    PreparedStatement preparedStatement = null;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        preparedStatement.setString(1, locale.toString());
                        preparedStatement.setInt(2, n);
                        preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder2.toString());
                        if (list.isEmpty()) {
                            ServiceLogger.logDebug("Add placehold GlobalNLS item: " + locale);
                            preparedStatement.setString(1, locale.toString());
                            preparedStatement.setInt(2, -99);
                            preparedStatement.setString(3, ResourceNLSTable.contains);
                            preparedStatement.setString(4, ResourceNLSTable.contains);
                            preparedStatement.setString(5, string);
                            preparedStatement.execute();
                            Integer n2 = 0;
                            return n2;
                        }
                        Object object = list.iterator();
                        while (object.hasNext()) {
                            ResourceNLSRecord resourceNLSRecord = (ResourceNLSRecord)object.next();
                            preparedStatement.setString(1, locale.toString());
                            preparedStatement.setInt(2, n);
                            preparedStatement.setString(3, resourceNLSRecord.getKeyText());
                            preparedStatement.setString(4, resourceNLSRecord.getValueText());
                            preparedStatement.setString(5, string);
                            preparedStatement.addBatch();
                        }
                        for (Object object2 : object = (Object)preparedStatement.executeBatch()) {
                            n3 += object2;
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return n3;
                }
            });
            return n2;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public int deleteNLS(String string) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(this.fields(4).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(4).getName(), string, 12);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    public int deleteNLS(int n) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(this.fields(1).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(1).getName(), n, 4);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    public int deleteNLS(int n, String string) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(this.fields(1).getName()).append("=? AND ").append(EMPTY[2]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(1).getName(), n, 4);
        parameterMetaInfo.add(this.fields(2).getName(), string, 12);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    public int deleteNLS(Locale locale, String string) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(this.fields(0).getName()).append("=? AND ").append(this.fields(4).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        parameterMetaInfo.add(this.fields(4).getName(), string, 12);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    public int deleteNLS(Locale locale, int n) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(this.fields(0).getName()).append("=? AND").append(this.fields(1).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        parameterMetaInfo.add(this.fields(1).getName(), n, 4);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    public int deleteNLS(ResourceNLSRecord resourceNLSRecord) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(" WHERE ").append(EMPTY[0]).append("=? AND ").append(EMPTY[1]).append("=? AND ").append(EMPTY[2]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), resourceNLSRecord.getLocale().toString(), 12);
        parameterMetaInfo.add(this.fields(1).getName(), resourceNLSRecord.getFolderID(), 4);
        parameterMetaInfo.add(this.fields(2).getName(), resourceNLSRecord.getKeyText(), 12);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }
}

