/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.paramlist;

import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.paramlist.SavedParamRecord;
import jet.server.db.paramlist.SavedParamTable;
import jet.server.log.ServiceLogger;

public class SavedParamTableImpl
extends TableImpl
implements SavedParamTable {
    public static final int VERSION = 1;
    public static final String TABLE_NAME = "SAVED_PARAM_TABLE_1";
    private static final String[] BOOLEAN = new String[]{"id", "paramlist_id", "name", "value", "isexpression", "ismultiplevalue", "ismultival_all"};
    private static SavedParamTableImpl INTEGER;
    private Database SEDU = null;
    private UpdateDetailsTable VARCHAR = null;

    public static SavedParamTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        if (INTEGER == null) {
            try {
                INTEGER = new SavedParamTableImpl(database, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return INTEGER;
    }

    public static SavedParamTableImpl getInstance() {
        return INTEGER;
    }

    public SavedParamTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        this.SEDU = database;
        this.VARCHAR = updateDetailsTable;
        this.append(new FieldImpl(this.getName(), BOOLEAN[0], JDBCType.INTEGER, 0, 7, 0));
        this.append(new FieldImpl(this.getName(), BOOLEAN[1], JDBCType.INTEGER, 0, 1, 0));
        this.append(new FieldImpl(this.getName(), BOOLEAN[2], JDBCType.VARCHAR, 256, 1, 0));
        this.append(new FieldImpl(this.getName(), BOOLEAN[3], JDBCType.VARCHAR, 2048, 1, 0));
        this.append(new FieldImpl(this.getName(), BOOLEAN[4], JDBCType.BOOLEAN, 0, 1, 0));
        this.append(new FieldImpl(this.getName(), BOOLEAN[5], JDBCType.BOOLEAN, 0, 1, 0));
        this.append(new FieldImpl(this.getName(), BOOLEAN[6], JDBCType.BOOLEAN, 0, 1, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    @Override
    public synchronized SavedParamRecord addRecord(int n, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        try {
            SavedParamRecord savedParamRecord = new SavedParamRecord(this.adapter.getID(this, this.fields(0)), n, string, string2, bl, bl2, bl3);
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(savedParamRecord.getId()));
            fieldValueArray[1].setValue(new Integer(savedParamRecord.getListId()));
            fieldValueArray[2].setValue(savedParamRecord.getParamName());
            fieldValueArray[3].setValue(savedParamRecord.getParamValue());
            fieldValueArray[4].setValue(new Boolean(savedParamRecord.isExpression()));
            fieldValueArray[5].setValue(new Boolean(savedParamRecord.isMultValue()));
            fieldValueArray[6].setValue(new Boolean(savedParamRecord.isAllMultValue()));
            this.insert(fieldValueArray);
            return savedParamRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteRecords(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(1).getName()).append("=?");
        try {
            int n2 = super.delete(stringBuffer.toString(), new ParameterMetaInfo().add("paramListId", n));
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getRecordsByParamListID(int n) {
        Table[] tableArray = new Table[]{this};
        Vector<SavedParamRecord> vector = new Vector<SavedParamRecord>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(1).getFullyQualifiedName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("paramListId", n);
        Recordset recordset = null;
        try {
            recordset = this.adapter.select(this.BOOLEAN(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(this.INTEGER(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public synchronized boolean updateParamValue(int n, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        FieldValue[] fieldValueArray = new FieldValue[4];
        fieldValueArray[0] = this.fields(3).createFieldValue();
        fieldValueArray[0].setValue(string2);
        fieldValueArray[1] = this.fields(4).createFieldValue();
        fieldValueArray[1].setValue(bl);
        fieldValueArray[2] = this.fields(5).createFieldValue();
        fieldValueArray[2].setValue(bl2);
        fieldValueArray[3] = this.fields(6).createFieldValue();
        fieldValueArray[3].setValue(bl3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(1).getFullyQualifiedName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("paramListId", n);
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    private Field[] BOOLEAN() {
        Field[] fieldArray = new Field[]{super.fields(0), super.fields(1), super.fields(2), super.fields(3), super.fields(4), super.fields(5), super.fields(6)};
        return fieldArray;
    }

    private SavedParamRecord INTEGER(Recordset recordset) throws SQLException {
        SavedParamRecord savedParamRecord = new SavedParamRecord();
        savedParamRecord.setId(recordset.getInt(0));
        savedParamRecord.setListId(recordset.getInt(1));
        savedParamRecord.setParamName(recordset.getString(2));
        savedParamRecord.setParamValue(recordset.getString(3));
        savedParamRecord.setExpression(recordset.getBoolean(4));
        savedParamRecord.setMultValue(recordset.getBoolean(5));
        savedParamRecord.setAllMultValue(recordset.getBoolean(6));
        return savedParamRecord;
    }
}

