/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.quartz;

import java.sql.SQLException;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.log.ServiceLogger;

public class LocksTable
extends TableImpl
implements Table {
    public static final String TABLENAME = "JR_QRTZ_LOCKS";
    static final String[] COLNAMES = new String[1];

    public static LocksTable newInstance(Database database) {
        try {
            return new LocksTable(database);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private LocksTable(Database database) throws SQLException, InstantiationException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 200, 9, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public String addRecord(String string) {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(string);
        try {
            super.insert(fieldValueArray);
            return string;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRecord(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("lockName", string);
        String string2 = null;
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                string2 = recordset.getString(COLNAMES[0]);
            }
            String string3 = string2;
            return string3;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return string2;
    }

    static {
        LocksTable.COLNAMES[0] = "LOCK_NAME";
    }
}

