/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.resource;

import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.resource.NodeRecord;
import jet.server.db.resource.NodeTable;
import jet.server.log.ServiceLogger;

public class NodeTableImpl
extends TableImpl
implements Table,
NodeTable {
    private static final int BIGINT = 6;
    private static final int BIT = 1;
    private static final int EMPTY = 2;
    private static final int INTEGER = 3;
    private static final int SEDU = 4;
    private static final int TINYINT = 5;
    public static final String TABLE_NAME = "NODES_6";
    protected static final String[] colNames = new String[]{"id", "name", "creatorName", "createTime", "parentID", "nodeType", "aclID", "description", "enablelinkedcat", "linkedcat", "useinherited", "linkedcatid", "organization"};

    public static NodeTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        return new NodeTableImpl(database, updateDetailsTable);
    }

    private NodeTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), colNames[0], JDBCType.INTEGER, 0, 3, 0));
        super.append(new FieldImpl(this.getName(), colNames[1], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[2], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[3], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[4], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[5], JDBCType.TINYINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[6], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[7], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[8], JDBCType.BIT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[9], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[10], JDBCType.BIT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[11], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[12], JDBCType.VARCHAR, 32, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "NODES_1";
        super.upgradeOldTable(database, updateDetailsTable, string, 1);
        string = "NODES_2";
        super.upgradeOldTable(database, updateDetailsTable, string, 2);
        string = "NODES_3";
        super.upgradeOldTable(database, updateDetailsTable, string, 3);
        string = "NODES_4";
        super.upgradeOldTable(database, updateDetailsTable, string, 4);
        string = "NODES_5";
        super.upgradeOldTable(database, updateDetailsTable, string, 4);
        int n = super.queryMaxValue("id", null, ParameterMetaInfo.EMPTY, false).intValue();
        if (n == Integer.MIN_VALUE) {
            n = -1;
        }
        this.adapter.setID(this, this.fields("id"), n++);
    }

    protected synchronized int nextRecordID() throws SQLException {
        return this.adapter.getID(this, this.fields(colNames[0]));
    }

    @Override
    public synchronized boolean deleteRecord(int n) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(0).getName()).append("=?");
            super.delete(stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean deleteRecordByParent(int n) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(4).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(4).getName()).append("=?");
            super.delete(stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean deleteRecordAndChildren(int n) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            parameterMetaInfo.add(super.fields(4).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(0).getName()).append("=?").append(" OR ").append(super.fields(4).getName()).append("=?");
            super.delete(stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean deleteAll() {
        try {
            int n = super.delete(null, ParameterMetaInfo.EMPTY);
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean addRecord(String string, String string2, Date date, int n, byte by, int n2, String string3, boolean bl, String string4, boolean bl2, int n3) {
        FieldValue[] fieldValueArray = super.fields().values();
        try {
            fieldValueArray[0].setValue(new Integer(this.nextRecordID()));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(string2);
        fieldValueArray[3].setValue(new Long(date.getTime()));
        fieldValueArray[4].setValue(new Integer(n));
        fieldValueArray[5].setValue(new Byte(by));
        fieldValueArray[6].setValue(new Integer(n2));
        fieldValueArray[7].setValue(string3);
        fieldValueArray[8].setValue(new Boolean(bl));
        fieldValueArray[9].setValue(string4);
        fieldValueArray[10].setValue(new Boolean(bl2));
        fieldValueArray[11].setValue(new Integer(n3));
        try {
            super.insert(fieldValueArray);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean updateName(int n, String string) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(1).createFieldValue()};
        fieldValueArray[0].setValue(string);
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean updateAcl(int n, int n2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(6).createFieldValue()};
        fieldValueArray[0].setValue(new Integer(n2));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateOrgUserFolder(int n, int n2, String string) {
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        FieldValue[] fieldValueArray = new FieldValue[3];
        fieldValueArray[0] = super.fields(4).createFieldValue();
        fieldValueArray[0].setValue(new Integer(n2));
        fieldValueArray[1] = super.fields(1).createFieldValue();
        fieldValueArray[1].setValue(string3);
        fieldValueArray[2] = super.fields(12).createFieldValue();
        fieldValueArray[2].setValue(string2);
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(4).getName(), String.valueOf(n), 4);
        parameterMetaInfo.add(super.fields(1).getName(), String.valueOf(string), 12);
        stringBuffer.append("WHERE ").append(super.fields(4).getName()).append("=? AND ").append(super.fields(1).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addRecord(NodeRecord nodeRecord) {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(new Integer(nodeRecord.getID()));
        fieldValueArray[1].setValue(nodeRecord.getName());
        fieldValueArray[2].setValue(nodeRecord.getCreatorName());
        fieldValueArray[3].setValue(new Long(nodeRecord.getCreateTime().getTime()));
        fieldValueArray[4].setValue(new Integer(nodeRecord.getParentID()));
        fieldValueArray[5].setValue(new Byte(nodeRecord.getNodeType()));
        fieldValueArray[6].setValue(new Integer(nodeRecord.getAclID()));
        fieldValueArray[7].setValue(nodeRecord.getDescription());
        fieldValueArray[8].setValue(new Boolean(nodeRecord.isEnableLinkedCatalog));
        fieldValueArray[9].setValue(nodeRecord.getLinkedCatalog());
        fieldValueArray[10].setValue(new Boolean(nodeRecord.isUseInherited()));
        fieldValueArray[11].setValue(new Integer(nodeRecord.getLinkedCatalogID()));
        fieldValueArray[12].setValue(nodeRecord.getOrganization());
        try {
            super.insert(fieldValueArray);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean updateDescription(int n, String string) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(7).createFieldValue()};
        fieldValueArray[0].setValue(string);
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean updateForReplace(int n, String string, String string2, Date date, int n2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(1).createFieldValue(), super.fields(2).createFieldValue(), super.fields(3).createFieldValue(), super.fields(6).createFieldValue()};
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(string2);
        fieldValueArray[2].setValue(new Long(date.getTime()));
        fieldValueArray[3].setValue(new Integer(n2));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean updateNameAndDesc(int n, String string, String string2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(1).createFieldValue(), super.fields(7).createFieldValue()};
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(string2);
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean updateLinkedCatalogProps(int n, boolean bl, String string, boolean bl2, int n2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(8).createFieldValue(), super.fields(9).createFieldValue(), super.fields(10).createFieldValue(), super.fields(11).createFieldValue()};
        fieldValueArray[0].setValue(new Boolean(bl));
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(new Boolean(bl2));
        fieldValueArray[3].setValue(new Integer(n2));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getAllNodeIDWithAclID() {
        Field[] fieldArray = new Field[]{this.fields(colNames[6]), this.fields(colNames[0])};
        Recordset recordset = null;
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        try {
            recordset = super.query(fieldArray, null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                int n = recordset.getInt(colNames[6]);
                int n2 = recordset.getInt(colNames[0]);
                if (n == -1) continue;
                hashtable.put(new Integer(n), new Integer(n2));
            }
        }
        catch (SQLException sQLException) {
            hashtable = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllNodeIDsByLinkCatalogID(int n) throws SQLException {
        Vector<Integer> vector = new Vector<Integer>();
        Field[] fieldArray = new Field[]{this.fields(colNames[0])};
        Recordset recordset = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(11).getName(), n, 4);
            stringBuffer.append("WHERE ").append(super.fields(8).getName()).append("=").append(this.adapter.formatValue(true)).append(" AND ").append(super.fields(11).getName()).append("=? AND ").append(super.fields(10).getName()).append("=").append(this.adapter.formatValue(false));
            recordset = super.query(fieldArray, stringBuffer.toString(), parameterMetaInfo, true);
            while (recordset.next()) {
                int n2 = recordset.getInt(colNames[0]);
                vector.add(new Integer(n2));
            }
        }
        catch (SQLException sQLException) {
            vector = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }
}

