/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.resource;

import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.resource.ResourceMapRecord;
import jet.server.db.resource.ResourceMapTable;
import jet.server.log.ServiceLogger;

public class ResourceMapTableImpl
extends TableImpl
implements Table,
ResourceMapTable {
    private static final int EMPTY = 2;
    private static final int INTEGER = 1;
    private static final String SEDU = "RESOURCEMAP_2";
    private static final String[] TINYINT = new String[]{"RESOURCEID", "RESOURCENAME", "RESOURCETYPE"};
    private int VARCHAR = -1;
    private static final int add = 0;
    private static final int addElement = 1;
    private static final int append = 2;

    public static ResourceMapTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new ResourceMapTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, SEDU, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    public ResourceMapTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, SEDU);
        super.append(new FieldImpl(this.getName(), TINYINT[0], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), TINYINT[1], JDBCType.VARCHAR, 512, 1, 0));
        super.append(new FieldImpl(this.getName(), TINYINT[2], JDBCType.TINYINT, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "RESOURCEMAP_1";
        super.upgradeOldTable(database, updateDetailsTable, string, 1);
    }

    @Override
    public synchronized int addRecord(String string, byte by) {
        FieldValue[] fieldValueArray = super.fields().values();
        int n = this.EMPTY();
        fieldValueArray[0].setValue(new Integer(n));
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(new Byte(by));
        try {
            super.insert(fieldValueArray);
            return n;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getResource(int n) {
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            String string = " WHERE " + super.fields(0).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            if (recordset.next()) {
                String string2 = recordset.getString(TINYINT[1]);
                return string2;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return null;
    }

    @Override
    public synchronized boolean deleteRecord(int n) {
        try {
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(0).getName()).append("=?");
            n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    private synchronized int EMPTY() {
        Number number = null;
        if (this.VARCHAR != -1) {
            --this.VARCHAR;
        } else {
            try {
                number = super.queryMinValue(TINYINT[0], null, ParameterMetaInfo.EMPTY, true);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
            this.VARCHAR = number == null || number.intValue() == -1 || number.intValue() <= Integer.MIN_VALUE ? -2 : number.intValue() - 1;
        }
        return this.VARCHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getResNumber(String string) {
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(1).getName(), string, 12);
            String string2 = " WHERE " + super.fields(1).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            if (recordset.next()) {
                int n = recordset.getInt(TINYINT[0]);
                return n;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getRecord(String string) {
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(1).getName(), string, 12);
            String string2 = " WHERE " + super.fields(1).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            if (recordset.next()) {
                ResourceMapRecord resourceMapRecord = new ResourceMapRecord(string, recordset.getInt(TINYINT[0]), recordset.getByte(TINYINT[2]));
                return resourceMapRecord;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecords() {
        Vector<ResourceMapRecord> vector = new Vector<ResourceMapRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                ResourceMapRecord resourceMapRecord = new ResourceMapRecord(recordset.getString(TINYINT[1]), recordset.getInt(TINYINT[0]), recordset.getByte(TINYINT[2]));
                vector.addElement(resourceMapRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllResources() {
        Vector<String> vector = new Vector<String>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                String string = recordset.getString(TINYINT[1]);
                vector.addElement(string);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }
}

