/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.resource;

import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.event.NodeRecordEvent;
import jet.server.db.event.RecordEventListener;
import jet.server.db.event.RecordEventListenerManager;
import jet.server.db.event.RecordEventType;
import jet.server.db.resource.NodeTableImpl;
import jet.server.db.resource.ResourceNodeRecord;
import jet.server.db.resource.ResourceNodeTable;
import jet.server.jrc.JRVersionService;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.log.ServiceLogger;

public class ResourceNodeTableImpl
extends TableImpl
implements Table,
ResourceNodeTable {
    public static final int VERSION = 5;
    private static final int B = 1;
    private static final int BIT = 2;
    private static final int EMPTY = 3;
    private static final int INTEGER = 4;
    public static final String TABLE_NAME = "RESOURCENODES_5";
    private static final String[] SEDU = new String[]{"id", "resourceType", "realPath", "maxVersionAmount", "archiveNewVersion", "enableArchivePolicy", "profileName", "enableNLS", "status", "resourceSubType"};
    private NodeTableImpl TINYINT = null;
    private UpdateDetailsTable VARCHAR = null;
    private Database Z = null;

    public static ResourceNodeTableImpl newInstance(Database database, NodeTableImpl nodeTableImpl, UpdateDetailsTable updateDetailsTable) {
        try {
            ResourceNodeTableImpl resourceNodeTableImpl = new ResourceNodeTableImpl(database, nodeTableImpl, updateDetailsTable);
            RecordEventListenerManager.initListener(resourceNodeTableImpl);
            return resourceNodeTableImpl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLE_NAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private ResourceNodeTableImpl(Database database, NodeTableImpl nodeTableImpl, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        this.TINYINT = nodeTableImpl;
        this.Z = database;
        this.VARCHAR = updateDetailsTable;
        super.append(new FieldImpl(this.getName(), SEDU[0], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[1], JDBCType.TINYINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[2], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU[3], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[4], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[5], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[6], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU[7], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[8], JDBCType.TINYINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU[9], JDBCType.TINYINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    @Override
    public void mergeOldInformation(JRVersionService jRVersionService) throws SQLException {
        String string = "RESOURCENODES_1";
        this.B(this.Z, this.VARCHAR, string, jRVersionService);
        String string2 = "RESOURCENODES_2";
        this.B(this.Z, this.VARCHAR, string2, jRVersionService);
        String string3 = "RESOURCENODES_3";
        this.B(this.Z, this.VARCHAR, string3, jRVersionService);
        String string4 = "RESOURCENODES_4";
        this.B(this.Z, this.VARCHAR, string4, jRVersionService);
    }

    private void B(Database database, UpdateDetailsTable updateDetailsTable, String string, JRVersionService jRVersionService) throws SQLException {
        boolean bl = updateDetailsTable.isUpdating(string);
        if (database.tables().contains(string)) {
            Table table = database.tables(string);
            if (!bl) {
                this.BIT(table, jRVersionService, string);
                table.delete(null, ParameterMetaInfo.EMPTY);
                updateDetailsTable.setUpdateDetails(string, true);
            }
            ((DatabaseImpl)database).remove(table);
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BIT(Table table, JRVersionService jRVersionService, String string) throws SQLException {
        Recordset recordset = null;
        try {
            recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            if (string.endsWith("_4")) {
                FieldValue[] fieldValueArray = new FieldValue[recordset.fields().length + 1];
                fieldValueArray[fieldValueArray.length - 1] = this.fields(SEDU[9]).createFieldValue();
                while (recordset.next()) {
                    try {
                        System.arraycopy(recordset.fields(), 0, fieldValueArray, 0, fieldValueArray.length - 1);
                        byte by = 0;
                        byte by2 = recordset.getByte(SEDU[1]);
                        if (by2 == 2) {
                            int n = recordset.getInt(SEDU[0]);
                            String string2 = jRVersionService.getLatestVersion(n, by2).getRealPath();
                            by = string2.endsWith(".dsh") ? (byte)3 : (string2.endsWith(".va") ? (byte)4 : (string2.endsWith(".wls") ? (byte)2 : 1));
                            ServiceLogger.logDebug(5620034, new Object[]{new Byte(by), string2}, 5);
                        }
                        fieldValueArray[fieldValueArray.length - 1].setValue(new Byte(by));
                        super.insert(fieldValueArray);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                        super.insert(recordset.fields());
                    }
                }
            } else {
                boolean bl = table.fields().contains(SEDU[7]);
                boolean bl2 = table.fields().contains(SEDU[8]);
                if (bl && bl2) {
                    while (recordset.next()) {
                        super.insert(recordset.fields());
                    }
                } else if (!bl && !bl2) {
                    FieldValue[] fieldValueArray = new FieldValue[recordset.fields().length + 3];
                    fieldValueArray[fieldValueArray.length - 3] = this.fields(SEDU[7]).createFieldValue();
                    fieldValueArray[fieldValueArray.length - 2] = this.fields(SEDU[8]).createFieldValue();
                    fieldValueArray[fieldValueArray.length - 1] = this.fields(SEDU[9]).createFieldValue();
                    while (recordset.next()) {
                        try {
                            System.arraycopy(recordset.fields(), 0, fieldValueArray, 0, fieldValueArray.length - 3);
                            boolean bl3 = false;
                            byte by = 0;
                            byte by3 = 1;
                            byte by4 = recordset.getByte(SEDU[1]);
                            if (by4 == 2) {
                                int n = recordset.getInt(SEDU[0]);
                                String string3 = jRVersionService.getLatestVersion(n, by4).getRealPath();
                                bl3 = NLSUtil.isReportNationalLanguageSupport(string3);
                                by = string3.endsWith(".dsh") ? (byte)3 : (string3.endsWith(".va") ? (byte)4 : (string3.endsWith(".wls") ? (byte)2 : 1));
                                ServiceLogger.logDebug(5620033, new Object[]{new Boolean(bl3), new Byte(by3), string3}, 5);
                            }
                            fieldValueArray[fieldValueArray.length - 3].setValue(new Boolean(bl3));
                            fieldValueArray[fieldValueArray.length - 2].setValue(new Byte(by3));
                            fieldValueArray[fieldValueArray.length - 1].setValue(new Byte(by));
                            super.insert(fieldValueArray);
                        }
                        catch (Exception exception) {
                            ServiceLogger.logError(exception, 3);
                            super.insert(recordset.fields());
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    @Override
    public synchronized ResourceNodeRecord addRecord(String string, String string2, String string3, Date date, int n, int n2, String string4, byte by, byte by2, String string5, int n3, boolean bl, boolean bl2, boolean bl3, String string6, boolean bl4, int n4) {
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = new ResourceNodeRecord(this.TINYINT.nextRecordID(), string, string2, string3, date, n, n2, string4, by, by2, string5, n3, bl, bl2, bl3, string6, bl4, n4);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
        boolean bl5 = this.TINYINT.addRecord(resourceNodeRecord);
        if (bl5) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(resourceNodeRecord.getID()));
            fieldValueArray[1].setValue(new Byte(by));
            fieldValueArray[9].setValue(new Byte(by2));
            fieldValueArray[2].setValue(string5);
            fieldValueArray[3].setValue(new Integer(n3));
            fieldValueArray[4].setValue(new Boolean(bl));
            fieldValueArray[5].setValue(new Boolean(bl2));
            try {
                super.insert(fieldValueArray);
                this.fireEvent(RecordEventType.inserted, null, resourceNodeRecord);
                return resourceNodeRecord;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
        return null;
    }

    @Override
    public synchronized ResourceNodeRecord addRecord(String string, String string2, String string3, Date date, int n, int n2, String string4, byte by, byte by2, String string5, int n3, boolean bl, boolean bl2, boolean bl3, String string6, boolean bl4, String string7, boolean bl5, byte by3, int n4) {
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = new ResourceNodeRecord(this.TINYINT.nextRecordID(), string, string2, string3, date, n, n2, string4, by, by2, string5, n3, bl, bl2, bl3, string6, bl4, string7, bl5, by3, n4);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
        boolean bl6 = this.TINYINT.addRecord(resourceNodeRecord);
        if (bl6) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(resourceNodeRecord.getID()));
            fieldValueArray[1].setValue(new Byte(by));
            fieldValueArray[9].setValue(new Byte(by2));
            fieldValueArray[2].setValue(string5);
            fieldValueArray[3].setValue(new Integer(n3));
            fieldValueArray[4].setValue(new Boolean(bl));
            fieldValueArray[5].setValue(new Boolean(bl2));
            fieldValueArray[6].setValue(string7);
            fieldValueArray[7].setValue(new Boolean(bl5));
            fieldValueArray[8].setValue(new Byte(by3));
            try {
                super.insert(fieldValueArray);
                this.fireEvent(RecordEventType.inserted, null, resourceNodeRecord);
                return resourceNodeRecord;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
        return null;
    }

    @Override
    public synchronized boolean updateMaxVersionAmount(int n, int n2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(3).createFieldValue()};
        fieldValueArray[0].setValue(new Integer(n2));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = this.getResourceByID(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.fireEvent(RecordEventType.updated, n, resourceNodeRecord);
        return true;
    }

    @Override
    public synchronized boolean updateAll(int n, String string, int n2, boolean bl, boolean bl2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(2).createFieldValue(), super.fields(3).createFieldValue(), super.fields(4).createFieldValue(), super.fields(5).createFieldValue()};
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(new Integer(n2));
        fieldValueArray[2].setValue(new Boolean(bl));
        fieldValueArray[3].setValue(new Boolean(bl2));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = this.getResourceByID(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.fireEvent(RecordEventType.updated, n, resourceNodeRecord);
        return true;
    }

    @Override
    public synchronized boolean updateAll(int n, String string, int n2, boolean bl, boolean bl2, String string2, boolean bl3, byte by) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(2).createFieldValue(), super.fields(3).createFieldValue(), super.fields(4).createFieldValue(), super.fields(5).createFieldValue(), super.fields(6).createFieldValue(), super.fields(7).createFieldValue(), super.fields(8).createFieldValue()};
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(new Integer(n2));
        fieldValueArray[2].setValue(new Boolean(bl));
        fieldValueArray[3].setValue(new Boolean(bl2));
        fieldValueArray[4].setValue(string2);
        fieldValueArray[5].setValue(new Boolean(bl3));
        fieldValueArray[6].setValue(new Byte(by));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = this.getResourceByID(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.fireEvent(RecordEventType.updated, n, resourceNodeRecord);
        return true;
    }

    @Override
    public synchronized boolean deleteRecord(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(0).getName()).append("=?");
            n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            this.fireEvent(RecordEventType.deleted, n, null);
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean updateRealPath(int n, String string) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(2).createFieldValue()};
        fieldValueArray[0].setValue(string);
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = this.getResourceByID(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.fireEvent(RecordEventType.updated, n, resourceNodeRecord);
        return true;
    }

    @Override
    public synchronized boolean updateEnableNLS(int n, boolean bl) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(7).createFieldValue()};
        fieldValueArray[0].setValue(new Boolean(bl));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = this.getResourceByID(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.fireEvent(RecordEventType.updated, n, resourceNodeRecord);
        return true;
    }

    @Override
    public synchronized boolean updateStatus(int n, byte by) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(8).createFieldValue()};
        fieldValueArray[0].setValue(new Byte(by));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = this.getResourceByID(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.fireEvent(RecordEventType.updated, n, resourceNodeRecord);
        return true;
    }

    @Override
    public synchronized boolean updateResourceSubType(int n, byte by) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(9).createFieldValue()};
        fieldValueArray[0].setValue(new Byte(by));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            resourceNodeRecord = this.getResourceByID(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.fireEvent(RecordEventType.updated, n, resourceNodeRecord);
        return true;
    }

    @Override
    public synchronized boolean deleteAll() {
        try {
            int n = super.delete(null, ParameterMetaInfo.EMPTY);
            this.fireEvent(RecordEventType.deletedAll, null, null);
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllResources() throws SQLException {
        Table[] tableArray = new Table[]{this.TINYINT, this};
        Recordset recordset = null;
        Vector<ResourceNodeRecord> vector = new Vector<ResourceNodeRecord>();
        try {
            recordset = this.adapter.select(this.INTEGER(), tableArray, "WHERE " + this.EMPTY(), ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                vector.addElement(this.SEDU(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private String EMPTY() {
        return this.TINYINT.fields(0).getFullyQualifiedName() + "=" + super.fields(0).getFullyQualifiedName();
    }

    private Field[] INTEGER() {
        Field[] fieldArray = new Field[]{this.TINYINT.fields(0), this.TINYINT.fields(1), this.TINYINT.fields(2), this.TINYINT.fields(3), this.TINYINT.fields(4), this.TINYINT.fields(5), this.TINYINT.fields(6), this.TINYINT.fields(7), this.TINYINT.fields(8), this.TINYINT.fields(9), this.TINYINT.fields(10), super.fields(1), super.fields(2), super.fields(3), super.fields(4), super.fields(5), super.fields(6), super.fields(7), super.fields(8), super.fields(9), this.TINYINT.fields(11), this.TINYINT.fields(12)};
        return fieldArray;
    }

    private ResourceNodeRecord SEDU(Recordset recordset) throws SQLException {
        ResourceNodeRecord resourceNodeRecord = new ResourceNodeRecord();
        resourceNodeRecord.recordID = recordset.getInt(0);
        resourceNodeRecord.name = recordset.getString(1);
        resourceNodeRecord.creatorName = recordset.getString(2);
        resourceNodeRecord.createTime = new Date(recordset.getLong(3));
        resourceNodeRecord.parentID = recordset.getInt(4);
        resourceNodeRecord.nodeType = recordset.getByte(5);
        resourceNodeRecord.aclID = recordset.getInt(6);
        resourceNodeRecord.description = recordset.getString(7);
        resourceNodeRecord.isEnableLinkedCatalog = recordset.getBoolean(8);
        resourceNodeRecord.linkedCatalog = recordset.getString(9);
        resourceNodeRecord.isUseInherited = recordset.getBoolean(10);
        resourceNodeRecord.resourceType = recordset.getByte(11);
        resourceNodeRecord.realPath = recordset.getString(12);
        resourceNodeRecord.maxVersionAmount = recordset.getInt(13);
        resourceNodeRecord.archiveNewVersion = recordset.getBoolean(14);
        resourceNodeRecord.enableArchivePolicy = recordset.getBoolean(15);
        resourceNodeRecord.profileName = recordset.getString(16);
        resourceNodeRecord.isEnableNLS = recordset.getBoolean(17);
        resourceNodeRecord.status = recordset.getByte(18);
        resourceNodeRecord.resourceSubType = recordset.getByte(19);
        resourceNodeRecord.linkedCatalogID = recordset.getInt(20);
        resourceNodeRecord.organization = recordset.getString(21);
        return resourceNodeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResourceNodeRecord getResourceByID(int n) throws SQLException {
        Table[] tableArray = new Table[]{this.TINYINT, this};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(this.EMPTY()).append(" AND ").append(super.fields(0).getFullyQualifiedName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("recordID", n);
        Recordset recordset = null;
        ResourceNodeRecord resourceNodeRecord = null;
        try {
            recordset = this.adapter.select(this.INTEGER(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                resourceNodeRecord = this.SEDU(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return resourceNodeRecord;
    }

    protected void fireEvent(RecordEventType recordEventType, Integer n, ResourceNodeRecord resourceNodeRecord) {
        if (this.listeners == null) {
            return;
        }
        NodeRecordEvent nodeRecordEvent = new NodeRecordEvent(recordEventType, n, resourceNodeRecord);
        for (RecordEventListener recordEventListener : this.listeners) {
            recordEventListener.onChanged(nodeRecordEvent);
        }
    }

    @Override
    public void updateNodeRecord(int n, Object object) throws SQLException {
        this.fireEvent(RecordEventType.updated, n, this.getResourceByID(n));
    }
}

