/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.AclRecord;
import jet.server.db.security2.AclTable;
import jet.server.log.ServiceLogger;

public class AclTableImpl
extends TableImpl
implements Table,
AclTable {
    public static final int OLDVERSION = 1;
    public static final int VERSION = 2;
    private static final String BIGINT = "ACLS_2";
    static final String[] COLNAMES = new String[4];

    public static AclTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        AclTableImpl aclTableImpl = null;
        try {
            aclTableImpl = new AclTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, BIGINT, 1);
            ServiceLogger.logError(exception, 1);
        }
        return aclTableImpl;
    }

    private AclTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws SQLException, InstantiationException {
        super(database, BIGINT);
        int n;
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.INTEGER, 0, 11, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.VARCHAR, 64, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[2], JDBCType.VARCHAR, 32, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[3], JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "ACLS_1";
        boolean bl = updateDetailsTable.isUpdating(string);
        if (database.tables().contains(string)) {
            Table table = database.tables(string);
            if (!bl) {
                this.COLNAMES(table);
                table.delete(null, ParameterMetaInfo.EMPTY);
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
        if ((n = super.queryMaxValue("id", null, ParameterMetaInfo.EMPTY, false).intValue()) == Integer.MIN_VALUE) {
            n = -1;
        }
        this.adapter.setID(this, this.fields("id"), n++);
    }

    @Override
    public synchronized AclRecord addRecord(String string, String string2, Date date, boolean bl) {
        try {
            int n = this.adapter.getID(this, this.fields(COLNAMES[0]));
            AclRecord aclRecord = bl ? new AclRecord(n, string + "_" + n, string2, date) : new AclRecord(n, string, string2, date);
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(n));
            fieldValueArray[1].setValue(aclRecord.getName());
            fieldValueArray[2].setValue(string2);
            fieldValueArray[3].setValue(new Long(date.getTime()));
            super.insert(fieldValueArray);
            return aclRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteRecord(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n2 >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AclRecord getRecordByID(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        AclRecord aclRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(n), 4);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            while (recordset.next()) {
                aclRecord = this.BIGINT(recordset);
            }
        }
        catch (SQLException sQLException) {
            aclRecord = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return aclRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AclRecord getRecordByName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        AclRecord aclRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            while (recordset.next()) {
                aclRecord = this.BIGINT(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return aclRecord;
    }

    private synchronized AclRecord BIGINT(Recordset recordset) throws SQLException {
        AclRecord aclRecord = new AclRecord();
        aclRecord.setRecordID(recordset.getInt(COLNAMES[0]));
        aclRecord.setName(recordset.getString(COLNAMES[1]));
        aclRecord.setCreatorName(recordset.getString(COLNAMES[2]));
        aclRecord.setCreateTime(recordset.getInt(COLNAMES[0]));
        return aclRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllAclID() {
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[0])};
        Recordset recordset = null;
        Vector<String> vector = new Vector<String>();
        try {
            recordset = super.query(fieldArray, null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                int n = recordset.getInt(COLNAMES[0]);
                String string = String.valueOf(n);
                vector.add(string);
            }
        }
        catch (SQLException sQLException) {
            vector = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void COLNAMES(Table table) throws SQLException {
        Recordset recordset = null;
        try {
            recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                FieldValue[] fieldValueArray = super.fields().values();
                fieldValueArray[0].setValue(recordset.fields("id").getValue());
                fieldValueArray[1].setValue(recordset.fields("name").getValue());
                fieldValueArray[2].setValue(recordset.fields("creatorName").getValue());
                fieldValueArray[3].setValue(recordset.fields("createTime").getValue());
                super.insert(fieldValueArray);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                recordset.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        AclTableImpl.COLNAMES[0] = "id";
        AclTableImpl.COLNAMES[1] = "name";
        AclTableImpl.COLNAMES[2] = "create_name";
        AclTableImpl.COLNAMES[3] = "create_time";
    }
}

