/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.resource.VersionNodeRecord;
import jet.server.db.security2.AclRecord;
import jet.server.db.security2.AclTable;
import jet.server.db.security2.AclsWithResourceRecord;
import jet.server.db.security2.AclsWithResourceTable;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.log.ServiceLogger;

public class AclsWithResourceTableImpl
extends TableImpl
implements Table,
AclsWithResourceTable {
    public static final int VERSION = 1;
    private static final String BIGINT = "ACLS_WITH_RESOURCE_1";
    private static final String EMPTY = "ACLS_TABLE";
    UpdateDetailsTable updateDetailsTable = null;
    AclTable aclTable = null;
    static final String[] COLNAMES = new String[6];

    public static AclsWithResourceTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable, AclTable aclTable) {
        AclsWithResourceTableImpl aclsWithResourceTableImpl = null;
        try {
            aclsWithResourceTableImpl = new AclsWithResourceTableImpl(database, updateDetailsTable, aclTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 1);
        }
        return aclsWithResourceTableImpl;
    }

    private AclsWithResourceTableImpl(Database database, UpdateDetailsTable updateDetailsTable, AclTable aclTable) throws SQLException, InstantiationException {
        super(database, BIGINT);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.INTEGER, 0, 11, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[2], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[3], JDBCType.VARCHAR, 512, 17, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[4], JDBCType.VARCHAR, 32, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[5], JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        this.aclTable = aclTable;
        this.updateDetailsTable = updateDetailsTable;
        ((DatabaseImpl)database).append(this);
        int n = super.queryMaxValue(COLNAMES[0], null, ParameterMetaInfo.EMPTY, false).intValue();
        if (n == Integer.MIN_VALUE) {
            n = -1;
        }
        this.adapter.setID(this, this.fields(COLNAMES[0]), n++);
    }

    @Override
    public synchronized AclsWithResourceRecord addRecord(String string, int n, String string2, String string3, Date date) {
        try {
            int n2 = this.adapter.getID(this, this.fields(COLNAMES[0]));
            String string4 = SecurityUtil.createAclName(string, n);
            AclsWithResourceRecord aclsWithResourceRecord = new AclsWithResourceRecord(n2, string, n, string4, string3, date);
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(n2));
            fieldValueArray[1].setValue(string);
            fieldValueArray[2].setValue(new Integer(n));
            fieldValueArray[3].setValue(string4);
            fieldValueArray[4].setValue(string3);
            fieldValueArray[5].setValue(new Long(date.getTime()));
            super.insert(fieldValueArray);
            return aclsWithResourceRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteRecord(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n2 >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AclsWithResourceRecord getRecordByID(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        AclsWithResourceRecord aclsWithResourceRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(n), 4);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=").append(n);
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                aclsWithResourceRecord = this.BIGINT(recordset);
            }
        }
        catch (SQLException sQLException) {
            aclsWithResourceRecord = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return aclsWithResourceRecord;
    }

    @Override
    public synchronized boolean deleteRecord(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            parameterMetaInfo.add(super.fields(COLNAMES[2]).getName(), String.valueOf(n), 4);
            stringBuffer.append(" AND ").append(super.fields(COLNAMES[2]).getName()).append("=?");
            n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n2 >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AclsWithResourceRecord getRecord(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        AclsWithResourceRecord aclsWithResourceRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string, 12);
            parameterMetaInfo.add(super.fields(COLNAMES[2]).getName(), String.valueOf(n), 4);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=? AND ").append(super.fields(COLNAMES[2]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                aclsWithResourceRecord = this.BIGINT(recordset);
            }
        }
        catch (SQLException sQLException) {
            aclsWithResourceRecord = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return aclsWithResourceRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getRecordIDByResourcePath(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Recordset recordset = null;
        int n2 = -1;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string, 12);
            parameterMetaInfo.add(super.fields(COLNAMES[2]).getName(), String.valueOf(n), 4);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=? AND ").append(super.fields(COLNAMES[2]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                n2 = recordset.getInt(COLNAMES[0]);
            }
        }
        catch (SQLException sQLException) {
            n2 = -1;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllAclID() {
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[0])};
        Recordset recordset = null;
        Vector<String> vector = new Vector<String>();
        try {
            recordset = super.query(fieldArray, null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                int n = recordset.getInt(COLNAMES[0]);
                String string = String.valueOf(n);
                vector.add(string);
            }
        }
        catch (SQLException sQLException) {
            vector = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private synchronized AclsWithResourceRecord BIGINT(Recordset recordset) throws SQLException {
        AclsWithResourceRecord aclsWithResourceRecord = new AclsWithResourceRecord();
        aclsWithResourceRecord.setAclID(recordset.getInt(COLNAMES[0]));
        aclsWithResourceRecord.setResourcePath(recordset.getString(COLNAMES[1]));
        aclsWithResourceRecord.setVersionNumber(recordset.getInt(COLNAMES[2]));
        aclsWithResourceRecord.setName(recordset.getString(COLNAMES[3]));
        aclsWithResourceRecord.setCreatorName(recordset.getString(COLNAMES[4]));
        aclsWithResourceRecord.setCreateTime(recordset.getInt(COLNAMES[5]));
        return aclsWithResourceRecord;
    }

    @Override
    public synchronized void mergeOldInformation(ResourceTreeManagerImpl resourceTreeManagerImpl) throws SQLException {
        boolean bl = this.updateDetailsTable.isUpdating(EMPTY);
        if (!bl && this.aclTable != null) {
            Object object;
            Vector vector = this.aclTable.getAllAclID();
            Hashtable hashtable = resourceTreeManagerImpl.nodeTable.getAllNodeIDWithAclID();
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                int n;
                String string = (String)vector.elementAt(i);
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                object = (Integer)hashtable.get(new Integer(n));
                if (object == null) continue;
                int n2 = (Integer)object;
                Node node = (Node)resourceTreeManagerImpl.getNodeIdMap().get(n2);
                AclRecord aclRecord = this.aclTable.getRecordByID(n);
                if (node != null) {
                    object2 = node.getAbsolutePath();
                    if (this.getRecordIDByResourcePath((String)object2, -1) != -1) {
                        this.deleteRecord((String)object2, -1);
                    }
                    this.addRecord(n, (String)object2, -1, aclRecord.getName(), aclRecord.getCreatorName(), aclRecord.getCreateTime());
                    continue;
                }
                object2 = resourceTreeManagerImpl.versionNodeTable.getVersionByID(n2);
                int n3 = ((VersionNodeRecord)object2).getResourceID();
                int n4 = ((VersionNodeRecord)object2).getVersionNumber();
                Node node2 = (Node)resourceTreeManagerImpl.getNodeIdMap().get(n3);
                String string2 = node2.getAbsolutePath();
                if (this.getRecordIDByResourcePath(string2, n4) != -1) {
                    this.deleteRecord(string2, n4);
                }
                this.addRecord(n, string2, n4, aclRecord.getName(), aclRecord.getCreatorName(), aclRecord.getCreateTime());
            }
            AclRecord aclRecord = this.aclTable.getRecordByName("defaultAcl");
            try {
                if (aclRecord != null) {
                    int n = aclRecord.getID();
                    Folder folder = resourceTreeManagerImpl.getRoot();
                    if (folder != null) {
                        String string = folder.getAbsolutePath();
                        object = this.getRecordByID(n);
                        if (object == null) {
                            this.addRecord(n, string, -1, aclRecord.getName(), aclRecord.getCreatorName(), aclRecord.getCreateTime());
                        }
                    }
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            int n = super.queryMaxValue(COLNAMES[0], null, ParameterMetaInfo.EMPTY, false).intValue();
            if (n == Integer.MIN_VALUE) {
                n = -1;
            }
            this.adapter.setID(this, this.fields(COLNAMES[0]), n++);
            this.updateDetailsTable.setUpdateDetails(EMPTY, true);
        }
    }

    private synchronized AclsWithResourceRecord addRecord(int n, String string, int n2, String string2, String string3, Date date) {
        try {
            String string4 = SecurityUtil.createAclName(string, n2);
            AclsWithResourceRecord aclsWithResourceRecord = new AclsWithResourceRecord(n, string, n2, string4, string3, date);
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(n));
            fieldValueArray[1].setValue(string);
            fieldValueArray[2].setValue(new Integer(n2));
            fieldValueArray[3].setValue(string4);
            fieldValueArray[4].setValue(string3);
            fieldValueArray[5].setValue(new Long(date.getTime()));
            super.insert(fieldValueArray);
            return aclsWithResourceRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    static {
        AclsWithResourceTableImpl.COLNAMES[0] = "id";
        AclsWithResourceTableImpl.COLNAMES[1] = "resource_path";
        AclsWithResourceTableImpl.COLNAMES[2] = "version_number";
        AclsWithResourceTableImpl.COLNAMES[3] = "acl_name";
        AclsWithResourceTableImpl.COLNAMES[4] = "create_name";
        AclsWithResourceTableImpl.COLNAMES[5] = "create_time";
    }
}

