/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.GUProfileRecord;
import jet.server.db.security2.GUProfileTable;
import jet.server.log.ServiceLogger;

public class GUProfileTableImpl
extends TableImpl
implements Table,
GUProfileTable {
    public static final int OLDVERSION = 1;
    public static final int OLDVERSION2 = 2;
    public static final int VERSION = 3;
    public static final String TABLENAME = "GUPROFILES_3";
    static final String[] COLNAMES = new String[2];

    public static GUProfileTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new GUProfileTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private GUProfileTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws SQLException, InstantiationException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 65, 0, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.VARCHAR, 256, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, "GUPROFILES_1", 1);
        super.upgradeOldTable(database, updateDetailsTable, "GUPROFILES_2", 2);
    }

    @Override
    public synchronized GUProfileRecord addRecord(String string, String string2) {
        GUProfileRecord gUProfileRecord = new GUProfileRecord(string, string2);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(gUProfileRecord.getGroupName());
        fieldValueArray[1].setValue(gUProfileRecord.getUserName());
        try {
            super.insert(fieldValueArray);
            return gUProfileRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteRecordByUserName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string), 1);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteRecordByGroupName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string2), 12);
            stringBuffer.append(" AND ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getGroupNamesByUser(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[0])};
        Vector<String> vector = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            recordset = super.query(fieldArray, stringBuffer.toString(), parameterMetaInfo, false);
            vector = new Vector<String>();
            while (recordset.next()) {
                vector.add(recordset.getString(COLNAMES[0]));
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getUserNamesByGroup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[1])};
        Vector<String> vector = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            recordset = super.query(fieldArray, stringBuffer.toString(), parameterMetaInfo, false);
            vector = new Vector<String>();
            while (recordset.next()) {
                vector.add(recordset.getString(COLNAMES[1]));
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public synchronized int getGroupsCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            n = super.queryCountValue(COLNAMES[0], stringBuffer.toString(), parameterMetaInfo, false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    @Override
    public synchronized int getUsersCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.queryCountValue(COLNAMES[1], stringBuffer.toString(), parameterMetaInfo, false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized GUProfileRecord getRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        GUProfileRecord gUProfileRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string2, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=? AND ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            while (recordset.next()) {
                gUProfileRecord = this.COLNAMES(recordset);
            }
        }
        catch (SQLException sQLException) {
            gUProfileRecord = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return gUProfileRecord;
    }

    private synchronized GUProfileRecord COLNAMES(Recordset recordset) throws SQLException {
        GUProfileRecord gUProfileRecord = new GUProfileRecord();
        gUProfileRecord.setGroupName(recordset.getString(COLNAMES[0]));
        gUProfileRecord.setUserName(recordset.getString(COLNAMES[1]));
        return gUProfileRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Hashtable[] getAllRecords() {
        Hashtable[] hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable()};
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                Vector<String> vector;
                String string = recordset.getString(COLNAMES[0]);
                String string2 = recordset.getString(COLNAMES[1]);
                Vector vector2 = (Vector)hashtableArray[0].get(string);
                Vector vector3 = (Vector)hashtableArray[1].get(string2);
                if (vector2 != null) {
                    vector2.add(string2);
                } else {
                    vector = new Vector<String>();
                    vector.add(string2);
                    hashtableArray[0].put(string, vector);
                }
                if (vector3 != null) {
                    vector3.add(string);
                    continue;
                }
                vector = new Vector();
                vector.add(string);
                hashtableArray[1].put(string2, vector);
            }
        }
        catch (SQLException sQLException) {
            hashtableArray = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return hashtableArray;
    }

    private void EMPTY(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields("group_name").getValue());
            fieldValueArray[1].setValue(recordset.fields("user_name").getValue());
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    @Override
    public boolean deleteRecordByOrganization(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append(" LIKE ?");
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" OR ").append(super.fields(COLNAMES[1]).getName()).append(" LIKE ?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    static {
        GUProfileTableImpl.COLNAMES[0] = "group_name";
        GUProfileTableImpl.COLNAMES[1] = "user_name";
    }
}

