/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.GroupRecord;
import jet.server.db.security2.GroupTable;
import jet.server.log.ServiceLogger;

public class GroupTableImpl
extends TableImpl
implements Table,
GroupTable {
    public static final int VERSION = 3;
    public static final int OLDVERSION = 1;
    public static final int OLDVERSION2 = 2;
    private static final String BIT = "GROUPS_3";
    static final String[] COLNAMES = new String[4];

    public static GroupTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new GroupTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, BIT, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private GroupTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, BIT);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 65, 9, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[2], JDBCType.VARCHAR, 256, 16, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[3], JDBCType.INTEGER, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, "GROUPS_1", 1);
        super.upgradeOldTable(database, updateDetailsTable, "GROUPS_2", 2);
    }

    @Override
    public synchronized GroupRecord addRecord(String string, boolean bl, String string2, int n) {
        GroupRecord groupRecord = new GroupRecord(string, bl, string2, n);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(groupRecord.getName());
        fieldValueArray[1].setValue(new Boolean(groupRecord.isBuiltin()));
        fieldValueArray[2].setValue(groupRecord.getDescription());
        fieldValueArray[3].setValue(new Integer(n));
        try {
            super.insert(fieldValueArray);
            return groupRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteGroup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized GroupRecord getGroup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        GroupRecord groupRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.substring(0), parameterMetaInfo, true);
            while (recordset.next()) {
                groupRecord = this.BIT(recordset);
                if (groupRecord.getName().equals(string)) {
                    break;
                }
                groupRecord = null;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return groupRecord;
    }

    private synchronized GroupRecord BIT(Recordset recordset) throws SQLException {
        GroupRecord groupRecord = new GroupRecord();
        groupRecord.setName(recordset.getString(COLNAMES[0]));
        groupRecord.setBuiltin(recordset.getBoolean(COLNAMES[1]));
        groupRecord.setDescription(recordset.getString(COLNAMES[2]));
        groupRecord.setType(recordset.getInt(COLNAMES[3]));
        return groupRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllGroups() {
        Vector<GroupRecord> vector = new Vector<GroupRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                GroupRecord groupRecord = this.BIT(recordset);
                if (groupRecord == null) continue;
                vector.add(groupRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllGroupsName() {
        Vector<Object> vector = new Vector<Object>();
        FieldValue[] fieldValueArray = new FieldValue[]{this.fields(COLNAMES[0]).createFieldValue()};
        Recordset recordset = null;
        try {
            Object object;
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            if (recordset.next() && (object = recordset.getString(COLNAMES[0])) != null) {
                vector.add(object);
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            vector = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public boolean deleteRecordByOrganization(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append(" LIKE ?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    static {
        GroupTableImpl.COLNAMES[0] = "name";
        GroupTableImpl.COLNAMES[1] = "buildin";
        GroupTableImpl.COLNAMES[2] = "description";
        GroupTableImpl.COLNAMES[3] = "group_type";
    }
}

