/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.OrganizationRecord;
import jet.server.db.security2.OrganizationTable;
import jet.server.log.ServiceLogger;

public class OrganizationTableImpl
extends TableImpl
implements OrganizationTable {
    public static final int VERSION = 1;
    public static final String TABLENAME = "ORGANIZATIONS_1";
    private static final int EMPTY = 0;
    private static final int INTEGER = 1;
    private static final int SEDU = 2;
    private static final String[] VARCHAR = new String[3];

    public static OrganizationTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new OrganizationTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private OrganizationTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), VARCHAR[0], JDBCType.VARCHAR, 32, 9, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR[1], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR[2], JDBCType.INTEGER, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    @Override
    public OrganizationRecord addRecord(String string, String string2, int n) {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(string2);
        fieldValueArray[2].setValue(new Integer(n));
        try {
            super.insert(fieldValueArray);
            return new OrganizationRecord(string, string2, n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllRecords() {
        ArrayList<OrganizationRecord> arrayList = new ArrayList<OrganizationRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                OrganizationRecord organizationRecord = this.EMPTY(recordset);
                if (organizationRecord == null) continue;
                arrayList.add(organizationRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return arrayList;
    }

    private OrganizationRecord EMPTY(Recordset recordset) throws SQLException {
        return new OrganizationRecord(recordset.getString(0), recordset.getString(1), recordset.getInt(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrganizationRecord getRecord(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        OrganizationRecord organizationRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(VARCHAR[0]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(VARCHAR[0]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                organizationRecord = this.EMPTY(recordset);
            }
            OrganizationRecord organizationRecord2 = organizationRecord;
            return organizationRecord2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return organizationRecord;
    }

    @Override
    public boolean deleteRecord(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(VARCHAR[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(VARCHAR[0]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public boolean updateRecord(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        FieldValue[] fieldValueArray = new FieldValue[]{this.fields(VARCHAR[1]).createFieldValue(), this.fields(VARCHAR[2]).createFieldValue()};
        fieldValueArray[0].setValue(string2);
        fieldValueArray[1].setValue(new Integer(n));
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(VARCHAR[0]).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(VARCHAR[0]).getName()).append("=?");
        try {
            int n2 = super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    static {
        OrganizationTableImpl.VARCHAR[0] = "name";
        OrganizationTableImpl.VARCHAR[1] = "description";
        OrganizationTableImpl.VARCHAR[2] = "useramount";
    }
}

