/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.storage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.db.storage.StorageMemberTable;
import jet.server.db.storage.StorageRecord;
import jet.server.log.ServiceLogger;

public class StorageResourceTable
extends TableImpl {
    public static final int VERSION = 1;
    public static final String TABLE_NAME = "STORAGE_RESOURCE_1";
    static final String[] colNames = new String[]{"ID", "PATH", "ISDIRECTORY", "LAST_MODIFIED"};
    private static final int BIGINT = 0;
    private static final int BIT = 1;
    private static final int EMPTY = 2;
    private static final int INTEGER = 3;
    private StorageMemberTable SEDU;

    public StorageResourceTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), colNames[0], JDBCType.INTEGER, 0, 11, 0));
        super.append(new FieldImpl(this.getName(), colNames[1], JDBCType.VARCHAR, 255, 5, 0));
        super.append(new FieldImpl(this.getName(), colNames[2], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[3], JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        this.SEDU = new StorageMemberTable(database);
    }

    @Override
    public void close() {
        super.close();
        if (this.SEDU != null) {
            this.SEDU.close();
            this.SEDU = null;
        }
    }

    public boolean addFile(final StorageRecord storageRecord, final Integer ... integerArray) {
        try {
            boolean bl;
            boolean bl2 = bl = storageRecord.getID() == -1;
            if (bl) {
                storageRecord.setID(this.getDBAdapter().getID(this, this.fields(0)));
            }
            ((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    if (bl) {
                        FieldValue[] fieldValueArray = StorageResourceTable.this.fields().values();
                        fieldValueArray[0].setValue(storageRecord.getID());
                        fieldValueArray[1].setValue(storageRecord.getPath());
                        fieldValueArray[2].setValue(storageRecord.isDirectory());
                        fieldValueArray[3].setValue(storageRecord.getLastModified());
                        try {
                            StorageResourceTable.this.insert(fieldValueArray);
                        }
                        catch (SQLException sQLException) {
                            StorageRecord storageRecord2 = StorageResourceTable.this.getFile(storageRecord.getPath());
                            if (storageRecord2 == null || storageRecord2.isDirectory() != storageRecord.isDirectory()) {
                                ServiceLogger.logError("Storage:: addFile file failed: " + sQLException.getMessage() + "\n\t toAddFile=" + storageRecord + "\n\t existsFile=" + storageRecord2, 2);
                                throw sQLException;
                            }
                            ServiceLogger.logError("Storage:: the file is exists, ignore previous error: " + sQLException.getMessage() + "\n\t toAddFile=" + storageRecord + "\n\t existsFile=" + storageRecord2, 3);
                            storageRecord.setID(storageRecord2.getID());
                        }
                    }
                    StorageResourceTable.this.SEDU.addMember(storageRecord, true, integerArray);
                    return null;
                }
            });
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        catch (LockException lockException) {
            ServiceLogger.logError(lockException);
        }
        return false;
    }

    public boolean addMember(final StorageRecord storageRecord, final Integer ... integerArray) {
        try {
            return (Boolean)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    return StorageResourceTable.this.SEDU.addMember(storageRecord, false, integerArray);
                }
            });
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        catch (LockException lockException) {
            ServiceLogger.logError(lockException);
        }
        return false;
    }

    public boolean deleteFile(final StorageRecord ... storageRecordArray) {
        if (storageRecordArray == null || storageRecordArray.length == 0) {
            return false;
        }
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WHERE ").append(this.fields(0).getName());
        if (storageRecordArray.length == 1) {
            stringBuilder.append("=?");
        } else {
            stringBuilder.append(" IN(");
            for (int i = 0; i < storageRecordArray.length; ++i) {
                stringBuilder.append("?");
                if (i >= storageRecordArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
        }
        final ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        for (StorageRecord storageRecord : storageRecordArray) {
            parameterMetaInfo.add(this.fields(0).getName(), storageRecord.getID(), 4);
        }
        try {
            ((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    StorageResourceTable.this.SEDU.deleteFile(storageRecordArray);
                    StorageResourceTable.this.delete(stringBuilder.toString(), parameterMetaInfo);
                    return null;
                }
            });
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        catch (LockException lockException) {
            ServiceLogger.logError(lockException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageRecord getFile(int n) {
        StorageRecord storageRecord = null;
        Recordset recordset = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(this.fields(0).getName()).append("=?");
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(0).getName(), n, 4);
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                storageRecord = new StorageRecord();
                storageRecord.setID(recordset.getInt(0));
                storageRecord.setPath(recordset.getString(1));
                storageRecord.setDirectory(recordset.getBoolean(2));
                storageRecord.setLastModified(recordset.getLong(3));
                storageRecord.getMembers().addAll(this.SEDU.getMember(storageRecord.getID()));
            }
        }
        catch (SQLException sQLException) {
            storageRecord = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return storageRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageRecord getFile(String string) {
        StorageRecord storageRecord = null;
        Recordset recordset = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(this.fields(1).getName()).append("=?");
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(1).getName(), string, 12);
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                storageRecord = new StorageRecord();
                storageRecord.setID(recordset.getInt(0));
                storageRecord.setPath(recordset.getString(1));
                storageRecord.setDirectory(recordset.getBoolean(2));
                storageRecord.setLastModified(recordset.getLong(3));
                storageRecord.getMembers().addAll(this.SEDU.getMember(storageRecord.getID()));
            }
        }
        catch (SQLException sQLException) {
            storageRecord = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return storageRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAll() {
        ArrayList<StorageRecord> arrayList = new ArrayList<StorageRecord>();
        Recordset recordset = null;
        try {
            Map map = this.SEDU.getAll();
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                List list;
                StorageRecord storageRecord = new StorageRecord();
                storageRecord.setID(recordset.getInt(0));
                storageRecord.setPath(recordset.getString(1));
                storageRecord.setDirectory(recordset.getBoolean(2));
                storageRecord.setLastModified(recordset.getLong(3));
                if (map != null && (list = (List)map.get(storageRecord.getID())) != null) {
                    storageRecord.getMembers().addAll(list);
                }
                arrayList.add(storageRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return arrayList;
    }
}

