/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.transfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.api.db.Tables;
import jet.server.db.core.Dbs;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TransferHelp;
import jet.server.util.WebSecurityUtil;

public abstract class AbstractTransferHelp
implements TransferHelp {
    public static final String MANIFEST = "MANIFEST";
    public static final String SPCHAR = ";";
    protected static final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static final ZipOutputStream createBackupVolume(String string, String string2) throws IOException {
        Object object;
        File file = WebSecurityUtil.validateFilePath(string);
        if (!file.exists() && (object = file.getParentFile()) != null) {
            ((File)object).mkdirs();
        }
        object = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        ((ZipOutputStream)object).putNextEntry(new ZipEntry(string2));
        return object;
    }

    private static void C(Table table, List list, Map map) {
        if (list.contains(table)) {
            return;
        }
        for (String string : table.getForeignTableNames()) {
            Table table2 = (Table)map.get(string);
            if (table2 == null) continue;
            AbstractTransferHelp.C(table2, list, map);
        }
        list.add(table);
    }

    public static List sortBackupTables(Tables tables) {
        HashMap<String, Table> hashMap = new HashMap<String, Table>();
        for (Table table : tables.toArray()) {
            hashMap.put(table.getName(), table);
        }
        ArrayList arrayList = new ArrayList();
        for (Table table : hashMap.values()) {
            AbstractTransferHelp.C(table, arrayList, hashMap);
        }
        return arrayList;
    }

    public static final List getRestoreList(Properties properties) {
        Object var1_1 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("tableset"), SPCHAR);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static void deleteTablesPreRestore(List list, String string, Database database) throws SQLException {
        ArrayList arrayList = new ArrayList(list);
        Collections.reverse(arrayList);
        for (String string2 : arrayList) {
            String string3 = Dbs.fullTableName(string, string2);
            Table table = database.tables(string3);
            if (table == null) continue;
            table.delete(null, ParameterMetaInfo.EMPTY);
        }
    }

    public static final boolean exportExternalData(ZipOutputStream zipOutputStream, String string, String string2, String string3) throws IOException {
        File file = WebSecurityUtil.validateFilePath(string);
        if (file == null || !file.exists()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (file.isDirectory()) {
            int n = string2.length();
            stringBuffer.append(string3).append(string.substring(n)).append("/");
            String string4 = AbstractTransferHelp.replacePathSeparator(stringBuffer.toString(), '\\', '/');
            zipOutputStream.putNextEntry(new ZipEntry(string4));
            zipOutputStream.closeEntry();
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(string).append(File.separator).append(stringArray[i]);
                AbstractTransferHelp.exportExternalData(zipOutputStream, stringBuffer.toString(), string2, string3);
            }
        } else {
            int n = string2.length();
            String string5 = AbstractTransferHelp.replacePathSeparator(string3 + string.substring(n), '\\', '/');
            zipOutputStream.putNextEntry(new ZipEntry(string5));
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            byte[] byArray = new byte[2048];
            int n2 = -1;
            while ((n2 = randomAccessFile.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n2);
            }
            zipOutputStream.closeEntry();
            randomAccessFile.close();
        }
        return true;
    }

    public static final int exportTableData(ZipOutputStream zipOutputStream, ZipEntry zipEntry, Recordset recordset) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        zipOutputStream.putNextEntry(zipEntry);
        recordset.first();
        int n = 0;
        while (recordset.next()) {
            stringBuffer.delete(0, stringBuffer.length());
            zipOutputStream.write(AbstractTransferHelp.formatExport(stringBuffer, recordset.fields()).getBytes());
            ++n;
        }
        zipOutputStream.closeEntry();
        return n;
    }

    public static final int exportTableData(ZipOutputStream zipOutputStream, ZipEntry zipEntry, List list) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        zipOutputStream.putNextEntry(zipEntry);
        for (FieldValue[] fieldValueArray : list) {
            stringBuffer.delete(0, stringBuffer.length());
            zipOutputStream.write(AbstractTransferHelp.formatExport(stringBuffer, fieldValueArray).getBytes());
        }
        zipOutputStream.closeEntry();
        return list.size();
    }

    public static final String formatExport(StringBuffer stringBuffer, FieldValue[] fieldValueArray) {
        int n = stringBuffer.length();
        int n2 = fieldValueArray.length;
        for (int i = 0; i < n2; ++i) {
            FieldValue fieldValue = fieldValueArray[i];
            switch (fieldValue.getJDBCType().dataType()) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    stringBuffer.append("\"").append(fieldValue.getString()).append("\"");
                    break;
                }
                case -7: 
                case 16: {
                    boolean bl = fieldValue.getBoolean();
                    stringBuffer.append(bl ? "true" : "false");
                    break;
                }
                case -6: {
                    stringBuffer.append(fieldValue.getByte());
                    break;
                }
                case 5: {
                    stringBuffer.append(fieldValue.getShort());
                    break;
                }
                case 4: {
                    stringBuffer.append(fieldValue.getInt());
                    break;
                }
                case -5: {
                    stringBuffer.append(fieldValue.getLong());
                    break;
                }
                case 6: 
                case 7: {
                    stringBuffer.append(fieldValue.getFloat());
                    break;
                }
                case 8: {
                    stringBuffer.append(fieldValue.getDouble());
                    break;
                }
                case 2: 
                case 3: {
                    stringBuffer.append(fieldValue.getValue());
                    break;
                }
                case 91: {
                    stringBuffer.append(fieldValue.getDate());
                    break;
                }
                case 92: {
                    stringBuffer.append(fieldValue.getTime());
                    break;
                }
                case 93: {
                    stringBuffer.append(fieldValue.getTimestamp());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    stringBuffer.append("\"");
                    byte[] byArray = fieldValue.getBytes();
                    for (int j = 0; j < byArray.length; ++j) {
                        stringBuffer.append(AbstractTransferHelp.byteToHexString(byArray[j]));
                    }
                    stringBuffer.append("\"");
                    break;
                }
                default: {
                    stringBuffer.append("\"").append(fieldValue.getValue()).append("\"");
                }
            }
            if (i < n2 - 1) {
                stringBuffer.append(",");
                continue;
            }
            stringBuffer.append(";\r\n");
        }
        return stringBuffer.substring(n);
    }

    public static final String byteToHexString(byte by) {
        String string = Integer.toHexString(by & 0xFF).toUpperCase();
        if (string.length() < 2) {
            return "0" + string;
        }
        return string;
    }

    public static final void importsExternalData(String string, InputStream inputStream) throws IOException {
        String string2 = AbstractTransferHelp.replacePathSeparator(string, '/', File.separatorChar);
        File file = WebSecurityUtil.validateFilePath(string2);
        if (string2.endsWith(File.separator)) {
            file.mkdirs();
            return;
        }
        file.getParentFile().mkdirs();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        byte[] byArray = new byte[2048];
        int n = -1;
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            randomAccessFile.write(byArray, 0, n);
        }
        randomAccessFile.close();
        bufferedInputStream.close();
    }

    public static final int importsTableData(Table table, List list, InputStream inputStream) throws SQLException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string);
            list.add(AbstractTransferHelp.DF(table, bufferedReader, stringBuffer, string));
            ++n;
        }
        return n;
    }

    private static FieldValue[] DF(Table table, BufferedReader bufferedReader, StringBuffer stringBuffer, String string) throws SQLException, IOException {
        FieldValue[] fieldValueArray = table.fields().values();
        while (!string.endsWith(SPCHAR)) {
            string = bufferedReader.readLine();
            stringBuffer.append(string);
        }
        try {
            fieldValueArray = AbstractTransferHelp.formatImport(fieldValueArray, stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("] is crushed") > 0) {
                String string2 = bufferedReader.readLine();
                stringBuffer.append(string2);
                return AbstractTransferHelp.DF(table, bufferedReader, stringBuffer, string2);
            }
            throw iOException;
        }
        return fieldValueArray;
    }

    public static final FieldValue[] formatImport(FieldValue[] fieldValueArray, String string) throws SQLException, IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>(fieldValueArray.length);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("\"", 0) && !bl) {
                bl = true;
                if (string2.endsWith("\"")) {
                    arrayList.add(string2.substring(1, string2.length() - 1));
                    bl = false;
                    if (stringBuffer.length() <= 0) continue;
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(string2.substring(1));
                continue;
            }
            if (bl) {
                stringBuffer.append(",");
                if (string2.endsWith("\"")) {
                    stringBuffer.append(string2.substring(0, string2.length() - 1));
                    arrayList.add(stringBuffer.toString());
                    bl = false;
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(string2);
                continue;
            }
            arrayList.add(string2);
        }
        if (arrayList.size() != fieldValueArray.length) {
            throw new IOException("The [" + string + "] is crushed");
        }
        int n = 0;
        block15: for (int i = 0; i < fieldValueArray.length; ++i) {
            int n2 = fieldValueArray[i].getJDBCType().dataType();
            switch (n2) {
                case -6: {
                    fieldValueArray[i].setValue(Byte.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case 5: {
                    fieldValueArray[i].setValue(Short.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case 4: {
                    fieldValueArray[i].setValue(Integer.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case -5: {
                    fieldValueArray[i].setValue(Long.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case 6: {
                    fieldValueArray[i].setValue(Float.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    fieldValueArray[i].setValue(new BigDecimal((String)arrayList.get(i)));
                    continue block15;
                }
                case -7: 
                case 16: {
                    fieldValueArray[i].setValue(Boolean.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    if (((String)arrayList.get(i)).equalsIgnoreCase("null")) {
                        ++n;
                        fieldValueArray[i] = null;
                        continue block15;
                    }
                    fieldValueArray[i].setValue(arrayList.get(i));
                    continue block15;
                }
                case 91: {
                    fieldValueArray[i].setValue(Date.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case 92: {
                    fieldValueArray[i].setValue(Time.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case 93: {
                    fieldValueArray[i].setValue(Timestamp.valueOf((String)arrayList.get(i)));
                    continue block15;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    String string3 = (String)arrayList.get(i);
                    byte[] byArray = new byte[string3.length() / 2];
                    char[] cArray = string3.toCharArray();
                    for (int j = 0; j < byArray.length; ++j) {
                        int n3 = 2 * j;
                        byArray[j] = (byte)(AbstractTransferHelp.EMPTY(cArray[n3]) << 4 | AbstractTransferHelp.EMPTY(cArray[n3 + 1]));
                    }
                    fieldValueArray[i].setValue(byArray);
                    continue block15;
                }
            }
        }
        return fieldValueArray;
    }

    private static byte EMPTY(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static final String replacePathSeparator(String string, char c, char c2) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            cArray[i] = c2;
        }
        return new String(cArray);
    }

    public static final void deleteExternalData(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                AbstractTransferHelp.deleteExternalData(fileArray[i]);
            }
            file.delete();
        }
    }

    public static Properties getVolumeSummary(ZipFile zipFile) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipFile.getEntry(MANIFEST));
        }
        catch (Exception exception) {
            properties.setProperty("status", "-1");
            properties.put("exception", exception);
            return properties;
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            properties.setProperty("status", "-1");
            properties.put("exception", iOException);
            return properties;
        }
        properties.setProperty("status", "0");
        return properties;
    }
}

