/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.transfer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jet.server.api.db.Database;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.Dbs;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.transfer.AbstractTransferHelp;
import jet.server.util.WebSecurityUtil;

public final class ProfilingTransferHelp
extends AbstractTransferHelp {
    @Override
    public synchronized boolean backup(Database database, String string) throws SQLException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        System.out.println("Backup begin...");
        String string2 = database.getWorkspace().getName();
        String string3 = database.getName();
        String string4 = string2 + "/";
        ZipOutputStream zipOutputStream = ProfilingTransferHelp.createBackupVolume(string, string4);
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        properties.setProperty("version", "1.0");
        properties.setProperty("type", "BAK");
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string2);
        properties.setProperty("database", string3);
        List list = AbstractTransferHelp.sortBackupTables(database.ProfileTables());
        for (Table table : list) {
            String string5 = table.getName();
            Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2, 1003);
            System.out.print("Backup " + string3 + "." + string5 + " ... ");
            n = ProfilingTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string4 + table.getNameWithoutSchema() + ".dat"), recordset);
            recordset.close();
            System.out.println(n + " OK");
            stringBuffer.append(table.getNameWithoutSchema()).append(";");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
        properties.setProperty("tableset", stringBuffer.toString());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "JREntServer profiling data backup archive");
        zipOutputStream.write(byteArrayOutputStream.toByteArray());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        System.gc();
        System.out.println("Backup end");
        return true;
    }

    @Override
    public synchronized boolean restore(Database database, String string) throws SQLException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(string);
        Properties properties = ProfilingTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string2 = properties.getProperty("version");
        String string3 = properties.getProperty("type");
        String string4 = properties.getProperty("realm");
        String string5 = properties.getProperty("database");
        String string6 = database.getProperty("schema");
        String string7 = database.getWorkspace().getName();
        String string8 = database.getName();
        if (!(string7.equals(string4) && string8.equals(string5) && string2.equals("1.0") && string3.equals("BAK"))) {
            throw new IOException("The " + string + " is not for " + string7 + "." + string8);
        }
        String string9 = string7 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string9);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string7 + " workspace.");
        }
        List list = ProfilingTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        System.out.println("Restore begin...");
        ProfilingTransferHelp.deleteTablesPreRestore(list, string6, database);
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string10 = (String)iterator.next();
            String string11 = Dbs.fullTableName(string6, string10);
            Table table = database.tables(string11);
            String string12 = string9 + string10 + ".dat";
            ZipEntry zipEntry2 = zipFile.getEntry(string12);
            if (table == null || zipEntry2 == null) continue;
            System.out.print("Restore " + database.getName() + "." + string11 + " ...");
            ProfilingTransferHelp.importsTableData(table, arrayList, zipFile.getInputStream(zipEntry2));
            int n2 = table.insert2(arrayList);
            arrayList.clear();
            System.out.println(n2 + " OK");
        }
        zipFile.close();
        System.gc();
        System.out.println("Restore end");
        return true;
    }

    @Override
    public synchronized boolean cutdownTable(Database database, Table table, String string, String string2) throws SQLException, IOException {
        String string3 = database.getWorkspace().getName();
        String string4 = database.getName();
        String string5 = table.getName();
        String string6 = table.getNameWithoutSchema();
        String string7 = Dbs.fullTableName(database.getProperty("schema"), "");
        if (!string5.equalsIgnoreCase(string7 + "TaskContext_2")) {
            throw new SQLException("Can not cut down " + string5 + " in " + string4);
        }
        String string8 = null;
        long l = 0L;
        if (string2 != null && string2.trim().length() > 0) {
            try {
                l = DF.parse(string2).getTime() + 60000L;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        string8 = "WHERE TS_TSK_COMPLETE <=?";
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("TS_TSK_COMPLETE", new Timestamp(l));
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        properties.setProperty("version", "1.0");
        properties.setProperty("type", "CUT");
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string3);
        properties.setProperty("database", string4);
        if (string != null && string.trim().length() > 0) {
            System.out.println("Backup begin...");
            String string9 = string3 + "/";
            ZipOutputStream zipOutputStream = ProfilingTransferHelp.createBackupVolume(string, string9);
            Recordset recordset = table.query(table.fields().toArray(), string8 + " ORDER BY " + string5 + ".TS_TSK_COMPLETE ASC", parameterMetaInfo, false, 2, 1003);
            String string10 = null;
            if (recordset.next()) {
                string10 = DF.format(new Date(recordset.getTimestamp("TS_TSK_COMPLETE").getTime()));
            }
            System.out.print("Backup " + string4 + "." + string5 + " ... ");
            int n = ProfilingTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string9 + string6 + ".dat"), recordset);
            string10 = string10 != null ? string10 + " to " + DF.format(new Date(recordset.getTimestamp("TS_TSK_COMPLETE").getTime())) : "";
            properties.setProperty("scope", string10);
            recordset.close();
            System.out.println(n + " OK");
            stringBuffer.append(string6);
            zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
            properties.setProperty("tableset", stringBuffer.toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, "JREntServer profiling data cutdown archive");
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            System.out.println("Backup end");
        }
        table.delete(string8, parameterMetaInfo);
        System.gc();
        return true;
    }

    @Override
    public synchronized boolean importsTable(Database database, Table table, String string) throws SQLException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(WebSecurityUtil.validateFilePath(string));
        Properties properties = ProfilingTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string2 = properties.getProperty("version");
        String string3 = properties.getProperty("type");
        String string4 = properties.getProperty("realm");
        String string5 = properties.getProperty("database");
        String string6 = database.getWorkspace().getName();
        String string7 = database.getName();
        if (!(string6.equals(string4) && string7.equals(string5) && string2.equals("1.0") && string3.equals("CUT"))) {
            throw new IOException("The " + string + " is not for " + string6 + "." + string7);
        }
        String string8 = table.getName();
        String string9 = Dbs.fullTableName(database.getProperty("schema"), "TASKCONTEXT_2");
        if (!string9.equalsIgnoreCase(string8)) {
            throw new SQLException("Can not import " + string8 + " in " + string7);
        }
        String string10 = string6 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string10);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string6 + " workspace.");
        }
        List list = ProfilingTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string11 = (String)iterator.next();
            if (!string11.equals(string8)) {
                throw new IOException("The " + string + " not for " + string8);
            }
            String string12 = string10 + string11 + ".dat";
            ZipEntry zipEntry2 = zipFile.getEntry(string12);
            if (zipEntry2 == null) continue;
            System.out.print("Restore " + database.getName() + "." + string11 + " ...");
            ProfilingTransferHelp.importsTableData(table, arrayList, zipFile.getInputStream(zipEntry2));
            int n2 = table.insert2(arrayList);
            arrayList.clear();
            System.out.println(n2 + " OK");
        }
        zipFile.close();
        System.gc();
        System.out.println("Restore end");
        return true;
    }

    @Override
    public synchronized void checkIntegrality(Database database, Map map) throws SQLException {
    }
}

