/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.transfer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jet.server.api.db.Database;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.Dbs;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.transfer.AbstractTransferHelp;

public final class SystemDBTransferHelp
extends AbstractTransferHelp {
    @Override
    public synchronized boolean backup(Database database, String string) throws SQLException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        System.out.println("Backup begin...");
        String string2 = database.getWorkspace().getName();
        String string3 = database.getName();
        String string4 = string2 + "/";
        ZipOutputStream zipOutputStream = SystemDBTransferHelp.createBackupVolume(string, string4);
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        properties.setProperty("version", "1.0");
        properties.setProperty("type", "BAK");
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string2);
        properties.setProperty("database", string3);
        List list = AbstractTransferHelp.sortBackupTables(database.Systemtables());
        for (Table table : list) {
            Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2, 1003);
            String string5 = table.getName();
            System.out.print("Backup " + string3 + "." + string5 + " ... ");
            n = SystemDBTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string4 + table.getNameWithoutSchema() + ".dat"), recordset);
            recordset.close();
            System.out.println(n + " OK");
            stringBuffer.append(table.getNameWithoutSchema()).append(";");
        }
        if (stringBuffer.length() > 1) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
        properties.setProperty("tableset", stringBuffer.toString());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "JREntServer system data backup archive");
        zipOutputStream.write(byteArrayOutputStream.toByteArray());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        System.gc();
        System.out.println("Backup end");
        return true;
    }

    @Override
    public synchronized boolean restore(Database database, String string) throws SQLException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(string);
        Properties properties = SystemDBTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string2 = properties.getProperty("version");
        String string3 = properties.getProperty("type");
        String string4 = properties.getProperty("realm");
        String string5 = properties.getProperty("database");
        String string6 = database.getProperty("schema");
        String string7 = database.getWorkspace().getName();
        String string8 = database.getName();
        if (!(string7.equals(string4) && string8.equals(string5) && string2.equals("1.0") && string3.equals("BAK"))) {
            throw new IOException("The " + string + " is not for " + string7 + "." + string8);
        }
        String string9 = string7 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string9);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string7 + " workspace.");
        }
        List list = SystemDBTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        System.out.println("Restore begin...");
        SystemDBTransferHelp.deleteTablesPreRestore(list, string6, database);
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string10 = (String)iterator.next();
            String string11 = Dbs.fullTableName(string6, string10);
            Table table = database.tables(string11);
            String string12 = string9 + string10 + ".dat";
            ZipEntry zipEntry2 = zipFile.getEntry(string12);
            if (table == null || zipEntry2 == null) continue;
            System.out.print("Restore " + database.getName() + "." + string11 + " ...");
            SystemDBTransferHelp.importsTableData(table, arrayList, zipFile.getInputStream(zipEntry2));
            int n2 = table.insert2(arrayList);
            arrayList.clear();
            System.out.println(n2 + " OK");
        }
        zipFile.close();
        System.gc();
        System.out.println("Restore end");
        return true;
    }

    @Override
    public synchronized boolean cutdownTable(Database database, Table table, String string, String string2) throws SQLException, IOException {
        return false;
    }

    @Override
    public synchronized boolean importsTable(Database database, Table table, String string) throws SQLException, IOException {
        return false;
    }

    @Override
    public synchronized void checkIntegrality(Database database, Map map) throws SQLException {
    }
}

