/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.version;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.db.event.RecordEventListenerManager;
import jet.server.db.event.RecordEventType;
import jet.server.db.version.AbstractVersionTableImpl;
import jet.server.db.version.LCVersionRecord;
import jet.server.intf.version.LCVersionTable;
import jet.server.log.ServiceLogger;

public class LCVersionTableImpl
extends AbstractVersionTableImpl
implements LCVersionTable {
    public static String TABLE_NAME = "LCVERSION_2";
    public static String LCTABLE_1 = "LCVERSION_1";
    private static final String[] BIGINT = new String[]{"versionNumber", "versionName", "resourceID", "creator", "createdTime", "modifier", "modifiedTime", "lcFile", "id", "diskSize"};

    public static LCVersionTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            LCVersionTableImpl lCVersionTableImpl = new LCVersionTableImpl(database, updateDetailsTable);
            RecordEventListenerManager.initListener(lCVersionTableImpl);
            return lCVersionTableImpl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLE_NAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private LCVersionTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIGINT[0], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[1], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[2], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[3], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[4], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[5], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[6], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[7], JDBCType.VARCHAR, 512, 1, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[8], JDBCType.BIGINT, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[9], JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, LCTABLE_1, 1);
        try {
            this.adapter.setID(this, this.fields(BIGINT[8]), this.INTEGER() + 1);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    @Override
    public synchronized int addRecord(String string, final int n, String string2, long l, String string3, long l2) {
        final FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(new Integer(n));
        fieldValueArray[3].setValue(string2);
        fieldValueArray[4].setValue(new Long(l));
        fieldValueArray[5].setValue("");
        fieldValueArray[6].setValue(0);
        String string4 = this.ruleExternalDataPath(string3, this.getHistDir());
        fieldValueArray[7].setValue(string4);
        fieldValueArray[8].setValue(new Integer(this.LCTABLE_1()));
        fieldValueArray[9].setValue(new Long(l2));
        try {
            int n2 = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n2 = LCVersionTableImpl.this.EMPTY(n);
                    fieldValueArray[0].setValue(n2);
                    LCVersionTableImpl.this.insert(fieldValueArray);
                    return n2;
                }
            });
            LCVersionRecord lCVersionRecord = new LCVersionRecord();
            lCVersionRecord.setVersionID(n2);
            this.fireEvent(RecordEventType.inserted, lCVersionRecord, string4);
            return n2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return -1;
        }
        catch (LockException lockException) {
            ServiceLogger.logError(lockException);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LCVersionRecord getRecord(int n, int n2) {
        LCVersionRecord lCVersionRecord = new LCVersionRecord();
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n2), 4);
            String string = "WHERE " + super.fields(0).getName() + "=? AND " + super.fields(2).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            if (recordset.next()) {
                lCVersionRecord = this.BIGINT(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return lCVersionRecord;
    }

    @Override
    public synchronized boolean delRecord(int n, int n2) {
        LCVersionRecord lCVersionRecord = this.getRecord(n, n2);
        try {
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n2), 4);
            stringBuffer.append(" WHERE ").append(super.fields(2).getName()).append("=?");
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            stringBuffer.append(" AND ").append(super.fields(0).getName()).append("=?");
            n3 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            this.fireEvent(RecordEventType.deleted, lCVersionRecord, lCVersionRecord.getLcFile());
            return n3 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean delRecords(int n) {
        Vector vector = this.getAllRecords(n);
        try {
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(2).getName()).append("=?");
            n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            for (LCVersionRecord lCVersionRecord : vector) {
                this.fireEvent(RecordEventType.deleted, lCVersionRecord, lCVersionRecord.getLcFile());
            }
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    private LCVersionRecord BIGINT(Recordset recordset) throws SQLException {
        LCVersionRecord lCVersionRecord = new LCVersionRecord();
        lCVersionRecord.setVersionID(recordset.getInt(BIGINT[0]));
        lCVersionRecord.setVersionName(recordset.getString(BIGINT[1]));
        lCVersionRecord.setResourceID(recordset.getInt(BIGINT[2]));
        lCVersionRecord.setCreator(recordset.getString(BIGINT[3]));
        lCVersionRecord.setCreatedTime(recordset.getLong(BIGINT[4]));
        lCVersionRecord.setModifier(recordset.getString(BIGINT[5]));
        lCVersionRecord.setModifiedTime(recordset.getLong(BIGINT[6]));
        lCVersionRecord.setLcFile(recordset.getString(BIGINT[7]));
        lCVersionRecord.setDiskSize(recordset.getLong(9));
        return lCVersionRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllRecordsByPath(String string) {
        Vector<LCVersionRecord> vector = new Vector<LCVersionRecord>();
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(7).getName(), string + "%", 12);
            String string2 = "WHERE " + super.fields(7).getName() + " LIKE ?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.add(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecords(int n) {
        Vector<LCVersionRecord> vector = new Vector<LCVersionRecord>();
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(2).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.add(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecords() {
        Vector<LCVersionRecord> vector = new Vector<LCVersionRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, null, true);
            while (recordset.next()) {
                vector.add(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private synchronized int EMPTY(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(2).getName()).append("=?");
            number = super.queryMaxValue(BIGINT[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number == null || number.intValue() <= 0) {
            return 1;
        }
        return number.intValue() + 1;
    }

    @Override
    public synchronized boolean updateRecord(Object object) {
        LCVersionRecord lCVersionRecord = (LCVersionRecord)object;
        FieldValue[] fieldValueArray = super.fields().values();
        FieldValue[] fieldValueArray2 = new FieldValue[fieldValueArray.length - 1];
        for (int i = 0; i < fieldValueArray.length - 1; ++i) {
            fieldValueArray2[i] = fieldValueArray[i];
        }
        fieldValueArray2[fieldValueArray2.length - 1] = fieldValueArray[fieldValueArray.length - 1];
        fieldValueArray2[0].setValue(new Integer(lCVersionRecord.getVersionID()));
        fieldValueArray2[1].setValue(this.adapter.formatValue(lCVersionRecord.getVersionName()));
        fieldValueArray2[2].setValue(new Integer(lCVersionRecord.getResourceID()));
        fieldValueArray2[3].setValue(lCVersionRecord.getCreator());
        fieldValueArray2[4].setValue(new Long(lCVersionRecord.getCreatedTime()));
        fieldValueArray2[5].setValue(lCVersionRecord.getModifier());
        fieldValueArray2[6].setValue(new Long(lCVersionRecord.getModifiedTime()));
        fieldValueArray2[7].setValue(this.ruleExternalDataPath(lCVersionRecord.getLcFile(), this.getHistDir()));
        fieldValueArray2[8].setValue(new Long(lCVersionRecord.getDiskSize()));
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(lCVersionRecord.getVersionID()), 4);
        parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(lCVersionRecord.getResourceID()), 4);
        String string = " WHERE " + super.fields(0).getName() + "=? AND " + super.fields(2).getName() + "=?";
        try {
            int n = super.update(fieldValueArray2, string, parameterMetaInfo);
            LCVersionRecord lCVersionRecord2 = null;
            lCVersionRecord2 = this.getRecord(lCVersionRecord.getVersionID(), lCVersionRecord.getResourceID());
            String string2 = lCVersionRecord.getLcFile();
            String string3 = lCVersionRecord2.getLcFile();
            if (!string2.equals(string3)) {
                this.fireEvent(RecordEventType.deleted, lCVersionRecord, string2);
                this.fireEvent(RecordEventType.inserted, lCVersionRecord, string3);
            }
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized LCVersionRecord getLatestVerRec(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(BIGINT[2]).getName()).append("=?");
            number = super.queryMaxValue(BIGINT[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    @Override
    public synchronized LCVersionRecord getEarliestVerRec(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(BIGINT[2]).getName()).append("=?");
            number = super.queryMinValue(BIGINT[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getVersionNumbers(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        Field[] fieldArray = new Field[]{this.fields(BIGINT[0])};
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(2).getName() + "=?";
            recordset = super.query(fieldArray, string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(new Integer(recordset.getInt(BIGINT[0])));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                recordset.close();
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public synchronized int getVersionAmount(int n) {
        Number number = 0;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(BIGINT[2]).getName()).append("=?");
            number = super.querySumValue(BIGINT[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number;
    }

    @Override
    public synchronized boolean delEarliestVersion(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(BIGINT[2]).getName()).append("=?");
            number = super.queryMinValue(BIGINT[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.delRecord(number.intValue(), n);
        }
        return false;
    }

    private synchronized int INTEGER() {
        Number number = null;
        try {
            number = super.queryMaxValue(BIGINT[8], null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number == null ? -1 : number.intValue();
    }

    private synchronized int LCTABLE_1() {
        try {
            return this.adapter.getID(this, this.fields(BIGINT[8]));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return 1;
        }
    }

    @Override
    public boolean hasExternalData() {
        return true;
    }

    @Override
    public String getExternalDataPath(FieldValue[] fieldValueArray) {
        int n;
        String string = (String)fieldValueArray[7].getValue();
        if (string != null && string.length() != 0 && (n = string.lastIndexOf(File.separator)) > 0) {
            string = string.substring(0, n);
        }
        String string2 = this.getHistDir();
        return string2 + string;
    }
}

