/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.zeroconfig;

import java.sql.Connection;
import java.sql.SQLException;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.db.zeroconfig.MemberRecord;
import jet.server.log.ServiceLogger;

public class MemberTableImpl
extends TableImpl
implements Table {
    public static final String TABLENAME = "MEMBERS";
    static final String[] COLNAMES = new String[3];
    String rmiHost = null;
    int rmiPort = -1;
    int memberID = -1;
    MemberRecord memberRecord = null;

    public static MemberTableImpl newInstance(Database database) {
        try {
            return new MemberTableImpl(database);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private MemberTableImpl(Database database) throws InstantiationException, SQLException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.INTEGER, 0, 9, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.VARCHAR, 32, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[2], JDBCType.INTEGER, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        ((DatabaseImpl)database).appendSystemTable(this);
    }

    public synchronized MemberRecord addRecord(int n, String string, int n2) {
        MemberRecord memberRecord = new MemberRecord(n, string, n2);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(memberRecord.getMemberID());
        fieldValueArray[1].setValue(memberRecord.getRMIHost());
        fieldValueArray[2].setValue(memberRecord.getRMIPort());
        try {
            super.insert(fieldValueArray);
            return memberRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    public synchronized boolean deleteMember(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
        try {
            int n2 = super.delete(stringBuffer.toString(), new ParameterMetaInfo().add("memberID", n));
            return n2 >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MemberRecord getMember(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("memberID", n);
        MemberRecord memberRecord = null;
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), stringBuffer.substring(0), parameterMetaInfo, true);
            while (recordset.next()) {
                memberRecord = this.COLNAMES(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return memberRecord;
    }

    private synchronized MemberRecord COLNAMES(Recordset recordset) throws SQLException {
        MemberRecord memberRecord = new MemberRecord();
        memberRecord.setMemberID(recordset.getInt(COLNAMES[0]));
        memberRecord.setRMIHost(recordset.getString(COLNAMES[1]));
        memberRecord.setRMIPort(recordset.getInt(COLNAMES[2]));
        return memberRecord;
    }

    public synchronized int getLastedMember() {
        Number number = null;
        try {
            number = super.queryMaxValue(COLNAMES[0], null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number != null && number.intValue() > -1 ? number.intValue() : -1;
    }

    public void setRMIHost(String string) {
        this.rmiHost = string;
    }

    public void setRMIPort(int n) {
        this.rmiPort = n;
    }

    public void setMemberID(int n) {
        this.memberID = n;
    }

    Object newMemberID(Connection connection) {
        Number number = null;
        try {
            number = super.queryMaxValue(COLNAMES[0], null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.memberID = number != null && number.intValue() > 0 ? number.intValue() + 1 : 1;
        MemberRecord memberRecord = new MemberRecord(this.memberID, this.rmiHost, this.rmiPort);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(memberRecord.getMemberID());
        fieldValueArray[1].setValue(memberRecord.getRMIHost());
        fieldValueArray[2].setValue(memberRecord.getRMIPort());
        try {
            super.insert(fieldValueArray);
            return memberRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    public synchronized int getNewMemberID() throws SQLException, LockException {
        ((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLENAME, new ExecuteCallback(){

            @Override
            public Object execute(Connection connection) throws SQLException {
                return MemberTableImpl.this.newMemberID(connection);
            }
        });
        return this.memberID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MemberRecord SyncMemberID(Connection connection) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
        MemberRecord memberRecord = null;
        Recordset recordset = null;
        try {
            object = new ParameterMetaInfo().add("memberID", this.memberID);
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), (ParameterMetaInfo)object, true);
            while (recordset.next()) {
                memberRecord = this.COLNAMES(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        if (null != memberRecord) {
            if (memberRecord.getRMIHost().equals(this.rmiHost) && memberRecord.getRMIPort() == this.rmiPort) {
                this.memberRecord = memberRecord;
                return memberRecord;
            }
            object = new MemberRecord(this.memberID, this.rmiHost, this.rmiPort);
            FieldValue[] fieldValueArray = new FieldValue[2];
            fieldValueArray[0] = super.fields(1).createFieldValue();
            fieldValueArray[0].setValue(this.rmiHost);
            fieldValueArray[1] = super.fields(2).createFieldValue();
            fieldValueArray[1].setValue(this.rmiPort);
            String string = " WHERE " + super.fields(0).getName() + "=?";
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), this.memberID, 4);
            try {
                super.update(fieldValueArray, string, parameterMetaInfo);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                this.memberRecord = null;
                return null;
            }
            Object[] objectArray = new Object[]{this.memberID, this.rmiHost, this.rmiPort};
            ServiceLogger.logDebug(0x46F466, objectArray, 4);
            this.memberRecord = object;
            return object;
        }
        object = new MemberRecord(this.memberID, this.rmiHost, this.rmiPort);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(((MemberRecord)object).getMemberID());
        fieldValueArray[1].setValue(((MemberRecord)object).getRMIHost());
        fieldValueArray[2].setValue(((MemberRecord)object).getRMIPort());
        try {
            super.insert(fieldValueArray);
            this.memberRecord = object;
            return object;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            this.memberRecord = null;
            return null;
        }
    }

    public synchronized MemberRecord SyncMemberIDToDB() throws SQLException, LockException {
        ((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLENAME, new ExecuteCallback(){

            @Override
            public Object execute(Connection connection) throws SQLException {
                return MemberTableImpl.this.SyncMemberID(connection);
            }
        });
        return this.memberRecord;
    }

    static {
        MemberTableImpl.COLNAMES[0] = "member_id";
        MemberTableImpl.COLNAMES[1] = "rmi_host";
        MemberTableImpl.COLNAMES[2] = "rmi_port";
    }
}

