/*
 * Decompiled with CFR 0.152.
 */
package jet.server.event.core;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import jet.server.event.EventHandler;
import jet.server.event.Filter;
import jet.server.event.TopicEvent;
import jet.server.event.core.InputChannel;
import jet.server.event.core.RouterService;
import jet.server.log.ServiceLogger;

public final class RouterServiceImpl
implements RouterService,
EventHandler {
    private static final long serialVersionUID = 762631669047955247L;
    private Hashtable SEDU = new Hashtable();
    private ArrayList Z = new ArrayList();

    @Override
    public synchronized int createAgent(Filter filter, InputChannel inputChannel) throws RemoteException {
        SubscriberAgent subscriberAgent = new SubscriberAgent(filter, inputChannel);
        this.SEDU.put(String.valueOf(subscriberAgent.getId()), subscriberAgent);
        return subscriberAgent.getId();
    }

    @Override
    public synchronized void destroyAgent(int n) throws RemoteException {
        this.SEDU.remove(String.valueOf(n));
    }

    @Override
    public synchronized void updateAgent(int n, Filter filter) throws RemoteException {
        SubscriberAgent subscriberAgent = (SubscriberAgent)this.SEDU.get(String.valueOf(n));
        subscriberAgent.setFilter(filter);
    }

    @Override
    public synchronized void enableAgent(int n) throws RemoteException {
        SubscriberAgent subscriberAgent = (SubscriberAgent)this.SEDU.get(String.valueOf(n));
        subscriberAgent.enable = true;
    }

    @Override
    public synchronized void disableAgent(int n) throws RemoteException {
        SubscriberAgent subscriberAgent = (SubscriberAgent)this.SEDU.get(String.valueOf(n));
        subscriberAgent.enable = false;
    }

    @Override
    public synchronized void process(TopicEvent topicEvent) {
        for (SubscriberAgent subscriberAgent : this.SEDU.values()) {
            try {
                subscriberAgent.handle(topicEvent);
            }
            catch (RemoteException remoteException) {
                this.Z.add(subscriberAgent);
            }
        }
        while (!this.Z.isEmpty()) {
            SubscriberAgent subscriberAgent;
            subscriberAgent = (SubscriberAgent)this.Z.remove(0);
            this.SEDU.remove(String.valueOf(subscriberAgent.getId()));
        }
    }

    @Override
    public String echo() throws RemoteException {
        return "Hello";
    }

    private static class SubscriberAgent {
        Filter filter;
        InputChannel sender;
        boolean enable = true;

        SubscriberAgent(Filter filter, InputChannel inputChannel) {
            this.filter = filter;
            this.sender = inputChannel;
        }

        int getId() {
            return this.hashCode();
        }

        public synchronized void handle(TopicEvent topicEvent) throws RemoteException {
            if (this.filter == null || this.sender == null) {
                return;
            }
            if (this.enable && this.filter.accept(topicEvent)) {
                ServiceLogger.print("EventSystem:: agent id: " + this.getId() + ", send " + topicEvent);
                this.sender.put(topicEvent);
            }
        }

        synchronized void setFilter(Filter filter) {
            this.filter = filter;
        }
    }
}

