/*
 * Decompiled with CFR 0.152.
 */
package jet.server.event.publisher;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.event.EventHandler;
import jet.server.event.EventQueue;
import jet.server.event.TopicEvent;
import jet.server.event.TopicEventImpl;
import jet.server.event.core.RouterService;
import jet.server.event.core.RouterServiceImpl;
import jet.server.event.util.ActiveQueue;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public final class PublishService {
    private static PublishService SEDU = null;
    private RouterServiceImpl activate = null;
    private EventQueueImpl activeQueue = null;

    public static PublishService getInstance() {
        return SEDU;
    }

    public static PublishService newInstance() {
        if (SEDU == null) {
            SEDU = new PublishService();
        }
        return SEDU;
    }

    public void destroy() {
        if (this.activeQueue != null) {
            this.activeQueue.activeQueue.destroy();
            this.activeQueue.activeQueue = null;
            this.activeQueue = null;
        }
        if (this.activate != null) {
            this.activate = null;
        }
        SEDU = null;
    }

    public EventQueue getEventQueue() {
        return this.activeQueue;
    }

    public RouterService getRouterService() {
        return this.activate;
    }

    public void registerToManager() {
        RemoteObjectFactory.register("d1957da4-976f-4bf9-b242-93f3cd72d239", this.activate);
        RemoteObjectFactory.register("A33FFD61-12F2-413f-8272-B89AB0A534D9", this.activeQueue);
    }

    private PublishService() {
        try {
            this.activate = new RouterServiceImpl();
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)this.activate, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        try {
            this.activeQueue = new EventQueueImpl(this.activate);
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)this.activeQueue, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        this.activeQueue.activeQueue.activate();
    }

    private static final class EventQueueImpl
    implements EventQueue,
    ActiveQueue.CallBack {
        private static final long serialVersionUID = 3151171435157173402L;
        ActiveQueue activeQueue = new ActiveQueue(this, 2);
        EventHandler handler;

        public EventQueueImpl(EventHandler eventHandler) throws RemoteException {
            this.handler = eventHandler;
        }

        @Override
        public void postEvent(String string, int n, Object object, int n2) throws RemoteException {
            this.postEvent(new TopicEventImpl(string, n, object), n2);
        }

        @Override
        public void postEvent(TopicEvent topicEvent, int n) throws RemoteException {
            if (this.activeQueue == null) {
                return;
            }
            ServiceLogger.print("EventSystem:: EventQueue.postEvent(), TopicEvent: " + topicEvent + ", priority: " + n);
            this.activeQueue.enqueue(topicEvent, n);
        }

        @Override
        public void method(Object object) {
            try {
                this.handler.process((TopicEvent)object);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }
}

