/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import jet.report.mode.common.cusAction.CusCustomizeCtrlAction;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.server.ServerEnv;
import jet.server.db.cfg.PropsTable;
import jet.server.intf.jrs.CustomizeControlManager;
import jet.server.log.ServiceLogger;

public class CustomizeControlManagerImpl
implements CustomizeControlManager {
    private PropsTable SEDU;
    private File append;

    public CustomizeControlManagerImpl(PropsTable propsTable) {
        this.SEDU = propsTable;
        this.append = new File(ServerEnv.homePath + "Customized Control");
    }

    @Override
    public List getAllCustomizeControlNames() {
        List<String> list = null;
        try {
            list = this.SEDU.queryKeys("Customized Control");
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 3);
        }
        if ((list == null || list.size() == 0) && this.append.exists() && this.append.isDirectory()) {
            String[] stringArray = this.append.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return new File(file, string).isFile() && string.endsWith("wctrl");
                }
            });
            list = Arrays.asList(stringArray);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CusCustomizeCtrlAction getCustomizeControl(String string) {
        Object object;
        InputStream inputStream = null;
        try {
            object = string + "";
            if (!((String)object).endsWith(".wctrl")) {
                object = (String)object + ".wctrl";
            }
            byte[] byArray = this.SEDU.queryBytes("Customized Control", (String)object);
            inputStream = new ByteArrayInputStream(byArray);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 3);
        }
        if (inputStream == null && this.append.exists() && this.append.isDirectory() && ((File)(object = new File(this.append, string))).exists()) {
            try {
                inputStream = new FileInputStream((File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 3);
            }
        }
        if (inputStream != null) {
            try {
                object = ObjectLogicFactory.getEventActionLogic().readCusCustomizeControlAction(inputStream);
                return object;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException, 3);
            }
            catch (IllegalAccessException illegalAccessException) {
                ServiceLogger.logError(illegalAccessException, 3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceLogger.logError(classNotFoundException, 3);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

