/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.util.Enumeration;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.OndemandReportManager;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.util.TempFileDeleteUtil;

class DelTempFileThread
extends Thread {
    long sleepTime = 3600000L;
    private boolean SEDU = false;
    String tempDir = null;
    transient OndemandReportManager ondemandMan = null;
    JRRptServer rptServer;
    int time = 1;
    private long delExpiredDhtmlFiles = ServerEnv.getResultLife() * 1000L;

    public DelTempFileThread(JRRptServer jRRptServer, OndemandReportManager ondemandReportManager) {
        this.tempDir = jRRptServer.getResourceManager().getTempDir();
        this.rptServer = jRRptServer;
        this.ondemandMan = ondemandReportManager;
        TempFileDeleteUtil.delExpiredFiles(this.rptServer);
        this.start();
    }

    @Override
    public void run() {
        if (this.delExpiredDhtmlFiles < this.sleepTime && this.delExpiredDhtmlFiles > 0L) {
            this.sleepTime = this.delExpiredDhtmlFiles;
        }
        ServiceLogger.logDebug(6600282, String.valueOf(this.sleepTime), 6);
        this.delExpiredFiles();
    }

    public void delExpiredFiles() {
        while (!this.SEDU) {
            ServiceLogger.logDebug(6600280, 6);
            Vector vector = SchdTools.deleteExpiredFiles(this.tempDir);
            ServiceLogger.logDebug(6600281, vector, 7);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.ondemandMan.removeOndemandReport((String)enumeration.nextElement());
            }
            TempFileDeleteUtil.delExpiredDhtmlFiles(this.rptServer);
            try {
                JRTUtil.removeExpiredEngine();
                DelTempFileThread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.SEDU) continue;
                ServiceLogger.logError(interruptedException);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }

    public void stopRun() {
        this.SEDU = true;
        try {
            this.interrupt();
        }
        catch (SecurityException securityException) {
            ServiceLogger.logError(securityException, 3);
        }
        this.ondemandMan = null;
    }
}

