/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.core.ClusterServer;
import jet.server.cluster.core.MemberService;
import jet.server.db.core.GlobalDataService;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.JRLoadBalancer;
import jet.server.jrc.JRMember;
import jet.server.jrc.JRMemberTable;
import jet.server.jrc.JRRandomLoadBalancer;
import jet.server.jrc.JRReportMember;
import jet.server.jrc.JRRoundLoadBalancer;
import jet.server.jrc.JRWeightLoadBalancer;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRClusterService
implements ClusterService {
    private LoadBalancer SEDU = null;
    private JRReportMember add = null;
    public JRMemberTable clusterTable = null;
    private MemberService append = null;
    private String close = null;
    private int contains;
    private int equals;

    public JRClusterService(String string, int n, int n2) throws ClusterException {
        this.close = string.trim();
        this.contains = n;
        this.equals = n2;
        this.SEDU();
    }

    private void SEDU() throws ClusterException {
        this.append = ClusterServer.getMemberService();
        this.add = (JRReportMember)this.append.getLocalMember();
        try {
            this.clusterTable = new JRMemberTable(this.append);
            this.SEDU = this.add();
        }
        catch (RemoteException remoteException) {
            throw new ClusterException(650003);
        }
    }

    private LoadBalancer add() throws RemoteException {
        LoadBalancer loadBalancer = null;
        try {
            String string = ServerEnv.getCustomLoadBalancer();
            if (string != null && string.trim().length() > 0) {
                loadBalancer = (LoadBalancer)Class.forName(string).newInstance();
                ServiceLogger.logEvent(6650015, string, 6);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 2);
            ServiceLogger.logEvent(6650016, throwable, 6);
        }
        if (loadBalancer == null) {
            int n = ServerEnv.getLoadBalancerType();
            ServiceLogger.logEvent(5650001, String.valueOf(n), 5);
            switch (n) {
                case 0: {
                    loadBalancer = new JRLoadBalancer();
                    break;
                }
                case 1: {
                    loadBalancer = new JRRoundLoadBalancer(this);
                    break;
                }
                case 2: {
                    loadBalancer = new JRWeightLoadBalancer();
                    break;
                }
                case 3: {
                    loadBalancer = new JRRandomLoadBalancer(this);
                    break;
                }
                default: {
                    loadBalancer = new JRLoadBalancer();
                    ServiceLogger.logEvent(6650017, String.valueOf(n), 6);
                    ServiceLogger.logEvent("Unknown load balancer type: " + n + "! Use the default load balancer.");
                }
            }
        }
        return loadBalancer;
    }

    public void startupFinished() throws ClusterException {
        try {
            GlobalDataService.getInstance().setFinishedStartup();
        }
        catch (Exception exception) {
            throw new ClusterException(exception);
        }
    }

    public void quit() {
        if (this.clusterTable != null) {
            this.clusterTable.close();
        }
    }

    public void clearMem() {
        this.add = null;
        this.SEDU = null;
    }

    public int getConcurrentReports(Member member) throws Exception {
        MemberMonitor memberMonitor = null;
        memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(member.getHost(), CSUtil.parseInt(member.getPort()), "MemberMonitor");
        return memberMonitor.getConcurrentReports();
    }

    public boolean isActiveMember(ReportMember reportMember) {
        List list = this.append.getMembers();
        return list.contains(reportMember);
    }

    public String getLocalHost() {
        return this.close;
    }

    public String getLocalPort() {
        return String.valueOf(this.contains);
    }

    @Override
    public String getClusterName() {
        return ClusterEnv.getClusterName();
    }

    public Member[] getActiveMembers() {
        return this.append.getMembers().toArray(new Member[this.append.getMembers().size()]);
    }

    @Override
    public Member[] getAllMembers() {
        return this.getActiveMembers();
    }

    private Member[] append() {
        List list = this.append.getMembers();
        ArrayList<JRMember> arrayList = new ArrayList<JRMember>();
        for (JRMember jRMember : list) {
            if (!jRMember.isServerReady() && !this.add.equals(jRMember)) continue;
            arrayList.add(jRMember);
        }
        return arrayList.toArray(new Member[arrayList.size()]);
    }

    @Override
    public Member getLocalMember() {
        return this.add;
    }

    @Override
    public Member getAdminMember() throws ClusterException {
        return this.append.getCoordinator();
    }

    @Override
    public LoadBalancer getDefaultLoadBalancer() {
        return this.SEDU;
    }

    @Override
    public void setDefaultLoadBalancer(LoadBalancer loadBalancer) {
        this.SEDU = loadBalancer;
    }

    @Override
    public Member getMember() {
        Member[] memberArray;
        Member member;
        if (this.SEDU != null && (member = this.SEDU.selectMember(this.add, memberArray = this.append())) != null) {
            ReportMember reportMember = (ReportMember)member;
            return member;
        }
        return this.add;
    }

    @Override
    public void registerLocalMember() throws ClusterException {
    }

    @Override
    public void removeLocalMember() throws ClusterException {
    }

    @Override
    public boolean isAdminServerCrashed() {
        return false;
    }

    @Override
    public boolean isTaskQueueFull(int n) {
        return false;
    }
}

