/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.IOException;
import java.io.InputStream;
import jet.server.intf.jrs.RemoteFileAccess;

public class JRInputStream
extends InputStream {
    private RemoteFileAccess SEDU;
    private byte[] arraycopy;
    private int openForRead = 0;
    private int read = 0;
    private int I = 0;
    private final int Z = 512000;
    private String C;

    public JRInputStream(RemoteFileAccess remoteFileAccess, String string) throws IOException {
        this.SEDU = remoteFileAccess;
        this.I = remoteFileAccess.openForRead(string);
        this.arraycopy = remoteFileAccess.read(this.openForRead, 512000 > this.I ? this.I : 512000, string);
        this.C = string;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.read >= this.arraycopy.length) {
            this.openForRead += this.arraycopy.length;
            this.arraycopy = this.SEDU.read(this.openForRead, 512000, this.C);
            this.read = 0;
        }
        return this.read + this.openForRead < this.I ? this.arraycopy[this.read++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read + this.openForRead >= this.I) {
            return -1;
        }
        if (this.openForRead + this.read + n2 > this.I) {
            n2 = this.I - this.read - this.openForRead;
        }
        if (n2 <= 0) {
            return 0;
        }
        if (n2 <= this.arraycopy.length - this.read) {
            System.arraycopy(this.arraycopy, this.read, byArray, n, n2);
            this.read += n2;
        } else {
            int n3 = n2;
            while (n3 > this.arraycopy.length - this.read) {
                System.arraycopy(this.arraycopy, this.read, byArray, n, this.arraycopy.length - this.read);
                n3 = n3 - this.arraycopy.length + this.read;
                n += this.arraycopy.length - this.read;
                this.read = 0;
                this.openForRead += this.arraycopy.length;
                this.arraycopy = this.SEDU.read(this.openForRead, 512000, this.C);
            }
            System.arraycopy(this.arraycopy, this.read, byArray, n, n3);
            this.read += n3;
        }
        return n2;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        if ((long)(this.openForRead + this.read) + l > (long)this.I) {
            l = this.I - this.read - this.openForRead;
        }
        if (l < 0L) {
            return 0L;
        }
        this.read = (int)((long)this.read + l);
        while (this.read >= this.arraycopy.length) {
            this.openForRead += this.arraycopy.length;
            this.arraycopy = this.SEDU.read(this.openForRead, 512000, this.C);
            this.read -= this.arraycopy.length;
        }
        return l;
    }

    @Override
    public synchronized int available() {
        return this.I - this.read - this.openForRead;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() throws IOException {
    }
}

