/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jet.cs.ExProperties;
import jet.cs.FileNameFromTemplate;
import jet.css.CssStyleSheetManager;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.http.HttpUtil;
import jet.server.api.monitor.CurrentMonitorStatistics;
import jet.server.api.monitor.FinishedReportTable;
import jet.server.api.monitor.RunningReportTable;
import jet.server.db.core.WorkspaceManager;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.JRTaskManager;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.JRUserPreferenceManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class JRMemberMonitor
implements MemberMonitor {
    JRRptServer rptServer = null;

    public JRMemberMonitor(JRRptServer jRRptServer) throws RemoteException {
        this.rptServer = jRRptServer;
    }

    @Override
    public int getConcurrentReports() throws RemoteException {
        return this.rptServer.getConCurrentReports();
    }

    @Override
    public void stopServer() throws RemoteException {
        if ("true".equals(System.getProperty("jrs.isMyServer"))) {
            try {
                HttpUtil.shutdownServer();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            System.exit(0);
        }
    }

    @Override
    public ExProperties getCommonProps() throws RemoteException {
        ExProperties exProperties = new ExProperties();
        exProperties.setProperty("server.realm.active", ServerEnv.getActiveRealm());
        exProperties.setProperty("server.security", ServerEnv.needSecurity());
        exProperties.setProperty("server.version.from.temp", ServerEnv.isPublishTempToVersion());
        exProperties.setProperty("server.completed.max_count", ServerEnv.getMaxCompletedRecordCount());
        exProperties.setProperty("cluster.send_concurrent_reports", ServerEnv.mustSendConcurrentReports());
        exProperties.setProperty("cluster.enable_notify_server_down", ServerEnv.enableNotifyServerDown());
        exProperties.setProperty("cluster.notify_server_down_address", ServerEnv.getNotifyServerDownAddress());
        exProperties.setProperty("jrs.auth_scheme", HttpUtil.getAuthScheme());
        return exProperties;
    }

    @Override
    public long runTestReport(Properties properties) throws RptServerException {
        return this.rptServer.runTestReport(properties);
    }

    @Override
    public String getRemoteRealmsPath() throws RemoteException {
        return ServerEnv.realmsPath;
    }

    @Override
    public Properties getMailConfig() throws RemoteException {
        try {
            return SchdTools.loadMailConfig();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 6);
            throw new ServerException("", exception);
        }
    }

    @Override
    public Properties getLdapConfig() throws RemoteException {
        return ServerEnv.getLdapConfig();
    }

    @Override
    public void setLdapConfig(Hashtable hashtable) throws RemoteException {
        LDAPData.replaceProperties(hashtable);
    }

    @Override
    public void broadcastDefaultPreference() throws RemoteException {
        ((JRUserPreferenceManager)this.rptServer.getUserPreferenceManager()).loadDefaultPref();
    }

    @Override
    public RunningReportTable getRunningReportTable() throws RemoteException {
        return this.rptServer.getMonitorService().getRunningReportTable();
    }

    @Override
    public FinishedReportTable getFinishedReportTable() throws RemoteException {
        return this.rptServer.getMonitorService().getFinishedReportTable();
    }

    @Override
    public CurrentMonitorStatistics getCurrentMonitorStatistics() throws RemoteException {
        return this.rptServer.getMonitorService().getCurrentMonitorStatistics();
    }

    @Override
    public long getMonitorRefreshInterval() throws RemoteException {
        return this.rptServer.getMonitorService().getMonitorSetting().getMonitorRefreshInterval();
    }

    @Override
    public long getMonitorOverTimeRunning() throws RemoteException {
        return this.rptServer.getMonitorService().getMonitorSetting().getMonitorOverTimeRunning();
    }

    @Override
    public int getMonitorMaxNumberSaveReport() throws RemoteException {
        return this.rptServer.getMonitorService().getMonitorSetting().getMonitorNumberSaveReport();
    }

    @Override
    public int getMonitorMaxMinuteSaveReport() throws RemoteException {
        return this.rptServer.getMonitorService().getMonitorSetting().getMonitorMaxMinuteSaveReport();
    }

    @Override
    public void deleteOndemandReport(String string) throws RemoteException {
        ((JRTaskManager)this.rptServer.getTaskManager()).deleteOndemandReport(string);
    }

    @Override
    public Properties getDatabaseInfo(String string, String string2) throws RemoteException {
        WorkspaceManager workspaceManager = WorkspaceManager.getInstance();
        return workspaceManager.workspaces(string).databases(string2).getProperties();
    }

    @Override
    public int[] getActiveAndWaiting() throws RemoteException {
        JRTaskManager jRTaskManager = (JRTaskManager)this.rptServer.getTaskManager();
        int[] nArray = new int[3];
        if (jRTaskManager != null) {
            nArray[0] = jRTaskManager.getActiveReportsInQueue();
            nArray[1] = jRTaskManager.getWaitingReports();
            nArray[2] = jRTaskManager.getQueuingReports();
        }
        return nArray;
    }

    @Override
    public void removePipelineFilenames(String string) throws RemoteException {
        ((JRTaskManager)this.rptServer.getTaskManager()).removePipelineFilenames(string);
    }

    @Override
    public String getPathNameFromTemplate(String string, String string2, String string3, String string4) throws RemoteException {
        return FileNameFromTemplate.getPathNameFromTemplate(string, string2, string3, string4);
    }

    @Override
    public String getFileNameFromTemplate(String string, String string2, String string3, String string4, String string5) throws RemoteException {
        return FileNameFromTemplate.getFileNameFromTemplate(string, string2, string3, string4, string5);
    }

    @Override
    public String[] getSupportStyleNames() throws RemoteException {
        List list = CssStyleSheetManager.getSupportStyleNameList();
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    @Override
    public boolean isTaskQueueFull(int n) throws RemoteException {
        return this.rptServer.isTaskQueueFull(n);
    }
}

