/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.cluster.ReportMember;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MemberListenerAdapter;
import jet.server.cluster.core.MemberService;
import jet.server.intf.jrs.ClusterListener;
import jet.server.jrc.JRReportMember;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class JRMemberTable
extends MemberListenerAdapter {
    public static final String CLUSTER_TOPIC = "ClusterService";
    public static final int START_SERVER = 0;
    public static final int SHUT_SERVER = 1;
    public static final int CRASH_SERVER = 2;
    public static final String SERVER_NAME = "serverName";
    public static final String SERVER_ID = "serverID";
    public static final String SERVER_HOST = "serverHost";
    public static final String SERVER_PORT = "serverPort";
    public static final String SERVER_TYPE = "serverType";
    public static final String START_TIME = "startTime";
    public static final String CLOSE_TIME = "closeTime";
    public static final String CRASH_REASON = "crashReason";
    public static int ADMIN_SERVER = 0;
    public static int BACKUP_SERVER = 1;
    public static int SLAVE_SERVER = 2;
    private MemberService SEDU = null;
    private JRView addMemberListener;
    private JRReportMember append;
    private boolean contains;

    public JRMemberTable(MemberService memberService) {
        this.SEDU = memberService;
        this.append = (JRReportMember)memberService.getLocalMember();
        memberService.addMemberListener(this);
        this.viewAccepted(memberService.getView());
    }

    public void addClusterListener(ClusterListener clusterListener) {
    }

    public void close() {
        this.SEDU.removeMemberListener(this);
    }

    @Override
    public synchronized void viewAccepted(JRView jRView) {
        ReportMember reportMember;
        JRView jRView2 = this.addMemberListener;
        this.addMemberListener = jRView;
        this.contains = this.SEDU.isCoordinator();
        Set set = JRView.minus(jRView, jRView2);
        Set set2 = JRView.minus(jRView2, jRView);
        Set set3 = this.SEDU.getCrashedMembers();
        for (Integer n : set) {
            reportMember = (ReportMember)((Object)jRView.getMemberById(n));
            if (reportMember == null) continue;
            this.addMemberListener(reportMember);
        }
        for (Integer n : set2) {
            reportMember = (ReportMember)((Object)jRView2.getMemberById(n));
            if (reportMember == null) continue;
            if (set3.contains(n)) {
                this.contains(reportMember);
                continue;
            }
            this.append(reportMember);
        }
    }

    private void ADMIN_SERVER(int n, Properties properties) {
        try {
            ServerEnv.getEventQueue().postEvent(CLUSTER_TOPIC, n, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 6);
        }
    }

    private void BACKUP_SERVER(String string, String string2, String string3, String string4, int n, long l) {
        Properties properties = new Properties();
        properties.put(SERVER_NAME, string);
        properties.put(SERVER_ID, string2);
        properties.put(SERVER_HOST, string3);
        properties.put(SERVER_PORT, string4);
        properties.put(SERVER_TYPE, String.valueOf(n));
        properties.put(START_TIME, String.valueOf(l));
        this.ADMIN_SERVER(0, properties);
    }

    private void SEDU(String string, String string2, long l) {
        Properties properties = new Properties();
        properties.put(SERVER_HOST, string);
        properties.put(SERVER_PORT, string2);
        properties.put(CLOSE_TIME, String.valueOf(l));
        this.ADMIN_SERVER(1, properties);
    }

    private void SLAVE_SERVER(String string, String string2, long l, String string3) {
        Properties properties = new Properties();
        properties.put(SERVER_HOST, string);
        properties.put(SERVER_PORT, string2);
        properties.put(CLOSE_TIME, String.valueOf(l));
        properties.put(CRASH_REASON, string3);
        this.ADMIN_SERVER(2, properties);
    }

    private void addMemberListener(ReportMember reportMember) {
        this.BACKUP_SERVER(reportMember.getServerName() == null ? "" : reportMember.getServerName(), String.valueOf(reportMember.getID()), reportMember.getHost() == null ? "" : reportMember.getHost(), reportMember.getPort() == null ? "" : reportMember.getPort(), reportMember.isAdmin() ? ADMIN_SERVER : BACKUP_SERVER, System.currentTimeMillis());
        ServiceLogger.logDebug(6650030, reportMember, 6);
    }

    private void append(ReportMember reportMember) {
        this.SEDU(reportMember.getHost() == null ? "" : reportMember.getHost(), reportMember.getPort() == null ? "" : reportMember.getPort(), System.currentTimeMillis());
        if (this.contains && ServerEnv.enableNotifyServerDown()) {
            try {
                JRReportMember jRReportMember = this.append;
                String string = jRReportMember.getServerName() + "(" + jRReportMember.getHost() + ":" + jRReportMember.getPort() + ")";
                ServerUtil.sendNormalMail(ServerEnv.getNotifyServerDownAddress(), null, null, JSvrResource.getMessage("SVR_87", reportMember.getServerName()), JSvrResource.getMessage("SVR_88", new String[]{reportMember.getServerName(), string, "" + new Date()}), null);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 5);
            }
        }
        ServiceLogger.logDebug(6650031, reportMember, 6);
    }

    private void contains(ReportMember reportMember) {
        this.SLAVE_SERVER(reportMember.getHost() == null ? "" : reportMember.getHost(), reportMember.getPort() == null ? "" : reportMember.getPort(), System.currentTimeMillis(), JSvrResource.getMessage("SVR_79", reportMember));
        if (this.contains && ServerEnv.enableNotifyServerDown()) {
            try {
                JRReportMember jRReportMember = this.append;
                String string = jRReportMember.getServerName() + "(" + jRReportMember.getHost() + ":" + jRReportMember.getPort() + ")";
                ServerUtil.sendNormalMail(ServerEnv.getNotifyServerDownAddress(), null, null, JSvrResource.getMessage("SVR_87", reportMember.getServerName()), JSvrResource.getMessage("SVR_88", new String[]{reportMember.getServerName(), string, "" + new Date()}), null);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 5);
            }
        }
        ServiceLogger.logDebug(6650031, reportMember, 6);
    }
}

