/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import com.jinfonet.api.crd.CRDResult;
import com.jinfonet.api.crd.DataResult;
import com.jinfonet.api.crd.QueryInformation;
import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JException;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.autocachekey.JAutoCacheKey;
import jet.formula.ParamDesc;
import jet.formula.fArray;
import jet.parameter.UserInput;
import jet.server.ServerEnv;
import jet.server.api.CatalogInfo;
import jet.server.api.ParamInfo;
import jet.server.api.ParameterManager;
import jet.server.api.PathInfo;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.api.admin.cfg.ConfigurationCache;
import jet.server.api.cluster.ClusterException;
import jet.server.api.crd.CRDInfo;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDManageException;
import jet.server.api.crd.CRDRunDetail;
import jet.server.api.crd.CompletedCRDInfo;
import jet.server.api.crd.CubeInfo;
import jet.server.api.crd.CubeInfoKey;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.cluster.core.ClusterServer;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.crd.AbstractCRDResult;
import jet.server.crd.AutoCacheResult;
import jet.server.crd.CRDResultKey;
import jet.server.crd.CRDResultToolkit;
import jet.server.crd.CRDSimpleResult;
import jet.server.crd.ExtCRDInfo;
import jet.server.crd.ExtCompletedCRDInfo;
import jet.server.crd.ExtRunningCRDInfo;
import jet.server.db.dao.CRDInfoDAO;
import jet.server.db.dao.CRDRunDetailDAO;
import jet.server.db.dao.CompletedCRDInfoDAO;
import jet.server.db.model.AbstractCRDInfoModel;
import jet.server.db.model.CRDInfoModel;
import jet.server.db.model.CRDRunDetailModel;
import jet.server.db.model.CompletedCRDInfoModel;
import jet.server.db.resource.ResourceNodeTableImpl;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.server.intf.jrs.RemoteCRDManager;
import jet.server.intf.security.SecurityService;
import jet.server.intf.version.CatalogVersionTable;
import jet.server.jrc.JRDataService;
import jet.server.jrc.StartupContext;
import jet.server.jrc.quartz.JRSchedulingServiceQuartzImpl;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRCatalogInfo;
import jet.server.jrserver.JRParamInfo;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.rmi.JRRemoteParamInfo;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerResourceStore;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.resstore.SpaceAllocatorExt;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;
import jet.server.util.DatabaseMetadataInfoMaker;
import jet.server.util.IOUtil;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;
import jet.server.util.StringUtils;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUQueriable;
import jet.universe.JetUUniverse;
import jet.universe.UniverseToolkit;
import jet.universe.tools.ParseParametersForQueryFactory;

public class JRRemoteCRDManager
implements RemoteCRDManager {
    private static final long serialVersionUID = 2865233522836770643L;
    public static String CACHE_DIR_NAME = "cache";
    public static String CRD_DIR_NAME = "crd";
    public static String AUTO_CACHE_DIR_NAME = "auto";
    private JRRptServer AUTO_CACHE_RESULT_USABLED_MAP;
    private JRDataService BvUseMoreParameter;
    private JDataService CRD_CACHE;
    private CatalogVersionTable CRD_CONFIG_MAP;
    private ResourceNodeTableImpl CRD_PARAM_MAP;
    private ResourceManager CRD_RESULT_USABLED_MAP;
    private String CreateParseParametersForQuery;
    private ConfigurationCache EXT_CRD_INFO_MAP;
    private ConfigurationAdvanced HISTORY;
    private ConnectionInfoProvider SEDU;
    private ClusterMap add;
    private List addAll;
    private ClusterMap addListener;
    private ClusterMap addRunDetail;
    private Map allocate = new HashMap();
    private ClusterMap allocateForce;
    private ClusterMap append;
    private int asList = 1;
    private Storage available;
    private Map backupInfo = new HashMap();

    public JRRemoteCRDManager(JRRptServer jRRptServer) throws RemoteException, CRDManageException {
        this.AUTO_CACHE_RESULT_USABLED_MAP = jRRptServer;
    }

    public void init(boolean bl) throws CRDManageException, RemoteException {
        ServiceLogger.logDebug(6690001, 6);
        this.BvUseMoreParameter = (JRDataService)this.AUTO_CACHE_RESULT_USABLED_MAP.getDataService();
        this.CRD_CONFIG_MAP = this.BvUseMoreParameter.getCatalogVersionTable();
        this.CRD_PARAM_MAP = this.BvUseMoreParameter.getResourceNodeTable();
        this.CRD_RESULT_USABLED_MAP = this.AUTO_CACHE_RESULT_USABLED_MAP.getResourceManager();
        this.CreateParseParametersForQuery = this.AUTO_CACHE_RESULT_USABLED_MAP.getHomePath();
        if (this.CreateParseParametersForQuery.endsWith(File.separator)) {
            this.CreateParseParametersForQuery = this.CreateParseParametersForQuery.substring(0, this.CreateParseParametersForQuery.length() - 1);
        }
        AdminService adminService = this.AUTO_CACHE_RESULT_USABLED_MAP.getAdminService();
        ConfigService configService = adminService.getConfigService();
        this.EXT_CRD_INFO_MAP = configService.getConfigurationCache();
        this.HISTORY = configService.getConfigurationAdvanced();
        this.SEDU = (ConnectionInfoProvider)((Object)this.AUTO_CACHE_RESULT_USABLED_MAP.getAdminService().getConnectionInfoProviderService());
        try {
            Object object2;
            Iterator iterator;
            if (!ClusterInitLocker.hasInited(this.getClass().getName())) {
                try {
                    this.AUTO_CACHE_DIR_NAME();
                    iterator = ((JRDataService)this.AUTO_CACHE_RESULT_USABLED_MAP.getDataService()).getUpdateDetailsTable();
                    if (!iterator.isUpdating("transfer_crd_to_cube")) {
                        this.transCRDToCube();
                        iterator.setUpdateDetails("transfer_crd_to_cube", true);
                    }
                    this.recoverCRDs();
                    ClusterInitLocker.setInited(this.getClass().getName());
                }
                catch (Exception exception) {
                    ClusterInitLocker.cancelInit(this.getClass().getName());
                    throw exception;
                }
            } else {
                this.AUTO_CACHE_DIR_NAME();
                if (bl && ClusterServer.getMemberService().isCoordinator()) {
                    this.recoverCRDs();
                } else {
                    for (Object object2 : this.add.values()) {
                        this.addAll.add(object2);
                        this.add((ExtCRDInfo)object2);
                    }
                    for (Object object2 : this.allocateForce.values()) {
                        ((AbstractCRDResult)object2).setCRDCache(this.EXT_CRD_INFO_MAP(((CRDSimpleResult)object2).getResultKey().getCRDKey().getCatalogPath()).getMemoryStore().getCrdCache());
                    }
                    iterator = this.append.values().iterator();
                    while (iterator.hasNext()) {
                        object2 = (AutoCacheResult)iterator.next();
                        ((AbstractCRDResult)object2).setCRDCache(this.EXT_CRD_INFO_MAP(((AutoCacheResult)object2).getQueryKey().getCatalogKey().getPath()).getMemoryStore().getCrdCache());
                    }
                }
            }
            this.exists();
            if ((!ServerEnv.isClusterEnabled() || ClusterServer.getMemberService().isCoordinator()) && (iterator = (List)StartupContext.remove("expired_crdresult")) != null) {
                object2 = iterator.iterator();
                while (object2.hasNext()) {
                    CRDInfoKey cRDInfoKey = (CRDInfoKey)object2.next();
                    try {
                        this.deleteCRDResult(cRDInfoKey);
                    }
                    catch (CRDManageException cRDManageException) {
                        ServiceLogger.logError(cRDManageException.getMessage());
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new CRDManageException(exception);
        }
        ServiceLogger.logDebug(6690002, 6);
    }

    private void AUTO_CACHE_DIR_NAME() throws CRDManageException {
        try {
            this.available = StorageEnv.getStorage();
            this.addAll = new ArrayList();
            this.add = MapFactory.getMap(MapAttr.EXT_CRD_INFO_MAP);
            this.add.addListener(new MapListenerAdapter(){

                @Override
                public void afterClear(String string, int n, MapFlags mapFlags) {
                    JRRemoteCRDManager.this.addAll.clear();
                }

                public void afterPut(String string, int n, CRDInfoKey cRDInfoKey, ExtCRDInfo extCRDInfo, ExtCRDInfo extCRDInfo2, MapFlags mapFlags) {
                    if (JRRemoteCRDManager.this.addAll.contains(extCRDInfo)) {
                        JRRemoteCRDManager.this.addAll.remove(extCRDInfo);
                    }
                    JRRemoteCRDManager.this.addAll.add(extCRDInfo);
                    if (n != -1) {
                        JRRemoteCRDManager.this.add(extCRDInfo);
                    }
                }

                public void afterRemove(String string, int n, CRDInfoKey cRDInfoKey, ExtCRDInfo extCRDInfo, MapFlags mapFlags) {
                    if (extCRDInfo != null) {
                        JRRemoteCRDManager.this.addAll.remove(extCRDInfo);
                        if (n != -1) {
                            JRRemoteCRDManager.this.addAll(extCRDInfo);
                        }
                    }
                }
            });
            this.addListener = MapFactory.getMap(MapAttr.CRD_PARAM_MAP);
            this.addRunDetail = MapFactory.getMap(MapAttr.CRD_CONFIG_MAP);
            this.allocateForce = MapFactory.getMap(MapAttr.CRD_RESULT_USABLED_MAP);
            this.allocateForce.addListener(new MapListenerAdapter(){

                public void afterPut(String string, int n, CRDInfoKey cRDInfoKey, CRDSimpleResult cRDSimpleResult, CRDSimpleResult cRDSimpleResult2, MapFlags mapFlags) {
                    cRDSimpleResult.setCRDCache(JRRemoteCRDManager.this.EXT_CRD_INFO_MAP(cRDInfoKey.getCatalogPath()).getMemoryStore().getCrdCache());
                }

                public void afterRemove(String string, int n, CRDInfoKey cRDInfoKey, CRDSimpleResult cRDSimpleResult, MapFlags mapFlags) {
                    if (cRDSimpleResult != null) {
                        cRDSimpleResult.setExpired(true);
                    }
                }
            });
            this.append = MapFactory.getMap(MapAttr.AUTO_CACHE_RESULT_USABLED_MAP);
            this.append.addListener(new MapListenerAdapter(){

                public void afterPut(String string, int n, JAutoCacheKey jAutoCacheKey, AutoCacheResult autoCacheResult, AutoCacheResult autoCacheResult2, MapFlags mapFlags) {
                    autoCacheResult.setCRDCache(JRRemoteCRDManager.this.EXT_CRD_INFO_MAP(jAutoCacheKey.getCatalogKey().getPath()).getMemoryStore().getCrdCache());
                }

                public void afterRemove(String string, int n, JAutoCacheKey jAutoCacheKey, AutoCacheResult autoCacheResult, MapFlags mapFlags) {
                    if (autoCacheResult != null) {
                        autoCacheResult.setExpired(true);
                    }
                }
            });
        }
        catch (StorageException storageException) {
            throw new CRDManageException((Exception)((Object)storageException));
        }
        catch (ClusterException clusterException) {
            throw new CRDManageException((Exception)((Object)clusterException));
        }
    }

    @Override
    public long getCacheSize() {
        int n = 4;
        if (this.EXT_CRD_INFO_MAP != null && (n = this.EXT_CRD_INFO_MAP.getCRDMemoryUsage()) <= 0) {
            n = 4;
        }
        return 0x100000L * (long)n;
    }

    @Override
    public String getHomePath() {
        return this.CreateParseParametersForQuery;
    }

    public long getAutoCacheSize() {
        int n = 512;
        if (this.EXT_CRD_INFO_MAP != null && (n = this.EXT_CRD_INFO_MAP.getMaxDiskUsage()) <= 0) {
            n = 512;
        }
        return 0x100000L * (long)n;
    }

    @Override
    public long getAutoCacheExpired() {
        if (this.EXT_CRD_INFO_MAP.isNeverExpire()) {
            return 0L;
        }
        return this.EXT_CRD_INFO_MAP.getExpiredTime() * 1000L;
    }

    @Override
    public String getAutoCacheResultFile() {
        String string = ServerEnv.getServerID();
        if (string != null && string.trim().length() > 0) {
            return this.getAutoCacheDir() + ServerEnv.getServerID() + "_" + this.asList++ + ".rst";
        }
        return this.getAutoCacheDir() + this.asList++ + ".rst";
    }

    public static String getCachePath() {
        return "/" + CACHE_DIR_NAME;
    }

    @Override
    public String getCRDCacheDir() {
        return JRRemoteCRDManager.getCachePath() + File.separator + CRD_DIR_NAME + File.separator;
    }

    @Override
    public String getAutoCacheDir() {
        return JRRemoteCRDManager.getCachePath() + File.separator + AUTO_CACHE_DIR_NAME + File.separator;
    }

    private String AUTO_CACHE_RESULT_USABLED_MAP() {
        return Storage.StorageRoot.CRD_CACHE.getRootPath() + "/" + CRD_DIR_NAME + "/";
    }

    private String BvUseMoreParameter() {
        return Storage.StorageRoot.CRD_CACHE.getRootPath() + "/" + AUTO_CACHE_DIR_NAME + "/";
    }

    private JDataService CACHE_DIR_NAME(String string) {
        String string2 = CSUtil.parseVirtualResourcePath(string)[0];
        return UserDataToolkit.getJDataService(string2);
    }

    @Override
    public void createCRD(String string, CRDInfo cRDInfo) throws CRDManageException {
        ServiceLogger.trace("CRDManager: createCRD...(crdInfo=%s, loginUser=%s)", cRDInfo, string);
        long l = System.currentTimeMillis();
        try {
            this.getBvName(string, cRDInfo.getCatalogPath());
        }
        catch (RptServerException rptServerException) {
            throw new CRDManageException((Exception)((Object)rptServerException));
        }
        CRDInfoModel cRDInfoModel = this.available(cRDInfo);
        CRDInfoDAO cRDInfoDAO = CRDInfoDAO.getInstance();
        Connection connection = null;
        ExtCRDInfo extCRDInfo = null;
        try {
            connection = cRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            this.clone(cRDInfoModel);
            if (cRDInfoDAO.existed(connection, cRDInfoModel)) {
                throw new CRDManageException("CRD has existed.");
            }
            cRDInfoDAO.insert(connection, cRDInfoModel);
            extCRDInfo = this.charAt(cRDInfoModel);
            this.SEDU(extCRDInfo);
            this.addListener(extCRDInfo);
            CRDInfoKey cRDInfoKey = extCRDInfo.getCRDKey();
            this.close(cRDInfoKey);
            try {
                this.doubleValue(cRDInfo.getCRDKey(), true);
            }
            catch (Exception exception) {
                ServiceLogger.trace("CRDManager: createCRD: create config file failed! %s [crdKey=%s]", exception, cRDInfo.getCRDKey());
                ServiceLogger.logError(exception, 2);
                throw exception;
            }
            this.commit(cRDInfoKey);
            if (extCRDInfo.getBVName() != null) {
                ExtCompletedCRDInfo extCompletedCRDInfo = new ExtCompletedCRDInfo(extCRDInfo);
                extCompletedCRDInfo.setStartTime(new Date(l));
                extCompletedCRDInfo.setCompletedTime(new Date());
                extCompletedCRDInfo.setActivityType((short)1);
                extCompletedCRDInfo.setSuccess(true);
                CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
                CompletedCRDInfoModel completedCRDInfoModel = this.backupInfo(extCompletedCRDInfo);
                completedCRDInfoDAO.insert(connection, completedCRDInfoModel);
            }
            connection.commit();
        }
        catch (CRDManageException cRDManageException) {
            ServiceLogger.logError((Throwable)((Object)cRDManageException));
            ServiceLogger.trace("CRDManager: createCRD: failed! %s [crdKey=%s]", new Object[]{cRDManageException, cRDInfo.getCRDKey()});
            if (extCRDInfo != null) {
                this.addRunDetail(extCRDInfo);
            }
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw cRDManageException;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            ServiceLogger.trace("CRDManager: createCRD: failed! %s [crdKey=%s]", exception, cRDInfo.getCRDKey());
            if (extCRDInfo != null) {
                this.addRunDetail(extCRDInfo);
            }
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw new CRDManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
        ServiceLogger.trace("CRDManager: createCRD: success![crdKey=%s]", cRDInfo.getCRDKey());
    }

    @Override
    public void updateCRD(String string, CRDInfo cRDInfo) throws CRDManageException {
        long l = System.currentTimeMillis();
        CRDManageException cRDManageException = null;
        try {
            this.getBvName(string, cRDInfo.getCatalogPath());
            this.CRD_CACHE(cRDInfo, true);
        }
        catch (RptServerException rptServerException) {
            cRDManageException = new CRDManageException((Exception)((Object)rptServerException));
        }
        catch (CRDManageException cRDManageException2) {
            cRDManageException = cRDManageException2;
        }
        if (cRDInfo instanceof CubeInfo && ((CubeInfo)cRDInfo).getBVName() != null) {
            this.getByCatalog((CubeInfo)cRDInfo, l, (short)2, cRDManageException == null, cRDManageException == null ? null : cRDManageException.getMessage());
        }
        if (cRDManageException != null) {
            throw cRDManageException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CRD_CACHE(CRDInfo cRDInfo, boolean bl) throws CRDManageException {
        CRDInfoModel cRDInfoModel = this.available(cRDInfo);
        CRDInfoDAO cRDInfoDAO = CRDInfoDAO.getInstance();
        Connection connection = null;
        ExtCRDInfo extCRDInfo = null;
        try {
            connection = cRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            this.clone(cRDInfoModel);
            CRDInfoModel cRDInfoModel2 = cRDInfoDAO.get(connection, cRDInfoModel);
            if (!cRDInfoDAO.existed(connection, cRDInfoModel)) {
                throw new CRDManageException("CRD isn't existed.");
            }
            cRDInfoModel2.setCatalogLastModified(cRDInfoModel.getCatalogLastModified());
            cRDInfoModel2.setDataSource(cRDInfoModel.getDataSource());
            cRDInfoModel2.setLastModified(cRDInfoModel.getLastModified());
            cRDInfoModel2.setLazy(cRDInfoModel.getLazy());
            cRDInfoModel2.setParamFile(cRDInfoModel.getParamFile());
            cRDInfoModel2.setPasswords(cRDInfoModel.getPasswords());
            cRDInfoModel2.setTaskId(cRDInfoModel.getTaskId());
            cRDInfoModel2.setUserNames(cRDInfoModel.getUserNames());
            cRDInfoModel2.setCacheType(cRDInfoModel.getCacheType());
            cRDInfoModel2.setMaxMemory(cRDInfoModel.getMaxMemory());
            cRDInfoModel2.setCanSwaptoDisk(cRDInfoModel.getCanSwaptoDisk());
            if (cRDInfo instanceof ExtCRDInfo) {
                cRDInfoModel2.setLocation(cRDInfoModel.getLocation());
            }
            cRDInfoModel2.setResultVersion(cRDInfoModel.getResultVersion());
            if (cRDInfo instanceof ExtCRDInfo) {
                cRDInfoModel2.setCreateTime(cRDInfoModel.getCreateTime());
                cRDInfoModel2.setStatus(cRDInfoModel.getStatus());
            }
            cRDInfoDAO.update(connection, cRDInfoModel2);
            ExtCRDInfo extCRDInfo2 = extCRDInfo = this.charAt(cRDInfoModel2);
            synchronized (extCRDInfo2) {
                try {
                    extCRDInfo.backupInfo();
                    CRDInfoKey cRDInfoKey = extCRDInfo.getCRDKey();
                    this.close(cRDInfoKey);
                    try {
                        this.doubleValue(cRDInfo.getCRDKey(), bl);
                    }
                    catch (Exception exception) {
                        ServiceLogger.trace("CRDManager: updateCRD: create config file failed! %s [crdKey=%s]", exception, cRDInfo.getCRDKey());
                        ServiceLogger.logError(exception, 2);
                        throw exception;
                    }
                    this.commit(cRDInfoKey);
                    this.addListener(extCRDInfo);
                }
                catch (Exception exception) {
                    extCRDInfo.restoreInfo();
                    throw exception;
                }
            }
            connection.commit();
        }
        catch (CRDManageException cRDManageException) {
            ServiceLogger.trace("CRDManager: updateCRD: failed! %s [crdKey=%s]", new Object[]{cRDManageException, cRDInfo.getCRDKey()});
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw cRDManageException;
        }
        catch (Exception exception) {
            ServiceLogger.trace("CRDManager: updateCRD: failed! %s [crdKey=%s]", exception, cRDInfo.getCRDKey());
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw new CRDManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
        ServiceLogger.trace("CRDManager: updateCRD: success![crdKey=%s]", cRDInfo.getCRDKey());
    }

    @Override
    public void deleteCRD(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        ServiceLogger.trace("CRDManager: deleteCRD...(crdKey=%s, loginUser=%s)", cRDInfoKey, string);
        long l = System.currentTimeMillis();
        this.getBvs(string);
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        CRDInfoModel cRDInfoModel = this.allocate(cRDInfoKey);
        CRDInfoDAO cRDInfoDAO = CRDInfoDAO.getInstance();
        CRDRunDetailDAO cRDRunDetailDAO = CRDRunDetailDAO.getInstance();
        Connection connection = null;
        try {
            connection = cRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            this.clone(cRDInfoModel);
            cRDInfoModel = cRDInfoDAO.get(connection, cRDInfoModel);
            cRDRunDetailDAO.delete(connection, cRDInfoModel.getId());
            int n = cRDInfoDAO.delete(connection, cRDInfoModel);
            if (extCRDInfo == null) {
                extCRDInfo = this.charAt(cRDInfoModel);
            }
            this.deleteCRDResult(extCRDInfo);
            this.getAutoCacheExpired(cRDInfoKey);
            if (extCRDInfo.isRunning()) {
                CRDResultToolkit.cancelGenerateCRDResult(this, this.CACHE_DIR_NAME(extCRDInfo.getCatalogPath()), extCRDInfo);
            }
            this.addRunDetail(extCRDInfo);
            if (extCRDInfo.getBVName() != null) {
                ExtCompletedCRDInfo extCompletedCRDInfo = new ExtCompletedCRDInfo(extCRDInfo);
                extCompletedCRDInfo.setStartTime(new Date(l));
                extCompletedCRDInfo.setCompletedTime(new Date());
                extCompletedCRDInfo.setActivityType((short)7);
                extCompletedCRDInfo.setSuccess(true);
                CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
                CompletedCRDInfoModel completedCRDInfoModel = this.backupInfo(extCompletedCRDInfo);
                completedCRDInfoDAO.insert(connection, completedCRDInfoModel);
            }
            connection.commit();
        }
        catch (CRDManageException cRDManageException) {
            ServiceLogger.trace("CRDManager: deleteCRD: failed! %s [extCRDInfo=%s]", new Object[]{cRDManageException, extCRDInfo});
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw cRDManageException;
        }
        catch (Exception exception) {
            ServiceLogger.trace("CRDManager: deleteCRD: failed! %s [extCRDInfo=%s]", exception, extCRDInfo);
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            ServiceLogger.logError(exception, 2);
            throw new CRDManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
        ServiceLogger.trace("CRDManager: deleteCRD: success![extCRDInfo=%s]", extCRDInfo);
    }

    public void clearCompletedCRD(Connection connection) throws SQLException {
        ServiceLogger.trace("CRDManager: clearCompletedCRD... (conn=%s)", connection);
        CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
        List list = completedCRDInfoDAO.listAll(connection);
        if (list != null) {
            for (int i = list.size() - 1; i >= this.HISTORY.getMaxCompletedRecordCount(); --i) {
                CompletedCRDInfoModel completedCRDInfoModel = (CompletedCRDInfoModel)list.get(i);
                completedCRDInfoDAO.delete(connection, completedCRDInfoModel);
            }
        }
        ServiceLogger.trace("CRDManager: clearCompletedCRD: success![conn=%s]", connection);
    }

    @Override
    public CRDInfo getCRD(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        return this.CRD_CONFIG_MAP(cRDInfoKey);
    }

    private CRDInfo CRD_CONFIG_MAP(CRDInfoKey cRDInfoKey) {
        return (CRDInfo)this.add.get(cRDInfoKey);
    }

    @Override
    public Vector listCompletedCRDs(String string, boolean bl) throws CRDManageException {
        ServiceLogger.trace("CRDManager: listCompletedCRDs... (loginUser=%s, isCube=%s)", string, bl);
        this.getBvs(string);
        CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
        Vector<CompletedCRDInfo> vector = new Vector<CompletedCRDInfo>();
        Connection connection = null;
        try {
            connection = completedCRDInfoDAO.getConnection();
            List list = completedCRDInfoDAO.listAll(connection);
            for (CompletedCRDInfoModel completedCRDInfoModel : list) {
                CompletedCRDInfo completedCRDInfo;
                if (bl && completedCRDInfoModel.getBvName() == null || !bl && completedCRDInfoModel.getBvName() != null || (completedCRDInfo = this.clear(completedCRDInfoModel)) == null || !StringUtils.equals(CSUtil.parsePrincipalDisplayName(string)[0], CSUtil.parseVirtualResourcePath(completedCRDInfo.getCatalogPath())[0])) continue;
                vector.add(completedCRDInfo);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.trace("CRDManager: listCompletedCRDs: failed! %s [loginUser=%s]", sQLException, string);
            throw new CRDManageException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    throw new CRDManageException(sQLException);
                }
            }
        }
        ServiceLogger.trace("CRDManager: listCompletedCRDs: success![resultSize=%s]", vector.size());
        return vector;
    }

    @Override
    public Vector listRunningCRDs(String string) throws CRDManageException {
        ServiceLogger.trace("CRDManager: listRunningCRDs... (loginUser=%s)", string);
        this.getBvs(string);
        Vector<ExtRunningCRDInfo> vector = new Vector<ExtRunningCRDInfo>();
        for (ExtCRDInfo extCRDInfo : this.addAll) {
            if (extCRDInfo == null || !extCRDInfo.isRunning() || !StringUtils.equals(CSUtil.parsePrincipalDisplayName(string)[0], CSUtil.parseVirtualResourcePath(extCRDInfo.getCatalogPath())[0])) continue;
            ExtRunningCRDInfo extRunningCRDInfo = new ExtRunningCRDInfo(extCRDInfo);
            vector.add(extRunningCRDInfo);
        }
        ServiceLogger.trace("CRDManager: listRunningCRDs: success![resultSize=%s]", vector.size());
        return vector;
    }

    @Override
    public Vector listCRDs(String string, boolean bl) throws CRDManageException {
        ServiceLogger.trace("CRDManager: listCRDs... (loginUser=%s, isCube=%s)", string, bl);
        this.getBvs(string);
        Vector<ExtCRDInfo> vector = new Vector<ExtCRDInfo>();
        for (ExtCRDInfo extCRDInfo : this.addAll) {
            if (extCRDInfo == null || bl != (extCRDInfo.getBVName() != null && extCRDInfo.getBVName().trim().length() > 0) || !StringUtils.equals(CSUtil.parsePrincipalDisplayName(string)[0], CSUtil.parseVirtualResourcePath(extCRDInfo.getCatalogPath())[0])) continue;
            vector.add(extCRDInfo);
        }
        ServiceLogger.trace("CRDManager: listCRDs: success![resultSize=%s]", vector.size());
        return vector;
    }

    private Vector CRD_DIR_NAME() {
        Vector<ExtCRDInfo> vector = new Vector<ExtCRDInfo>();
        for (ExtCRDInfo extCRDInfo : this.addAll) {
            if (extCRDInfo == null) continue;
            vector.add(extCRDInfo);
        }
        ServiceLogger.trace("CRDManager: listCRDs: success![resultSize=%s]", vector.size());
        return vector;
    }

    @Override
    public List getParamInfos(String string, CRDInfoKey cRDInfoKey) throws RemoteException, CRDManageException {
        ServiceLogger.trace("CRDManager: getParamInfos... (crdKey=%s, loginUser=%s)", cRDInfoKey, string);
        if (this.getAutoCacheResult(cRDInfoKey) == null) {
            return null;
        }
        ArrayList<JRRemoteParamInfo> arrayList = new ArrayList<JRRemoteParamInfo>();
        List list = this.CreateParseParametersForQuery(cRDInfoKey);
        if (list != null) {
            for (ParamInfo paramInfo : list) {
                JRRemoteParamInfo jRRemoteParamInfo = new JRRemoteParamInfo(paramInfo);
                arrayList.add(jRRemoteParamInfo);
            }
        }
        return arrayList;
    }

    private String CRD_PARAM_MAP(CRDInfoKey cRDInfoKey) {
        return this.CRD_RESULT_USABLED_MAP(this.CRD_CONFIG_MAP(cRDInfoKey));
    }

    private String CRD_RESULT_USABLED_MAP(CRDInfo cRDInfo) {
        String string = "JReport_System_User";
        if (cRDInfo != null) {
            string = cRDInfo.getLoginUser();
        }
        if (string == null || string.trim().length() == 0) {
            string = "JReport_System_User";
        }
        return string;
    }

    private List CreateParseParametersForQuery(CRDInfoKey cRDInfoKey) throws RemoteException, CRDManageException {
        Map map = (Map)this.addListener.get(cRDInfoKey);
        if (map == null) {
            ServiceLogger.trace("CRDManager: getParamInfos: no parameter. [crdKey=%s]", cRDInfoKey);
            return null;
        }
        Map map2 = (Map)this.addRunDetail.get(cRDInfoKey);
        Map map3 = (Map)this.addListener.get(cRDInfoKey);
        Vector<ParamInfo> vector = null;
        ParameterManager parameterManager = null;
        String string = this.CRD_PARAM_MAP(cRDInfoKey);
        try {
            PathInfo pathInfo = this.CRD_RESULT_USABLED_MAP.getPathInfo(string, cRDInfoKey.getCatalogPath());
            CatalogInfo catalogInfo = this.AUTO_CACHE_RESULT_USABLED_MAP.getCatalogInfo(string, cRDInfoKey.getCatalogPath(), pathInfo.getLatestVersionNumber());
            parameterManager = catalogInfo.getParameterManager(cRDInfoKey.getDataSource(), new String[]{cRDInfoKey.getQueryName()});
            vector = parameterManager.getAllParametersWithChanging(new HashMap());
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.trace("CRDManager: getParamInfos: fail! %s [crdKey=%s]", new Object[]{rptServerException, cRDInfoKey});
        }
        long l = System.currentTimeMillis();
        if (vector != null) {
            for (ParamInfo paramInfo : vector) {
                String string2 = paramInfo.getName();
                ParamDesc paramDesc = ((JRParamInfo)paramInfo).getParamDesc();
                Locale locale = Locale.getDefault();
                paramInfo.setLocale(locale);
                String[] stringArray = (String[])map3.get(string2);
                try {
                    String[] stringArray2;
                    Object object;
                    if (stringArray != null && stringArray.length > 0) {
                        object = null;
                        object = ParamUtil.isDateTime(paramDesc) ? (!paramDesc.isMultipleValue() ? ParamUtil.makeUserInput(stringArray)[0] : ParamUtil.makeUserInput(stringArray)) : (!paramDesc.isMultipleValue() ? stringArray[0] : stringArray);
                        ParamUtil.setParamValue(paramDesc, object, locale, l);
                    }
                    if ((object = (String[])map2.get("jrs.param.values$" + string2)) != null) {
                        stringArray2 = new Vector();
                        for (UserInput userInput : object) {
                            stringArray2.add(userInput);
                        }
                        paramDesc.setValues((Vector)stringArray2, locale);
                    }
                    if ((stringArray2 = (String[])map2.get("jrs.param.display.values$" + string2)) == null) continue;
                    Vector vector2 = new Vector();
                    for (String string3 : stringArray2) {
                        vector2.add(string3);
                    }
                    paramDesc.setShowValues(vector2);
                }
                catch (Exception exception) {
                    ServiceLogger.trace("CRDManager: getParamInfos: fail! %s [crdKey=%s]", exception, cRDInfoKey);
                    throw new CRDManageException(exception);
                }
            }
            parameterManager.clear();
            ServiceLogger.trace("CRDManager: getParamInfos: success! [crdKey=%s, resultSize=%s]", cRDInfoKey, vector.size());
        }
        return vector;
    }

    private ServerResourceStore EXT_CRD_INFO_MAP(String string) {
        return ServerResourceStoreFactory.getInstance().getResourceStoreByResourcePath(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HISTORY(ExtCRDInfo extCRDInfo, boolean bl) throws OutOfSpaceException {
        Map map = this.backupInfo;
        synchronized (map) {
            Long l;
            boolean bl2;
            boolean bl3 = bl2 = extCRDInfo.getBVName() != null && extCRDInfo.getBVName().trim().length() > 0;
            if (!bl2) {
                return;
            }
            if (extCRDInfo.getStatus() == 5) {
                this.addAll(extCRDInfo);
            }
            l = (l = (Long)this.backupInfo.get(extCRDInfo.getCRDKey())) == null ? 0L : l;
            long l2 = (long)(1048576.0 * extCRDInfo.getMaxAllowMemory());
            long l3 = l2 - l;
            if (l3 == 0L) {
                return;
            }
            SpaceAllocatorExt spaceAllocatorExt = this.EXT_CRD_INFO_MAP(extCRDInfo.getCRDKey().getCatalogPath()).getMemoryStore().getCubeSpaceAllocator();
            if (bl) {
                spaceAllocatorExt.allocateForce(l3);
            } else if (l3 > 0L) {
                if (!spaceAllocatorExt.allocate(l3)) {
                    throw new OutOfSpaceException();
                }
            } else {
                spaceAllocatorExt.deallocate(-l3);
            }
            this.backupInfo.put(extCRDInfo.getCRDKey(), l2);
        }
    }

    private void SEDU(ExtCRDInfo extCRDInfo) throws OutOfSpaceException {
        this.HISTORY(extCRDInfo, false);
    }

    private void add(ExtCRDInfo extCRDInfo) {
        try {
            this.HISTORY(extCRDInfo, true);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(ExtCRDInfo extCRDInfo) {
        Map map = this.backupInfo;
        synchronized (map) {
            boolean bl;
            boolean bl2 = bl = extCRDInfo.getBVName() != null && extCRDInfo.getBVName().trim().length() > 0;
            if (!bl) {
                return;
            }
            Long l = (Long)this.backupInfo.remove(extCRDInfo.getCRDKey());
            if (l != null && l > 0L) {
                this.EXT_CRD_INFO_MAP(extCRDInfo.getCRDKey().getCatalogPath()).getMemoryStore().getCubeSpaceAllocator().deallocate(l);
            }
        }
    }

    private void addListener(ExtCRDInfo extCRDInfo) {
        this.add(extCRDInfo);
        if (this.add.containsKey(extCRDInfo.getCRDKey())) {
            this.add.remove(extCRDInfo.getCRDKey());
        }
        this.add.put(extCRDInfo.getCRDKey(), extCRDInfo);
        if (this.addAll.contains(extCRDInfo)) {
            this.addAll.remove(extCRDInfo);
        }
        this.addAll.add(extCRDInfo);
    }

    private void addRunDetail(ExtCRDInfo extCRDInfo) {
        this.addAll(extCRDInfo);
        this.add.remove(extCRDInfo.getCRDKey());
        this.addAll.remove(extCRDInfo);
        this.addListener.remove(extCRDInfo.getCRDKey());
        this.addRunDetail.remove(extCRDInfo.getCRDKey());
        this.allocate.remove(extCRDInfo.getCRDKey());
    }

    private CRDInfoModel allocate(CRDInfoKey cRDInfoKey) {
        CRDInfo cRDInfo = null;
        cRDInfo = cRDInfoKey instanceof CubeInfoKey ? new CubeInfo(cRDInfoKey.getCatalogPath(), cRDInfoKey.getDataSource(), cRDInfoKey.getQueryType(), cRDInfoKey.getQueryName(), ((CubeInfoKey)cRDInfoKey).getBVName()) : new CRDInfo(cRDInfoKey.getCatalogPath(), cRDInfoKey.getDataSource(), cRDInfoKey.getQueryType(), cRDInfoKey.getQueryName());
        return this.available(cRDInfo);
    }

    private void allocateForce(AbstractCRDInfoModel abstractCRDInfoModel, CRDInfo cRDInfo) {
        abstractCRDInfoModel.setDataSource(cRDInfo.getDataSource());
        Date date = cRDInfo.getLastModified();
        abstractCRDInfoModel.setLastModified(date == null ? 0L : date.getTime());
        abstractCRDInfoModel.setLazy(cRDInfo.isLazy() ? 1 : 0);
        abstractCRDInfoModel.setParamFile(cRDInfo.getParamFile());
        abstractCRDInfoModel.setPasswords(cRDInfo.getPasswords());
        abstractCRDInfoModel.setQueryName(cRDInfo.getQueryName());
        abstractCRDInfoModel.setQueryType(cRDInfo.getQueryType());
        abstractCRDInfoModel.setUserNames(cRDInfo.getUserNames());
        abstractCRDInfoModel.setLoginUser(cRDInfo.getLoginUser());
        abstractCRDInfoModel.setCacheType(cRDInfo.getCacheType());
    }

    private void append(CRDInfoModel cRDInfoModel, CRDInfo cRDInfo) {
        if (!(cRDInfo instanceof CubeInfo)) {
            return;
        }
        CubeInfo cubeInfo = (CubeInfo)cRDInfo;
        cRDInfoModel.setBvName(cubeInfo.getBVName());
        cRDInfoModel.setStatus(this.asList(cubeInfo.getStatus()));
        cRDInfoModel.setCreateTime(cubeInfo.getCreatedTime());
        cRDInfoModel.setMaxMemory(cubeInfo.getMaxAllowMemory());
        cRDInfoModel.setCanSwaptoDisk(cubeInfo.getCanSwaptoDisk());
        cRDInfoModel.setLocation(cubeInfo.getLocation());
    }

    private short asList(short s) {
        if (s == 5) {
            return 1;
        }
        return 0;
    }

    private CRDInfoModel available(CRDInfo cRDInfo) {
        if (cRDInfo == null) {
            return null;
        }
        CRDInfoModel cRDInfoModel = new CRDInfoModel();
        String string = cRDInfo.getCatalogPath();
        String string2 = this.CRD_RESULT_USABLED_MAP(cRDInfo);
        try {
            PathInfoImpl pathInfoImpl = (PathInfoImpl)this.CRD_RESULT_USABLED_MAP.getPathInfo(string2, string);
            int n = pathInfoImpl.getID();
            cRDInfoModel.setCatalogLastModified(pathInfoImpl.getLastModified());
            cRDInfoModel.setCatalogId(n);
            cRDInfoModel.setCatalogVersion(pathInfoImpl.getLatestVersionNumber());
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.trace("CRDManager: CRDInfoModel convertCRD(CRDInfo crdInfo)...have not find catalog [catalogPath=%s]", string);
        }
        cRDInfoModel.setCatalogPath(string);
        cRDInfoModel.setTaskId(cRDInfo.getTaskId());
        this.allocateForce(cRDInfoModel, cRDInfo);
        this.append(cRDInfoModel, cRDInfo);
        if (cRDInfo instanceof ExtCRDInfo) {
            cRDInfoModel.setResultVersion(((ExtCRDInfo)cRDInfo).getResultVersion());
            cRDInfoModel.setConfigFile(((ExtCRDInfo)cRDInfo).getConfigFile());
        }
        return cRDInfoModel;
    }

    private CompletedCRDInfoModel backupInfo(ExtCompletedCRDInfo extCompletedCRDInfo) {
        if (extCompletedCRDInfo == null) {
            return null;
        }
        CompletedCRDInfoModel completedCRDInfoModel = new CompletedCRDInfoModel();
        String string = extCompletedCRDInfo.getCatalogPath();
        String string2 = this.CRD_RESULT_USABLED_MAP(extCompletedCRDInfo.getCrdInfo());
        try {
            PathInfoImpl pathInfoImpl = (PathInfoImpl)this.CRD_RESULT_USABLED_MAP.getPathInfo(string2, string);
            int n = pathInfoImpl.getID();
            completedCRDInfoModel.setCatalogLastModified(pathInfoImpl.getLastModified());
            completedCRDInfoModel.setCatalogId(n);
            completedCRDInfoModel.setCatalogVersion(pathInfoImpl.getLatestVersionNumber());
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.trace("CRDManager: CompletedCRDInfoModel convertCRD(CompletedCRDInfo crdInfo)...have not find catalog [catalogPath=%s]", string);
        }
        completedCRDInfoModel.setCatalogPath(string);
        this.allocateForce(completedCRDInfoModel, extCompletedCRDInfo.getCrdInfo());
        completedCRDInfoModel.setId(extCompletedCRDInfo.getId());
        completedCRDInfoModel.setCompletedTime(extCompletedCRDInfo.getCompletedTime().getTime());
        completedCRDInfoModel.setStartTime(extCompletedCRDInfo.getStartTime().getTime());
        completedCRDInfoModel.setSuccess(extCompletedCRDInfo.isSuccess() ? 1 : 0);
        completedCRDInfoModel.setBvName(extCompletedCRDInfo.getBvName());
        completedCRDInfoModel.setActivity(extCompletedCRDInfo.getActivityType());
        completedCRDInfoModel.setMessage(extCompletedCRDInfo.getMessage());
        return completedCRDInfoModel;
    }

    private void calculateCubeMemorySize(ExtCRDInfo extCRDInfo, AbstractCRDInfoModel abstractCRDInfoModel) {
        extCRDInfo.setLastModified(new Date(abstractCRDInfoModel.getLastModified()));
        extCRDInfo.setLazy(abstractCRDInfoModel.getLazy() > 0);
        extCRDInfo.setParamFile(abstractCRDInfoModel.getParamFile());
        extCRDInfo.setPasswords(abstractCRDInfoModel.getPasswords());
        extCRDInfo.setUserNames(abstractCRDInfoModel.getUserNames());
        extCRDInfo.setCatalogLastModified(new Date(abstractCRDInfoModel.getCatalogLastModified()));
        extCRDInfo.setLastModified(new Date(abstractCRDInfoModel.getLastModified()));
        extCRDInfo.setCatalogVersion(abstractCRDInfoModel.getCatalogVersion());
        extCRDInfo.setLoginUser(abstractCRDInfoModel.getLoginUser());
        extCRDInfo.setCacheType(abstractCRDInfoModel.getCacheType());
    }

    private void cancelGenerateCRDResult(ExtCRDInfo extCRDInfo, CRDInfoModel cRDInfoModel) {
        extCRDInfo.setCreatedTime(cRDInfoModel.getCreateTime());
        extCRDInfo.setMaxAllowMemory(cRDInfoModel.getMaxMemory());
        extCRDInfo.setCanSwaptoDisk(cRDInfoModel.getCanSwaptoDisk());
        extCRDInfo.setLocation(cRDInfoModel.getLocation());
    }

    private CRDRunDetail cancelInit(CRDInfoKey cRDInfoKey, CRDRunDetailModel cRDRunDetailModel) {
        return new CRDRunDetail(cRDInfoKey, cRDRunDetailModel.getActivity(), cRDRunDetailModel.getStartTime(), cRDRunDetailModel.getEndTime(), cRDRunDetailModel.isSucc());
    }

    private ExtCRDInfo charAt(CRDInfoModel cRDInfoModel) {
        if (cRDInfoModel == null) {
            return null;
        }
        ExtCRDInfo extCRDInfo = null;
        String string = cRDInfoModel.getCatalogPath();
        String string2 = string == null ? null : string.substring(string.lastIndexOf("/") + 1);
        CRDInfoKey cRDInfoKey = null;
        String string3 = null;
        if (cRDInfoModel.getBvName() == null || cRDInfoModel.getBvName().trim().length() == 0) {
            cRDInfoKey = new CRDInfoKey(string, cRDInfoModel.getDataSource(), cRDInfoModel.getQueryType(), cRDInfoModel.getQueryName());
        } else {
            string3 = cRDInfoModel.getBvName();
            cRDInfoKey = new CubeInfoKey(string, cRDInfoModel.getDataSource(), cRDInfoModel.getQueryType(), cRDInfoModel.getQueryName(), string3);
        }
        extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        if (extCRDInfo == null) {
            extCRDInfo = new ExtCRDInfo(string, cRDInfoModel.getDataSource(), cRDInfoModel.getQueryType(), cRDInfoModel.getQueryName(), string3);
        }
        extCRDInfo.setCatalogName(string2);
        extCRDInfo.setResultVersion(cRDInfoModel.getResultVersion());
        extCRDInfo.setConfigFile(cRDInfoModel.getConfigFile());
        extCRDInfo.setId(cRDInfoModel.getId());
        extCRDInfo.setTaskId(cRDInfoModel.getTaskId());
        this.calculateCubeMemorySize(extCRDInfo, cRDInfoModel);
        this.cancelGenerateCRDResult(extCRDInfo, cRDInfoModel);
        return extCRDInfo;
    }

    private CompletedCRDInfo clear(CompletedCRDInfoModel completedCRDInfoModel) {
        if (completedCRDInfoModel == null) {
            return null;
        }
        ExtCompletedCRDInfo extCompletedCRDInfo = null;
        String string = completedCRDInfoModel.getCatalogPath();
        String string2 = string == null ? null : string.substring(string.lastIndexOf("/") + 1);
        ExtCRDInfo extCRDInfo = new ExtCRDInfo(string, completedCRDInfoModel.getDataSource(), completedCRDInfoModel.getQueryType(), completedCRDInfoModel.getQueryName(), completedCRDInfoModel.getBvName());
        extCRDInfo.setCatalogName(string2);
        this.calculateCubeMemorySize(extCRDInfo, completedCRDInfoModel);
        extCompletedCRDInfo = new ExtCompletedCRDInfo(extCRDInfo);
        extCompletedCRDInfo.setId(completedCRDInfoModel.getId());
        extCompletedCRDInfo.setCompletedTime(new Date(completedCRDInfoModel.getCompletedTime()));
        extCompletedCRDInfo.setStartTime(new Date(completedCRDInfoModel.getStartTime()));
        extCompletedCRDInfo.setSuccess(completedCRDInfoModel.getSuccess() > 0);
        extCompletedCRDInfo.setActivityType(completedCRDInfoModel.getActivity());
        extCompletedCRDInfo.setMessage(completedCRDInfoModel.getMessage());
        return extCompletedCRDInfo;
    }

    private void clone(CRDInfoModel cRDInfoModel) throws CRDManageException {
        if (cRDInfoModel.getCatalogPath() == null || cRDInfoModel.getCatalogPath().trim().length() == 0) {
            throw new CRDManageException("unknown catalog.");
        }
        if (cRDInfoModel.getDataSource() == null || cRDInfoModel.getDataSource().trim().length() == 0) {
            throw new CRDManageException("unknown datasouce.");
        }
        if (cRDInfoModel.getQueryType() < 0) {
            throw new CRDManageException("unknown query type.");
        }
        if (!(cRDInfoModel.getQueryName() != null && cRDInfoModel.getQueryName().trim().length() != 0 || cRDInfoModel.getBvName() != null && cRDInfoModel.getBvName().trim().length() != 0)) {
            throw new CRDManageException("unknown query or business view name.");
        }
    }

    private void close(CRDInfoKey cRDInfoKey) throws IOException, StorageException {
        HashMap hashMap = (HashMap)this.addListener.get(cRDInfoKey);
        if (hashMap == null) {
            hashMap = new HashMap();
        } else {
            hashMap.clear();
        }
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        extCRDInfo.setParamValues(hashMap);
        String string = extCRDInfo.getParamFile();
        if (string != null && string.trim().length() > 0) {
            this.available.get(Storage.StorageRoot.HISTORY, string);
            this.delete(cRDInfoKey, this.CRD_RESULT_USABLED_MAP.getHistDir() + string, hashMap);
        }
        this.addListener.put(cRDInfoKey, hashMap);
    }

    private void commit(CRDInfoKey cRDInfoKey) throws IOException {
        HashMap hashMap = (HashMap)this.addRunDetail.get(cRDInfoKey);
        if (hashMap == null) {
            hashMap = new HashMap();
        } else {
            hashMap.clear();
        }
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        String string = this.evalExpressionValues(extCRDInfo);
        try {
            this.available.get(this.existed(extCRDInfo));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                this.doubleValue(cRDInfoKey, true);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        catch (StorageException storageException) {
            try {
                this.doubleValue(cRDInfoKey, true);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        this.delete(cRDInfoKey, this.CreateParseParametersForQuery + string, hashMap);
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("CRDManager: initConfig. [crdKey=%s, config=%s]", cRDInfoKey, StringUtil.toString(hashMap));
        }
        this.addRunDetail.put(cRDInfoKey, hashMap);
    }

    private boolean contains(Map hashMap, Map hashMap2) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
        }
        if (hashMap.size() == 0 && hashMap2.size() == 0) {
            return true;
        }
        if (hashMap.size() != hashMap2.size()) {
            return false;
        }
        boolean bl = true;
        for (String string : hashMap.keySet()) {
            if (hashMap2.containsKey(string)) {
                if (this.containsKey((Properties)hashMap.get(string), (Properties)hashMap2.get(string))) continue;
                bl = false;
                break;
            }
            bl = false;
            break;
        }
        return bl;
    }

    private boolean containsKey(Properties properties, Properties properties2) {
        if (properties == null) {
            properties = new Properties();
        }
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if (properties.size() == 0 && properties2.size() == 0) {
            return true;
        }
        if (properties.size() != properties2.size()) {
            return false;
        }
        boolean bl = true;
        for (String string : properties.keySet()) {
            if (properties2.containsKey(string)) {
                Object object = properties.get(string);
                if (object.equals(properties2.get(string))) continue;
                bl = false;
                break;
            }
            bl = false;
            break;
        }
        return bl;
    }

    private boolean copy(Map hashMap, Map hashMap2) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
        }
        if (hashMap.size() == 0 && hashMap2.size() == 0) {
            return true;
        }
        if (hashMap.size() != hashMap2.size()) {
            return false;
        }
        for (String string : hashMap.keySet()) {
            String[] stringArray;
            if (!hashMap2.containsKey(string)) {
                return false;
            }
            String[] stringArray2 = (String[])hashMap.get(string);
            if (stringArray2.length != (stringArray = (String[])hashMap2.get(string)).length) {
                return false;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray2) {
                arrayList.add(string2.trim());
            }
            ArrayList arrayList2 = new ArrayList();
            for (String string3 : stringArray) {
                arrayList2.add(string3.trim());
            }
            for (String string4 : arrayList) {
                if (arrayList2.contains(string4)) continue;
                return false;
            }
        }
        return true;
    }

    private Map createNewFile(CRDInfoKey cRDInfoKey) {
        return this.decreaseUsingReport(cRDInfoKey, "jrs.conn_info1$");
    }

    private Map currentTimeMillis(CRDInfoKey cRDInfoKey) {
        return this.decreaseUsingReport(cRDInfoKey, "jrs.param.values$");
    }

    private Map deallocate(CRDInfoKey cRDInfoKey) {
        return this.decreaseUsingReport(cRDInfoKey, "jrs.param.display.values$");
    }

    private Map decreaseUsingReport(CRDInfoKey cRDInfoKey, String string) {
        Map map = (Map)this.addRunDetail.get(cRDInfoKey);
        if (map == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2.substring(string.length()), map.get(string2));
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("CRDManager: getConfig. [crdKey=%s, prefix=%s, returnValue=%s]", cRDInfoKey, string, StringUtil.toString(hashMap));
        }
        return hashMap;
    }

    private void delete(CRDInfoKey cRDInfoKey, String string, Map map) {
        ServiceLogger.trace("CRDManager: readParamFile... [crdKey=%s, paramValueFile=%s]", cRDInfoKey, string);
        if (!new File(string).exists()) {
            ServiceLogger.trace("CRDManager: readParamFile: failed! file not exists.[crdKey=%s]", cRDInfoKey);
            return;
        }
        Map map2 = JRTUtil.readParamFile(string);
        if (map2 == null || map2.isEmpty()) {
            ServiceLogger.trace("CRDManager: readParamFile: file is empty. [crdKey=%s]", cRDInfoKey);
            return;
        }
        ServiceLogger.trace("CRDManager: readParamFile: success. [crdKey=%s, paramSize=%s]", cRDInfoKey, map2.size());
        for (String string2 : map2.keySet()) {
            List list = (List)map2.get(string2);
            String[] stringArray = list == null ? null : list.toArray(new String[list.size()]);
            map.put(string2, stringArray);
        }
    }

    private void deleteCRDResult(ExtCRDInfo extCRDInfo) throws IOException, StorageException {
        File file = new File(this.CRD_RESULT_USABLED_MAP.getHistDir() + extCRDInfo.getParamFile());
        File file2 = new File(this.CreateParseParametersForQuery + this.evalExpressionValues(extCRDInfo));
        ServiceLogger.trace("CRDManager: deleteFiles... [crdInfo=%s, paramFile=%s, configFile=%s]", extCRDInfo, file.getAbsolutePath(), file2.getAbsoluteFile());
        if (extCRDInfo.getParamFile() != null) {
            this.available.delete(Storage.StorageRoot.HISTORY, extCRDInfo.getParamFile());
        }
        if (file.exists()) {
            file.delete();
        }
        this.available.delete(this.existed(extCRDInfo));
        if (file2.exists()) {
            file2.delete();
        }
    }

    private void doubleValue(CRDInfoKey cRDInfoKey, boolean bl) throws Exception {
        String[] stringArray;
        Object object;
        Object object2;
        String string = this.CRD_PARAM_MAP(cRDInfoKey);
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (bl) {
            ArrayList<String> arrayList;
            JetUDatabase jetUDatabase;
            Object object3;
            object2 = (PathInfoImpl)this.CRD_RESULT_USABLED_MAP.getPathInfo(string, cRDInfoKey.getCatalogPath());
            object = (JRCatalogInfo)this.AUTO_CACHE_RESULT_USABLED_MAP.getCatalogInfo(string, cRDInfoKey.getCatalogPath(), ((PathInfoImpl)object2).getLatestVersionNumber());
            Object object4 = (Map)this.addListener.get(cRDInfoKey);
            stringArray = ((JRCatalogInfo)object).getUniverse();
            if ((extCRDInfo.getCacheType() == 2 || extCRDInfo.getCacheType() == 3) && UniverseToolkit.BvUseMoreParameter((JetUUniverse)stringArray, (String)cRDInfoKey.getDataSource(), (String)((CubeInfoKey)cRDInfoKey).getBVName())) {
                throw new CRDManageException(600060, new Object[]{cRDInfoKey.getQueryName()}, null);
            }
            if (cRDInfoKey.getQueryType() != 6 && (object3 = (jetUDatabase = ParseParametersForQueryFactory.CreateParseParametersForQuery((JetUUniverse)stringArray, (String)cRDInfoKey.getDataSource(), (String)cRDInfoKey.getQueryName())).getParameterNamesInQuery()) != null) {
                JetUConnection jetUConnection = new ArrayList();
                for (Object object5 : object3) {
                    jetUConnection.add(this.paramName((String)object5).toUpperCase());
                }
                arrayList = new ArrayList<String>();
                if (object4 != null) {
                    Iterator iterator = object4.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = this.paramName((String)iterator.next());
                        if (jetUConnection.contains(string2.toUpperCase())) continue;
                        arrayList.add(string2);
                    }
                }
                hashtable.put("jrs.nonequery.param$", arrayList);
            }
            if ((jetUDatabase = stringArray.getDatabase(extCRDInfo.getDataSource())) != null) {
                for (JetUConnection jetUConnection : jetUDatabase.getConnections()) {
                    if (jetUConnection == null) continue;
                    arrayList = jetUConnection.getResourceName();
                    this.endsWith(cRDInfoKey, hashtable, (String)((Object)arrayList));
                }
            }
            stringArray.free();
        } else {
            object2 = (Map)this.addRunDetail.get(cRDInfoKey);
            if (object2 != null) {
                for (Object object4 : object2.keySet()) {
                    stringArray = (String[])object2.get(object4);
                    if (!((String)object4).startsWith("jrs.param.values$") && !((String)object4).startsWith("jrs.param.display.values$") && !((String)object4).startsWith("jrs.nonequery.param$") && !((String)object4).startsWith("jrs.conn_info1$")) continue;
                    hashtable.put(object4, stringArray);
                }
            }
        }
        if (this.addRunDetail.get(cRDInfoKey) != null && (object2 = extCRDInfo.getRuntimeParamValues()) != null) {
            for (Object object4 : object2.keySet()) {
                stringArray = (String[])object2.get(object4);
                hashtable.put("jrs.param.runtime$" + (String)object4, stringArray);
            }
        }
        object2 = this.evalExpressionValues(extCRDInfo);
        object = new File(this.CreateParseParametersForQuery + (String)object2);
        ((File)object).getParentFile().mkdirs();
        if (((File)object).exists()) {
            ((File)object).delete();
            ((File)object).createNewFile();
        }
        this.equals((File)object, hashtable);
        this.available.add(this.existed(extCRDInfo), null);
    }

    private void endsWith(CRDInfoKey cRDInfoKey, Hashtable hashtable, String string) throws RemoteException {
        Properties properties = this.SEDU.getConnectionInfo(string);
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("CRDManager: createConfigFile... [crdKey=%s, connName=%s, connInfo=%s]", cRDInfoKey, string, StringUtil.toString(properties));
        }
        if (properties != null) {
            properties = (Properties)properties.clone();
            DatabaseMetadataInfo databaseMetadataInfo = this.SEDU.getDatabaseMetadataInfo(string);
            Properties properties2 = DatabaseMetadataInfoMaker.toProperties(databaseMetadataInfo);
            properties.putAll((Map<?, ?>)properties2);
            hashtable.put("jrs.conn_info1$" + string, CSUtil.makeNoHeadQuery(properties));
        }
    }

    private String paramName(String string) {
        return string;
    }

    private String equals(File file, Hashtable hashtable) throws Exception {
        if (file == null || hashtable == null) {
            return null;
        }
        String string = null;
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        String string2 = null;
        String string3 = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Map map = ParamUtil.evalExpressionValues(hashtable2);
            for (Object object : map.keySet()) {
                Object object2;
                int n;
                Object object3;
                StringTokenizer stringTokenizer;
                if (!(object instanceof String)) continue;
                string2 = (String)object;
                if ((object = map.get(string2)) == null || object instanceof String) {
                    string3 = (String)object;
                    if (string3.endsWith("\\")) {
                        string3 = string3 + "\\";
                    }
                    if (string3 == null) continue;
                    stringTokenizer = new StringTokenizer(string2, "=");
                    string2 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        if (string2.length() == 0) {
                            string2 = string2 + stringTokenizer.nextToken();
                            continue;
                        }
                        string2 = string2 + "\\\\=" + stringTokenizer.nextToken();
                    }
                    object3 = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    n = 0;
                    object2 = new BufferedReader(new StringReader(string3));
                    while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                        n = stringBuffer.length();
                        if (n == 0) {
                            stringBuffer.append((String)object3);
                            continue;
                        }
                        if (stringBuffer.charAt(n - 1) == '\\') {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append('\\').append('\n').append((String)object3);
                    }
                    string3 = stringBuffer.toString();
                    fileOutputStream.write((string2 + "=" + string3 + "\n").getBytes());
                    continue;
                }
                if (!(object instanceof List) && !(object instanceof String[])) continue;
                if (object instanceof String[]) {
                    object = Arrays.asList((String[])object);
                }
                stringTokenizer = new StringTokenizer(string2, "=");
                string2 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    if (string2.length() == 0) {
                        string2 = string2 + stringTokenizer.nextToken();
                        continue;
                    }
                    string2 = string2 + "\\\\=" + stringTokenizer.nextToken();
                }
                object3 = (List)object;
                int n2 = object3.size();
                for (n = 0; n < n2; ++n) {
                    object2 = object3.get(n);
                    if (object2 != null && !(object2 instanceof String)) continue;
                    string3 = (String)object2;
                    if (string3.endsWith("\\")) {
                        string3 = string3 + "\\";
                    }
                    if (string3 == null) continue;
                    String string4 = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
                    while ((string4 = bufferedReader.readLine()) != null) {
                        n3 = stringBuffer.length();
                        if (n3 == 0) {
                            stringBuffer.append(string4);
                            continue;
                        }
                        if (stringBuffer.charAt(n3 - 1) == '\\') {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append('\\').append('\n').append(string4);
                    }
                    string3 = stringBuffer.toString();
                    fileOutputStream.write((string2 + "=" + string3 + "\n").getBytes());
                }
            }
            fileOutputStream.close();
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return string;
    }

    private Object equalsIgnoreCase(ExtCRDInfo extCRDInfo) {
        CRDInfoKey cRDInfoKey = extCRDInfo.getCRDKey();
        Object object = this.allocate.get(cRDInfoKey);
        if (object == null) {
            object = new Object();
            this.allocate.put(cRDInfoKey, object);
        }
        return object;
    }

    private String evalExpressionValues(ExtCRDInfo extCRDInfo) {
        return this.getCRDCacheDir() + extCRDInfo.getAutoConfigFile();
    }

    private String existed(ExtCRDInfo extCRDInfo) {
        return this.AUTO_CACHE_RESULT_USABLED_MAP() + extCRDInfo.getAutoConfigFile();
    }

    private void exists() throws IOException, StorageException {
        Object object;
        Object object22;
        ServiceLogger.logDebug("CRDManager: removeResultVersionFiles...", 6);
        Vector vector = this.CRD_DIR_NAME();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : this.allocateForce.values()) {
            String string;
            object = ((AbstractCRDResult)object22).getPersistFile();
            if (object != null) {
                int n = ((String)(object = ((String)object).replace(File.separator, "/"))).lastIndexOf("/");
                if (n != -1) {
                    object = ((String)object).substring(n + 1);
                }
                ServiceLogger.trace("CRDManager: removeResultVersionFiles: crd simple result file (persistFile=%s)", object);
                arrayList.add(object);
            }
            if ((string = ((AbstractCRDResult)object22).getPersistBVFile()) == null) continue;
            int n = (string = string.replace(File.separator, "/")).lastIndexOf("/");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            ServiceLogger.trace("CRDManager: removeResultVersionFiles: crd simple result BV file (persistBVFile=%s)", string);
            arrayList.add(string);
        }
        File file = new File(this.CreateParseParametersForQuery + this.getCRDCacheDir());
        if (file.exists()) {
            for (File[] fileArray : object22 = file.listFiles()) {
                String string = fileArray.getName();
                if (arrayList.contains(string) || string.indexOf(".rst") <= -1) continue;
                ServiceLogger.trace("CRDManager: removeResultVersionFiles: delete .rst file (name=%s)", string);
                fileArray.delete();
                String string2 = fileArray.getAbsolutePath().replace(File.separator, "/").replace(this.CreateParseParametersForQuery.replace(File.separator, "/"), "");
                string2 = string2.replace(JRRemoteCRDManager.getCachePath(), "");
                this.available.delete(Storage.StorageRoot.CRD_CACHE, string2);
            }
        }
        if (((File)(object22 = new File(this.CreateParseParametersForQuery + this.getAutoCacheDir()))).exists()) {
            File[] fileArray;
            object = new ArrayList();
            for (AutoCacheResult autoCacheResult : this.append.values()) {
                object.add(autoCacheResult.getPersistFile().replace(File.separator, "/"));
            }
            for (File file2 : fileArray = ((File)object22).listFiles()) {
                String string = file2.getAbsolutePath().replace(File.separator, "/").replace(this.CreateParseParametersForQuery.replace(File.separator, "/"), "");
                if (object.contains(string)) continue;
                file2.delete();
                string = string.replace(JRRemoteCRDManager.getCachePath(), "");
                this.available.delete(Storage.StorageRoot.CRD_CACHE, string);
            }
        }
    }

    private String fileUpdated(ExtCRDInfo extCRDInfo) {
        return this.getCRDCacheDir() + extCRDInfo.getResultFile();
    }

    private String free(ExtCRDInfo extCRDInfo) {
        String string = this.fileUpdated(extCRDInfo);
        string = string.substring(0, string.length() - 4) + "_BV.rst";
        return string;
    }

    private String generateCRDResult(CRDInfoModel cRDInfoModel) {
        String string = cRDInfoModel.getId() + "_" + cRDInfoModel.getResultVersion();
        String string2 = ServerEnv.getServerID();
        if (string2 != null && string2.trim().length() > 0) {
            string = string2 + "_" + string;
        }
        return this.getCRDCacheDir() + string;
    }

    private Map get(ExtCRDInfo extCRDInfo) {
        Map<String, String[]> map = extCRDInfo.getRuntimeParamValues();
        HashMap<String, String[]> hashMap = null;
        if (map != null) {
            String[] stringArray;
            hashMap = new HashMap<String, String[]>();
            hashMap.putAll(map);
            Map map2 = (Map)this.addRunDetail.get(extCRDInfo.getCRDKey());
            if (map2 != null && (stringArray = (String[])map2.get("jrs.nonequery.param$")) != null) {
                for (String string : stringArray) {
                    hashMap.remove(this.paramName(string));
                }
            }
        }
        return hashMap;
    }

    private ExtCRDInfo getAbsoluteFile(CatalogKey catalogKey, String string, String string2, String string3) {
        ServiceLogger.trace("CRDManager: queryCubeInfo...(catKey=%s, ds=%s, query=%s, bv=%s)", catalogKey, string, string2, string3);
        List list = this.getActivity(catalogKey.getPath(), string, string2, string3);
        ExtCRDInfo extCRDInfo = null;
        CubeInfoKey cubeInfoKey = null;
        if (list != null) {
            for (CubeInfoKey cubeInfoKey2 : list) {
                ExtCRDInfo extCRDInfo2 = (ExtCRDInfo)this.CRD_CONFIG_MAP(cubeInfoKey2);
                if (extCRDInfo2 == null) continue;
                extCRDInfo = extCRDInfo2;
                cubeInfoKey = cubeInfoKey2;
                break;
            }
        }
        if (extCRDInfo == null) {
            ServiceLogger.trace("CRDManager: queryCubeInfo: failed! cube not existed. (catKey=%s, ds=%s, query=%s, bv=%s)", catalogKey, string, string2, string3);
            return null;
        }
        ServiceLogger.trace("CRDManager: queryCubeInfo. [\ncatKey=%s, ds=%s, query=%s, bv=%s\ncrdInfo=%s]", catalogKey, string, string2, string3, extCRDInfo);
        if (extCRDInfo.getCatalogVersion() != catalogKey.getVersionNumber() || catalogKey.getLastModified() != extCRDInfo.getCatalogLastModified().getTime()) {
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.trace("CRDManager: queryCubeInfo: failed! catalog version not equals. [cubeCatalogVersion=%s, cubeCatalogLastModified=%s][queryCatalogVersion=%s, queryCatalogLastModified=%s]", extCRDInfo.getCatalogVersion(), extCRDInfo.getCatalogLastModified().getTime(), catalogKey.getVersionNumber(), catalogKey.getLastModified());
            }
            return null;
        }
        ServiceLogger.trace("CRDManager: queryCubeInfo: success, [catKey=%s, ds=%s, query=%s, bv=%s, crdInfo=%s]", catalogKey, string, string2, string3, extCRDInfo);
        return extCRDInfo;
    }

    private ExtCRDInfo getAbsolutePath(QueryInformation queryInformation) {
        Object object2;
        ServiceLogger.trace("CRDManager: queryCRDInfo...(queryInfo=%s)", queryInformation);
        List list = this.getActivityType(queryInformation);
        ExtCRDInfo extCRDInfo = null;
        CRDInfoKey cRDInfoKey = null;
        if (list != null) {
            for (Object object2 : list) {
                ExtCRDInfo extCRDInfo2 = (ExtCRDInfo)this.CRD_CONFIG_MAP((CRDInfoKey)object2);
                if (extCRDInfo2 == null) continue;
                extCRDInfo = extCRDInfo2;
                cRDInfoKey = object2;
                break;
            }
        }
        if (extCRDInfo == null) {
            ServiceLogger.trace("CRDManager: queryCRDInfo: failed! CRD not existed. [queryInfo=%s]", queryInformation);
            return null;
        }
        ServiceLogger.trace("CRDManager: queryCRDInfo. [\nqueryInfo=%s\ncrdInfo=%s]", queryInformation, extCRDInfo);
        if (extCRDInfo.getCatalogVersion() != queryInformation.getCatalogVersionNumber() || queryInformation.getCatalogLastModified() != extCRDInfo.getCatalogLastModified().getTime()) {
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.trace("CRDManager: queryCRDInfo: failed! catalog version not equals. [crdCatalogVersion=%s, crdCatalogLastModified=%s][queryCatalogVersion=%s, queryCatalogLastModified=%s]", extCRDInfo.getCatalogVersion(), extCRDInfo.getCatalogLastModified().getTime(), queryInformation.getCatalogVersionNumber(), queryInformation.getCatalogLastModified());
            }
            return null;
        }
        Map map = this.get(extCRDInfo);
        if (!this.copy(map, (Map)(object2 = queryInformation.getParamValues()))) {
            ServiceLogger.trace("CRDManager: queryCRDInfo: failed! param values not equals. [crdParamValues=%s, queryParamValues=%s]", map, object2);
            return null;
        }
        boolean bl = extCRDInfo.runtimeConnInfoEquals(queryInformation);
        ServiceLogger.trace("CRDManager: queryCRDInfo: success? %s [queryInfo=%s, crdInfo=%s]", bl, queryInformation, extCRDInfo);
        return bl ? extCRDInfo : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transCRDToCube() throws RemoteException, CRDManageException {
        ServiceLogger.trace("CRDManager: transCRDToCube...", new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        CRDInfoDAO cRDInfoDAO = CRDInfoDAO.getInstance();
        Connection connection = null;
        try {
            connection = cRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            List list = cRDInfoDAO.listAll(connection);
            double d = 0.0;
            for (CRDInfoModel cRDInfoModel : list) {
                int n = cRDInfoModel.getCacheType();
                if (cRDInfoModel.getBvName() != null || n != 2 && n != 3) continue;
                String string = cRDInfoModel.getCatalogPath();
                String string2 = cRDInfoModel.getDataSource();
                String string3 = cRDInfoModel.getQueryName();
                int n2 = cRDInfoModel.getCatalogVersion();
                String string4 = cRDInfoModel.getLoginUser();
                String string5 = null;
                JetUUniverse jetUUniverse = null;
                try {
                    Object object2;
                    JRCatalogInfo jRCatalogInfo = (JRCatalogInfo)this.AUTO_CACHE_RESULT_USABLED_MAP.getCatalogInfo(string4, string, n2);
                    jetUUniverse = jRCatalogInfo.getUniverse();
                    JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string2);
                    Vector vector = jetUDatabase.getBvs();
                    for (Object object2 : vector) {
                        if (!object2.getQuery().getResourceName().equals(string3)) continue;
                        string5 = object2.getDisplayName();
                    }
                    CubeInfoKey cubeInfoKey = new CubeInfoKey(string, string2, cRDInfoModel.getQueryType(), string3, string5);
                    object2 = cRDInfoModel.getId() + ".cfg";
                    HashMap hashMap = new HashMap();
                    this.delete(cubeInfoKey, this.CreateParseParametersForQuery + this.getCRDCacheDir() + (String)object2, hashMap);
                    Properties properties = new Properties();
                    for (String string6 : hashMap.keySet()) {
                        if (string6.startsWith("jrs.param.runtime$")) {
                            properties.put("jrs.param$" + string6.substring("jrs.param.runtime$".length()), hashMap.get(string6));
                            continue;
                        }
                        properties.put(string6, ((String[])hashMap.get(string6))[0]);
                    }
                    double d2 = 10.0;
                    try {
                        d2 = CRDResultToolkit.calculateCubeMemorySize(cubeInfoKey, jetUUniverse, properties, "JReport_System_User", true);
                        d2 /= 1048576.0;
                        d2 = new BigDecimal(d2).setScale(1).doubleValue();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    ((JRSchedulingServiceQuartzImpl)this.AUTO_CACHE_RESULT_USABLED_MAP.getSchedulingService()).transCRDToCubeTask(cRDInfoModel.getTaskId(), string5, n, d2);
                    cRDInfoModel.setBvName(string5);
                    cRDInfoModel.setMaxMemory(d2);
                    cRDInfoModel.setStatus((short)0);
                    d += d2;
                    String string7 = this.generateCRDResult(cRDInfoModel);
                    this.available.delete(Storage.StorageRoot.CRD_CACHE, (string7 + "_BV.rst").replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), ""));
                    if (n == 3) {
                        this.available.delete(Storage.StorageRoot.CRD_CACHE, (string7 + ".rst").replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), ""));
                    }
                    cRDInfoModel.setResultVersion(0);
                    cRDInfoDAO.update(connection, cRDInfoModel);
                    arrayList.add(string5);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                finally {
                    if (jetUUniverse == null) continue;
                    jetUUniverse.free();
                    jetUUniverse = null;
                }
            }
            connection.commit();
            this.AUTO_CACHE_RESULT_USABLED_MAP.getAdminService().getConfigService().getConfigurationCache().setMaxCubeMemory(d);
        }
        catch (SQLException sQLException) {
            ServiceLogger.trace("CRDManager: transCRDToCube: failed! %s", sQLException);
            ServiceLogger.logError(sQLException);
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                ServiceLogger.logError(sQLException2, 2);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
            }
        }
        ServiceLogger.trace("CRDManager: transCRDToCube: end, transfer cubes: %s!", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverCRDs() throws RemoteException, CRDManageException {
        ServiceLogger.trace("CRDManager: recoverCRDs...", new Object[0]);
        CRDInfoDAO cRDInfoDAO = CRDInfoDAO.getInstance();
        CRDRunDetailDAO cRDRunDetailDAO = CRDRunDetailDAO.getInstance();
        Connection connection = null;
        try {
            connection = cRDInfoDAO.getConnection();
            List list = cRDInfoDAO.listAll(connection);
            HashMap hashMap = cRDRunDetailDAO.listAll(connection);
            for (CRDInfoModel cRDInfoModel : list) {
                try {
                    Object object2;
                    Cloneable cloneable;
                    ExtCRDInfo extCRDInfo = this.charAt(cRDInfoModel);
                    if (extCRDInfo == null) continue;
                    ArrayList arrayList = (ArrayList)hashMap.get(extCRDInfo.getId());
                    if (arrayList != null) {
                        cloneable = new Vector<CRDRunDetail>();
                        for (Object object2 : arrayList) {
                            cloneable.add(this.cancelInit(extCRDInfo.getCRDKey(), (CRDRunDetailModel)object2));
                        }
                        extCRDInfo.setRunDetails((Vector)cloneable);
                    }
                    this.addRunDetail(extCRDInfo);
                    this.addListener(extCRDInfo);
                    this.close(extCRDInfo.getCRDKey());
                    this.commit(extCRDInfo.getCRDKey());
                    cloneable = this.getBytes(extCRDInfo);
                    Map map = this.createNewFile(extCRDInfo.getCRDKey());
                    object2 = new HashMap();
                    if (map != null) {
                        for (String string : map.keySet()) {
                            String string2 = ((String[])map.get(string))[0];
                            Properties properties = CSUtil.parseQuery(string2);
                            object2.put(string, properties);
                            properties.remove("jrs.db_date_format");
                            properties.remove("jrs.db_datetime_format");
                            properties.remove("jrs.db_extra_characters");
                            properties.remove("jrs.db_quote_character");
                            properties.remove("jrs.db_transaction_readonly");
                            properties.remove("jrs.db_refresh_support_info");
                            properties.remove("jrs.db_time_format");
                            properties.remove("jrs.db_transaction_mode");
                            properties.remove("jrs.db_char_to_be_replaced");
                            properties.remove("jrs.db_char_replaced_by");
                        }
                    }
                    if (!this.contains((Map)object2, (Map)((Object)cloneable))) {
                        this.updateCRDResult(extCRDInfo.getCRDKey());
                        continue;
                    }
                    extCRDInfo.running();
                    Object object3 = this.equalsIgnoreCase(extCRDInfo);
                    synchronized (object3) {
                        try {
                            if (this.recoverCRDResult(extCRDInfo)) {
                                extCRDInfo.ready();
                            } else if (cRDInfoModel.getStatus() == 1) {
                                extCRDInfo.setStatus((short)5);
                            }
                        }
                        catch (CRDManageException cRDManageException) {
                            ServiceLogger.logError((Throwable)((Object)cRDManageException));
                            extCRDInfo.notReady();
                        }
                        catch (RemoteException remoteException) {
                            ServiceLogger.logError(remoteException);
                            extCRDInfo.notReady();
                        }
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.trace("CRDManager: recoverCRDs: failed! %s", sQLException);
            ServiceLogger.logError(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
            }
        }
        ServiceLogger.trace("CRDManager: recoverCRDs: end!", new Object[0]);
    }

    @Override
    public boolean updateCRDResult(CRDInfoKey cRDInfoKey) throws CRDManageException, RemoteException {
        ServiceLogger.trace("CRDManager: updateCRDResult...(crdInfoKey=%s)", cRDInfoKey);
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        if (extCRDInfo == null) {
            ServiceLogger.trace("CRDManager: updateCRDResult: failed! CRD is not existed.[crdInfoKey=%s]", cRDInfoKey);
            throw new CRDManageException("CRD is not existed");
        }
        if (cRDInfoKey instanceof CubeInfoKey && extCRDInfo.getStatus() == 5) {
            ServiceLogger.logDebug("CRDManager: updateCRDResult... disabled CRD, do nothing!");
            return false;
        }
        if (extCRDInfo.isLazy()) {
            if (extCRDInfo.getResultVersion() <= 0) {
                extCRDInfo.setResultVersion(1);
                ServiceLogger.trace("CRDManager: updateCRDResult: failed! CRD result version is 0.[crdInfoKey=%s]", cRDInfoKey);
                return false;
            }
            this.getAutoCacheExpired(cRDInfoKey);
            extCRDInfo.running();
            ServiceLogger.trace("CRDManager: updateCRDResult: failed! CRD is running.[crdInfoKey=%s]", cRDInfoKey);
            return false;
        }
        boolean bl = this.getActiveRealm(cRDInfoKey);
        ServiceLogger.trace("CRDManager: updateCRDResult: success? %s [crdInfoKey=%s]", bl, cRDInfoKey);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getActiveRealm(CRDInfoKey cRDInfoKey) throws CRDManageException, RemoteException {
        ServiceLogger.trace("CRDManager: updateCRDResultWithoutLazy...(crdInfoKey=%s)", cRDInfoKey);
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        if (extCRDInfo == null) {
            ServiceLogger.trace("CRDManager: updateCRDResultWithoutLazy: failed! CRD is not existed.[crdInfoKey=%s]", cRDInfoKey);
            throw new CRDManageException("CRD is not existed");
        }
        ExtCompletedCRDInfo extCompletedCRDInfo = new ExtCompletedCRDInfo(extCRDInfo);
        long l = System.currentTimeMillis();
        extCompletedCRDInfo.setStartTime(new Date(l));
        short s = 2;
        if (extCRDInfo.getRunTimes() == 0) {
            s = 1;
            extCompletedCRDInfo.setActivityType((short)3);
        } else {
            extCompletedCRDInfo.setActivityType((short)4);
        }
        extCRDInfo.running();
        Object object = this.equalsIgnoreCase(extCRDInfo);
        synchronized (object) {
            boolean bl = true;
            if (this.updateCRDResult(extCRDInfo, extCompletedCRDInfo)) {
                extCompletedCRDInfo.setSuccess(true);
                extCRDInfo.ready();
                ServiceLogger.trace("CRDManager: updateCRDResultWithoutLazy: success! CRD is ready [crdInfoKey=%s]", cRDInfoKey);
            } else {
                bl = false;
                extCompletedCRDInfo.setSuccess(false);
                extCRDInfo.notReady();
                ServiceLogger.trace("CRDManager: updateCRDResultWithoutLazy: failed! CRD not ready [crdInfoKey=%s]", cRDInfoKey);
            }
            CRDRunDetailModel cRDRunDetailModel = new CRDRunDetailModel();
            cRDRunDetailModel.setId(extCRDInfo.getId());
            cRDRunDetailModel.setActivity(s);
            cRDRunDetailModel.setStartTime(l);
            cRDRunDetailModel.setEndTime(System.currentTimeMillis());
            cRDRunDetailModel.setSucc(true);
            extCRDInfo.addRunDetail(this.cancelInit(extCRDInfo.getCRDKey(), cRDRunDetailModel));
            this.CRD_CACHE(extCRDInfo, false);
            extCompletedCRDInfo.setCompletedTime(new Date(cRDRunDetailModel.getEndTime()));
            ServiceLogger.trace("CRDManager: updateCRDResultWithoutLazy: insert completed crd record to DB. [crdInfoKey=%s]", cRDInfoKey);
            CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
            CRDRunDetailDAO cRDRunDetailDAO = CRDRunDetailDAO.getInstance();
            Connection connection = null;
            try {
                connection = completedCRDInfoDAO.getConnection();
                connection.setAutoCommit(false);
                CompletedCRDInfoModel completedCRDInfoModel = this.backupInfo(extCompletedCRDInfo);
                completedCRDInfoDAO.insert(connection, completedCRDInfoModel);
                cRDRunDetailDAO.update(connection, cRDRunDetailModel);
                connection.commit();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
                ServiceLogger.trace("CRDManager: updateCRDResultWithoutLazy: failed! %s [crdInfoKey=%s]", exception, cRDInfoKey);
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
                throw new CRDManageException(exception);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 2);
                    }
                }
            }
        }
        ServiceLogger.trace("CRDManager: updateCRDResultWithoutLazy: success! [crdInfoKey=%s]", cRDInfoKey);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void upgradeCRD(String string) throws CRDManageException, RemoteException {
        ServiceLogger.trace("CRDManager: upgradeCRD...(catalogPath=%s)", string);
        LinkedList<CRDInfoKey> linkedList = new LinkedList<CRDInfoKey>();
        CRDInfoDAO cRDInfoDAO = CRDInfoDAO.getInstance();
        Connection connection = null;
        try {
            void var7_14;
            connection = cRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            PathInfoImpl pathInfoImpl = (PathInfoImpl)this.CRD_RESULT_USABLED_MAP.getPathInfo("JReport_System_User", string);
            int n = pathInfoImpl.getID();
            if (n > 0) {
                List object2 = cRDInfoDAO.getByCatalog(connection, n);
            } else {
                List list = cRDInfoDAO.getByCatalog(connection, string);
            }
            ServiceLogger.trace("CRDManager: upgradeCRD: %s CRD will be updated. (catalogPath=%s, catalogVersion=%s)", var7_14 == null ? 0 : var7_14.size(), string, pathInfoImpl.getLatestVersionNumber());
            for (CRDInfoModel cRDInfoModel : var7_14) {
                cRDInfoModel.setCatalogLastModified(pathInfoImpl.getLastModified());
                cRDInfoModel.setCatalogVersion(pathInfoImpl.getLatestVersionNumber());
                cRDInfoModel.setLastModified(new Date().getTime());
                cRDInfoDAO.update(connection, cRDInfoModel);
                ExtCRDInfo extCRDInfo = this.charAt(cRDInfoModel);
                this.addListener(extCRDInfo);
                linkedList.add(extCRDInfo.getCRDKey());
            }
            connection.commit();
        }
        catch (Exception exception) {
            ServiceLogger.trace("CRDManager: upgradeCRD: failed! %s [catalogPath=%s]", exception, string);
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw new CRDManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
        int n = 0;
        for (CRDInfoKey cRDInfoKey : linkedList) {
            CRDResult cRDResult = this.getCRDResult(cRDInfoKey);
            if (cRDResult == null) continue;
            cRDResult.releaseDataResult();
            this.getAutoCacheExpired(cRDInfoKey);
            this.updateCRDResult(cRDInfoKey);
            ++n;
        }
        ServiceLogger.trace("CRDManager: upgradeCRD: success! update %s CRD result. [catalogPath=%s]", n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CRDResult getCRDResult(QueryInformation queryInformation) throws RemoteException {
        ServiceLogger.trace("CRDManager: queryCRDResult...(queryInfo=%s)", queryInformation);
        ExtCRDInfo extCRDInfo = this.getAbsolutePath(queryInformation);
        if (extCRDInfo == null) {
            ServiceLogger.trace("CRDManager: queryCRDResult: failed! CRD not existed. (queryInfo=%s)", queryInformation);
            return null;
        }
        CRDInfoKey cRDInfoKey = extCRDInfo.getCRDKey();
        if (cRDInfoKey == null) {
            ServiceLogger.trace("CRDManager: queryCRDResult: failed! (queryInfo=%s, crdKey=null)", queryInformation);
            return null;
        }
        if (extCRDInfo.isNotReady()) {
            ServiceLogger.trace("CRDManager: queryCRDResult: failed! CRD is not ready (queryInfo=%s, crdKey=%s)", queryInformation, cRDInfoKey);
            return null;
        }
        if (extCRDInfo.isReady()) {
            CRDResult cRDResult = this.getCRDResult(cRDInfoKey);
            ServiceLogger.trace("CRDManager: queryCRDResult: success! CRD is ready (queryInfo=%s, crdKey=%s)", queryInformation, cRDInfoKey);
            return cRDResult;
        }
        ServiceLogger.trace("CRDManager: queryCRDResult: CRD is running (queryInfo=%s, crdKey=%s)", queryInformation, cRDInfoKey);
        Object object = this.equalsIgnoreCase(extCRDInfo);
        synchronized (object) {
            CRDResult cRDResult = this.getCRDResult(cRDInfoKey);
            ServiceLogger.trace("CRDManager: queryCRDResult: success? %s [queryInfo=%s, crdKey=%s)", cRDResult != null, queryInformation, cRDInfoKey);
            return cRDResult;
        }
    }

    private Map convert(Properties properties) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        if (properties == null) {
            return hashMap;
        }
        for (String string : properties.keySet()) {
            String string2 = (String)properties.get(string);
            hashMap.put(string, new String[]{string2});
        }
        return hashMap;
    }

    private List getActivity(String string, String string2, String string3, String string4) {
        ArrayList<CubeInfoKey> arrayList = new ArrayList<CubeInfoKey>(5);
        arrayList.add(new CubeInfoKey(string, string2, 5, string3, string4));
        arrayList.add(new CubeInfoKey(string, string2, 3, string3, string4));
        arrayList.add(new CubeInfoKey(string, string2, 1, string3, string4));
        arrayList.add(new CubeInfoKey(string, string2, 2, string3, string4));
        arrayList.add(new CubeInfoKey(string, string2, 4, string3, string4));
        return arrayList;
    }

    private List getActivityType(QueryInformation queryInformation) {
        if (queryInformation == null) {
            return null;
        }
        String string = queryInformation.getCatalogPath();
        String string2 = queryInformation.getDataSource();
        String string3 = queryInformation.getName();
        ArrayList<CRDInfoKey> arrayList = new ArrayList<CRDInfoKey>();
        if (queryInformation.getType() == 2) {
            arrayList.add(new CRDInfoKey(string, string2, 6, string3));
        } else if (queryInformation.isCube()) {
            arrayList.add(new CubeInfoKey(string, string2, 5, string3, queryInformation.getBVName()));
            arrayList.add(new CubeInfoKey(string, string2, 3, string3, queryInformation.getBVName()));
            arrayList.add(new CubeInfoKey(string, string2, 1, string3, queryInformation.getBVName()));
            arrayList.add(new CubeInfoKey(string, string2, 2, string3, queryInformation.getBVName()));
            arrayList.add(new CubeInfoKey(string, string2, 4, string3, queryInformation.getBVName()));
        } else {
            arrayList.add(new CRDInfoKey(string, string2, 5, string3));
            arrayList.add(new CRDInfoKey(string, string2, 3, string3));
            arrayList.add(new CRDInfoKey(string, string2, 1, string3));
            arrayList.add(new CRDInfoKey(string, string2, 2, string3));
            arrayList.add(new CRDInfoKey(string, string2, 4, string3));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAdminService(ExtCRDInfo extCRDInfo) {
        int n;
        Object object;
        Object object22;
        Object object3;
        JetUDatabase jetUDatabase;
        Object object4;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        String string = this.CRD_RESULT_USABLED_MAP(extCRDInfo);
        JetUConnection[] jetUConnectionArray = null;
        JetUUniverse jetUUniverse = null;
        try {
            object4 = (JRCatalogInfo)this.AUTO_CACHE_RESULT_USABLED_MAP.getCatalogInfo(string, extCRDInfo.getCatalogPath(), extCRDInfo.getCatalogVersion());
            jetUUniverse = ((JRCatalogInfo)object4).getUniverse();
            jetUDatabase = jetUUniverse.getDatabase(extCRDInfo.getDataSource());
            object3 = jetUDatabase.getQueriableByResourceName(extCRDInfo.getQueryName());
            jetUConnectionArray = object3.getConnections();
            for (JetUConnection jetUConnection : jetUConnectionArray) {
                if (!(jetUConnection instanceof JetUJDBCConnection)) continue;
                JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUConnection;
                object22 = jetUConnection.getResourceName();
                hashMap3.put((String)object22, jetUJDBCConnection.getUID());
                hashMap4.put((String)object22, jetUJDBCConnection.getPSWD());
                hashMap2.put((String)object22, jetUJDBCConnection.getURL());
            }
        }
        catch (JException jException) {
            ServiceLogger.logError(jException, 3);
        }
        catch (Exception exception) {
            ServiceLogger.trace("CRDManager: initRuntimeInfo...can't get catalogInfo(catalogPath=%s)", extCRDInfo.getCatalogPath());
        }
        finally {
            if (jetUUniverse != null) {
                jetUUniverse.free();
            }
        }
        object4 = this.createNewFile(extCRDInfo.getCRDKey());
        jetUDatabase = new HashMap();
        for (Object object22 : object4.keySet()) {
            object = ((String[])object4.get(object22))[0];
            jetUDatabase.put(object22, CSUtil.parseQuery((String)object));
        }
        object3 = this.getAllParametersWithChanging(extCRDInfo.getPasswords(), (Map)jetUDatabase, false, null, "jrs.ds_pswd");
        object22 = this.getAllParametersWithChanging(extCRDInfo.getUserNames(), (Map)jetUDatabase, false, null, "jrs.ds_user");
        object = new HashMap();
        HashMap<String, String> hashMap5 = new HashMap<String, String>();
        if (jetUConnectionArray != null) {
            for (JetUConnection jetUConnection : jetUConnectionArray) {
                String string2 = jetUConnection.getResourceName();
                Properties properties = (Properties)jetUDatabase.get(string2);
                if (properties == null) continue;
                String string3 = properties.getProperty("jrs.catalog_connection_type");
                if (string3.equals("jdbc")) {
                    object.put(string2, properties.getProperty("jrs.jdbc_url"));
                    if (!object3.containsKey(string2)) {
                        object3.put(string2, properties.getProperty("jrs.ds_pswd"));
                    }
                    if (object22.containsKey(string2)) continue;
                    object22.put(string2, properties.getProperty("jrs.ds_user"));
                    continue;
                }
                if (!string3.equals("jndi")) continue;
                hashMap5.put(string2, properties.getProperty("jrs.jndi_datasource"));
            }
        }
        int n2 = n = ServerUtil.mapContains(hashMap4, (Map<String, String>)object3) && ServerUtil.mapContains(hashMap3, (Map<String, String>)object22) && ServerUtil.mapContains(hashMap2, (Map<String, String>)object) && ServerUtil.mapContains(hashMap, hashMap5) ? 1 : 0;
        if (n != 0) {
            extCRDInfo.setRuntimePasswords(new HashMap());
            extCRDInfo.setRuntimeUserNames(new HashMap());
            extCRDInfo.setRuntimeJdbcUrls(new HashMap());
            extCRDInfo.setRuntimeJndiNames(new HashMap());
        } else {
            extCRDInfo.setRuntimePasswords((Map)object3);
            extCRDInfo.setRuntimeUserNames((Map)object22);
            extCRDInfo.setRuntimeJdbcUrls((Map)object);
            extCRDInfo.setRuntimeJndiNames(hashMap5);
        }
        extCRDInfo.setConnInfoMap((Map)jetUDatabase);
        Map map = this.decreaseUsingReport(extCRDInfo.getCRDKey(), "jrs.param.runtime$");
        extCRDInfo.setRuntimeParamValues(map);
    }

    private Map getAllParametersWithChanging(Map map, Map map2, boolean bl, String string, String string2) {
        if (map == null) {
            return new HashMap();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(map.keySet());
        for (Object object : map2.keySet()) {
            if (arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        HashMap hashMap = new HashMap();
        for (String string3 : arrayList) {
            Properties properties;
            String string4 = (String)map.get(string3);
            String string5 = string4 = string4 == null ? "" : string4;
            if (string4.equals("") && (properties = (Properties)map2.get(string3)) != null) {
                String string6 = properties.getProperty("jrs.catalog_connection_type");
                if (!bl || string6.equalsIgnoreCase(string)) {
                    string4 = (String)properties.get(string2);
                }
            }
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    @Override
    public void deleteCRDResult(CRDInfoKey cRDInfoKey) throws RemoteException, CRDManageException {
        this.getAutoCacheDir(cRDInfoKey, false);
    }

    private void getAutoCacheDir(CRDInfoKey cRDInfoKey, boolean bl) throws RemoteException, CRDManageException {
        this.getAutoCacheExpired(cRDInfoKey);
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey);
        if (cRDInfoKey instanceof CubeInfoKey && bl) {
            extCRDInfo.setStatus((short)5);
        }
        if (extCRDInfo.getResultVersion() > 0) {
            extCRDInfo.setResultVersion(0);
            this.CRD_CACHE(extCRDInfo, false);
            ServiceLogger.trace("CRDManager: deleteCRDResult: reset result version to 0(crdKey=%s)", cRDInfoKey);
        } else if (cRDInfoKey instanceof CubeInfoKey && bl) {
            this.CRD_CACHE(extCRDInfo, false);
        }
    }

    private void getAutoCacheExpired(CRDInfoKey cRDInfoKey) throws RemoteException, CRDManageException {
        ServiceLogger.trace("CRDManager: _deleteCRDResult...(crdKey=%s)", cRDInfoKey);
        CRDSimpleResult cRDSimpleResult = (CRDSimpleResult)this.allocateForce.remove(cRDInfoKey);
        this.getBVName(cRDSimpleResult);
        ServiceLogger.trace("CRDManager: _deleteCRDResult: result is %s [crdKey=%s]", cRDSimpleResult == null ? "null" : (cRDSimpleResult.isExpired() ? "expired" : "normal"), cRDInfoKey);
    }

    private CRDSimpleResult getAutoCacheResult(CRDInfoKey cRDInfoKey) throws RemoteException {
        ExtCRDInfo extCRDInfo;
        ServiceLogger.trace("CRDManager: checkCRDResult...(crdKey=%s)", cRDInfoKey);
        CRDSimpleResult cRDSimpleResult = (CRDSimpleResult)this.allocateForce.get(cRDInfoKey);
        if ((cRDSimpleResult == null || cRDSimpleResult.isExpired()) && (extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cRDInfoKey)) != null && extCRDInfo.isLazy() && extCRDInfo.getResultVersion() > 0) {
            try {
                this.getActiveRealm(cRDInfoKey);
                cRDSimpleResult = (CRDSimpleResult)this.allocateForce.get(cRDInfoKey);
            }
            catch (CRDManageException cRDManageException) {
                ServiceLogger.trace("CRDManager: checkCRDResult: update lazy CRD result failed! [crdKey=%s, e=%s]", new Object[]{cRDInfoKey, cRDManageException});
                return null;
            }
        }
        if (cRDSimpleResult != null && cRDSimpleResult.isExpired()) {
            ServiceLogger.trace("CRDManager: checkCRDResult: result existed but expired.[crdKey=%s]", cRDInfoKey);
            return null;
        }
        ServiceLogger.trace("CRDManager: checkCRDResult: result existed? %s [crdKey=%s]", cRDSimpleResult != null, cRDInfoKey);
        return cRDSimpleResult;
    }

    @Override
    public CRDResult getCRDResult(CRDInfoKey cRDInfoKey) throws RemoteException {
        CRDSimpleResult cRDSimpleResult = this.getAutoCacheResult(cRDInfoKey);
        if (cRDSimpleResult != null) {
            cRDSimpleResult.increaseRefrenced();
        }
        return cRDSimpleResult;
    }

    @Override
    public boolean isExpired(CRDResultKey cRDResultKey) throws RemoteException, CRDManageException {
        ServiceLogger.trace("CRDManager: isExpired... (resultKey=%s)", cRDResultKey);
        CRDInfoKey cRDInfoKey = cRDResultKey.getCRDKey();
        CRDSimpleResult cRDSimpleResult = (CRDSimpleResult)this.allocateForce.get(cRDInfoKey);
        if (cRDSimpleResult != null) {
            boolean bl = cRDSimpleResult.isExpired();
            ServiceLogger.trace("CRDManager: isExpired: CRD result is expired? %s [resultKey=%s]", bl, cRDResultKey);
            return bl;
        }
        ServiceLogger.trace("CRDManager: isExpired: CRD result is expired. [resultKey=%s]", cRDResultKey);
        return true;
    }

    public boolean recoverCRDResult(ExtCRDInfo extCRDInfo) throws RemoteException, CRDManageException {
        if (extCRDInfo.getResultVersion() <= 0 || extCRDInfo.isLazy()) {
            extCRDInfo.notReady();
            ServiceLogger.trace("CRDManager: recoverCRDResult: don't recover it(crdInfo=%s)", extCRDInfo);
            return false;
        }
        ServiceLogger.trace("CRDManager: recoverCRDResult... (crdInfo=%s)", extCRDInfo);
        CRDResultKey cRDResultKey = new CRDResultKey(extCRDInfo.getCRDKey(), extCRDInfo.getResultVersion());
        int n = extCRDInfo.getQueryType();
        n = n == 6 ? 2 : 1;
        CRDSimpleResult cRDSimpleResult = new CRDSimpleResult(cRDResultKey, n);
        try {
            this.getAutoConfigFile(extCRDInfo, cRDSimpleResult);
            this.getAdminService(extCRDInfo);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExtCompletedCRDInfo extCompletedCRDInfo = new ExtCompletedCRDInfo(extCRDInfo);
            this.updateCRDResult(extCRDInfo, extCompletedCRDInfo);
            this.CRD_CACHE(extCRDInfo, false);
        }
        ServiceLogger.trace("CRDManager: recoverCRDResult: end. [crdInfo=%s]", extCRDInfo);
        return true;
    }

    private void getAutoCacheResultFile(ExtCRDInfo extCRDInfo) {
        try {
            Object object2;
            List list = this.CreateParseParametersForQuery(extCRDInfo.getCRDKey());
            ServiceLogger.trace("CRDManager: evalRuntimeParamValues: paramInfos.size is %s [crdInfo=%s]", list == null ? 0 : list.size(), extCRDInfo);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list != null) {
                for (Object object2 : list) {
                    hashMap.put(object2.getName().toUpperCase(), object2);
                }
            }
            Map<String, String[]> map = extCRDInfo.getParamValues();
            object2 = new HashMap();
            if (map != null) {
                Iterator iterator = map.keySet().iterator();
                Locale locale = Locale.getDefault();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    JRParamInfo jRParamInfo = (JRParamInfo)hashMap.get(string.toUpperCase());
                    ParamDesc paramDesc = jRParamInfo.getParamDesc();
                    String[] stringArray = null;
                    if (paramDesc.isMultipleValue()) {
                        String[] stringArray2;
                        if (paramDesc.isAllSelected()) {
                            String[] stringArray3 = new String[1];
                            stringArray2 = stringArray3;
                            stringArray3[0] = "\u0007";
                        } else {
                            stringArray2 = paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), locale);
                        }
                        stringArray = stringArray2;
                    } else {
                        stringArray = new String[]{paramDesc.getDisplayValue(paramDesc.getValue(), locale)};
                    }
                    ServiceLogger.trace("CRDManager: evalRuntimeParamValues: runtimeParamValues.put %s=%s [crdInfo=%s]", string, stringArray, extCRDInfo);
                    object2.put(string, stringArray);
                }
            }
            ServiceLogger.trace("CRDManager: evalRuntimeParamValues: runtimeParamValues.size is %s [crdInfo=%s, runtimeParamValues=%s]", object2 == null ? 0 : object2.size(), extCRDInfo, StringUtil.toString((Map)object2));
            extCRDInfo.setRuntimeParamValues((Map)object2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            ServiceLogger.trace("CRDManager: evalRuntimeParamValues: failed! %s [crdInfo=%s]", exception, extCRDInfo);
        }
    }

    private Throwable getAutoCacheSize(Exception exception) {
        Throwable throwable;
        Exception exception2 = throwable = exception;
        while ((throwable = throwable.getCause()) != null) {
            exception2 = throwable;
        }
        return exception2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateCRDResult(ExtCRDInfo extCRDInfo, ExtCompletedCRDInfo extCompletedCRDInfo) throws RemoteException, CRDManageException {
        File file;
        Object object;
        ServiceLogger.trace("CRDManager: updateCRDResult... (crdInfo=%s)", extCRDInfo);
        this.getAdminService(extCRDInfo);
        CRDSimpleResult cRDSimpleResult = (CRDSimpleResult)this.allocateForce.remove(extCRDInfo.getCRDKey());
        if (cRDSimpleResult != null) {
            this.getBVName(cRDSimpleResult);
        }
        extCRDInfo.nextResultVersion();
        cRDSimpleResult = null;
        try {
            this.getAutoCacheResultFile(extCRDInfo);
            cRDSimpleResult = CRDResultToolkit.generateCRDResult(this, this.CACHE_DIR_NAME(extCRDInfo.getCatalogPath()), extCRDInfo);
        }
        catch (DSException dSException) {
            int n;
            extCompletedCRDInfo.setMessage(dSException.getMessage());
            ServiceLogger.logError(dSException);
            object = this.getAutoCacheSize((Exception)((Object)dSException));
            if (object instanceof DSException && (n = ((DSException)((Object)object)).getErrorKey()) == 113001) {
                extCompletedCRDInfo.setMessage(JSvrResource.getMessage("CUBE_ERR_1_NO_MEMORY"));
            }
        }
        catch (Exception exception) {
            extCompletedCRDInfo.setMessage(exception.getMessage());
            ServiceLogger.logError(exception);
        }
        if (cRDSimpleResult == null) {
            try {
                this.getAutoCacheDir(extCRDInfo.getCRDKey(), true);
            }
            catch (CRDManageException cRDManageException) {
                ServiceLogger.logError((Throwable)((Object)cRDManageException));
            }
            ServiceLogger.trace("CRDManager: updateCRDResult: failed! result is null [crdInfo=%s]", extCRDInfo);
            return false;
        }
        String string = "";
        if (cRDSimpleResult.getStream() != null) {
            object = this.fileUpdated(extCRDInfo);
            string = string + "[" + (String)object + "]";
            String string2 = this.CreateParseParametersForQuery + (String)object;
            file = new File(string2);
            try {
                IOUtil.copy(cRDSimpleResult.getStream(), file);
                cRDSimpleResult.setDataResult(null);
                this.EXT_CRD_INFO_MAP(extCRDInfo.getCatalogPath()).getDiskStore().fileUpdated(file);
                this.available.add(Storage.StorageRoot.CRD_CACHE, ((String)object).replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), ""), file);
            }
            catch (Throwable throwable) {
                ServiceLogger.trace("CRDManager: updateCRDResult: failed! %s [crdInfo=%s, resultFile=%s]", throwable, extCRDInfo, object);
                ServiceLogger.logError(throwable, 2);
                this.EXT_CRD_INFO_MAP(extCRDInfo.getCatalogPath()).getDiskStore().delete(file);
                boolean bl = false;
                return bl;
            }
            finally {
                cRDSimpleResult.setStream(null);
            }
        }
        if (cRDSimpleResult.getBVStream() != null) {
            object = this.free(extCRDInfo);
            string = string + "[" + (String)object + "]";
            String string3 = this.CreateParseParametersForQuery + (String)object;
            file = new File(string3);
            try {
                IOUtil.copy(cRDSimpleResult.getBVStream(), file);
                this.EXT_CRD_INFO_MAP(extCRDInfo.getCatalogPath()).getDiskStore().fileUpdated(file);
                this.available.add(Storage.StorageRoot.CRD_CACHE, ((String)object).replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), ""), file);
            }
            catch (Throwable throwable) {
                ServiceLogger.trace("CRDManager: updateCRDResult: failed! %s [crdInfo=%s, resultFile=%s]", throwable, extCRDInfo, object);
                ServiceLogger.logError(throwable, 2);
                this.EXT_CRD_INFO_MAP(extCRDInfo.getCatalogPath()).getDiskStore().delete(file);
                boolean bl = false;
                return bl;
            }
            finally {
                cRDSimpleResult.setBVStream(null);
            }
            if (cRDSimpleResult.getBVSwapFile() != null) {
                String string4 = string3.substring(0, string3.length() - 4) + ".swap";
                File file2 = new File(string4);
                File file3 = new File(cRDSimpleResult.getBVSwapFile());
                try {
                    IOUtil.copy(file3, file2);
                    String string5 = ((String)object).substring(0, ((String)object).length() - 4) + ".swap";
                    cRDSimpleResult.setBVSwapFileToCube(string4);
                    this.EXT_CRD_INFO_MAP(extCRDInfo.getCatalogPath()).getDiskStore().fileUpdated(file);
                    this.available.add(Storage.StorageRoot.CRD_CACHE, string5.replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), ""), file2);
                }
                catch (Throwable throwable) {
                    ServiceLogger.trace("CRDManager: updateCRDResult: failed! %s [crdInfo=%s, resultSwapFile=%s]", throwable, extCRDInfo, string4);
                    ServiceLogger.logError(throwable, 2);
                    this.EXT_CRD_INFO_MAP(extCRDInfo.getCatalogPath()).getDiskStore().delete(file);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.EXT_CRD_INFO_MAP(extCRDInfo.getCatalogPath()).getDiskStore().delete(file3);
                }
            }
        }
        try {
            this.getAutoConfigFile(extCRDInfo, cRDSimpleResult);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.trace("CRDManager: updateCRDResult: recover CRD result failed! %s [crdInfo=%s, resultFile=%s]", fileNotFoundException, extCRDInfo, string);
            throw new CRDManageException(fileNotFoundException);
        }
        ServiceLogger.trace("CRDManager: updateCRDResult: success! [crdInfo=%s, resultFile=%s]", extCRDInfo, string);
        return true;
    }

    private void getAutoConfigFile(ExtCRDInfo extCRDInfo, CRDSimpleResult cRDSimpleResult) throws FileNotFoundException {
        ServiceLogger.trace("CRDManager: recoverCRDResult... (crdInfo=%s, result=%s)", extCRDInfo, cRDSimpleResult);
        int n = extCRDInfo.getCacheType();
        String string = this.fileUpdated(extCRDInfo);
        String string2 = this.CreateParseParametersForQuery + string;
        if (!(new File(string2).exists() || n != 3 && n != 1)) {
            ServiceLogger.trace("CRDManager: recoverCRDResult: failed! file not found [crdInfo=%s, resultFile=%s, cacheType=%s, homePath=%s]", extCRDInfo, string, n, this.CreateParseParametersForQuery);
            throw new FileNotFoundException(string2);
        }
        String string3 = this.free(extCRDInfo);
        String string4 = this.CreateParseParametersForQuery + string3;
        if (!(new File(string4).exists() || n != 3 && n != 2)) {
            ServiceLogger.trace("CRDManager: recoverCRDResult: failed! file not found [crdInfo=%s, BVresultFile=%s, cacheType=%s, homePath=%s]", extCRDInfo, string3, n, this.CreateParseParametersForQuery);
            throw new FileNotFoundException(string4);
        }
        CRDInfoKey cRDInfoKey = extCRDInfo.getCRDKey();
        cRDSimpleResult.setCRDCache(this.EXT_CRD_INFO_MAP(cRDInfoKey.getCatalogPath()).getMemoryStore().getCrdCache());
        if (string != null && (n == 3 || n == 1)) {
            cRDSimpleResult.setPersistFile(string);
        }
        if (string3 != null && (n == 3 || n == 2)) {
            cRDSimpleResult.setPersistBVFile(string3);
            extCRDInfo.setActualUsedMemory(cRDSimpleResult.getCubeActualMemorySize());
            double d = cRDSimpleResult.getCubeActualMemorySize() / 1024L / 1024L;
            if (extCRDInfo.getCanSwaptoDisk() && d > extCRDInfo.getMaxAllowMemory()) {
                extCRDInfo.setLocation((short)2);
            } else {
                extCRDInfo.setLocation((short)1);
            }
        }
        this.allocateForce.put(cRDInfoKey, cRDSimpleResult);
        ServiceLogger.trace("CRDManager: recoverCRDResult: success! [crdInfo=%s]", extCRDInfo);
    }

    private void getBVName(CRDSimpleResult cRDSimpleResult) {
        if (cRDSimpleResult != null) {
            cRDSimpleResult.setExpired(true);
        }
    }

    @Override
    public AutoCacheResult getAutoCacheResult(JAutoCacheKey jAutoCacheKey) throws RemoteException {
        ServiceLogger.trace("CRDManager: getAutoCacheResult... (queryKey=%s)", jAutoCacheKey);
        AutoCacheResult autoCacheResult = (AutoCacheResult)this.append.get(jAutoCacheKey);
        if (autoCacheResult == null) {
            ServiceLogger.trace("CRDManager: getAutoCacheResult: failed! result is %s [queryKey=%s]", "null", jAutoCacheKey);
            return null;
        }
        autoCacheResult.setExpired(this.getAutoCacheExpired());
        if (autoCacheResult.isExpired()) {
            this.append.remove(jAutoCacheKey);
            autoCacheResult.release();
            ServiceLogger.trace("CRDManager: getAutoCacheResult: failed! result is %s [queryKey=%s]", "expired", jAutoCacheKey);
            return null;
        }
        this.append.put(jAutoCacheKey, autoCacheResult);
        try {
            String string = autoCacheResult.getPersistFile().replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), "");
            File file = this.available.get(Storage.StorageRoot.CRD_CACHE, string);
            try {
                this.EXT_CRD_INFO_MAP(jAutoCacheKey.getCatalogKey().getPath()).getDiskStore().getCrdAutoCacheDiskStore().fileUpdated(file);
            }
            catch (OutOfSpaceException outOfSpaceException) {}
        }
        catch (Exception exception) {
            ServiceLogger.trace("CRDManager: getAutoCacheResult: failed! %s [queryKey=%s]", exception, jAutoCacheKey);
            ServiceLogger.logError(exception, 2);
            return null;
        }
        autoCacheResult.increaseRefrenced();
        ServiceLogger.trace("CRDManager: getAutoCacheResult: success! [queryKey=%s]", jAutoCacheKey);
        return autoCacheResult;
    }

    private void getBVStream(JAutoCacheKey jAutoCacheKey) {
        AutoCacheResult autoCacheResult = (AutoCacheResult)this.append.get(jAutoCacheKey);
        this.append.remove(jAutoCacheKey);
        autoCacheResult.release();
    }

    private boolean getBVSwapFile(JAutoCacheKey jAutoCacheKey, long l) {
        Object object;
        long l2 = this.getAutoCacheSize();
        Iterator iterator = this.append.keySet().iterator();
        LinkedList<JAutoCacheKey> linkedList = new LinkedList<JAutoCacheKey>();
        while (iterator.hasNext()) {
            object = (JAutoCacheKey)iterator.next();
            AutoCacheResult autoCacheResult2 = (AutoCacheResult)this.append.get(object);
            if (!autoCacheResult2.isExpired()) continue;
            linkedList.add((JAutoCacheKey)object);
        }
        for (JAutoCacheKey jAutoCacheKey2 : linkedList) {
            this.getBVStream(jAutoCacheKey2);
            ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: release expired auto cached result [expiredKey=%s]", jAutoCacheKey2);
        }
        if (l > l2) {
            ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: failed! Auto cache max disk limitation is %sB, current result is %sB", l2, l);
            return false;
        }
        object = CSUtil.parseVirtualResourcePath(jAutoCacheKey.getCatalogKey().getPath())[0];
        DiskStore diskStore = this.EXT_CRD_INFO_MAP(jAutoCacheKey.getCatalogKey().getPath()).getDiskStore().getCrdAutoCacheDiskStore();
        long l3 = diskStore.getSpaceAllocator().getUsedSpace();
        long l4 = l - diskStore.getSpaceAllocator().getFreeSpace();
        ServiceLogger.trace("CRDManager: releaseAutoCacheDisk. [maxDisk=%s, usageDisk=%s, currentResultSize=%s, needDisk=%s]", l2, l3, l, l4);
        if (l4 > 0L) {
            Comparable<File> comparable;
            Object object2;
            AutoCacheResult autoCacheResult;
            int n;
            iterator = this.append.keySet().iterator();
            LinkedList<JAutoCacheKey> linkedList2 = new LinkedList<JAutoCacheKey>();
            while (iterator.hasNext()) {
                JAutoCacheKey jAutoCacheKey3 = (JAutoCacheKey)iterator.next();
                if (!StringUtils.equals((String)object, CSUtil.parseVirtualResourcePath(jAutoCacheKey3.getCatalogKey().getPath())[0])) continue;
                AutoCacheResult autoCacheResult2 = (AutoCacheResult)this.append.get(jAutoCacheKey3);
                n = 0;
                for (int i = linkedList2.size() - 1; i >= 0; --i) {
                    autoCacheResult = (JAutoCacheKey)linkedList2.get(i);
                    object2 = (AutoCacheResult)this.append.get(autoCacheResult);
                    comparable = ((AutoCacheResult)object2).getRecentUsaged();
                    Date date = autoCacheResult2.getRecentUsaged();
                    if (((Date)comparable).getTime() <= date.getTime()) continue;
                    n = i + 1;
                    break;
                }
                ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: order result by recent usage time. orderIndex = %s [cachedResult=%s]", n, autoCacheResult2);
                if (n >= linkedList2.size()) {
                    linkedList2.add(jAutoCacheKey3);
                    continue;
                }
                linkedList2.add(n, jAutoCacheKey3);
            }
            long l5 = 0L;
            for (n = linkedList2.size() - 1; n >= 0; --n) {
                JAutoCacheKey jAutoCacheKey4 = (JAutoCacheKey)linkedList2.get(n);
                autoCacheResult = (AutoCacheResult)this.append.get(jAutoCacheKey4);
                object2 = this.CreateParseParametersForQuery + autoCacheResult.getPersistFile();
                comparable = new File((String)object2);
                if (!((File)comparable).exists()) {
                    ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: local file not existed! [sortedResult=%s]", autoCacheResult);
                    continue;
                }
                if (autoCacheResult.getRefrencedCount() > 0) {
                    ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: auto cached result be using, refrencedCount = %s [sortedResult=%s]", autoCacheResult.getRefrencedCount(), autoCacheResult);
                    continue;
                }
                autoCacheResult.setExpired(true);
                this.getBVStream(jAutoCacheKey4);
                ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: release the most recent not be used result [sortedResult=%s]", autoCacheResult);
                if ((l5 += autoCacheResult.getSize()) < l4) continue;
                ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: success! [releasedDisk=%s, needDisk=%s]", l5, l4);
                break;
            }
            if (l5 < l4) {
                ServiceLogger.trace("CRDManager: releaseAutoCacheDisk: failed! [releasedDisk=%s, needDisk=%s]", l5, l4);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean registerDataResult(JAutoCacheKey jAutoCacheKey, DataResult dataResult) throws RemoteException, DSException, IOException {
        block31: {
            OutputStream outputStream;
            InputStream inputStream;
            block30: {
                int n;
                block28: {
                    boolean bl;
                    block29: {
                        ServiceLogger.trace("CRDManager: registerDataResult...(queryKey=%s, result=%s)", jAutoCacheKey, dataResult);
                        inputStream = dataResult.getStream();
                        outputStream = null;
                        n = inputStream.available();
                        if (this.getBVSwapFile(jAutoCacheKey, n)) break block28;
                        bl = false;
                        if (inputStream == null) break block29;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                String string = this.getAutoCacheResultFile();
                ServiceLogger.trace("CRDManager: registerDataResult: make file. [queryKey=%s, resultFile=%s]", jAutoCacheKey, string);
                DiskStore diskStore = this.EXT_CRD_INFO_MAP(jAutoCacheKey.getCatalogKey().getPath()).getDiskStore().getCrdAutoCacheDiskStore();
                String string2 = this.CreateParseParametersForQuery + string;
                File file = new File(string2);
                try {
                    IOUtil.copy(inputStream, file);
                    diskStore.fileUpdated(file);
                    this.available.add(Storage.StorageRoot.CRD_CACHE, string.replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), ""), file);
                }
                catch (Exception exception) {
                    diskStore.delete(file);
                    throw exception;
                }
                AutoCacheResult autoCacheResult = new AutoCacheResult(jAutoCacheKey, this.getAutoCacheExpired(), dataResult.getType(), n);
                autoCacheResult.setPersistFile(string);
                autoCacheResult.setCRDCache(this.EXT_CRD_INFO_MAP(jAutoCacheKey.getCatalogKey().getPath()).getMemoryStore().getCrdCache());
                this.registerAutoCacheResult(jAutoCacheKey, autoCacheResult);
                ServiceLogger.trace("CRDManager: registerDataResult: success! [queryKey=%s]", jAutoCacheKey);
                if (inputStream == null) break block30;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            break block31;
            catch (Throwable throwable) {
                try {
                    ServiceLogger.trace("CRDManager: registerDataResult: failed! %s [queryKey=%s]", throwable, jAutoCacheKey);
                    ServiceLogger.logError(throwable, 2);
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void registerAutoCacheResult(JAutoCacheKey jAutoCacheKey, AutoCacheResult autoCacheResult) {
        this.append.put(jAutoCacheKey, autoCacheResult);
    }

    @Override
    public boolean isExpired(JAutoCacheKey jAutoCacheKey) throws RemoteException {
        AutoCacheResult autoCacheResult = (AutoCacheResult)this.append.get(jAutoCacheKey);
        if (autoCacheResult == null) {
            return true;
        }
        return autoCacheResult.isExpired();
    }

    public void quit() {
    }

    @Override
    public void deleteCompletedCRD(String string, int n) throws RemoteException, CRDManageException {
        this.getBvs(string);
        CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
        Connection connection = null;
        try {
            connection = completedCRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            CompletedCRDInfoModel completedCRDInfoModel = completedCRDInfoDAO.get(connection, n);
            if (completedCRDInfoModel == null) {
                throw new CRDManageException(600061, new Object[]{n}, null);
            }
            completedCRDInfoDAO.delete(connection, completedCRDInfoModel);
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw new CRDManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
    }

    @Override
    public void deleteCompletedCRD(String string, int[] nArray) throws RemoteException, CRDManageException {
        this.getBvs(string);
        CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
        Connection connection = null;
        try {
            connection = completedCRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            for (int n : nArray) {
                CompletedCRDInfoModel completedCRDInfoModel = completedCRDInfoDAO.get(connection, n);
                if (completedCRDInfoModel == null) {
                    throw new CRDManageException(600061, new Object[]{n}, null);
                }
                completedCRDInfoDAO.delete(connection, completedCRDInfoModel);
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            throw new CRDManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletedCRDInfo getCompletedCRD(String string, int n) throws RemoteException, CRDManageException {
        this.getBvs(string);
        CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
        Connection connection = null;
        try {
            connection = completedCRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            CompletedCRDInfoModel completedCRDInfoModel = completedCRDInfoDAO.get(connection, n);
            if (completedCRDInfoModel != null) {
                CompletedCRDInfo completedCRDInfo = this.clear(completedCRDInfoModel);
                return completedCRDInfo;
            }
            CompletedCRDInfo completedCRDInfo = null;
            return completedCRDInfo;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            CompletedCRDInfo completedCRDInfo = null;
            return completedCRDInfo;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
    }

    private void getBvName(String string, String string2) throws RptServerException, CRDManageException {
        this.getBvs(string);
        if (!StringUtils.equals(CSUtil.parsePrincipalDisplayName(string)[0], CSUtil.parseVirtualResourcePath(string2)[0])) {
            throw new CRDManageException("Forbidden Access another organization resource");
        }
        this.CRD_RESULT_USABLED_MAP.getPathInfo(string, string2);
    }

    private void getBvs(String string) throws CRDManageException {
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        if (securityService == null) {
            throw new CRDManageException(JSvrResource.getMessage("SVR_125"));
        }
        if (!(securityService.isAdminUser(string) || securityService.isOrganizationAdminUser(string) || string.equals("JReport_System_User"))) {
            throw new CRDManageException(JSvrResource.getMessage("SVR_125"));
        }
    }

    @Override
    public void disableCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException, RemoteException {
        ServiceLogger.trace("CRDManager: disable cube...(cubeKey=%s, loginUser=%s)", cubeInfoKey, string);
        long l = System.currentTimeMillis();
        CRDManageException cRDManageException = null;
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cubeInfoKey);
        try {
            this.getBvName(string, extCRDInfo.getCatalogPath());
            this.getAutoCacheDir(cubeInfoKey, true);
        }
        catch (RptServerException rptServerException) {
            cRDManageException = new CRDManageException((Exception)((Object)rptServerException));
        }
        catch (CRDManageException cRDManageException2) {
            cRDManageException = cRDManageException2;
        }
        this.getByCatalog(extCRDInfo, l, (short)5, cRDManageException == null, cRDManageException == null ? null : cRDManageException.getMessage());
        if (cRDManageException != null) {
            throw cRDManageException;
        }
        ServiceLogger.trace("CRDManager: disable cube... succss!! (cubeKey=%s, loginUser=%s)", cubeInfoKey, string);
    }

    @Override
    public void enableCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException, RemoteException {
        ServiceLogger.trace("CRDManager: enable cube...(cubeKey=%s, loginUser=%s)", cubeInfoKey, string);
        long l = System.currentTimeMillis();
        CRDManageException cRDManageException = null;
        ExtCRDInfo extCRDInfo = (ExtCRDInfo)this.CRD_CONFIG_MAP(cubeInfoKey);
        if (extCRDInfo.getStatus() != 5) {
            return;
        }
        try {
            this.SEDU(extCRDInfo);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            this.getByCatalog(extCRDInfo, l, (short)6, false, JSvrResource.getMessage("CUBE_ERR_1_NO_MEMORY"));
            ServiceLogger.trace("CRDManager: enable cube... failed!! (cubeKey=%s, loginUser=%s)", cubeInfoKey, string);
            return;
        }
        try {
            this.getBvName(string, extCRDInfo.getCatalogPath());
            extCRDInfo.setStatus((short)1);
            this.CRD_CACHE(extCRDInfo, false);
            Properties properties = this.AUTO_CACHE_RESULT_USABLED_MAP.getCubeTask(extCRDInfo.getTaskId());
            if (properties != null) {
                ((JRSchedulingServiceQuartzImpl)this.AUTO_CACHE_RESULT_USABLED_MAP.getSchedulingService()).runTaskAfterStartCube(properties);
            }
        }
        catch (RptServerException rptServerException) {
            cRDManageException = new CRDManageException((Exception)((Object)rptServerException));
        }
        catch (CRDManageException cRDManageException2) {
            cRDManageException = cRDManageException2;
        }
        this.getByCatalog(extCRDInfo, l, (short)6, cRDManageException == null, cRDManageException == null ? null : cRDManageException.getMessage());
        if (cRDManageException != null) {
            ServiceLogger.trace("CRDManager: enable cube... failed!! (cubeKey=%s, loginUser=%s)", cubeInfoKey, string);
            throw cRDManageException;
        }
        ServiceLogger.trace("CRDManager: enable cube... failed!! (cubeKey=%s, loginUser=%s)", cubeInfoKey, string);
    }

    private void getByCatalog(CubeInfo cubeInfo, long l, short s, boolean bl, String string) throws CRDManageException {
        ExtCompletedCRDInfo extCompletedCRDInfo = new ExtCompletedCRDInfo(cubeInfo);
        extCompletedCRDInfo.setStartTime(new Date(l));
        extCompletedCRDInfo.setCompletedTime(new Date());
        extCompletedCRDInfo.setActivityType(s);
        extCompletedCRDInfo.setSuccess(bl);
        extCompletedCRDInfo.setMessage(string);
        Connection connection = null;
        try {
            CompletedCRDInfoDAO completedCRDInfoDAO = CompletedCRDInfoDAO.getInstance();
            connection = completedCRDInfoDAO.getConnection();
            connection.setAutoCommit(false);
            CompletedCRDInfoModel completedCRDInfoModel = this.backupInfo(extCompletedCRDInfo);
            completedCRDInfoDAO.insert(connection, completedCRDInfoModel);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                ServiceLogger.logError(sQLException, 3);
            }
            throw new CRDManageException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
            }
        }
    }

    @Override
    public String startUsingCube(CatalogKey catalogKey, String string, String string2, String string3, String string4, int n, String string5, String string6) throws RemoteException {
        ExtCRDInfo extCRDInfo = this.getAbsoluteFile(catalogKey, string, string2, string3);
        String string7 = null;
        if (extCRDInfo != null) {
            string7 = extCRDInfo.increaseUsingReport(string4, n, string5, string6);
            this.addListener(extCRDInfo);
        }
        return string7;
    }

    @Override
    public void finishUsingCube(CatalogKey catalogKey, String string, String string2, String string3, String string4) throws RemoteException {
        ExtCRDInfo extCRDInfo = this.getAbsoluteFile(catalogKey, string, string2, string3);
        if (extCRDInfo != null) {
            extCRDInfo.decreaseUsingReport(string4);
            this.addListener(extCRDInfo);
        }
    }

    @Override
    public void afterRename(CatalogKey catalogKey, String string, String string2, String string3, String string4, String string5) throws RemoteException {
        ExtCRDInfo extCRDInfo = this.getAbsoluteFile(catalogKey, string, string2, string3);
        if (extCRDInfo != null) {
            extCRDInfo.usingReportRenamed(string4, string5);
            this.addListener(extCRDInfo);
        }
    }

    public ConnectionInfoProvider getConnProvider() {
        return this.SEDU;
    }

    private HashMap getBytes(CRDInfo cRDInfo) {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        try {
            JetUConnection[] jetUConnectionArray;
            PathInfoImpl pathInfoImpl = (PathInfoImpl)this.CRD_RESULT_USABLED_MAP.getPathInfo(this.CRD_RESULT_USABLED_MAP(cRDInfo), cRDInfo.getCatalogPath());
            JRCatalogInfo jRCatalogInfo = (JRCatalogInfo)this.AUTO_CACHE_RESULT_USABLED_MAP.getCatalogInfo(this.CRD_RESULT_USABLED_MAP(cRDInfo), cRDInfo.getCatalogPath(), pathInfoImpl.getLatestVersionNumber());
            JetUUniverse jetUUniverse = null;
            jetUUniverse = jRCatalogInfo.getUniverse();
            JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(cRDInfo.getDataSource(), cRDInfo.getQueryName());
            for (JetUConnection jetUConnection : jetUConnectionArray = jetUQueriable.getConnections()) {
                String string = jetUConnection.getResourceName();
                Properties properties = null;
                try {
                    properties = this.SEDU.getConnectionInfo(string);
                }
                catch (RemoteException remoteException) {
                    ServiceLogger.logError(remoteException, 3);
                }
                if (properties == null) continue;
                hashMap.put(string, properties);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return hashMap;
    }
}

