/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jet.server.JREntServer;
import jet.server.ServerEnv;
import jet.server.api.RptServer;
import jet.server.api.admin.ConnectionInformation;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.Member;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.jrc.JRReportMember;
import jet.server.jrc.JRTaskManager;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.JRWebPageOptions;
import jet.server.jrserver.monitor.JRUserSessionMonitor;
import jet.server.log.ServiceLogger;

public class JRRemoteMonitorService
implements RemoteMonitorService {
    private Hashtable SEDU = null;
    private int append = 0;
    private RptServer currentTimeMillis = null;
    private static final long serialVersionUID = -3839424265930975410L;

    public JRRemoteMonitorService(RptServer rptServer) throws RemoteException {
        this.currentTimeMillis = rptServer;
    }

    @Override
    public boolean isClusterEnable() throws RemoteException {
        return this.currentTimeMillis.isClusterEnable();
    }

    @Override
    public String getClusterName() throws RemoteException {
        if (this.isClusterEnable()) {
            return this.currentTimeMillis.getClusterService().getClusterName();
        }
        return null;
    }

    @Override
    public Member[] getPredefinedServers() throws RemoteException {
        try {
            return this.getClusteredServers();
        }
        catch (ClusterException clusterException) {
            throw new RemoteException(clusterException.getMessage(), (Throwable)((Object)clusterException));
        }
    }

    @Override
    public Member[] getClusteredServers() throws RemoteException, ClusterException {
        Member[] memberArray = null;
        if (this.isClusterEnable()) {
            memberArray = this.currentTimeMillis.getClusterService().getAllMembers();
        }
        if (memberArray == null) {
            memberArray = new Member[1];
            try {
                memberArray[0] = new JRReportMember(ServerEnv.getLocalRMIHost(), String.valueOf(ServerEnv.getActiveRMIPort()));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new RemoteException(exception.getMessage());
            }
        }
        return memberArray;
    }

    @Override
    public boolean isStarted(String string, int n) throws RemoteException {
        Member[] memberArray = null;
        try {
            if (this.isClusterEnable()) {
                memberArray = this.currentTimeMillis.getClusterService().getAllMembers();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (memberArray != null) {
            for (int i = 0; i < memberArray.length; ++i) {
                if (!memberArray[i].getHost().equals(string) || !memberArray[i].getPort().equals(String.valueOf(n))) continue;
                return true;
            }
        } else {
            try {
                String string2 = InetAddress.getLocalHost().getHostAddress();
                int n2 = ServerEnv.getActiveRMIPort();
                if (string.equals(string2) || string.equalsIgnoreCase("localhost") && n == n2) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isStarting() throws RemoteException {
        return true;
    }

    @Override
    public boolean isAdminUser(String string, String string2, String string3) throws RemoteException {
        return this.currentTimeMillis.getUserSessionManager().getAuthenticator().isValidAdminUser(string, string2, string3);
    }

    @Override
    public boolean isValidAdminUserEx(String string, String string2, String string3) throws RemoteException, InvalidUserException {
        return this.currentTimeMillis.getUserSessionManager().getAuthenticator().isValidAdminUserEx(string, string2, string3);
    }

    @Override
    public String getActiveRealm() throws RemoteException {
        return this.currentTimeMillis.getResourceManager().getRealm();
    }

    @Override
    public String getPassword(String string, String string2) throws RemoteException {
        try {
            return UserDataToolkit.getSecurityService(string).getIntegrityUser(string2).getPassword();
        }
        catch (NoSuchUserException noSuchUserException) {
            return null;
        }
    }

    private String SEDU() {
        return ServerEnv.getMonitorBindAddress() + "_" + ++this.append;
    }

    @Override
    public Properties[] getConnectionProperties() throws RemoteException {
        this.SEDU = new Hashtable();
        this.append = 0;
        String string = null;
        ConnectionInformation[] connectionInformationArray = this.currentTimeMillis.getAdminService().getConnectionPoolManager().getConnections();
        Properties[] propertiesArray = new Properties[connectionInformationArray != null ? connectionInformationArray.length : 0];
        for (int i = 0; i < connectionInformationArray.length; ++i) {
            string = this.SEDU();
            this.SEDU.put(string, connectionInformationArray[i]);
            propertiesArray[i] = new Properties();
            propertiesArray[i].put("id", string);
            propertiesArray[i].put("User", connectionInformationArray[i].getUser().length() == 0 ? " " : connectionInformationArray[i].getUser());
            propertiesArray[i].put("URL", connectionInformationArray[i].getUrl());
            propertiesArray[i].put("Expiring_Time", String.valueOf(connectionInformationArray[i].getExpire() / 1000));
            propertiesArray[i].put("Idle_Expiring_Time", String.valueOf(connectionInformationArray[i].getIdleExpire() / 1000));
            propertiesArray[i].put("Maximal_Connection_Count", String.valueOf(connectionInformationArray[i].getMaxCount()));
            propertiesArray[i].put("Maximal_Share_Count", String.valueOf(connectionInformationArray[i].getShare()));
            propertiesArray[i].put("Attempt", String.valueOf(connectionInformationArray[i].getAttempt()));
            propertiesArray[i].put("Interval", String.valueOf(connectionInformationArray[i].getInterval()));
            propertiesArray[i].put("Last_User_Connecting_Time", String.valueOf(connectionInformationArray[i].getStartTime() / 1000));
            propertiesArray[i].put("Current_Idle_Time", String.valueOf(connectionInformationArray[i].getIdleTime() / 1000));
            propertiesArray[i].put("Current_Share_Count", String.valueOf(connectionInformationArray[i].getLockNumber()));
        }
        return propertiesArray;
    }

    @Override
    public void disconnect(String string) throws RemoteException {
        ConnectionInformation connectionInformation = (ConnectionInformation)this.SEDU.get(string);
        if (connectionInformation != null) {
            this.currentTimeMillis.getAdminService().getConnectionPoolManager().disconnect(connectionInformation);
        }
    }

    @Override
    public Vector getAllUserSessions() throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getAllUserSessions();
    }

    @Override
    public Vector getUserSessionsByUser(String string) throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getAllUserSessionsByUserID(string);
    }

    @Override
    public Vector getSortedUserSessions(Vector vector, int[] nArray) throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getSortedUserSessions(vector, nArray);
    }

    @Override
    public void removeUserSessionBySessionID(String string) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeUserSessionBySessionID(string);
    }

    @Override
    public void removeUserSessionsByUserID(String string) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeUserSessionsByUserID(string);
    }

    @Override
    public void removeAllSelectedUserSessions(String[] stringArray) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeAllSelectedUserSessions(stringArray);
    }

    @Override
    public void removeAllUserSessions() throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeAllUserSessions();
    }

    @Override
    public String getHttpSessionID(String string) throws RemoteException {
        return ((JRUserSessionMonitor)this.currentTimeMillis.getMonitorService().getUserSessionMonitor()).getHttpSessionID(string);
    }

    @Override
    public void setSessionTimeout(int n) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().setSessionTimeout(n);
    }

    @Override
    public int getSessionTimeout() throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getSessionTimeout();
    }

    @Override
    public void stopTask(String string, int n) throws RemoteException {
        if (n == 1) {
            this.currentTimeMillis.getOndemandReportManager().removeOndemandReport(string, true);
        } else if (n == 2) {
            ((JRTaskManager)((JRRptServer)this.currentTimeMillis).getTaskManager()).stopActiveTask(string, false, false);
        }
    }

    @Override
    public void killTask(String string, int n) throws RemoteException {
        if (n == 1) {
            ((JRTaskManager)((JRRptServer)this.currentTimeMillis).getTaskManager()).deleteOndemandReport(string, true);
        } else if (n == 2) {
            ((JRTaskManager)((JRRptServer)this.currentTimeMillis).getTaskManager()).stopActiveTask(string, true, false);
        }
    }

    @Override
    public void stopServer(String string, int n) throws RemoteException {
        if (System.getProperty("jrs.isMyServer") == "true") {
            JREntServer.shutdownServer();
            System.exit(0);
        }
    }

    @Override
    public boolean isAdminServer() throws RemoteException {
        boolean bl = false;
        try {
            bl = ServerEnv.isClusterAdminServer() || this.currentTimeMillis.getClusterService().getLocalMember().equals(this.currentTimeMillis.getClusterService().getAdminMember());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public long getServerCurrentTime() throws RemoteException {
        return System.currentTimeMillis();
    }

    @Override
    public void setMonitorServerURL(String string) throws RemoteException {
        ((JRWebPageOptions)this.currentTimeMillis.getServerEnv().getWebPageOptions()).setMonitoringWebURL(string);
    }

    @Override
    public String getMonitorServerURL() throws RemoteException {
        return this.currentTimeMillis.getServerEnv().getWebPageOptions().getMonitoringWebURL();
    }

    @Override
    public Vector getAllTaskStatistics() throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskManager().getAllTaskStatistics();
    }

    @Override
    public List getAllAuditTasks() throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getAllAuditTasks();
    }

    @Override
    public List getAllAuditTasks(long l, long l2) throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getAllAuditTasks(l, l2);
    }

    @Override
    public List getWaitingAuditTasks() throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getWaitingAuditTasks();
    }

    @Override
    public List getWaitingAuditTasks(long l, long l2) throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getWaitingAuditTasks(l, l2);
    }

    @Override
    public List getRunningAuditTasks() throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getRunningAuditTasks();
    }

    @Override
    public List getRunningAuditTasks(long l, long l2) throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getRunningAuditTasks(l, l2);
    }

    @Override
    public List getFinishedAuditTasks() throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getFinishedAuditTasks();
    }

    @Override
    public List getFinishedAuditTasks(long l, long l2) throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getFinishedAuditTasks(l, l2);
    }

    @Override
    public List getFailedAuditTasks() throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getFailedAuditTasks();
    }

    @Override
    public List getFailedAuditTasks(long l, long l2) throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskAuditor().getFailedAuditTasks(l, l2);
    }
}

