/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Hashtable;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.UnknownPath;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.RemotePathInfo;
import jet.server.log.ServiceLogger;
import jet.server.resource.RptResourceManager;
import jet.server.resource.RptResourceNode;
import jet.server.userman.UserDataToolkit;

public class JRRemotePathInfo
implements RemotePathInfo {
    private static Hashtable SEDU = new Hashtable();
    private String append = null;
    private String charAt = null;
    protected RptResourceManager resManager = null;
    private boolean clear = false;
    private boolean endsWith = false;
    private String equals = null;

    public JRRemotePathInfo(String string, String string2, RptResourceManager rptResourceManager) throws RemoteException {
        this(string, string2, rptResourceManager, false);
    }

    public JRRemotePathInfo(String string, String string2, RptResourceManager rptResourceManager, boolean bl) throws RemoteException {
        this.append = string;
        this.endsWith = bl;
        this.charAt = string2 == null || string2.length() == 0 ? "/" : (!string2.startsWith("/") ? "/" + string2 : string2);
        if (this.charAt.length() > 1 && this.charAt.endsWith("/")) {
            this.charAt = this.charAt.substring(0, this.charAt.length() - 1);
        }
        if (this.charAt.startsWith("/USERFOLDERPATH")) {
            this.clear = true;
            this.equals = string2.substring("/USERFOLDERPATH".length());
            if (this.equals.startsWith("/")) {
                this.equals = this.equals.substring(1);
            }
            if (this.equals.endsWith("/")) {
                this.equals = this.equals.substring(0, this.equals.length() - 1);
            }
        }
        this.resManager = rptResourceManager;
    }

    @Override
    public String getUserID() {
        return this.append;
    }

    @Override
    public String getPath() {
        return this.charAt;
    }

    @Override
    public String getName() {
        String string = this.charAt;
        if (string.length() <= 1) {
            string = "";
        } else {
            int n = string.lastIndexOf("/");
            string = string.substring(n + 1);
        }
        if (this.endsWith && "".equals(string)) {
            string = "/";
        }
        return string;
    }

    @Override
    public String getParentPath() {
        int n;
        String string = this.charAt;
        string = string.length() <= 1 ? null : string.substring(0, (n = string.lastIndexOf("/")) == 0 ? 1 : n);
        return string;
    }

    @Override
    public String getRealPath() throws RptServerException {
        try {
            String string = null;
            if (this.clear) {
                Object object;
                String string2 = (String)SEDU.get(this.append);
                if (string2 == null) {
                    if (SEDU.size() > 1000) {
                        SEDU.clear();
                    }
                    object = this.getUserHome();
                    String string3 = (String)object + "folder.properties";
                    ExProperties exProperties = new ExProperties();
                    File file = new File(string3);
                    if (!file.exists()) {
                        UserDataToolkit.saveUserFolderProperties(UserDataToolkit.getDefaultUserFolderProperties(exProperties, this.resManager.getRealm(), this.append), this.resManager.getRealm(), this.append);
                    } else {
                        exProperties.load((String)object + "folder.properties");
                    }
                    string2 = exProperties.getProperty("my", (String)object + "my");
                    if (string2.endsWith("/")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (string2.endsWith(File.separator)) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    SEDU.put(this.append, string2);
                }
                if (this.equals.length() > 0) {
                    if (this.equals.endsWith(".cls")) {
                        object = new JRRemotePathInfo(this.append, this.getParentPath(), this.resManager);
                        if (ServerEnv.shouldStartRMI()) {
                            UnicastRemoteObject.exportObject((Remote)object, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                        }
                        if (((JRRemotePathInfo)object).isCatalog()) {
                            return new JRRemotePathInfo(this.append, ((JRRemotePathInfo)object).getParentPath(), this.resManager).getRealPath() + File.separator + new File(this.equals).getName();
                        }
                        return ((JRRemotePathInfo)object).getRealPath() + File.separator + new File(this.equals).getName();
                    }
                    return string2 + File.separator + this.equals;
                }
                return string2;
            }
            string = this.isReport() ? this.resManager.getRptRealPath(this.append, this.getParentPath(), this.getName()) : this.resManager.getRealPath(this.append, this.charAt);
            String string4 = CSUtil.getStdName(string);
            if (string4 != null) {
                string = string4;
            }
            return string;
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public String getDescription() {
        String string = "";
        try {
            StringBuffer stringBuffer = new StringBuffer();
            RptResourceNode rptResourceNode = this.resManager.getResourceNode(this.append, this.charAt, stringBuffer);
            if (rptResourceNode != null && stringBuffer.length() == 0) {
                string = rptResourceNode.getDescription();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return string;
    }

    @Override
    public boolean isResourceNode() {
        if (this.clear) {
            return false;
        }
        boolean bl = false;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            RptResourceNode rptResourceNode = this.resManager.getResourceNode(this.append, this.charAt, stringBuffer);
            if (rptResourceNode != null && stringBuffer.length() == 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    @Override
    public boolean isShared() {
        boolean bl = false;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            RptResourceNode rptResourceNode = this.resManager.getResourceNode(this.append, this.charAt, stringBuffer);
            if (rptResourceNode != null) {
                bl = rptResourceNode.isMapSharedDisk();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    @Override
    public boolean isDir() {
        try {
            int n;
            boolean bl;
            if (this.clear) {
                String string = this.getRealPath();
                return new File(string).isDirectory();
            }
            String string = this.resManager.getPathInfo(this.append, this.charAt);
            boolean bl2 = bl = string.charAt((n = string.length()) - 1) == '1';
            if (n == 1 && !bl) {
                throw new UnknownPath(this.charAt);
            }
            return bl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            if (this.clear) {
                String string = this.getRealPath();
                return new File(string).isFile();
            }
            return this.resManager.getReferInfo(this.append, this.charAt).startsWith("2");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    @Override
    public boolean isCatalog() {
        try {
            if (this.clear) {
                return this.charAt.endsWith(".cat") || this.charAt.endsWith(".cat.xml");
            }
            String string = this.resManager.getPathInfo(this.append, this.charAt);
            return string.substring(0, string.length() - 1).equals("application/x-jrcatalog");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    @Override
    public boolean isSelfContainReport() {
        try {
            String string = this.getRealPath();
            return this.isReport() && string.endsWith(".clx");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    @Override
    public boolean isReport() {
        try {
            if (this.clear) {
                return this.charAt.endsWith(".cls") || this.charAt.endsWith(".clx") || this.charAt.endsWith(".cls.xml");
            }
            if (this.resManager.isReport(this.append, this.charAt)) {
                return true;
            }
            String string = this.resManager.getPathInfo(this.append, this.charAt);
            return string.substring(0, string.length() - 1).equals("application/x-jrreport");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    public String toString() {
        try {
            return super.toString() + "[" + "getPath=" + this.getPath() + " getParentPath=" + this.getParentPath() + " getRealPath()=" + this.getRealPath() + " isResourceNode()=" + this.isResourceNode() + " isDir()=" + this.isDir() + " isCatalog()=" + this.isCatalog() + " isReport()=" + this.isReport() + "]";
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return super.toString() + "[" + this.append + ":" + this.charAt + "]";
        }
    }

    public String getUserHome() {
        return ServerEnv.realmsPath + this.resManager.getRealm() + File.separator + this.append.toLowerCase() + File.separator;
    }

    @Override
    public String[] getFileInfo() throws RptServerException {
        File file;
        String string = this.getRealPath();
        String[] stringArray = new String[]{"", ""};
        if (string != null && string.length() > 0 && (this.isCatalog() || this.isReport()) && (file = new File(string)).exists()) {
            stringArray[0] = String.valueOf(file.length());
            stringArray[1] = CSUtil.getWinDate(new Date(file.lastModified()));
        }
        return stringArray;
    }

    @Override
    public String getDisplayName() throws RptServerException, RemoteException {
        String string = this.getName();
        if (!HttpUtil.isShowNameWithPostfix() && (this.isCatalog() || this.isReport())) {
            string = CSUtil.getNameWithoutExt(string, true);
        }
        return string;
    }

    @Override
    public boolean isRptReport() throws RptServerException, RemoteException {
        String string = this.getRealPath();
        return this.isReport() && string.endsWith(".rpt");
    }

    @Override
    public boolean isXmlReport() throws RptServerException, RemoteException {
        String string = this.getRealPath();
        return this.isReport() && string.endsWith(".cls.xml");
    }

    @Override
    public boolean isXmlCatalog() throws RptServerException, RemoteException {
        String string = this.getRealPath();
        return this.isCatalog() && string.endsWith(".cat.xml");
    }
}

