/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.jrc.JRClusterService;

public class JRRoundLoadBalancer
implements LoadBalancer {
    protected int iCur = -1;
    protected int iCount = 1;
    protected Member localMember = null;
    protected JRClusterService clusterServ = null;

    public JRRoundLoadBalancer(JRClusterService jRClusterService) {
        this.clusterServ = jRClusterService;
    }

    @Override
    public Member selectMember(Member member, Member[] memberArray) {
        this.localMember = member;
        if (memberArray.length == 1) {
            return member;
        }
        this.iCount = memberArray.length;
        if (this.iCur >= this.iCount) {
            this.iCur = 0;
        }
        if (this.iCur < 0) {
            this.iCur = 0;
            for (int i = 0; i < memberArray.length; ++i) {
                if (member.getID() != memberArray[i].getID()) continue;
                this.iCur = i;
                break;
            }
        }
        Member member2 = null;
        boolean bl = false;
        int n = 1;
        while (!bl && !this.canSelectMember(member2 = memberArray[this.iCur])) {
            this.round();
            if (++n <= this.iCount) continue;
            member2 = null;
            bl = true;
        }
        if (member2 == null) {
            member2 = memberArray[this.iCur];
        }
        this.round();
        return member2;
    }

    public boolean canSelectMember(Member member) {
        return true;
    }

    private int round() {
        this.iCur = this.iCur < this.iCount - 1 ? ++this.iCur : 0;
        return this.iCur;
    }
}

