/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JCliResource;
import jet.JSException;
import jet.bean.JREngine;
import jet.bean.ReportEngineAPI;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.CustomTaskIntf;
import jet.cs.TaskIntf;
import jet.cs.util.APIConst;
import jet.cs.util.APIUtil;
import jet.formula.ParamDesc;
import jet.formula.fArray;
import jet.server.ServerEnv;
import jet.server.api.ExportedFileList;
import jet.server.api.OndemandReportRecord;
import jet.server.api.RptServerException;
import jet.server.api.SecurityContext;
import jet.server.api.SecurityContextFactory;
import jet.server.api.TaskListener;
import jet.server.api.TooManyReportsException;
import jet.server.api.UserTask;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.ReportMember;
import jet.server.api.profiling.TaskAuditor;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.server.intf.engine.ReportEngine;
import jet.server.intf.jrs.ClusterListener;
import jet.server.intf.jrs.ScheduleTaskManager;
import jet.server.intf.jrs.SchedulingService;
import jet.server.intf.jrs.TaskManager;
import jet.server.jrc.ConcurrentReportManager;
import jet.server.jrc.DelTempFileThread;
import jet.server.jrc.DurationCheckingThread;
import jet.server.jrc.EngineErrorsMgrThread;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.JRDataService;
import jet.server.jrc.JRScheduleTaskManager;
import jet.server.jrc.JRTaskRecord;
import jet.server.jrc.RunRptThread;
import jet.server.jrc.TableProxy;
import jet.server.jrc.TableProxyExecutorQueueFactory;
import jet.server.jrc.TaskStatisticRecorder;
import jet.server.jrc.TempRstInfo;
import jet.server.jrc.engine.JREngineContext;
import jet.server.jrc.engine.JREngineManager;
import jet.server.jrc.engine.JRReportEngine;
import jet.server.jrc.track.TaskStatus;
import jet.server.jrc.track.Tracker;
import jet.server.jrserver.JRActiveTaskRecord;
import jet.server.jrserver.JRExportedFileList;
import jet.server.jrserver.JROndemandReportManager;
import jet.server.jrserver.JROndemandReportRecord;
import jet.server.jrserver.JRReportSheetInfo;
import jet.server.jrserver.JRResourceManager;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.JRRunReportTimeoutException;
import jet.server.jrserver.JRTaskAuditor;
import jet.server.jrserver.JRTaskCancellationException;
import jet.server.log.ServiceLogger;
import jet.server.schedule.CustomTask;
import jet.server.schedule.InternalStorableTask;
import jet.server.schedule.InternalTask;
import jet.server.schedule.JRServerInfo;
import jet.server.schedule.Launchable;
import jet.server.schedule.LaunchableObj;
import jet.server.schedule.SchdTools;
import jet.server.schedule.StartListener;
import jet.server.schedule.TerminationListener;
import jet.server.schedule.jrtasks.ExportInATypeTask;
import jet.server.schedule.jrtasks.ExportTask;
import jet.server.schedule.jrtasks.HtmlPipeFileNames;
import jet.server.schedule.jrtasks.HtmlPipeFileNamesImpl;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.JRTask;
import jet.server.schedule.jrtasks.MonitorThread;
import jet.server.schedule.jrtasks.PublishCRDTask;
import jet.server.schedule.jrtasks.PublishRptTask;
import jet.server.schedule.jrtasks.ReportInfoCache;
import jet.server.schedule.jrtasks.RunAndViewTermLsn;
import jet.server.schedule.jrtasks.RunRptTask;
import jet.server.schedule.jrtasks.RunRptTaskRoot;
import jet.server.schedule.jrtasks.UpdateRptTask;
import jet.server.schedule.jrtasks.UserTaskProxy;
import jet.server.schedule.jrtasks.ViewRptTask;
import jet.server.schedule.jrtasks.ViewTestRptTask;
import jet.server.util.ParamUtil;
import jet.server.util.Queue;
import jet.server.util.ThreadQueueController;
import jet.server.util.ThreadQueueElement;
import jet.server.util.WebSecurityUtil;
import jet.util.ReportsetEngineInfo;

public class JRTaskManager
implements TaskManager,
TerminationListener,
ClusterListener,
Runnable {
    public static final int ON_DEMAND = 1;
    public static final int SCHEDULED = 2;
    public static final int BURSTING_MAIN = 3;
    public static final int BURSTING_SUB = 4;
    public static final String TASK_TOPIC = "TaskManager";
    public static final int SUBMIT_TASK = 0;
    public static final int START_TASK = 1;
    public static final int FINISH_TASK = 2;
    public static final int FAILED_TASK = 3;
    public static final int SUBMITED = 1;
    public static final int UNLAUNCH = 2;
    public static final int TASK_QUEUE = 3;
    public static final int RUNNING = 4;
    public static final int INIT_ENGINE = 5;
    public static final int LOAD_REPORT = 6;
    public static final int EXPORTING = 7;
    public static final int EXIT_ENGINE = 8;
    public static final int COMPLETED = 9;
    public static final int FAILED = 10;
    public static final String TASK_ID = "taskID";
    public static final String RPT_NAME = "rptName";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_STATUS = "taskStatus";
    public static final String SERVER_NAME = "serverName";
    public static final String RUN_HOST = "runHost";
    public static final String RUN_PORT = "runPort";
    public static final String SUBMIT_TIME = "submitTime";
    public static final String START_TIME = "startTime";
    public static final String FINISH_TIME = "finishTime";
    public static final String RPT_PAGES = "rptPages";
    public static final String RPT_SOURCE = "rptSource";
    public static final String RST_FILE_NAME = "rstFileName";
    public static final String USER_NAME = "userName";
    public static final String REASON = "reason";
    public static final String ENGINE_INFO = "engineInfo";
    public static final String FAILED_INFO = "failedInfo";
    public static final String FIRST_SUBMIT_TIME = "firstSubmitTime";
    public static final String RUN_TIMES_NUMBER = "runTimesNumber";
    private JRDataService HTML_PIPE_FILE_NAMES = null;
    protected JROndemandReportManager ondemandManager = null;
    Hashtable htOndemands = null;
    Hashtable htOndemandThreads = null;
    protected RunAndViewTermLsn ravtLsn = null;
    protected JROndemandReportManager lrptMan = null;
    private DelTempFileThread J = null;
    private Hashtable SEDU = new Hashtable();
    private Hashtable TASK_PUBLISH_ANALYSIS_DISPLAY_NAME = new Hashtable();
    private JRResourceManager TIMEOUT = null;
    private MonitorThread add = new MonitorThread();
    private ReportMember addElement = null;
    private boolean addFailedTask = false;
    private ConcurrentReportManager addFailedTaskToMonitor = null;
    private int addFinishedTask = -1;
    private final Vector addFinishedTaskToMonitor = new Vector();
    private final Vector addRecord = new Vector();
    private final Vector addRunningTask = new Vector();
    private Hashtable addRunningTaskToMonitor = new Hashtable();
    private ClusterMap addTask;
    private Hashtable addTerminationListener = new Hashtable();
    private Vector addWaitingTask = new Vector();
    private Vector addWaitingTaskToMonitor = new Vector();
    private JRClusterService append = null;
    private Queue assertCheck = new Queue();
    private Object available = new Object();
    private Thread beforeStopLaunch = null;
    private int booleanValue = -1;
    private JREngineManager canAutoRefresh = null;
    private SchedulingService canCancelRecoveryTask = null;
    private int canRunReportInOrg = 0;
    private SecurityContextFactory cancelTask = null;
    private ConnectionInfoProvider clone = null;
    private Object close = new Object();
    private DurationCheckingThread contains = null;
    private EngineErrorsMgrThread containsKey = new EngineErrorsMgrThread();
    private JRRptServer convertEscapes;
    private TaskStatisticRecorder copyAllFiles;
    private JRScheduleTaskManager createActiveTaskRecord;
    private TaskAuditor currentThread;

    public JRTaskManager(JRRptServer jRRptServer, JRClusterService jRClusterService) {
        this.htOndemands = new Hashtable();
        this.htOndemandThreads = new Hashtable();
        this.ravtLsn = new RunAndViewTermLsn(this);
        this.append = jRClusterService;
        this.addElement = (ReportMember)((Object)ClusterEnv.getMember());
        try {
            this.createActiveTaskRecord = new JRScheduleTaskManager(this);
            this.addTask = MapFactory.getMap(MapAttr.HTML_PIPE_FILE_NAMES);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        this.convertEscapes = jRRptServer;
        this.copyAllFiles = new TaskStatisticRecorder(ServerEnv.getReportHome() + "profiling");
    }

    public void setOndemandReportManager(JROndemandReportManager jROndemandReportManager) {
        this.ondemandManager = jROndemandReportManager;
        this.lrptMan = jROndemandReportManager;
        if (this.J != null) {
            this.J.ondemandMan = jROndemandReportManager;
        }
    }

    public void setResourceManager(JRResourceManager jRResourceManager) {
        this.TIMEOUT = jRResourceManager;
    }

    public ScheduleTaskManager getScheduleTaskManager() {
        return this.createActiveTaskRecord;
    }

    public void setEngineManager(JREngineManager jREngineManager) {
        this.canAutoRefresh = jREngineManager;
    }

    public JREngineManager getEngineManager() {
        return this.canAutoRefresh;
    }

    public String getTempDir() {
        return this.TIMEOUT.getTempDir();
    }

    public ClusterService getClusterService() {
        return this.append;
    }

    public void setDataService(JRDataService jRDataService) {
        this.HTML_PIPE_FILE_NAMES = jRDataService;
    }

    public JRDataService getDataService() {
        return this.HTML_PIPE_FILE_NAMES;
    }

    public SchedulingService getSchedulingService() {
        return this.canCancelRecoveryTask;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.canCancelRecoveryTask = schedulingService;
    }

    public void start() throws Exception {
        ThreadQueueController threadQueueController;
        this.J = new DelTempFileThread(this.convertEscapes, this.ondemandManager);
        this.addFinishedTask = ServerEnv.getQueueSize();
        if (this.addFinishedTask > 0) {
            this.booleanValue = this.addFinishedTask * 2 + 10;
            threadQueueController = new ThreadQueueController(this.addFinishedTask, true);
        } else {
            threadQueueController = null;
        }
        this.addFailedTaskToMonitor = new ConcurrentReportManager(JRTask.getMaxReports(), threadQueueController, this.convertEscapes.getAdminService().getConfigService());
        Tracker.getInstance().init(threadQueueController, this.assertCheck, this.addElement == null ? false : this.addElement.isAdmin(), this.append);
        if (System.getProperty("com.jinfonet.securityContextFactory") != null) {
            try {
                this.cancelTask = (SecurityContextFactory)Class.forName(System.getProperty("com.jinfonet.securityContextFactory")).newInstance();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        if (ServerEnv.isEnableTaskDuration() && ServerEnv.getTimeoutsCheckCycle() > 0) {
            this.contains = new DurationCheckingThread(this);
        }
        this.currentThread = this.convertEscapes.getTaskAuditor();
        this.addFailedTask = true;
        if (this.addFailedTaskToMonitor.hasQueueController()) {
            this.beforeStopLaunch = new Thread(this);
            this.beforeStopLaunch.start();
        }
    }

    public void quit() throws Exception {
        this.stop();
        if (this.TIMEOUT != null) {
            SchdTools.deleteTempFilesWithSubFolders(this.TIMEOUT.getTempDir());
        }
        this.lrptMan = null;
        this.ravtLsn = null;
        this.TIMEOUT = null;
        this.append = null;
        if (this.HTML_PIPE_FILE_NAMES != null) {
            this.HTML_PIPE_FILE_NAMES = null;
        }
        this.addElement = null;
        this.canAutoRefresh = null;
        this.ondemandManager = null;
        if (this.copyAllFiles != null) {
            this.copyAllFiles.quit();
        }
        Tracker.getInstance().release();
        if (ServerEnv.shouldStartRMI()) {
            UnicastRemoteObject.unexportObject(this.clone, true);
        }
        this.addFailedTask = false;
    }

    public void stop() throws Exception {
        this.addFailedTask = false;
        ServiceLogger.logDebug("TaskManager::stopping task manager...");
        if (this.addFailedTaskToMonitor.hasQueueController()) {
            this.beforeStopLaunch.interrupt();
        }
        this.addFailedTaskToMonitor.quit();
        LaunchableObj[] launchableObjArray = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.keySet().toArray(new LaunchableObj[0]);
        for (int i = 0; i < launchableObjArray.length; ++i) {
            TaskIntf taskIntf = launchableObjArray[i].getTask();
            if (taskIntf == null) continue;
            this.stopActiveTask(taskIntf.getId(), true, true);
        }
        this.J.stopRun();
        this.containsKey.stopRun();
        this.add.destroy();
        if (this.contains != null) {
            this.contains.stopRun();
        }
        this.add = null;
        this.J = null;
    }

    @Override
    public String runTask(String string, Properties properties) throws Exception {
        properties.put("TS_tsk_submit", new Long(System.currentTimeMillis()));
        if (string != null) {
            properties.put("jrs.uid", string);
        }
        if (properties.getProperty("jrs.task_class").equals("jet.server.schedule.jrtasks.PublishRptTask")) {
            String string2 = properties.getProperty("jrs.cmd");
            SchdTools.removeUnusedTaskProps(properties);
            if (string2 != null) {
                properties.put("jrs.cmd", string2);
            }
        }
        return this.runTask(properties);
    }

    private static boolean HTML_PIPE_FILE_NAMES(Properties properties) {
        String string = (String)properties.get("jrs.task_class");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        try {
            return InternalTask.class.isAssignableFrom(Class.forName(string.trim()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runTask(Properties properties) throws Exception {
        if (!this.addFailedTask) {
            ServiceLogger.logError("TaskManager::runTask: task manager has stopped.", 3);
            return null;
        }
        if (!properties.containsKey("TS_tsk_submit")) {
            properties.put("TS_tsk_submit", new Long(System.currentTimeMillis()));
        }
        String string = null;
        boolean bl = JRTaskManager.HTML_PIPE_FILE_NAMES(properties);
        String string2 = null;
        if (!bl) {
            string2 = String.valueOf(Tracker.getSequenceId());
            properties.put("sequence_ID", string2);
        }
        String string3 = properties.getProperty("jrs.report");
        boolean bl2 = CSUtil.getBoolean(properties.getProperty("jrs.is_bursting_task"), false);
        boolean bl3 = properties.getProperty("jrs.task_class").equals(APIConst.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME);
        boolean bl4 = "jet.server.schedule.jrtasks.PublishCRDTask".equals(properties.getProperty("jrs.task_class"));
        Object object = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME;
        synchronized (object) {
            if (this.booleanValue > 0 && this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.size() >= this.booleanValue) {
                string = (String)properties.get("jrs.task_id");
                if (string == null) {
                    string = SchdTools.getIdBase();
                }
                properties.put("jrs.task_id", string);
                this.assertCheck.put(properties);
                if (!(bl3 || bl || bl4)) {
                    this.addWaitingTaskToMonitor(string2, string, string3, bl2 ? 3 : 2, ServerEnv.getHostName(), System.currentTimeMillis(), properties.getProperty("jrs.catalog"), properties.getProperty("jrs.uid"), 2);
                }
            } else {
                Object object2;
                Vector vector;
                LaunchableObj launchableObj = this.J(properties);
                if (!(bl3 || bl || bl4)) {
                    this.addWaitingTaskToMonitor(string2, launchableObj.getTask().getId(), string3, bl2 ? 3 : 2, ServerEnv.getHostName(), System.currentTimeMillis(), properties.getProperty("jrs.catalog"), properties.getProperty("jrs.uid"), 1);
                }
                if (null != (vector = ReportInfoCache.getCachedParams(properties.getProperty("jrs.engine_id")))) {
                    object2 = new Properties();
                    for (ParamDesc paramDesc : vector) {
                        if (!paramDesc.isMultipleValue()) {
                            ((Properties)object2).put(paramDesc.getPrompt(), paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault()));
                            continue;
                        }
                        if (paramDesc.isAllSelected()) {
                            ((Properties)object2).put(paramDesc.getPrompt(), "ALL");
                            continue;
                        }
                        String[] stringArray = paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), Locale.getDefault());
                        StringBuffer stringBuffer = new StringBuffer();
                        for (String string4 : stringArray) {
                            stringBuffer.append("," + string4);
                        }
                        if (stringArray.length > 0) {
                            ((Properties)object2).put(paramDesc.getPrompt(), stringBuffer.substring(1));
                            continue;
                        }
                        ((Properties)object2).put(paramDesc.getPrompt(), "");
                    }
                    ((JRTaskAuditor)this.currentThread).setTaskParameters(launchableObj.getTask().getId(), (Map)object2);
                }
                launchableObj.setUid((String)properties.get("jrs.uid"));
                launchableObj.addTerminationListener(this);
                object2 = new Thread(launchableObj);
                this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.put(launchableObj, object2);
                ((Thread)object2).start();
                this.addFinishedTask(launchableObj);
                string = launchableObj.getTask().getId();
            }
        }
        object = (String)properties.get("jrs.cmd");
        if (object != null && ((String)object).equalsIgnoreCase("jrs.run_task")) {
            this.TIMEOUT(string);
            while (!this.addElement(string)) {
                Thread.yield();
                Thread.sleep(1000L);
            }
            this.add(string);
        }
        return string;
    }

    private LaunchableObj J(Properties properties) throws Exception {
        TaskIntf taskIntf = (TaskIntf)this.makeTask(properties);
        if (taskIntf == null) {
            throw new Exception(JCliResource.getMessage("CS_ERR_54") + " " + this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME);
        }
        LaunchableObj launchableObj = new LaunchableObj(taskIntf, 0L);
        String string = (String)properties.get("jrs.launch_type");
        int n = string == null ? 0 : CSUtil.parseInt(string);
        launchableObj.setLaunchType(n);
        return launchableObj;
    }

    private String SEDU(String string, String string2, String string3, ViewRptTask viewRptTask, RunRptThread runRptThread, Hashtable hashtable, boolean bl) throws Exception {
        int n;
        String string4 = viewRptTask.getId();
        String string5 = (String)viewRptTask.getValue("rstName");
        this.prepareRslt(string5);
        int n2 = CSUtil.getResultType((String)hashtable.get("jrs.result_type"), -1);
        String string6 = null;
        if (n2 == 0) {
            string6 = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME(string2, string3, string5, hashtable);
        }
        Properties properties = null;
        properties = new Properties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string7 = (String)enumeration.nextElement();
            if (!string7.startsWith("jrs.param$")) continue;
            properties.put(string7, hashtable.get(string7));
        }
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.auto_archive"));
        int n3 = CSUtil.parseInt((String)hashtable.get("jrs.cat_version"), -1);
        if (n3 == -1 && string2 != null) {
            n3 = this.TIMEOUT.getLatestVersionNumber(string2);
        }
        if ((n = CSUtil.parseInt((String)hashtable.get("jrs.rpt_version"), -1)) == -1) {
            n = this.TIMEOUT.getLatestVersionNumber(string3);
        }
        String string8 = (String)hashtable.get("jrs.result");
        JRReportSheetInfo jRReportSheetInfo = null;
        Enumeration enumeration2 = viewRptTask.getRunningReportSheets().getAllReportSheets();
        if (enumeration2 != null && enumeration2.hasMoreElements()) {
            String string9 = (String)enumeration2.nextElement();
            jRReportSheetInfo = new JRReportSheetInfo(string9, viewRptTask.getRunningReportSheets().getReportSheetDisplayName(string9), null);
        } else {
            jRReportSheetInfo = new JRReportSheetInfo(viewRptTask.getReport(), null, null);
        }
        int n4 = APIUtil.parseInt("" + hashtable.get("jrs.result_type"));
        String string10 = this.ondemandManager.registerOndemandReport(string4, string, string2, n3, string3, jRReportSheetInfo, n, properties, string6, !bl2, string5, string8, n4);
        viewRptTask.setOndemandID(string10);
        if (string10 != null) {
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.ondemandManager.getOndemandReportRecord(string10);
            if (jROndemandReportRecord != null) {
                jROndemandReportRecord.setEngineErrors(viewRptTask.getEngineErrors());
            }
            this.htOndemands.put(string10, viewRptTask);
            if (runRptThread != null) {
                this.htOndemandThreads.put(string10, runRptThread);
            }
        }
        if (bl) {
            this.lrptMan.registerLargeReport(string, string2, string3, string5, properties, string6, runRptThread, viewRptTask);
            this.lrptMan.removeLargeReportIfTimeout();
        }
        return string10;
    }

    @Override
    public String runReport(String string, String string2, String string3, Properties properties) throws TooManyReportsException, Throwable {
        Properties properties2 = this.addFailedTask(string, string2, string3, properties);
        String string4 = properties2.getProperty("jrs.result_loca");
        if (string4 == null || string4.trim().length() == 0) {
            properties2.put("jrs.result_loca", this.getTempDir());
            properties2.put("jrs.result_loca_type", String.valueOf(1));
        }
        properties2.put("jrs.task_class", ViewRptTask.class.getName());
        String string5 = String.valueOf(Tracker.getSequenceId());
        properties2.put("sequence_ID", string5);
        ViewRptTask viewRptTask = (ViewRptTask)this.makeTask(properties2);
        if (viewRptTask != null) {
            List list;
            viewRptTask.setJRTaskManager(this);
            String string6 = viewRptTask.getResultType() == 1 ? viewRptTask.getHtmlResult() : viewRptTask.getResult();
            String string7 = new File(string6).getName();
            viewRptTask.putValue("rstName", string7);
            this.addWaitingTaskToMonitor(string5, viewRptTask.getId(), string3, 1, ServerEnv.getHostName(), System.currentTimeMillis(), string2, string, 1);
            viewRptTask.setThrow(true);
            this.SEDU(string, string2, string3, viewRptTask, null, properties, false);
            viewRptTask.runReport();
            this.ravtLsn.terminated(viewRptTask);
            if (viewRptTask.hasError()) {
                String string8 = viewRptTask.getErrorMsg();
                List list2 = viewRptTask.getEngineErrors();
                Throwable throwable = viewRptTask.getThrdThrow();
                viewRptTask = null;
                throw new RptServerException(string8, throwable, list2);
            }
            if (string6 != null && (list = viewRptTask.getEngineErrors()) != null && list.size() > 0) {
                this.containsKey.putErrors(string6, list);
            }
            viewRptTask = null;
            return string6;
        }
        return null;
    }

    @Override
    public String runReportNotWaitResult(String string, String string2, String string3, Properties properties) throws RptServerException, TooManyReportsException {
        String string4;
        Properties properties2 = this.addFailedTask(string, string2, string3, properties);
        String string5 = null;
        if (CSUtil.getBoolean((String)properties2.get("jrs.auto_archive"))) {
            properties2.put("jrs.archive_specified_destination", this.TIMEOUT.getRemoteHistDir());
            properties2.put("jrs.result_loca", this.TIMEOUT.getArchivePath(string));
            properties2.put("jrs.result_loca_type", String.valueOf(1));
        } else {
            string4 = properties2.getProperty("jrs.result_loca");
            if (string4 == null || string4.trim().length() == 0) {
                properties2.put("jrs.result_loca", this.getTempDir());
                properties2.put("jrs.result_loca_type", String.valueOf(1));
            }
        }
        properties2.put("jrs.task_class", ViewRptTask.class.getName());
        string4 = String.valueOf(Tracker.getSequenceId());
        properties2.put("sequence_ID", string4);
        try {
            Object object;
            ViewRptTask viewRptTask = (ViewRptTask)this.makeTask(properties2);
            String string6 = viewRptTask.getResultType() == 1 ? viewRptTask.getHtmlResult() : viewRptTask.getResult();
            String string7 = new File(string6).getName();
            viewRptTask.putValue("rstName", string7);
            boolean bl = CSUtil.getBoolean((String)properties2.get("isWait"), false);
            if (viewRptTask != null) {
                viewRptTask.setJRTaskManager(this);
                this.addWaitingTaskToMonitor(string4, viewRptTask.getId(), string3, 1, ServerEnv.getHostName(), System.currentTimeMillis(), string2, string, 1);
                viewRptTask.setWait(bl);
                object = new RunRptThread(this, viewRptTask, new Object());
                this.SEDU(string, string2, string3, viewRptTask, (RunRptThread)object, properties, false);
                ((Thread)object).start();
                string5 = string6;
            }
            if (string6 != null && (object = viewRptTask.getEngineErrors()) != null && object.size() > 0) {
                this.containsKey.putErrors(string6, (List)object);
            }
            return string5;
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public long runTestReport(Properties properties) throws Exception {
        String string = properties.getProperty("jrs.result_loca");
        if (string == null || string.trim().length() == 0) {
            properties.put("jrs.result_loca", this.getTempDir());
            properties.put("jrs.result_loca_type", String.valueOf(1));
        }
        properties.put("jrs.task_class", ViewTestRptTask.class.getName());
        String string2 = String.valueOf(Tracker.getSequenceId());
        properties.put("sequence_ID", string2);
        ViewTestRptTask viewTestRptTask = (ViewTestRptTask)this.makeTask(properties);
        viewTestRptTask.setJRTaskManager(this);
        this.addWaitingTaskToMonitor(string2, viewTestRptTask.getId(), viewTestRptTask.getReport(), 1, ServerEnv.getHostName(), System.currentTimeMillis(), viewTestRptTask.getCatalog(), viewTestRptTask.getUid(), 1);
        viewTestRptTask.setThrow(true);
        viewTestRptTask.runReport();
        if (viewTestRptTask.hasError()) {
            throw new Exception(viewTestRptTask.getErrorMsg(), viewTestRptTask.getThrdThrow());
        }
        return viewTestRptTask.getRunTime();
    }

    public void copyAllFiles(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                Object object2;
                if (!fileArray[i].isDirectory()) {
                    object2 = new FileInputStream(fileArray[i].toString());
                    object = new FileOutputStream(string2 + File.separator + fileArray[i].getName());
                    byte[] byArray = new byte[((FileInputStream)object2).available()];
                    ((FileInputStream)object2).read(byArray);
                    ((FileOutputStream)object).write(byArray);
                    ((FileInputStream)object2).close();
                    ((FileOutputStream)object).close();
                    continue;
                }
                object2 = string2 + File.separator + fileArray[i].getName();
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                this.copyAllFiles(fileArray[i].getPath(), (String)object2);
            }
        }
    }

    private String TASK_PUBLISH_ANALYSIS_DISPLAY_NAME(String string, String string2, String string3, Hashtable hashtable) {
        boolean bl;
        String string4;
        String string5 = null;
        string5 = "jrs.result_type=0";
        int n = CSUtil.parseInt((String)hashtable.get("jrs.applet_type"), -1);
        if (n >= 0) {
            string5 = string5 + "&jrs.applet_type=" + n;
        }
        if ((string4 = (String)hashtable.get("jrs.frameapplet")) != null) {
            string5 = string5 + "&jrs.frameapplet=" + string4;
        }
        if (bl = APIUtil.getBoolean((String)hashtable.get("jrs.isjrsapltpg"), false)) {
            string5 = string5 + "&jrs.isjrsapltpg=" + bl;
        }
        string5 = string5 + "&jrs.catalog=" + string;
        string5 = string5 + "&jrs.report=" + string2;
        string5 = string5 + "&jrs.temp_file=" + string3;
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String runReportWithTimeouts(String string, String string2, String string3, Properties properties, long l) throws RptServerException, TooManyReportsException, Throwable {
        String string4;
        Properties properties2 = this.addFailedTask(string, string2, string3, properties);
        if (CSUtil.getBoolean((String)properties.get("jrs.auto_archive"))) {
            properties.put("jrs.archive_specified_destination", this.TIMEOUT.getRemoteHistDir());
            properties.put("jrs.result_loca", this.TIMEOUT.getArchivePath(string));
            properties.put("jrs.result_loca_type", String.valueOf(1));
        } else {
            string4 = properties2.getProperty("jrs.result_loca");
            if (string4 == null || string4.trim().length() == 0) {
                properties2.put("jrs.result_loca", this.getTempDir());
                properties2.put("jrs.result_loca_type", String.valueOf(1));
            }
        }
        properties.put("jrs.task_class", ViewRptTask.class.getName());
        string4 = String.valueOf(Tracker.getSequenceId());
        properties.put("sequence_ID", string4);
        ViewRptTask viewRptTask = (ViewRptTask)this.makeTask(properties);
        if (viewRptTask != null) {
            Object object;
            viewRptTask.setJRTaskManager(this);
            String string5 = viewRptTask.getResultType() == 1 ? viewRptTask.getHtmlResult() : viewRptTask.getResult();
            String string6 = new File(string5).getName();
            viewRptTask.putValue("rstName", string6);
            this.addWaitingTaskToMonitor(string4, viewRptTask.getId(), string3, 1, ServerEnv.getHostName(), System.currentTimeMillis(), string2, string, 1);
            viewRptTask.setStatus("Wait in queue");
            long l2 = (Long)viewRptTask.getValue("jrs.task_duration");
            if (ServerEnv.isEnableTaskDuration() && l2 > 0L && (l2 < l || l <= 0L)) {
                viewRptTask.setThrow(true);
                object = new Object();
                RunRptThread runRptThread = new RunRptThread(this, viewRptTask, object);
                String string7 = this.SEDU(string, string2, string3, viewRptTask, runRptThread, properties, true);
                runRptThread.start();
                Object object2 = object;
                synchronized (object2) {
                    object.wait(l2 < 250L ? 250L : l2);
                    Thread.yield();
                }
                if (!runRptThread.hasFinished()) {
                    Object object3;
                    boolean bl;
                    runRptThread.setSendEmail(true);
                    object2 = this.ondemandManager.getOndemandReportRecord(string7);
                    viewRptTask.setHandledDuration(true);
                    boolean bl2 = (Boolean)viewRptTask.getValue("jrs.auto_cancel_task");
                    if (bl2) {
                        this.addRunningTaskToMonitor(viewRptTask, runRptThread);
                        ((JROndemandReportRecord)object2).setDuration(l2);
                        ((JROndemandReportRecord)object2).setCancelled(true);
                        ServiceLogger.logEvent("Cancelled ondemand report: " + viewRptTask.getReport() + ", catalog: " + viewRptTask.getCatalog() + ", started time: " + new Date(object2.getStartedTime()));
                    }
                    if ((bl = ((Boolean)viewRptTask.getValue("jrs.need_notify_duration")).booleanValue()) && (object3 = (String)viewRptTask.getValue("jrs.duration_notify_mail")) != null && ((String)object3).length() > 0) {
                        String string8 = " Task Type: Ondemand Run\nTask ID: " + viewRptTask.getId() + "\nReport: " + viewRptTask.getReport() + "\nCatalog:" + viewRptTask.getCatalog() + "\nTask Status: " + viewRptTask.getStatus() + "\nTask Start Time: " + new Date(object2.getStartedTime()) + "\nNotify Time: " + new Date(System.currentTimeMillis()) + "\nDuration: " + l2 / 60000L + " minute(s)" + "\nActive: " + (bl2 ? "false, the task has been auto canceled" : "true, the task still running") + "\nDescription: Running this report will require more time than the specified minutes in 'Duration'!";
                        CSMail cSMail = new CSMail((String)object3, null, null, "Task Timeout Notification", string8, false);
                        viewRptTask.execTimeoutNotification(cSMail);
                    }
                    if (bl2) {
                        throw new JRTaskCancellationException("Task cancelled", viewRptTask);
                    }
                    if (l > l2) {
                        object3 = object;
                        synchronized (object3) {
                            object.wait(l - l2);
                        }
                        if (!runRptThread.hasFinished()) {
                            runRptThread.setSendEmail(true);
                            throw new JRRunReportTimeoutException(string6, runRptThread, viewRptTask);
                        }
                    }
                }
                if (runRptThread.getThrowable() != null) {
                    throw runRptThread.getThrowable();
                }
                runRptThread = null;
            } else if (l > 0L) {
                viewRptTask.setThrow(true);
                object = new Object();
                RunRptThread runRptThread = new RunRptThread(this, viewRptTask, object);
                String string9 = this.SEDU(string, string2, string3, viewRptTask, runRptThread, properties, true);
                runRptThread.start();
                Object object4 = object;
                synchronized (object4) {
                    object.wait(l < 1000L ? 1000L : l);
                }
                if (!runRptThread.hasFinished()) {
                    runRptThread.setSendEmail(true);
                    throw new JRRunReportTimeoutException(string5, runRptThread, viewRptTask);
                }
                if (runRptThread.getThrowable() != null) {
                    throw runRptThread.getThrowable();
                }
                runRptThread = null;
            } else {
                viewRptTask.setThrow(true);
                viewRptTask.runReport();
                this.ravtLsn.terminated(viewRptTask);
            }
            if (viewRptTask.hasError()) {
                throw new RptServerException(viewRptTask.getErrorMsg(), viewRptTask.getThrdThrow(), viewRptTask.getEngineErrors());
            }
            if (CSUtil.getBoolean((String)properties.get("jrs.auto_archive"))) {
                this.copyAllFiles((String)properties.get("jrs.result_loca"), this.getTempDir());
            }
            if (string5 != null && (object = viewRptTask.getEngineErrors()) != null && object.size() > 0) {
                this.containsKey.putErrors(string5, (List)object);
            }
            return string5;
        }
        viewRptTask = null;
        return null;
    }

    @Override
    public String exportResultToOneFormat(String string, String string2, Properties properties) throws RptServerException {
        if (properties == null || string2 == null) {
            return null;
        }
        if (string != null) {
            properties.put("jrs.uid", string);
        }
        File file = new File(string2);
        try {
            if (file.exists()) {
                return this.exportResultInAType(file.getCanonicalPath(), properties);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new RptServerException(throwable);
        }
        return null;
    }

    public String exportResultInAType(String string, Properties properties) throws Throwable {
        if (properties == null || string == null) {
            return null;
        }
        properties.put("jrs.result", string);
        properties.put("jrs.task_class", ExportInATypeTask.class.getName());
        properties.put("exportResultInAType", String.valueOf(true));
        ExportInATypeTask exportInATypeTask = (ExportInATypeTask)this.makeTask(properties);
        if (exportInATypeTask != null) {
            exportInATypeTask.setThrow(true);
            exportInATypeTask.export();
            return exportInATypeTask.getResultName();
        }
        return null;
    }

    @Override
    public ExportedFileList exportResult(String string, String string2, Properties properties) throws RptServerException {
        if (properties == null || string2 == null) {
            return null;
        }
        if (string != null) {
            properties.put("jrs.uid", string);
        }
        JRExportedFileList jRExportedFileList = null;
        File file = new File(string2);
        try {
            if (file.exists()) {
                properties.put("jrs.result", file.getCanonicalPath());
                properties.put("jrs.task_class", ExportTask.class.getName());
                ExportTask exportTask = (ExportTask)this.makeTask(properties);
                if (exportTask != null) {
                    exportTask.setThrow(true);
                    exportTask.export();
                    Object[] objectArray = exportTask.getExportList();
                    if (objectArray != null) {
                        jRExportedFileList = new JRExportedFileList(objectArray);
                    }
                }
            }
            return jRExportedFileList;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new RptServerException(throwable);
        }
    }

    @Override
    public Vector getActiveTasks() {
        Vector<JRActiveTaskRecord> vector = new Vector<JRActiveTaskRecord>();
        Enumeration enumeration = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.keys();
        while (enumeration.hasMoreElements()) {
            LaunchableObj launchableObj = (LaunchableObj)enumeration.nextElement();
            if (launchableObj == null) continue;
            vector.add(JRTaskManager.createActiveTaskRecord(launchableObj, this.TIMEOUT));
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminated(Object object) throws Exception {
        if (!this.addFailedTask) {
            ServiceLogger.logError("TaskManager::terminated: task manager has stopped.", 3);
            return;
        }
        TaskIntf taskIntf = null;
        if (object instanceof LaunchableObj) {
            boolean bl;
            Object object2;
            this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.remove(object);
            Object object3 = this.available;
            synchronized (object3) {
                if (this.booleanValue > 0) {
                    this.available.notify();
                }
            }
            object3 = (LaunchableObj)object;
            int n = ((LaunchableObj)object3).getLaunchType();
            taskIntf = ((LaunchableObj)object3).getTask();
            if (taskIntf instanceof JRTask) {
                this.createActiveTaskRecord.notifyTaskFinished(((JRTask)taskIntf).getRunTaskId());
            }
            int n2 = -1;
            if (taskIntf instanceof UpdateRptTask) {
                n2 = ((UpdateRptTask)taskIntf).getVersionID();
            } else if (taskIntf instanceof PublishRptTask) {
                n2 = ((PublishRptTask)taskIntf).getVersionID();
            }
            String string = taskIntf.getId();
            this.add(string);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            int n3 = -1;
            String string8 = "";
            String string9 = null;
            String string10 = "";
            long[] lArray = null;
            Hashtable hashtable = null;
            boolean bl2 = false;
            if (taskIntf instanceof RunRptTaskRoot) {
                string2 = ((RunRptTaskRoot)taskIntf).getEngMsgs();
                string3 = ((RunRptTaskRoot)taskIntf).getTaskName();
                string4 = ((RunRptTaskRoot)taskIntf).getCatalog();
                string5 = ((RunRptTaskRoot)taskIntf).getReport();
                object2 = ((RunRptTaskRoot)taskIntf).getRunningReportSheets().getAllReportSheets();
                if (object2 != null) {
                    while (object2.hasMoreElements()) {
                        string8 = string8 + ((RunRptTaskRoot)taskIntf).getRunningReportSheets().getReportSheetDisplayName((String)object2.nextElement());
                        if (!object2.hasMoreElements()) continue;
                        string8 = string8 + ",";
                    }
                } else {
                    string8 = ((RunRptTaskRoot)taskIntf).getCurrentReport();
                }
                if ((string9 = (String)taskIntf.getValue("jrs.param_file")) == null) {
                    string9 = ((RunRptTaskRoot)taskIntf).getParamFile();
                }
                if (taskIntf instanceof RunRptTask) {
                    int n4 = -1;
                    bl = false;
                    if (taskIntf instanceof UpdateRptTask) {
                        bl = true;
                    } else if (((RunRptTask)taskIntf).isWillPublishToVersion) {
                        bl = true;
                    }
                    lArray = ((RunRptTask)taskIntf).getSuccInfo();
                    string10 = string10 + ((RunRptTask)taskIntf).getToDiskFiles();
                    hashtable = ((RunRptTask)taskIntf).getPublishRecords();
                    bl2 = ((RunRptTask)taskIntf).isMissed();
                }
            } else if (taskIntf instanceof UserTaskProxy) {
                string3 = ((UserTaskProxy)taskIntf).getTaskName();
                string4 = ((UserTaskProxy)taskIntf).getCatalog();
                string5 = ((UserTaskProxy)taskIntf).getReport();
                string9 = ((UserTaskProxy)taskIntf).getParamFile();
            } else if (taskIntf instanceof PublishCRDTask) {
                string4 = ((PublishCRDTask)taskIntf).getCatalog();
                string6 = ((PublishCRDTask)taskIntf).getDataSource();
                n3 = ((PublishCRDTask)taskIntf).getQueryType();
                string7 = ((PublishCRDTask)taskIntf).getQueryName();
            }
            if (!(taskIntf instanceof InternalTask)) {
                String string11;
                object2 = new Date();
                String string12 = "";
                if (((LaunchableObj)object3).getTask() instanceof RunRptTaskRoot) {
                    string12 = ((RunRptTaskRoot)((LaunchableObj)object3).getTask()).getUid();
                }
                bl = !taskIntf.hasError() && !((LaunchableObj)object3).hasError();
                String string13 = taskIntf.getErrorMsg();
                String string14 = ((LaunchableObj)object3).getMessage();
                if (string13 == null) {
                    string13 = string14;
                } else if (string14 != null) {
                    string13 = string13 + "\n\r" + string14;
                }
                String string15 = taskIntf.getClass().getName();
                if (taskIntf instanceof UserTaskProxy) {
                    string12 = ((UserTaskProxy)taskIntf).getUid();
                    string15 = ((UserTaskProxy)taskIntf).getTaskClass();
                }
                String string16 = ((Date)object2).getTime() + "-" + SchdTools.random.nextInt();
                JRTask jRTask = (JRTask)taskIntf;
                String string17 = null;
                if (bl && jRTask.getSuccessNotify()) {
                    string17 = ((JRTask)taskIntf).execNotification(bl, string13, string, string4, string5, (Date)object2, string6, n3, string7);
                } else if (!bl && jRTask.getFailNotify()) {
                    string17 = ((JRTask)taskIntf).execNotification(bl, string13, string, string4, string5, (Date)object2, string6, n3, string7);
                }
                if (string17 != null) {
                    string13 = string13 == null ? string17 : string13 + "\n\r" + string17;
                }
                if (!(taskIntf instanceof PublishCRDTask) && (taskIntf.hasError() || string13 != null && string13.trim().length() != 0)) {
                    if (((JRTask)taskIntf).getThrowable() != null) {
                        this.convertEscapes.handleThrowable(((JRTask)taskIntf).getThrowable());
                    }
                    string11 = null;
                    if (taskIntf instanceof RunRptTaskRoot) {
                        string11 = ((RunRptTaskRoot)taskIntf).getSequenceID();
                    }
                    this.addFailedTaskToMonitor(string11, string, string13 == null ? "null" : string13);
                }
                string11 = string9;
                if (string9 != null) {
                    int n5 = string9.lastIndexOf(File.separator);
                    string11 = string9.substring(n5 + 1);
                }
                String string18 = (String)taskIntf.getValue("jrs.triggers");
                String string19 = (String)taskIntf.getValue("jrs.triggers.logic");
                if (!(taskIntf instanceof PublishCRDTask)) {
                    try {
                        if (ServerEnv.isWriteCompletedInQueue()) {
                            TableProxy tableProxy = new TableProxy();
                            tableProxy.setProxyObject(this.HTML_PIPE_FILE_NAMES.getCompletedTable());
                            tableProxy.setProxyMethod("addRecord");
                            tableProxy.setArguments(new Object[]{string, string4, string5, string11, string10, object2, string12, new Boolean(bl), lArray, string13, string15, new Integer(n2), string16, new Integer(n), string2, string3, new Boolean(bl2), string18, string19, hashtable, string8});
                            TableProxyExecutorQueueFactory.getQueue().enqueue(tableProxy, 0);
                        } else {
                            this.HTML_PIPE_FILE_NAMES.getCompletedTable().addRecord(string, string4, string5, string11, string10, (Date)object2, string12, bl, lArray, string13, string15, n2, string16, n, string2, string3, bl2, string18, string19, hashtable, string8);
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                this.canCancelRecoveryTask.setLastSuccess(string, bl);
            }
        }
        if (object == null || !(object instanceof Launchable)) {
            return;
        }
        if (taskIntf != null) {
            if (!(taskIntf instanceof PublishCRDTask)) {
                this.sendTaskContext(taskIntf);
            }
            taskIntf = null;
        }
    }

    private void TIMEOUT(String string) {
        if (string != null && string.length() > 0) {
            this.SEDU.put(string, new Date());
        }
    }

    private void add(String string) {
        if (string != null && string.length() > 0) {
            this.SEDU.remove(string);
        }
    }

    private boolean addElement(String string) {
        Object var2_2 = null;
        if (string != null && string.length() > 0) {
            var2_2 = this.SEDU.get(string);
        }
        return var2_2 == null;
    }

    public boolean isRunningQueue() {
        return this.addFailedTaskToMonitor.isRunningQueue();
    }

    public boolean isTaskQueueFull(int n) {
        return this.addFailedTaskToMonitor.isTaskQueueFull(n);
    }

    public synchronized boolean canRunReport(RunRptTaskRoot runRptTaskRoot) {
        if (!this.addFailedTaskToMonitor.hasQueueController()) {
            if (JRTask.getMaxReports() <= 0 || this.canRunReportInOrg < JRTask.getMaxReports()) {
                String[] stringArray = CSUtil.parsePrincipalDisplayName(runRptTaskRoot.getUid());
                if (stringArray[0] != null) {
                    return this.addFailedTaskToMonitor.canRunReportInOrg(stringArray[0]);
                }
                return true;
            }
            ServiceLogger.logError(3600163, 3);
            return false;
        }
        if (!ServerEnv.isSpecialUser()) {
            return true;
        }
        ServiceLogger.logDebug(6600109, new Object[]{String.valueOf(this.addFailedTaskToMonitor.isFullActive()), String.valueOf(this.addFailedTaskToMonitor.getActiveAndWaitReportsCount())}, 6);
        if (!this.addFailedTaskToMonitor.isFullActive()) {
            return true;
        }
        if (runRptTaskRoot instanceof ViewRptTask && !((RunRptTask)runRptTaskRoot).isWait()) {
            ServiceLogger.logError(3600163, 3);
            ServiceLogger.logError(3600164, String.valueOf(this.addFailedTaskToMonitor.getActiveAndWaitReportsCount()), 3);
            return false;
        }
        if (JRTask.getMaxReports() <= 0 || this.addFailedTaskToMonitor.getActiveAndWaitReportsCount() < JRTask.getMaxReports()) {
            return true;
        }
        if (runRptTaskRoot instanceof ViewRptTask && ((RunRptTask)runRptTaskRoot).isWait()) {
            return true;
        }
        try {
            Thread.sleep(600000L);
            ServiceLogger.logDebug(6600110, 4);
        }
        catch (InterruptedException interruptedException) {
            ServiceLogger.logError(interruptedException, 3);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incThreadQueueController(ThreadQueueElement[] threadQueueElementArray) {
        int n = this.addFailedTaskToMonitor.queueUp(threadQueueElementArray);
        if (n > 0) {
            Vector vector = this.addFinishedTaskToMonitor;
            synchronized (vector) {
                this.canRunReportInOrg += n;
            }
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incThreadQueueController(ThreadQueueElement threadQueueElement) {
        boolean bl = this.addFailedTaskToMonitor.queueUp(threadQueueElement);
        if (bl) {
            Vector vector = this.addFinishedTaskToMonitor;
            synchronized (vector) {
                ++this.canRunReportInOrg;
            }
        }
        return bl;
    }

    public void incRptSetEngineRef(Object object) {
        if (object != null) {
            this.addRecord.add(object);
        }
    }

    public void incRptEngineRef(Object object) {
        if (object != null) {
            this.addFinishedTaskToMonitor.addElement(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConCurrentReports() {
        Vector vector = this.addFinishedTaskToMonitor;
        synchronized (vector) {
            return this.canRunReportInOrg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incRptTaskRef(Object object) {
        Vector vector = this.addRunningTask;
        synchronized (vector) {
            if (object != null) {
                this.addRunningTask.addElement(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRptTaskRef(Object object) {
        Vector vector = this.addRunningTask;
        synchronized (vector) {
            if (object != null) {
                this.addRunningTask.removeElement(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskIntf getTask(String string) {
        Vector vector = this.addRunningTask;
        synchronized (vector) {
            int n = this.addRunningTask.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.addRunningTask.elementAt(i);
                if (e instanceof RunRptTaskRoot && ((RunRptTaskRoot)e).getRunTaskId().equals(string)) {
                    return (RunRptTaskRoot)e;
                }
                if (!(e instanceof TaskIntf) || !((TaskIntf)e).getId().equals(string)) continue;
                return (TaskIntf)e;
            }
            return null;
        }
    }

    public List getEngineErrors(String string) {
        List list = null;
        if (string != null) {
            list = this.containsKey.getErrors(string);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRptSetEngineRef(Object object) {
        if (object != null) {
            JREngine jREngine = null;
            if (object instanceof JREngineContext) {
                jREngine = ((JREngineContext)object).getJREngine();
            }
            if (jREngine != null) {
                Vector vector = this.addRecord;
                synchronized (vector) {
                    this.addRecord.remove(jREngine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRptEngineRef(Object object, ThreadQueueElement threadQueueElement) {
        if (!this.addFailedTask) {
            ServiceLogger.logError("TaskManager::decRptEngineRef: task manager has stopped.", 3);
            return;
        }
        boolean bl = this.addFailedTaskToMonitor.notifyRelease(threadQueueElement);
        if (object != null) {
            ReportEngineAPI reportEngineAPI = null;
            if (object instanceof JRReportEngine) {
                reportEngineAPI = ((JRReportEngine)object).getReportEngineAPI();
            }
            if (reportEngineAPI != null) {
                Vector vector = this.addFinishedTaskToMonitor;
                synchronized (vector) {
                    if (this.addFinishedTaskToMonitor.removeElement(reportEngineAPI)) {
                        --this.canRunReportInOrg;
                    }
                }
            }
        } else if (bl) {
            Vector vector = this.addFinishedTaskToMonitor;
            synchronized (vector) {
                --this.canRunReportInOrg;
            }
        }
    }

    public ConcurrentReportManager getConcurrentReportManager() {
        return this.addFailedTaskToMonitor;
    }

    public void afterLoadReport(ReportEngine reportEngine) {
    }

    public void addPipelineFilenames(String string, HtmlPipeFileNames htmlPipeFileNames) {
        if (string != null && string.length() > 0) {
            this.addRunningTaskToMonitor.put(string, htmlPipeFileNames);
            if (htmlPipeFileNames instanceof HtmlPipeFileNamesImpl) {
                this.addTask.put(string, (HtmlPipeFileNamesImpl)htmlPipeFileNames);
            }
        }
    }

    public void removePipelineFilenames(String string) {
        if (string != null && string.length() > 0) {
            this.addRunningTaskToMonitor.remove(string);
            if (this.addTask.containsKey(string)) {
                this.addTask.remove(string);
            }
        }
    }

    public String getFilenames(String string, int n) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            HtmlPipeFileNames htmlPipeFileNames = (HtmlPipeFileNames)this.addRunningTaskToMonitor.get(string);
            if (htmlPipeFileNames == null) {
                htmlPipeFileNames = (HtmlPipeFileNames)this.addTask.get(string);
            }
            if (htmlPipeFileNames != null) {
                string2 = htmlPipeFileNames.getFilename(n);
            }
        }
        return string2;
    }

    public boolean canAutoRefresh(String string) {
        HtmlPipeFileNames htmlPipeFileNames;
        if (string != null && string.length() > 0 && (htmlPipeFileNames = (HtmlPipeFileNames)this.addRunningTaskToMonitor.get(string)) != null) {
            return htmlPipeFileNames.canAutoRefresh();
        }
        return false;
    }

    public boolean isHtmlPipeLine(String string) {
        HtmlPipeFileNames htmlPipeFileNames;
        if (string != null && string.length() > 0 && (htmlPipeFileNames = (HtmlPipeFileNames)this.addRunningTaskToMonitor.get(string)) != null) {
            return htmlPipeFileNames.isHtmlPipeLine();
        }
        return false;
    }

    public void setRefreshed(String string, boolean bl) {
        HtmlPipeFileNames htmlPipeFileNames;
        if (string != null && string.length() > 0 && (htmlPipeFileNames = (HtmlPipeFileNames)this.addRunningTaskToMonitor.get(string)) != null) {
            htmlPipeFileNames.setRefreshed(bl);
        }
    }

    private Properties addFailedTask(String string, String string2, String string3, Properties properties) throws RptServerException {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if (string != null) {
            properties2.put("jrs.uid", string);
        }
        if (string2 != null) {
            properties2.put("jrs.catalog", string2);
        }
        if (string3 != null) {
            properties2.put("jrs.report", string3);
        }
        return properties2;
    }

    public void prepareRslt(String string) {
        this.addFailedTaskToMonitor();
        if (string != null) {
            this.addTerminationListener.put(string, new TempRstInfo());
        }
    }

    public void completeOndemand(String string) {
        if (string != null) {
            this.ondemandManager.notifyOndemandCompleted(string);
            this.htOndemands.remove(string);
            this.htOndemandThreads.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeRslt(String string, Object object) {
        if (string != null) {
            this.lrptMan.notifyCompleted(string);
            TempRstInfo tempRstInfo = (TempRstInfo)this.addTerminationListener.get(string);
            if (tempRstInfo != null) {
                TempRstInfo tempRstInfo2 = tempRstInfo;
                synchronized (tempRstInfo2) {
                    tempRstInfo.endTime = System.currentTimeMillis();
                    tempRstInfo.status = object;
                }
            }
        }
    }

    public String getRunRptErrMsg(String string) {
        String string2;
        TempRstInfo tempRstInfo;
        String string3 = null;
        if (string != null && (tempRstInfo = (TempRstInfo)this.addTerminationListener.get(string2 = string)) != null && tempRstInfo.status != null && !(tempRstInfo.status instanceof Boolean)) {
            string3 = tempRstInfo.status.toString();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTempResultReady(String string) {
        String string2;
        TempRstInfo tempRstInfo;
        boolean bl = true;
        if (string != null && (tempRstInfo = (TempRstInfo)this.addTerminationListener.get(string2 = string)) != null) {
            TempRstInfo tempRstInfo2 = tempRstInfo;
            synchronized (tempRstInfo2) {
                if (tempRstInfo.endTime < 0L) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String waitTempResultReady(String string) throws InterruptedException {
        String string2 = string;
        while (!this.isTempResultReady(string)) {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        return this.getRunRptErrMsg(string);
    }

    private void addFailedTaskToMonitor() {
        Enumeration enumeration = this.addTerminationListener.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            TempRstInfo tempRstInfo = (TempRstInfo)this.addTerminationListener.get(string);
            if (tempRstInfo == null || System.currentTimeMillis() - tempRstInfo.startTime <= SchdTools.TIMEOUT) continue;
            this.addTerminationListener.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTask(Launchable launchable, boolean bl) {
        if (launchable == null) {
            return false;
        }
        Thread thread = (Thread)this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.get(launchable);
        if (thread == null) {
            return false;
        }
        launchable.setRuntimeErrorHappened();
        launchable.setCanceled();
        launchable.setMessage(JCliResource.getMessage("CS_ERR_52") + "!");
        launchable.beforeStopLaunch(thread, bl);
        thread.interrupt();
        try {
            thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            ServiceLogger.logError(interruptedException, 3);
        }
        if (thread.isAlive()) {
            ServiceLogger.logDebug(5600149, thread.getName(), 5);
            thread.stop();
        } else {
            ServiceLogger.logDebug(5600150, thread.getName(), 5);
        }
        TaskIntf taskIntf = ((LaunchableObj)launchable).getTask();
        if (taskIntf instanceof RunRptTaskRoot) {
            this.createActiveTaskRecord.notifyTaskFinished(((RunRptTaskRoot)taskIntf).getRunTaskId());
        }
        if (this.booleanValue > 0) {
            Hashtable hashtable = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME;
            synchronized (hashtable) {
                this.addRunningTask();
            }
        }
        return true;
    }

    @Override
    public Enumeration getAll() {
        return this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.keys();
    }

    @Override
    public boolean stopActiveTask(String string) {
        return this.stopActiveTask(string, false, false);
    }

    public boolean stopActiveTask(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        LaunchableObj launchableObj = null;
        TaskIntf taskIntf = null;
        Enumeration enumeration = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.keys();
        while (enumeration.hasMoreElements()) {
            launchableObj = (LaunchableObj)enumeration.nextElement();
            taskIntf = launchableObj.getTask();
            if (taskIntf == null || !taskIntf.getId().equals(string)) continue;
            if (taskIntf instanceof RunRptTask && !((RunRptTask)taskIntf).canCancelRecoveryTask() && ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6600148, taskIntf.getId(), 6);
            }
            ServiceLogger.logDebug(5600297, new Object[]{taskIntf.getId(), bl}, 5);
            taskIntf.stopExec(bl);
            this.cancelTask(launchableObj, bl2);
            bl3 = true;
        }
        return bl3;
    }

    public void checkActiveTaskDuration() {
        Enumeration enumeration = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            boolean bl;
            LaunchableObj launchableObj = (LaunchableObj)enumeration.nextElement();
            TaskIntf taskIntf = launchableObj.getTask();
            if (taskIntf == null) continue;
            long l = launchableObj.getStartTime();
            long l2 = (Long)taskIntf.getValue("jrs.task_duration");
            if (l2 <= 0L || l <= 0L || System.currentTimeMillis() - l <= l2 || ((JRTask)taskIntf).hasHandledDuration()) continue;
            ((JRTask)taskIntf).setHandledDuration(true);
            boolean bl2 = (Boolean)taskIntf.getValue("jrs.auto_cancel_task");
            if (bl2) {
                ServiceLogger.logDebug(5600297, new Object[]{taskIntf.getId(), false}, 5);
                taskIntf.stopExec();
                this.cancelTask(launchableObj, false);
                ServiceLogger.logEvent("Cancelled Schedule Task, task ID:" + taskIntf.getId() + ", report: " + ((RunRptTaskRoot)taskIntf).getReport() + ", catalog: " + ((RunRptTaskRoot)taskIntf).getCatalog() + ", started time: " + new Date(l));
            }
            if (!(bl = ((Boolean)taskIntf.getValue("jrs.need_notify_duration")).booleanValue()) || (string = (String)taskIntf.getValue("jrs.duration_notify_mail")) == null || string.length() <= 0) continue;
            String string2 = " Task Type: Schedule Run\nTask ID: " + taskIntf.getId() + "\nReport: " + ((RunRptTaskRoot)taskIntf).getReport() + "\nCatalog:" + ((RunRptTaskRoot)taskIntf).getCatalog() + "\nTask Status: " + ((JRTask)taskIntf).getStatus() + "\nTask Start Time: " + new Date(l) + "\nNotify Time: " + new Date(System.currentTimeMillis()) + "\nDuration: " + l2 / 60000L + " minute(s)" + "\nActive: " + (bl2 ? "false, the task has been auto canceled" : "true, the task still running") + "\nDescription: Running this report will require more time than the specified minutes in 'Duration'!";
            CSMail cSMail = new CSMail(string, null, null, "Task Timeout Notification", string2, false);
            ((JRTask)taskIntf).execTimeoutNotification(cSMail);
        }
    }

    @Override
    public boolean stopActiveTaskByUser(String string, String string2) {
        boolean bl = false;
        LaunchableObj launchableObj = null;
        TaskIntf taskIntf = null;
        Enumeration enumeration = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.keys();
        while (enumeration.hasMoreElements()) {
            launchableObj = (LaunchableObj)enumeration.nextElement();
            if (ServerEnv.needSecurity() && !launchableObj.getUid().equalsIgnoreCase(string2) || (taskIntf = launchableObj.getTask()) == null || !taskIntf.getId().equals(string)) continue;
            if (taskIntf instanceof RunRptTask && !((RunRptTask)taskIntf).canCancelRecoveryTask() && ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6600148, taskIntf.getId(), 6);
            }
            ServiceLogger.logDebug(5600297, new Object[]{taskIntf.getId(), false}, 5);
            taskIntf.stopExec();
            this.cancelTask(launchableObj, false);
            bl = true;
        }
        return bl;
    }

    public synchronized void addStartListener(StartListener startListener) {
        if (!this.addWaitingTask.contains(startListener)) {
            this.addWaitingTask.addElement(startListener);
        }
    }

    public synchronized void removeStartListener(StartListener startListener) {
        this.addWaitingTask.removeElement(startListener);
    }

    private synchronized void addFinishedTask(Object object) {
        StartListener startListener = null;
        for (int i = this.addWaitingTask.size() - 1; i >= 0; --i) {
            startListener = (StartListener)this.addWaitingTask.elementAt(i);
            startListener.started(object);
        }
    }

    public synchronized void addTerminationListener(TerminationListener terminationListener) {
        if (!this.addWaitingTaskToMonitor.contains(terminationListener)) {
            this.addWaitingTaskToMonitor.addElement(terminationListener);
        }
    }

    public synchronized void removeTerminationListener(TerminationListener terminationListener) {
        this.addWaitingTaskToMonitor.removeElement(terminationListener);
    }

    private synchronized void addFinishedTaskToMonitor(Object object) {
        TerminationListener terminationListener = null;
        for (int i = this.addWaitingTaskToMonitor.size() - 1; i >= 0; --i) {
            terminationListener = (TerminationListener)this.addWaitingTaskToMonitor.elementAt(i);
            try {
                terminationListener.terminated(object);
                continue;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    public JRResourceManager getResourceManager() {
        return this.TIMEOUT;
    }

    public MonitorThread getMonitorRunning() {
        return this.add;
    }

    public void setMonitorRunning(MonitorThread monitorThread) {
        this.add = monitorThread;
    }

    public void addMonitorThreadRunningReport(ViewRptTask viewRptTask) {
        if (this.add == null) {
            this.add = new MonitorThread();
        }
        if (viewRptTask.getCatalog() != null && viewRptTask.getReport() != null) {
            this.add.notifyAddRunningReport(viewRptTask.getLaunchType(), viewRptTask.getTaskClass(), new Date(), viewRptTask.getSubmitTime(), viewRptTask.getUid(), viewRptTask.getCatalog(), viewRptTask.getReport(), viewRptTask.getParamFile(), viewRptTask.getId(), viewRptTask.getRunName(), viewRptTask.getRunPort(), viewRptTask.getPublishType());
        }
    }

    public void addMonitorThreadRunningReport(int n, String string, Date date, Date date2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this.getMonitorRunning().notifyAddRunningReport(n, string, date, date2, string2, string3, string4, string5, string6, string7, string8, string9);
    }

    public void delToMonitorRunningReport(String string) {
        if (this.add == null) {
            this.add = new MonitorThread();
        }
        if (string != null) {
            this.add.notifyDelRunningReport(string);
        }
    }

    public void addToMonitorFinishedReport(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, Vector vector, Vector vector2, int n2, String string9, long l, long l2, long l3, long l4, String string10, String string11, String string12) {
        if (this.add == null) {
            this.add = new MonitorThread();
            this.setMonitorRunning(this.add);
        }
        this.add.notifyaddFinishedReport(string, string2, n, string3, string4, string5, string6, string7, string8, vector, vector2, n2, string9, l, l2, l3, l4, string10, string11, string12);
    }

    public void notifyAddQueueToMonitor(String string, long l) {
        this.add.notifyAddQueueReport(string, l);
    }

    public void notifyAddRunPort(String string, String string2, String string3) {
        this.add.notifyAddRunPort(string, string2, string3);
    }

    private boolean addRecord(String string) {
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            String[] stringArray = new String[]{"jet.server.jrc.security.ldap.LDAPSynchronizeTask", "jet.server.schedule.jrtasks.ExportInATypeTask", "jet.server.schedule.jrtasks.ExportTask", "jet.server.schedule.jrtasks.PrintRptTask", "jet.server.schedule.jrtasks.PublishCRDTask", "jet.server.schedule.jrtasks.PublishRptTask", "jet.server.schedule.jrtasks.PublishToDiskTask", "jet.server.schedule.jrtasks.SendJRMailTask", "jet.server.schedule.jrtasks.SendMailTask", "jet.server.schedule.jrtasks.UpdateRptTask", "jet.server.schedule.jrtasks.UserTaskProxy", "jet.server.schedule.jrtasks.ValueTriggerTask", "jet.server.schedule.jrtasks.ViewRptTask", "jet.server.schedule.jrtasks.ViewTestRptTask"};
            Class[] classArray = null;
            try {
                classArray = new Class[]{Class.forName("jet.cs.TaskIntf")};
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceLogger.logError(classNotFoundException);
            }
            if (WebSecurityUtil.validateReflectClass(string, stringArray, classArray) != null) {
                bl = true;
            } else {
                ServiceLogger.logError(3670155, new Object[]{string}, 3);
            }
        }
        return bl;
    }

    public Object makeTask(Properties properties) throws Exception {
        Serializable serializable;
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        String string3;
        String string4;
        Object object4;
        properties = (Properties)properties.clone();
        boolean bl = CSUtil.getBoolean((String)properties.get("exportResultInAType"), false);
        String string5 = (String)properties.get("jrs.report");
        String string6 = (String)properties.get("jrs.catalog");
        String string7 = properties.getProperty("jrs.uid");
        String string8 = (String)properties.get("jrs.task_class");
        if (string8 == null || string8.trim().length() == 0) {
            throw new JSException(600039, new Object[]{properties}, null);
        }
        boolean bl2 = false;
        if (!string8.equals(ExportInATypeTask.class.getName()) && string6 == null && string5 != null && (object4 = this.TIMEOUT.getPathInfo(string7, string5)).isEnableLinkedCatalog()) {
            if (!object4.isUseInherited()) {
                string6 = object4.getLinkedCatalog();
            }
            if (string6 == null) {
                string6 = this.TIMEOUT.getInheritedLinkedCatalog(string7, string5);
            }
            if (string6 != null) {
                bl2 = true;
                properties.put("jrs.catalog", string6);
            }
        }
        if (string5 != null && string6 != null) {
            int n = CSUtil.parseInt((String)properties.get("jrs.cat_version"), -1);
            int n2 = CSUtil.parseInt((String)properties.get("jrs.rpt_version"), -1);
            if (!bl) {
                string4 = (String)properties.get("jrs.report");
                string3 = (String)properties.get("jrs.catalog");
                if (bl2 || n == -1 && string3 != null && string3.trim().length() != 0) {
                    n = this.TIMEOUT.getLatestVersionNumber((String)properties.get("jrs.catalog"), string7);
                    properties.put("jrs.cat_version", String.valueOf(n));
                }
                if (string4 != null && string4.indexOf("/") == -1) {
                    if (string3 != null) {
                        string3 = string3.substring(0, string3.lastIndexOf("/") + 1);
                        string4 = string3 + string4;
                    }
                    properties.put("jrs.report", string4);
                }
                if (n2 == -1) {
                    n2 = this.TIMEOUT.getLatestVersionNumber((String)properties.get("jrs.report"), string7);
                    properties.put("jrs.rpt_version", String.valueOf(n2));
                }
            }
        }
        object4 = null;
        JRServerInfo jRServerInfo = null;
        if (string8.equals(ViewRptTask.class.getName())) {
            boolean bl3;
            boolean bl4 = CSUtil.getBoolean(properties.getProperty("jrs.has_task_listener"), false);
            string3 = properties.getProperty("jrs.task_listener_class");
            if (bl4 && JRTUtil.validateTaskListenerClass(string3)) {
                object4 = (TaskListener)Class.forName(string3.trim()).newInstance();
            }
            object2 = (object3 = properties.get("jrs.schd_props")) instanceof String ? CSUtil.parseQuery((String)object3) : (object3 instanceof Properties ? (Properties)((Properties)object3).clone() : (Properties)properties.clone());
            jRServerInfo = new JRServerInfo((Properties)object2);
            if (properties.get("jrs.request_url") != null) {
                jRServerInfo.setRequestURL((String)properties.get("jrs.request_url"));
            }
            if (properties.get("jrs.remote_addr") != null) {
                jRServerInfo.setRemoteAddr((String)properties.get("jrs.remote_addr"));
            }
            int n = (bl3 = CSUtil.getBoolean((String)properties.get("is_direct_run"), false)) ? 0 : 2;
            JRTUtil.validateParameter(properties, n, this.getResourceManager(), (TaskListener)object4, jRServerInfo);
            ParamUtil.processReportParamSetting(string7, properties);
        } else if (!string8.equals(ExportInATypeTask.class.getName())) {
            string4 = (String)properties.get("jrs.launch_type");
            int n = string4 == null ? 0 : CSUtil.parseInt(string4);
            ServiceLogger.logDebug("JRTaskManager.makeTask(case-63668): evaluateParameter?" + (n != 0) + ", prop=" + properties);
            if (n != 0) {
                JRTUtil.evaluateParameter(properties, this.getResourceManager(), jRServerInfo);
                ServiceLogger.logDebug("JRTaskManager.makeTask(case-63668): prop=" + properties);
            }
        }
        Map map = (Map)properties.get("display_parameters_values");
        properties.remove("display_parameters_values");
        if (!this.addRecord(string8)) {
            throw new JSException(600062, new Object[]{string8}, null);
        }
        Object object5 = Class.forName(string8.trim()).newInstance();
        if (object5 instanceof JRTask) {
            ((JRTask)object5).setJRTaskManager(this);
            ((JRTask)object5).setTaskListener((TaskListener)object4);
            ((JRTask)object5).setServerInfo(jRServerInfo);
        }
        if (object5 instanceof CustomTaskIntf) {
            ((CustomTaskIntf)object5).init((Properties)properties.clone());
        }
        if (object5 instanceof InternalStorableTask) {
            ((InternalStorableTask)object5).init((Properties)properties.clone());
            ((InternalStorableTask)object5).setDataService(this.HTML_PIPE_FILE_NAMES);
        }
        if (object5 instanceof UserTask) {
            object3 = (Properties)properties.clone();
            object2 = (Properties)((Properties)object3).get("jrs.schd_props");
            if (object2 != null) {
                String[] stringArray = new String[]{"jrs.report", "jrs.rpt_version", "jrs.catalog", "jrs.cat_version"};
                String string9 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    string9 = stringArray[i];
                    if (!((Properties)object2).containsKey(string9)) continue;
                    ((Properties)object3).put(string9, ((Properties)object2).remove(string9));
                }
                object = ((Properties)object3).keys();
                while (object.hasMoreElements()) {
                    string9 = (String)object.nextElement();
                    if (!((Properties)object2).containsKey(string9)) continue;
                    ((Properties)object3).remove(string9);
                }
            }
            ((Properties)object3).remove("jrs.schd_props");
            ((UserTask)object5).initReportProperties((Properties)object3);
            String string10 = (String)((Properties)object3).get("jrs.user_task_prop");
            if (string10 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string10, "\t\n\r\f&");
                object = null;
                string2 = null;
                string = null;
                int n = 0;
                serializable = new Properties();
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    n = ((String)object).indexOf("=");
                    if (n <= 0) continue;
                    string2 = CSUtil.convertEscapes(((String)object).substring(0, n).trim());
                    string = n > ((String)object).length() - 1 ? null : CSUtil.convertEscapes(((String)object).substring(n + 1).trim());
                    if (string == null) continue;
                    ((Properties)serializable).setProperty(string2, string);
                }
                if (!((Properties)serializable).isEmpty()) {
                    ((UserTask)object5).initUserTaskProperties((Properties)serializable);
                }
            }
            UserTaskProxy userTaskProxy = new UserTaskProxy((UserTask)object5);
            userTaskProxy.setJRTaskManager(this);
            userTaskProxy.init((Properties)object3);
            object5 = userTaskProxy;
        }
        object3 = (TaskIntf)object5;
        if (string8.equals(PublishCRDTask.class.getName()) && (object2 = (String)properties.get("jrs.task_id")) != null) {
            object3.setId((String)object2);
        }
        object2 = null;
        object2 = (Long)properties.remove("TS_tsk_submit");
        if (object2 == null) {
            object2 = new Long(System.currentTimeMillis());
        }
        object3.putValue("TS_tsk_submit", object2);
        if (string8.trim().equals(ViewRptTask.class.getName())) {
            object3.putValue("VI_tsk_type", new Integer(0));
        } else {
            object3.putValue("VI_tsk_type", new Integer(1));
        }
        long l = this.addFailedTaskToMonitor.hasQueueController() ? (long)this.addFailedTaskToMonitor.getActiveAndWaitReportsCount() : 0L;
        object2 = new Long((long)this.assertCheck.size() + l);
        object3.putValue("NC_que_length", object2);
        object3.putValue("TS_eng_start", new Long(System.currentTimeMillis()));
        object3.putValue("TS_eng_exits", new Long(System.currentTimeMillis()));
        object3.putValue("TC_eng_total", new Long(0L));
        object3.putValue("TC_eng_load", new long[]{0L});
        object3.putValue("TC_eng_export", new long[]{0L});
        object3.putValue("TC_eng_other", new Long(0L));
        object3.putValue("NC_rpt_pages", new Long(0L));
        object3.putValue("NC_rpt_formats", new Long(0L));
        object3.putValue("NC_eng_concurrent", new Long(0L));
        object3.putValue("VS_rpt_name", "null");
        object = properties.getProperty("jrs.triggers");
        if (object != null && ((String)object).trim().length() > 0) {
            object3.putValue("jrs.triggers", object);
        }
        if ((string2 = properties.getProperty("jrs.triggers.logic")) != null && string2.trim().length() > 0) {
            object3.putValue("jrs.triggers.logic", string2);
        }
        object3.putValue("jrs.task_duration", new Long(CSUtil.parseLong(properties.getProperty("jrs.task_duration"), 0L) * 60L * 1000L));
        object3.putValue("jrs.need_notify_duration", new Boolean(CSUtil.getBoolean(properties.getProperty("jrs.need_notify_duration"), false)));
        if (properties.getProperty("jrs.duration_notify_mail") != null) {
            object3.putValue("jrs.duration_notify_mail", properties.getProperty("jrs.duration_notify_mail"));
        }
        object3.putValue("jrs.auto_cancel_task", new Boolean(CSUtil.getBoolean(properties.getProperty("jrs.auto_cancel_task"), false)));
        if (map != null) {
            object3.putValue("display_parameters_values", map);
        }
        if (object3 instanceof RunRptTaskRoot) {
            string = ((RunRptTaskRoot)object3).getRunTaskId();
            String string11 = ((RunRptTaskRoot)object3).getParamFile();
            serializable = this.createActiveTaskRecord.getTaskRecord(string);
            if (serializable != null && string11 != null && string11.length() > 0) {
                String string12 = this.TIMEOUT.getHistDir();
                if (string11.startsWith(string12)) {
                    string11 = string11.substring(string12.length());
                }
                ((JRTaskRecord)serializable).setParamFile(string11);
                this.createActiveTaskRecord.updateTaskRecord((JRTaskRecord)serializable);
            }
        }
        return object5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        while (this.addFailedTask) {
            Object object = this.available;
            synchronized (object) {
                try {
                    this.available.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) continue;
            object = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME;
            synchronized (object) {
                this.addRunningTask();
            }
        }
    }

    private void addRunningTask() {
        while (this.assertCheck.size() > 0 && this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.size() < this.booleanValue) {
            try {
                Object object;
                Properties properties = (Properties)this.assertCheck.pull();
                LaunchableObj launchableObj = this.J(properties);
                launchableObj.setUid(properties.getProperty("jrs.uid"));
                launchableObj.addTerminationListener(this);
                Vector vector = ReportInfoCache.getCachedParams(properties.getProperty("jrs.engine_id"));
                if (null != vector) {
                    object = new Properties();
                    for (ParamDesc paramDesc : vector) {
                        if (!paramDesc.isMultipleValue()) {
                            ((Properties)object).put(paramDesc.getPrompt(), paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault()));
                            continue;
                        }
                        if (paramDesc.isAllSelected()) {
                            ((Properties)object).put(paramDesc.getPrompt(), "ALL");
                            continue;
                        }
                        String[] stringArray = paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), Locale.getDefault());
                        StringBuffer stringBuffer = new StringBuffer();
                        for (String string : stringArray) {
                            stringBuffer.append("," + string);
                        }
                        if (stringArray.length > 0) {
                            ((Properties)object).put(paramDesc.getPrompt(), stringBuffer.substring(1));
                            continue;
                        }
                        ((Properties)object).put(paramDesc.getPrompt(), "");
                    }
                    ((JRTaskAuditor)this.currentThread).setTaskParameters(launchableObj.getTask().getId(), (Map)object);
                }
                object = new Thread(launchableObj);
                ((Thread)object).start();
                this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.put(launchableObj, object);
                this.addFinishedTask(launchableObj);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    public synchronized void sendTaskContext(TaskIntf taskIntf) {
        Hashtable hashtable = taskIntf.getTaskContext();
        hashtable.put("VI_tsk_status", new Integer(taskIntf.hasError() ? 0 : 1));
        String string = (String)hashtable.get("VS_rpt_name");
        if (string.endsWith(".cls")) {
            hashtable.put("Task_type", "DHTML");
        } else {
            hashtable.put("Task_type", "Non-DHTML");
        }
        long l = (Long)hashtable.get("TS_tsk_submit");
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        hashtable.put("TC_tsk_total", new Long(l3));
        long l4 = (Long)hashtable.get("TS_eng_start") - l;
        hashtable.put("TC_tsk_waited", new Long(l4));
        long l5 = (Long)hashtable.get("TC_eng_total");
        hashtable.put("TC_tsk_other", new Long(l3 - l4 - l5));
        hashtable.put("TS_tsk_complete", new Long(l2));
        long[] lArray = (long[])hashtable.remove("TC_eng_load");
        long[] lArray2 = (long[])hashtable.remove("TC_eng_export");
        for (int i = 0; i < lArray.length; ++i) {
            hashtable.put("TC_eng_load", new Long(lArray[i]));
            hashtable.put("TC_eng_export", new Long(lArray2[i]));
            long l6 = l5 - lArray[i] - lArray2[i];
            hashtable.put("TC_eng_other", new Long(l6));
            try {
                ServerEnv.getEventQueue().postEvent("TaskContext", 0, hashtable, 1);
                continue;
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
        }
    }

    public void deleteOndemandReport(String string) {
        this.deleteOndemandReport(string, false);
    }

    public void deleteOndemandReport(String string, boolean bl) {
        ViewRptTask viewRptTask = (ViewRptTask)this.htOndemands.remove(string);
        RunRptThread runRptThread = (RunRptThread)this.htOndemandThreads.remove(string);
        this.addTask(viewRptTask, runRptThread, bl);
        if (viewRptTask.isHtmlPipeLine()) {
            this.removePipelineFilenames(viewRptTask.getHtmName());
        }
        this.htOndemands.remove(string);
    }

    private void addRunningTaskToMonitor(ViewRptTask viewRptTask, RunRptThread runRptThread) {
        this.addTask(viewRptTask, runRptThread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(ViewRptTask viewRptTask, RunRptThread runRptThread, boolean bl) {
        ServiceLogger.logDebug(5600296, new Object[]{viewRptTask.getId(), bl}, 5);
        Object object = this.close;
        synchronized (object) {
            if (viewRptTask != null) {
                viewRptTask.stopExec(bl);
            }
            if (runRptThread != null && runRptThread.isAlive()) {
                runRptThread.interrupt();
                try {
                    runRptThread.join(3000L);
                }
                catch (InterruptedException interruptedException) {
                    ServiceLogger.logError(interruptedException, 3);
                }
                if (runRptThread.isAlive()) {
                    ServiceLogger.logDebug(5600149, runRptThread.getName(), 5);
                    runRptThread.stop();
                } else {
                    ServiceLogger.logDebug(5600150, runRptThread.getName(), 5);
                }
                runRptThread = null;
            }
        }
    }

    public void checkOndemandDuration() {
        Enumeration enumeration = this.htOndemands.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            ViewRptTask viewRptTask = (ViewRptTask)this.htOndemands.get(string);
            OndemandReportRecord ondemandReportRecord = this.ondemandManager.getOndemandReportRecord(string);
            if (ondemandReportRecord.isCompleted() || ondemandReportRecord.isCancelled() || viewRptTask.hasHandledDuration()) continue;
            long l = ondemandReportRecord.getStartedTime();
            long l2 = (Long)viewRptTask.getValue("jrs.task_duration");
            if (l2 <= 0L || System.currentTimeMillis() - l <= l2) continue;
            viewRptTask.setHandledDuration(true);
            boolean bl = (Boolean)viewRptTask.getValue("jrs.need_notify_duration");
            boolean bl2 = (Boolean)viewRptTask.getValue("jrs.auto_cancel_task");
            if (bl2) {
                object = (RunRptThread)this.htOndemandThreads.remove(string);
                this.addRunningTaskToMonitor(viewRptTask, (RunRptThread)object);
                ((JROndemandReportRecord)ondemandReportRecord).setDuration(l2);
                ((JROndemandReportRecord)ondemandReportRecord).setCancelled(true);
                ServiceLogger.logEvent("Cancelled ondemand report: " + viewRptTask.getReport() + ", catalog: " + viewRptTask.getCatalog() + ", started time: " + new Date(l));
            }
            if (!bl || (object = (String)viewRptTask.getValue("jrs.duration_notify_mail")) == null || ((String)object).length() <= 0) continue;
            String string2 = " Task Type: Ondemand Run\nTask ID: " + viewRptTask.getId() + "\nReport: " + viewRptTask.getReport() + "\nCatalog:" + viewRptTask.getCatalog() + "\nTask Status: " + viewRptTask.getStatus() + "\nTask Start Time: " + new Date(l) + "\nNotify Time: " + new Date(System.currentTimeMillis()) + "\nDuration: " + l2 / 60000L + " minute(s)" + "\nActive: " + (bl2 ? "false, the task has been auto canceled" : "true, the task still running") + "\nTemp Result: " + viewRptTask.getResult() + "\nDescription: Running this report will require more time than the specified minutes in 'Duration'!";
            CSMail cSMail = new CSMail((String)object, null, null, "Task Timeout Notification", string2, false);
            viewRptTask.execTimeoutNotification(cSMail);
        }
    }

    public void postEventToQueue(int n, Properties properties) {
        if (!this.addFailedTask) {
            ServiceLogger.logError("TaskManager::postEventToQueue: task manager has stopped.", 3);
            return;
        }
        int n2 = n == 0 || n == 1 ? 0 : 1;
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, n, properties, n2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    static JRActiveTaskRecord createActiveTaskRecord(LaunchableObj launchableObj, JRResourceManager jRResourceManager) {
        String string;
        String string2;
        Object object;
        Object object2;
        TaskIntf taskIntf = launchableObj.getTask();
        if (!(taskIntf instanceof CustomTask)) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string9 = null;
        if (taskIntf instanceof RunRptTaskRoot) {
            object2 = (RunRptTaskRoot)taskIntf;
            string3 = ((RunRptTaskRoot)object2).getEngMsgs();
            string4 = ((RunRptTaskRoot)object2).getCatalog();
            string5 = ((RunRptTaskRoot)object2).getReport();
            object = ((RunRptTaskRoot)object2).getRunningReportSheets().getAllReportSheets();
            if (object != null) {
                while (object.hasMoreElements()) {
                    stringBuffer.append(((RunRptTaskRoot)object2).getRunningReportSheets().getReportSheetDisplayName((String)object.nextElement()));
                    if (!object.hasMoreElements()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.length() > 1) {
                    stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
            } else {
                stringBuffer.append(string5);
            }
            string6 = ((RunRptTaskRoot)object2).getPublishType();
            string7 = ((RunRptTaskRoot)object2).getParamFile();
            string2 = jRResourceManager.getHistDir();
            if (string7 != null && string7.indexOf(string2) >= 0) {
                string7 = string7.substring(string2.length());
            }
            string8 = ((RunRptTaskRoot)object2).getTaskName();
            string9 = ((JRTask)object2).getRunTaskId();
        }
        object2 = taskIntf.getClass().getName();
        if (taskIntf instanceof UserTaskProxy) {
            object = (UserTaskProxy)taskIntf;
            object2 = ((UserTaskProxy)object).getTaskClass();
            string8 = ((UserTaskProxy)object).getTaskName();
            string4 = ((UserTaskProxy)object).getCatalog();
            string5 = ((UserTaskProxy)object).getReport();
            string6 = ((UserTaskProxy)object).getPublishType();
            string7 = ((UserTaskProxy)object).getParamFile();
            string2 = jRResourceManager.getHistDir();
            if (string7 != null && string7.indexOf(string2) >= 0) {
                string7 = string7.substring(string2.length());
            }
            string9 = ((JRTask)object).getRunTaskId();
        }
        object = new JRActiveTaskRecord(new Date(launchableObj.getStartTime()), string3, launchableObj.getUid(), taskIntf.getId(), (String)object2, launchableObj.getLaunchType(), string4, string5, string7, string6, string8, stringBuffer.toString(), string9);
        string2 = (String)taskIntf.getValue("jrs.triggers");
        if (string2 != null && string2.trim().length() > 0) {
            ((JRActiveTaskRecord)object).setTrigger(string2);
        }
        if ((string = (String)taskIntf.getValue("jrs.triggers.logic")) != null && string.trim().length() > 0) {
            ((JRActiveTaskRecord)object).setLogicOfConditions(string);
        }
        return object;
    }

    public void addWaitingTaskToMonitor(String string, String string2, int n, String string3, long l, String string4, String string5, int n2) {
        this.assertCheck(new String[]{string, string2, string3, string4, string5});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        if (string2 != null) {
            properties.put(RPT_NAME, string2);
        }
        properties.put(TASK_TYPE, String.valueOf(n));
        if (string3 != null) {
            properties.put(SERVER_NAME, string3);
        }
        properties.put(SUBMIT_TIME, String.valueOf(l));
        if (string4 != null) {
            properties.put(RPT_SOURCE, string4);
        }
        if (string5 != null) {
            properties.put(USER_NAME, string5);
        }
        properties.put(TASK_STATUS, String.valueOf(n2));
        if (n2 == 1) {
            this.copyAllFiles.addTask(properties);
        }
        this.postEventToQueue(0, properties);
        if (null != string2 && 0 != string2.length()) {
            Properties properties2 = new Properties();
            this.currentThread.taskSubmitted(string, n, l, string5, properties2);
            this.currentThread.setTaskReport(string, string2);
            this.currentThread.setTaskCatalog(string, string4);
        }
    }

    public void addWaitingTaskToMonitor(String string, String string2, String string3, int n, String string4, long l, String string5, String string6, int n2) {
        Tracker.getInstance().getTaskStatus().addWaitingTask(string, string2, string3, n, string4, l, string5, string6, n2);
        this.addWaitingTaskToMonitor(string2, string3, n, string4, l, string5, string6, n2);
        this.addTerminationListener();
    }

    public void addRunningTaskToMonitor(String string, long l) {
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string2 = "localhost";
        }
        this.addRunningTaskToMonitor(string, string2, String.valueOf(ServerEnv.getActiveRMIPort()), l);
    }

    public void addRunningTaskToMonitor(String string, String string2, long l) {
        String string3 = "";
        try {
            string3 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string3 = "localhost";
        }
        this.addRunningTaskToMonitor(string, string2, string3, String.valueOf(ServerEnv.getActiveRMIPort()), l);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, long l) {
        this.addRunningTaskToMonitor(string, string2, string3, l, 4);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, String string4, long l) {
        this.addRunningTaskToMonitor(string, string2, string3, string4, l, 4);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, long l, int n) {
        this.assertCheck(new String[]{string, string2, string3});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(RUN_HOST, string2);
        properties.put(RUN_PORT, string3);
        properties.put(START_TIME, String.valueOf(l));
        properties.put(TASK_STATUS, String.valueOf(n));
        this.postEventToQueue(1, properties);
        if (-1L == l) {
            l = System.currentTimeMillis();
        }
        this.currentThread.taskStarted(string, l);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, String string4, long l, int n) {
        Tracker.getInstance().getTaskStatus().addRunningTask(string, string2, string3, string4, l, n);
        this.addRunningTaskToMonitor(string2, string3, string4, l, n);
        this.addTerminationListener();
    }

    public void addFinishedTaskToMonitor(String string, String string2, String string3, long l, int n, String string4, String string5, String string6, String string7) {
        this.assertCheck(new String[]{string, string2, string3, string4, string5, string6});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(RUN_HOST, string2);
        properties.put(RUN_PORT, string3);
        properties.put(FINISH_TIME, String.valueOf(l));
        properties.put(RPT_PAGES, String.valueOf(n < 0 ? 0 : n));
        properties.put(RST_FILE_NAME, string4);
        properties.put(REASON, string5);
        properties.put(ENGINE_INFO, string6);
        properties.put(TASK_STATUS, String.valueOf(9));
        this.copyAllFiles.updateTask(string7, n);
        this.postEventToQueue(2, properties);
        ((JRTaskAuditor)this.currentThread).taskFinished(string, l, n, string5, string4, string6);
    }

    public void addFinishedTaskToMonitor(String string, String string2, String string3, String string4, long l, int n, String string5, String string6, String string7, String string8) {
        Tracker.getInstance().getTaskStatus().addFinishedTask(string, string2, string3, string4, l, n, string5, string6, string7);
        this.addFinishedTaskToMonitor(string2, string3, string4, l, n, string5, string6, string7, string8);
        this.addTerminationListener();
    }

    public void addFailedTaskToMonitor(String string, String string2) {
        this.assertCheck(new String[]{string, string2});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(FAILED_INFO, string2 == null ? "" : string2);
        properties.put(TASK_STATUS, String.valueOf(10));
        this.postEventToQueue(3, properties);
        this.currentThread.taskFailed(string, System.currentTimeMillis(), string2 == null ? "" : string2);
    }

    public void addFailedTaskToMonitor(String string, String string2, String string3) {
        Tracker.getInstance().getTaskStatus().addFailedTask(string, string2, string3);
        this.addFailedTaskToMonitor(string2, string3);
        this.addTerminationListener();
    }

    public void assertCheck(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            ServiceLogger.logDebug(6600111, String.valueOf(i), 6);
        }
    }

    public SecurityContext getSecurityContext(String string, String string2, String string3, int n) {
        if (this.cancelTask == null) {
            return null;
        }
        return this.cancelTask.getSecurityContext(string, string2, string3, n);
    }

    public void setConnectionInfoProvider(ConnectionInfoProvider connectionInfoProvider) {
        this.clone = connectionInfoProvider;
    }

    public ConnectionInfoProvider getConnectionInfoProvider() {
        return this.clone;
    }

    private void addTerminationListener() {
        TaskStatus taskStatus = Tracker.getInstance().getTaskStatus();
        int n = taskStatus.getQueuingOnDemandReports() + taskStatus.getQueuingScheduleReports() + taskStatus.getRunningOnDemandReports() + taskStatus.getRunningScheduleReports() + taskStatus.getWaitingOnDemandReports() + taskStatus.getWaitingScheduleReports();
        this.createActiveTaskRecord.notifyPenddingReports(n);
    }

    public void dumpEnginesInfo() {
        Vector vector = (Vector)this.addRecord.clone();
        Tracker.dump(4600168, new Object[]{new Integer(vector.size())}, 4);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JREngine)) continue;
            try {
                ReportsetEngineInfo reportsetEngineInfo = new ReportsetEngineInfo();
                ((JREngine)e).getEngineInfo(reportsetEngineInfo);
                Tracker.dump(reportsetEngineInfo.toString());
                continue;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }

    public int getActiveReportsInQueue() {
        if (this.addFailedTaskToMonitor != null) {
            return this.addFailedTaskToMonitor.getActiveReportsCount();
        }
        return -1;
    }

    public int getWaitingReports() {
        return this.assertCheck.size();
    }

    public int getQueuingReports() {
        return this.addFailedTaskToMonitor.getWaitReportsCount();
    }

    @Override
    public synchronized void registeredMember(ReportMember reportMember) {
        if (this.addFailedTaskToMonitor.hasQueueController()) {
            int n = reportMember.getMaxConcurrentReports();
            this.booleanValue += n;
        }
    }

    @Override
    public synchronized void removeMember(ReportMember reportMember) {
        if (this.addFailedTaskToMonitor.hasQueueController()) {
            int n = reportMember.getMaxConcurrentReports();
            this.booleanValue -= n;
        }
    }

    @Override
    public Vector getAllTaskStatistics() {
        if (this.copyAllFiles != null) {
            return this.copyAllFiles.getStatistics();
        }
        return new Vector(0);
    }

    public TaskStatisticRecorder getTaskStatRecorder() {
        return this.copyAllFiles;
    }
}

