/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.jrc.JRLoadBalancer;
import jet.server.log.ServiceLogger;

public class JRWeightLoadBalancer
extends JRLoadBalancer {
    private static PropsTable CLUSTER_CONFIG_PROPERTIES = null;
    private static boolean SEDU = false;
    private static ClusterMap append;

    @Override
    protected float[] make(Member[] memberArray) {
        JRWeightLoadBalancer.loadWeights();
        float[] fArray2 = new float[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            fArray2[i] = ((ReportMember)memberArray[i]).getPenddingReports();
            float f = CSUtil.parseFloat((String)append.get(memberArray[i].getServerName()));
            if (f <= 0.0f) {
                f = 1.0f;
            }
            ServiceLogger.logDebug(6650032, new String[]{memberArray[i].getServerName(), "" + fArray2[i], "" + f}, 6);
            fArray2[i] = fArray2[i] / f;
        }
        return fArray2;
    }

    public static void save(ExProperties exProperties) {
        try {
            CLUSTER_CONFIG_PROPERTIES.doUpdateProp("clusterweight.properties", exProperties, false);
            append.putAll((Map)exProperties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static Properties getWeightsProps() {
        JRWeightLoadBalancer.loadWeights();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)append);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadWeights() {
        block13: {
            if (SEDU) {
                return;
            }
            try {
                String string;
                File file;
                if (ClusterInitLocker.hasInited(append.getName())) break block13;
                Properties properties = CLUSTER_CONFIG_PROPERTIES.queryProp("clusterweight.properties");
                if (properties.isEmpty() && (file = new File(string = ServerEnv.getClusterWeightPropName())).exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        properties.load(fileInputStream);
                        if (!properties.isEmpty()) {
                            CLUSTER_CONFIG_PROPERTIES.doUpdateProp("clusterweight.properties", properties, false);
                        }
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException);
                    }
                    finally {
                        file.delete();
                    }
                }
                append.putAll((Map)properties);
                ClusterInitLocker.setInited(append.getName());
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            finally {
                SEDU = true;
            }
        }
    }

    static {
        try {
            append = MapFactory.getMap(MapAttr.CLUSTER_CONFIG_PROPERTIES);
            GlobalDataService globalDataService = GlobalDataService.getInstance();
            CLUSTER_CONFIG_PROPERTIES = globalDataService.getPropsTable();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

