/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.log.ServiceLogger;

public class TaskStatisticRecorder {
    private static String SEDU = "taskstats.dat";
    private static final long access$000 = 600000L;
    private CommitThread access$002;
    private long access$202;
    private boolean access$302 = false;
    private File access$402 = null;
    private Hashtable access$502;

    public TaskStatisticRecorder(String string) {
        this.access$402 = new File(string, SEDU);
        try {
            this.SEDU(this.access$402);
            this.access$002 = new CommitThread(this, 120000L);
            this.access$002.setPriority(1);
            this.access$002.setDaemon(true);
            this.access$002.start();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 2);
        }
    }

    private void SEDU(File file) throws IOException {
        this.access$502 = new Hashtable();
        if (file.exists()) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("&");
                if (8 != stringArray.length && 7 != stringArray.length) {
                    ServiceLogger.logError("Invalid task statistic record:[" + string + "]");
                    continue;
                }
                StatisticRecord statisticRecord = 7 == stringArray.length ? new StatisticRecord(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], "", stringArray[6]) : new StatisticRecord(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[7], stringArray[6]);
                this.access$502.put(statisticRecord.SEDU, statisticRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Properties properties) {
        String string = properties.getProperty("rptName");
        StatisticRecord statisticRecord = null;
        Hashtable hashtable = this.access$502;
        synchronized (hashtable) {
            statisticRecord = (StatisticRecord)this.access$502.get(string);
            if (statisticRecord == null) {
                statisticRecord = new StatisticRecord();
                statisticRecord.SEDU = string;
                statisticRecord.append = Long.parseLong(properties.getProperty("submitTime"));
                this.access$502.put(string, statisticRecord);
            }
        }
        statisticRecord.increaseRuntime();
        statisticRecord.put = properties.getProperty("rptSource");
        statisticRecord.parseInt = Long.parseLong(properties.getProperty("submitTime"));
        statisticRecord.nextToken = properties.getProperty("taskID");
        statisticRecord.hasMoreTokens = properties.getProperty("userName");
        this.access$202 = System.currentTimeMillis();
        this.access$302 = true;
    }

    public void updateTask(String string, int n) {
        if (null == this.access$502) {
            return;
        }
        StatisticRecord statisticRecord = (StatisticRecord)this.access$502.get(string);
        if (statisticRecord != null) {
            statisticRecord.parseLong = n;
        }
        this.access$202 = System.currentTimeMillis();
        this.access$302 = true;
    }

    public Vector getStatistics() {
        Vector<Properties> vector = new Vector<Properties>(this.access$502.size());
        Enumeration enumeration = this.access$502.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(((StatisticRecord)enumeration.nextElement()).toProperties());
        }
        return vector;
    }

    public void quit() {
        if (this.access$302) {
            this.access$302 = false;
            this.save();
        }
        this.access$002.stopCommit();
        this.access$502.clear();
        this.access$502 = null;
    }

    private boolean access$000() {
        return this.access$302 && System.currentTimeMillis() - this.access$202 >= 600000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        BufferedWriter bufferedWriter = null;
        try {
            if (!this.access$402.getParentFile().exists()) {
                this.access$402.getParentFile().mkdir();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(this.access$402));
            Hashtable hashtable = this.access$502;
            synchronized (hashtable) {
                Enumeration enumeration = this.access$502.elements();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().toString();
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
            }
            this.access$302 = false;
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    class StatisticRecord {
        private String SEDU;
        private long append;
        private int convertEscapes = 0;
        private String hasMoreTokens;
        private String nextToken;
        private long parseInt;
        private int parseLong = -1;
        private String put;

        private StatisticRecord() {
        }

        public StatisticRecord(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this.SEDU = CSUtil.convertEscapes(string);
            this.append = Long.parseLong(string2);
            this.convertEscapes = Integer.parseInt(string3);
            this.put = CSUtil.convertEscapes(string4);
            this.parseInt = Long.parseLong(string5);
            this.nextToken = string6;
            this.parseLong = Integer.parseInt(string7);
            this.hasMoreTokens = string8;
        }

        private StatisticRecord(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            this.SEDU = CSUtil.convertEscapes(stringTokenizer.nextToken());
            this.append = CSUtil.parseLong(stringTokenizer.nextToken());
            this.convertEscapes = CSUtil.parseInt(stringTokenizer.nextToken());
            this.put = CSUtil.convertEscapes(stringTokenizer.nextToken());
            this.parseInt = CSUtil.parseLong(stringTokenizer.nextToken());
            this.nextToken = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                this.hasMoreTokens = CSUtil.convertEscapes(string2);
                this.parseLong = CSUtil.parseInt(stringTokenizer.nextToken());
            } else {
                this.hasMoreTokens = "";
                this.parseLong = CSUtil.parseInt(string2);
            }
        }

        synchronized void increaseRuntime() {
            ++this.convertEscapes;
        }

        public String toString() {
            return CSUtil.replWithEsc(this.SEDU) + "&" + this.append + "&" + this.convertEscapes + "&" + CSUtil.replWithEsc(this.put) + "&" + this.parseInt + "&" + this.nextToken + "&" + CSUtil.replWithEsc(this.hasMoreTokens) + "&" + this.parseLong;
        }

        public Properties toProperties() {
            Properties properties = new Properties();
            properties.put("rptName", this.SEDU);
            properties.put("firstSubmitTime", String.valueOf(this.append));
            properties.put("runTimesNumber", String.valueOf(this.convertEscapes));
            properties.put("rptSource", this.put);
            properties.put("submitTime", String.valueOf(this.parseInt));
            properties.put("taskID", this.nextToken);
            properties.put("userName", this.hasMoreTokens);
            properties.put("rptPages", String.valueOf(this.parseLong));
            return properties;
        }
    }

    class CommitThread
    extends Thread {
        private long SEDU;
        private TaskStatisticRecorder access$800;
        private boolean access$900 = false;

        public CommitThread(TaskStatisticRecorder taskStatisticRecorder2, long l) {
            this.SEDU = l;
            this.access$800 = taskStatisticRecorder2;
        }

        @Override
        public void run() {
            while (!this.access$900) {
                try {
                    Thread.sleep(this.SEDU);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.access$900 || !TaskStatisticRecorder.this.access$000()) continue;
                this.access$800.save();
            }
        }

        void stopCommit() {
            this.access$900 = true;
        }
    }
}

