/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.io.IOException;
import java.rmi.UnmarshalException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.ClusterAdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.api.admin.cfg.ConfigurationMail;
import jet.server.api.admin.cfg.ConfigurationService;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.Member;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.JRWeightLoadBalancer;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRClusterAdminService
implements ClusterAdminService {
    private boolean SEDU = true;
    private JRClusterService addPredefinedServer = null;
    private ConfigurationService enableNotifyServerDown = null;
    private ConfigurationAdvanced equals = null;
    private ConfigurationMail equalsIgnoreCase = null;
    private ExProperties get = new ExProperties();
    private String getActiveRealm = null;
    private Properties getAllMembers = new Properties();
    private int getBoolean = 5;
    boolean isCluster = ServerEnv.isClusterEnabled();
    PropsTable propTable = null;
    private static String getConfigurationAdvanced = "weightconfig";

    public JRClusterAdminService(JRClusterService jRClusterService, ConfigService configService) {
        this.addPredefinedServer = jRClusterService;
        this.enableNotifyServerDown = configService.getConfigurationService();
        this.equals = configService.getConfigurationAdvanced();
        this.equalsIgnoreCase = configService.getConfigurationMail();
        this.getActiveRealm = ServerEnv.getServPropName();
        this.isCluster = ServerEnv.isClusterEnabled();
        if (this.isCluster) {
            GlobalDataService globalDataService = GlobalDataService.getInstance();
            this.propTable = globalDataService.getPropsTable();
            try {
                this.getAllMembers = this.propTable.queryProp("server.properties");
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
        try {
            this.get.load(this.getActiveRealm);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private boolean isAdminUser(String string, String string2) {
        return UserDataToolkit.getSecurityService(string).isAdminUser(string2);
    }

    @Override
    public String stopServer(String string, String string2, String string3) throws ClusterException {
        Object object;
        Member member = this.addPredefinedServer.getLocalMember();
        if ((member.getHost().equalsIgnoreCase(string) || string == null || string.length() == 0) && member.getPort().equalsIgnoreCase(string2) && ((Member[])(object = this.addPredefinedServer.getAllMembers())).length > 1) {
            int n;
            for (n = 0; n < ((Object)object).length && !object[n].isBackupAdmin(); ++n) {
            }
            if (n == ((Object)object).length) {
                return "CLUSTER_ERR_9_CAN_NOT_SHUT_DOWN_SERVER";
            }
        }
        try {
            object = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "MemberMonitor");
            object.stopServer();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (Exception exception) {
            throw new ClusterException(exception);
        }
        ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string3, 6660041, new Object[]{string, String.valueOf(string2)}, 6);
        return null;
    }

    @Override
    public String stopServer(String string, String string2) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string2) && !this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            if (this.getMessageMode()) {
                return JSvrResource.getMessage("SVR_125");
            }
            return "SVR_125";
        }
        if (string == null || string.trim().length() == 0) {
            if (this.getMessageMode()) {
                return JSvrResource.getMessage("CLUSTER_ERR_1_SERVER_NAME_NULL");
            }
            return "CLUSTER_ERR_1_SERVER_NAME_NULL";
        }
        Member[] memberArray = this.addPredefinedServer.getAllMembers();
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < memberArray.length; ++i) {
            if (!string.equalsIgnoreCase(memberArray[i].getServerName())) continue;
            string3 = memberArray[i].getHost();
            string4 = memberArray[i].getPort();
            break;
        }
        if (string3 != null) {
            String string5 = this.stopServer(string3, string4, string2);
            if (string5 == null) {
                return null;
            }
            if (this.getMessageMode()) {
                return JSvrResource.getMessage(string5);
            }
            return string5;
        }
        throw new ClusterException(650001, new Object[]{string}, null);
    }

    private long SEDU(String string, String string2, Properties properties) throws ClusterException {
        try {
            MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "MemberMonitor");
            return memberMonitor.runTestReport(properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
            throw new ClusterException(exception);
        }
    }

    @Override
    public long runTestReport(String string, Properties properties) throws ClusterException {
        Member[] memberArray = this.addPredefinedServer.getAllMembers();
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < memberArray.length; ++i) {
            if (!string.equalsIgnoreCase(memberArray[i].getServerName())) continue;
            string2 = memberArray[i].getHost();
            string3 = memberArray[i].getPort();
            break;
        }
        if (string2 != null) {
            return this.SEDU(string2, string3, properties);
        }
        throw new ClusterException(650001, new Object[]{string}, null);
    }

    @Override
    public void saveClusterWeights(Properties properties) {
        ExProperties exProperties = new ExProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = String.valueOf(enumeration.nextElement());
            exProperties.put(string, properties.get(string));
        }
        JRWeightLoadBalancer.save(exProperties);
    }

    @Override
    public Properties loadClusterWeights() throws IOException {
        return JRWeightLoadBalancer.getWeightsProps();
    }

    @Override
    public String stopCluster(String string) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            if (this.getMessageMode()) {
                return JSvrResource.getMessage("SVR_125");
            }
            return "SVR_125";
        }
        Member member = this.addPredefinedServer.getLocalMember();
        Member[] memberArray = this.addPredefinedServer.getAllMembers();
        String string2 = null;
        for (int i = 0; i < memberArray.length; ++i) {
            if (member.equals(memberArray[i]) || (string2 = this.stopServer(memberArray[i].getHost(), memberArray[i].getPort(), string)) == null) continue;
            string2 = "CLUSTER_ERR_8_CAN_NOT_STOP_SERVER";
            break;
        }
        if (string2 == null) {
            string2 = this.stopServer(member.getHost(), member.getPort(), string);
        }
        if (string2 == null) {
            return string2;
        }
        if (this.getMessageMode()) {
            return JSvrResource.getMessage(string2);
        }
        return string2;
    }

    @Override
    public boolean canEditPredefinedServers() {
        return false;
    }

    @Override
    public int getCheckAdminCrashedInterval() {
        return this.getBoolean;
    }

    @Override
    public void setCheckAdminCrashedInterval(int n) {
        this.getBoolean = n;
    }

    @Override
    public String addPredefinedServer(String string, String string2, String string3, String string4) throws ClusterException {
        return this.addPredefinedServer(string, string2, string3, -1, string4);
    }

    @Override
    public String addPredefinedServer(String string, String string2, String string3, int n, String string4) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string4)) {
            if (this.getMessageMode()) {
                return JSvrResource.getMessage("SVR_125");
            }
            return "SVR_125";
        }
        return "Not Support";
    }

    private String addPredefinedServer() {
        return null;
    }

    @Override
    public String removePredefinedServer(String string, String string2) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            if (this.getMessageMode()) {
                return JSvrResource.getMessage("SVR_125");
            }
            return "SVR_125";
        }
        return "Not support.";
    }

    @Override
    public Member[] getPredefinedServers() {
        return null;
    }

    @Override
    public void setEnableNotifyServerDown(boolean bl) {
        try {
            if (this.isCluster) {
                this.enableNotifyServerDown("cluster.enable_notify_server_down", Boolean.toString(bl));
            } else {
                this.get.setProperty("cluster.enable_notify_server_down", bl);
                this.getAllMembers.put("cluster.enable_notify_server_down", String.valueOf(bl));
                this.get.save(this.getActiveRealm, null);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public boolean isEnableNotifyServerDown() {
        return ServerEnv.enableNotifyServerDown();
    }

    @Override
    public void setNotifyServerDownAddress(String string) {
        try {
            if (this.isCluster) {
                this.enableNotifyServerDown("cluster.notify_server_down_address", string);
            } else {
                this.get.setProperty("cluster.notify_server_down_address", string);
                this.getAllMembers.put("cluster.notify_server_down_address", String.valueOf(string));
                this.get.save(this.getActiveRealm, null);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getNotifyServerDownAddress() {
        return ServerEnv.getNotifyServerDownAddress();
    }

    @Override
    public String getActiveRealm() {
        return this.enableNotifyServerDown.getActiveRealm();
    }

    @Override
    public void setActiveRealm(String string, String string2) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            this.enableNotifyServerDown.setActiveRealm(string);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string2, 6660046, string, 6);
        }
    }

    @Override
    public boolean isNeedSecurity() {
        return this.equals.getEnableSecurityCheck();
    }

    @Override
    public void setNeedSecurity(boolean bl, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.equals.setEnableSecurityCheck(bl);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660047, String.valueOf(bl), 6);
        }
    }

    @Override
    public boolean isEnableJSP() {
        return true;
    }

    @Override
    public void setEnableJSP(boolean bl, String string) {
    }

    @Override
    public boolean isEnablePublishTempToVersion() {
        return this.equals.getEnablePublishTempToVersion();
    }

    @Override
    public void setEnablePublishTempToVersion(boolean bl, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.equals.setEnablePublishTempToVersion(bl);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660049, String.valueOf(bl), 6);
        }
    }

    @Override
    public void setMailServer(String string, String string2) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            this.equalsIgnoreCase.setMailServer(string);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string2, 6660050, string, 6);
        }
    }

    @Override
    public void setMessageMode(boolean bl) {
        this.SEDU = bl;
    }

    @Override
    public String getMailServer() {
        return this.equalsIgnoreCase.getMailServer();
    }

    @Override
    public boolean getMessageMode() {
        return this.SEDU;
    }

    @Override
    public void setMailPort(int n, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.equalsIgnoreCase.setMailPort(n);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660051, String.valueOf(n), 6);
        }
    }

    @Override
    public int getMailPort() {
        return this.equalsIgnoreCase.getMailPort();
    }

    @Override
    public void setMailBox(String string, String string2) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            this.equalsIgnoreCase.setMailBox(string);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string2, 6660052, string, 6);
        }
    }

    @Override
    public String getMailBox() {
        return this.equalsIgnoreCase.getMailBox();
    }

    @Override
    public void setDefaultMailFormat(int n, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.equalsIgnoreCase.setMailFormat(n);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660053, String.valueOf(n), 6);
        }
    }

    @Override
    public int getDefaultMailFormat() {
        return this.equalsIgnoreCase.getDefaultMailFormat();
    }

    @Override
    public Vector getMailFormats() {
        return this.equalsIgnoreCase.getMailFormats();
    }

    @Override
    public void setEnableCompress(boolean bl, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.equalsIgnoreCase.setEnableCompress(bl);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660054, String.valueOf(bl), 6);
        }
    }

    @Override
    public boolean isEnableCompress() {
        return this.equalsIgnoreCase.getEnableCompress();
    }

    @Override
    public String getLoadBalanceCustomClass() {
        String string = ServerEnv.getPropertyFromClusterRegistry("loadbalance.custom_class");
        return string;
    }

    @Override
    public int getLoadBalanceType() {
        String string = ServerEnv.getPropertyFromClusterRegistry("loadbalance.type");
        return CSUtil.parseInt(string, 1);
    }

    @Override
    public void setLoadBalanceCustomClass(String string) {
        this.enableNotifyServerDown("loadbalance.custom_class", string);
    }

    @Override
    public void setLoadBalanceType(int n) {
        this.enableNotifyServerDown("loadbalance.type", Integer.toString(n));
    }

    private void enableNotifyServerDown(String string, String string2) {
        try {
            ServerEnv.registerProperty(string, string2);
            this.propTable.updateProp("server.properties", string, string2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public boolean isClusterSendConcurrentReport() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.send_concurrent_reports");
        return CSUtil.getBoolean(string, true);
    }

    @Override
    public void setClusterSendConcurrentReport(Boolean bl) {
        this.enableNotifyServerDown("cluster.send_concurrent_reports", String.valueOf(bl));
    }
}

