/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jet.cs.CSUtil;
import jet.server.api.RptServerException;
import jet.server.api.admin.DynamicConnectionManager;
import jet.server.api.admin.DynamicConnectionRecord;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.db.dynamiccon.DynamicConnectionDAO;
import jet.server.jrc.JRDataService;
import jet.server.log.ServiceLogger;

public class JRDynamicConnectionManager
implements DynamicConnectionManager {
    private Map SEDU;
    private Map add = new HashMap();
    private DynamicConnectionDAO addListener;
    private boolean append;

    public JRDynamicConnectionManager(JRDataService jRDataService) {
        this.addListener = new DynamicConnectionDAO(jRDataService.getDynamicConnectionTable(), jRDataService.getDynamicDbUserMappingTable());
        try {
            ClusterMap clusterMap = MapFactory.getCommonMap(this.getClass().getName());
            this.SEDU = clusterMap;
            clusterMap.addListener(new MapListenerAdapter(){

                public void afterPut(String string, int n, Integer n2, DynamicConnectionRecord dynamicConnectionRecord, DynamicConnectionRecord dynamicConnectionRecord2, MapFlags mapFlags) {
                    ConcurrentHashMap<Integer, DynamicConnectionRecord> concurrentHashMap = (ConcurrentHashMap<Integer, DynamicConnectionRecord>)JRDynamicConnectionManager.this.add.get(dynamicConnectionRecord.getOrgName());
                    if (concurrentHashMap == null) {
                        concurrentHashMap = new ConcurrentHashMap<Integer, DynamicConnectionRecord>();
                        JRDynamicConnectionManager.this.add.put(dynamicConnectionRecord.getOrgName(), concurrentHashMap);
                    }
                    concurrentHashMap.put(dynamicConnectionRecord.getRecordId(), dynamicConnectionRecord);
                }

                public void afterRemove(String string, int n, Integer n2, DynamicConnectionRecord dynamicConnectionRecord, MapFlags mapFlags) {
                    if (dynamicConnectionRecord == null) {
                        return;
                    }
                    Map map = (Map)JRDynamicConnectionManager.this.add.get(dynamicConnectionRecord.getOrgName());
                    if (map != null) {
                        map.remove(dynamicConnectionRecord.getRecordId());
                    }
                }

                @Override
                public void afterDestroy(String string, int n) {
                    JRDynamicConnectionManager.this.add.clear();
                }
            });
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
            this.SEDU = new ConcurrentHashMap();
        }
    }

    private void SEDU() throws SQLException, IOException {
        if (this.append) {
            return;
        }
        for (DynamicConnectionRecord dynamicConnectionRecord : this.addListener.getDynamicConnections(null, null, null, null)) {
            this.SEDU.put(dynamicConnectionRecord.getRecordId(), dynamicConnectionRecord);
        }
        this.append = true;
    }

    private void add(List list, Collection collection, String string, String string2, String string3) {
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string3);
        String string4 = CSUtil.getVirtualResourcePathPrefix(stringArray[0]);
        for (DynamicConnectionRecord dynamicConnectionRecord : collection) {
            String string5;
            if (string != null && !string.equals(dynamicConnectionRecord.getCatalog()) || string2 != null && !string2.equals(dynamicConnectionRecord.getDatasource())) continue;
            if (null != string && null != string2) {
                ServiceLogger.logDebug("filterCatalogDatasource: catalog=" + dynamicConnectionRecord.getCatalog() + ", datasource=" + dynamicConnectionRecord.getDatasource() + ", connection=" + dynamicConnectionRecord.getConnectionName(), 6);
            }
            if ((string5 = dynamicConnectionRecord.getCatalog()).startsWith(string4 + "/USERFOLDERPATH" + "/") && !string5.startsWith(string4 + "/USERFOLDERPATH" + "/" + stringArray[1] + "/") || string5.startsWith(string4 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/") && !string5.startsWith(string4 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + stringArray[1] + "/") || string5.startsWith("/USERFOLDERPATH/") && !string5.startsWith("/USERFOLDERPATH/" + string3 + "/") || string5.startsWith("/COMPONENT_LIB/USERFOLDERPATH/") && !string5.startsWith("/COMPONENT_LIB/USERFOLDERPATH/" + string3 + "/")) continue;
            list.add(dynamicConnectionRecord.clone());
        }
    }

    private void addListener(List list, Collection collection, String string, String string2, String string3, String string4) {
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string4);
        String string5 = CSUtil.getVirtualResourcePathPrefix(stringArray[0]);
        for (DynamicConnectionRecord dynamicConnectionRecord : collection) {
            String string6;
            if (string != null && !string.equals(dynamicConnectionRecord.getCatalog()) || string2 != null && !string2.equals(dynamicConnectionRecord.getDatasource()) || string3 != null && dynamicConnectionRecord.getConnectionName() != null && !string3.equals(dynamicConnectionRecord.getConnectionName())) continue;
            if (null != string && null != string2) {
                ServiceLogger.logDebug("filterCatalogDatasourceConnection: connectionName=" + string3 + ", catalog=" + dynamicConnectionRecord.getCatalog() + ", datasource=" + dynamicConnectionRecord.getDatasource() + ", connection=" + dynamicConnectionRecord.getConnectionName(), 6);
            }
            if ((string6 = dynamicConnectionRecord.getCatalog()).startsWith(string5 + "/USERFOLDERPATH" + "/") && !string6.startsWith(string5 + "/USERFOLDERPATH" + "/" + stringArray[1] + "/") || string6.startsWith(string5 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/") && !string6.startsWith(string5 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + stringArray[1] + "/") || string6.startsWith("/USERFOLDERPATH/") && !string6.startsWith("/USERFOLDERPATH/" + string4 + "/") || string6.startsWith("/COMPONENT_LIB/USERFOLDERPATH/") && !string6.startsWith("/COMPONENT_LIB/USERFOLDERPATH/" + string4 + "/")) continue;
            list.add(dynamicConnectionRecord.clone());
        }
    }

    public List getAllDynamicConnections(String string, String string2) throws RptServerException {
        if (string == null) {
            try {
                this.SEDU();
                ArrayList arrayList = new ArrayList();
                this.addListener(arrayList, this.SEDU.values(), null, null, null, string2);
                return Collections.unmodifiableList(arrayList);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                throw new RptServerException(sQLException);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
                throw new RptServerException(iOException);
            }
        }
        return this.getDynamicConnections(string, null, null, null, string2);
    }

    public List getDynamicConnections(String string, String string2, String string3, String string4) throws RptServerException {
        try {
            this.SEDU();
            ArrayList arrayList = new ArrayList();
            this.append(arrayList, string, string2, string3, string4);
            if (string != null) {
                this.append(arrayList, null, string2, string3, string4);
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
    }

    private void append(List list, String string, String string2, String string3, String string4) {
        Map map = (Map)this.add.get(string);
        if (map != null) {
            this.add(list, map.values(), string2, string3, string4);
        }
    }

    public List getDynamicConnections(String string, String string2, String string3, String string4, String string5) throws RptServerException {
        try {
            this.SEDU();
            ArrayList arrayList = new ArrayList();
            this.clone(arrayList, string, string2, string3, string4, string5);
            if (string != null) {
                this.clone(arrayList, null, string2, string3, string4, string5);
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
    }

    private void clone(List list, String string, String string2, String string3, String string4, String string5) {
        Map map = (Map)this.add.get(string);
        if (map != null) {
            this.addListener(list, map.values(), string2, string3, string4, string5);
        }
    }

    @Override
    public int addDynamicConnection(DynamicConnectionRecord dynamicConnectionRecord, String string) throws RptServerException {
        try {
            dynamicConnectionRecord = dynamicConnectionRecord.clone();
            int n = this.addListener.insertDynamicConnection(dynamicConnectionRecord);
            this.SEDU.put(n, dynamicConnectionRecord);
            return n;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
    }

    @Override
    public void updateDynamicConnection(DynamicConnectionRecord dynamicConnectionRecord, String string) throws RptServerException {
        try {
            dynamicConnectionRecord = dynamicConnectionRecord.clone();
            if (this.addListener.updateDynamicConnection(dynamicConnectionRecord)) {
                this.SEDU.put(dynamicConnectionRecord.getRecordId(), dynamicConnectionRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
    }

    @Override
    public void removeDynamicConnection(int n, String string) throws RptServerException {
        try {
            this.addListener.removeDynamicConnection(n);
            this.SEDU.remove(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            throw new RptServerException(sQLException);
        }
    }
}

