/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.admin.DynamicSecurityManager;
import jet.server.api.admin.security.DynamicSecurity;
import jet.server.db.dao.DynamicSecurityDAO;
import jet.server.db.model.DataVersionModel;
import jet.server.db.model.DynamicSecurityModel;
import jet.server.jrc.admin.ExtDynamicSecurity;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;
import jet.server.storage.UnavailableStorageException;
import jet.server.util.BVUtils;
import jet.server.util.IOUtil;
import jet.server.util.StringUtil;

public class JRDynamicSecurityManager
implements DynamicSecurityManager {
    private DynamicSecurityDAO REALM = DynamicSecurityDAO.getInstance();
    private Storage SEDU;
    private String add = "securityFiles";
    private String addDynamicSecurity;

    public JRDynamicSecurityManager(JRRptServer jRRptServer) {
        try {
            this.SEDU = StorageEnv.getStorage();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        this.addDynamicSecurity = jRRptServer.getHomePath();
    }

    private String REALM(String string, int n) {
        int n2 = string.lastIndexOf(".");
        String string2 = "";
        if (n2 > 0) {
            string2 = string.substring(n2);
        }
        return ServerEnv.getActiveRealm() + File.separator + this.add + File.separator + n + string2;
    }

    private String SEDU(String string) {
        return Storage.StorageRoot.REALM.getRootPath() + "/" + string;
    }

    private void add(File file, DynamicSecurityModel dynamicSecurityModel) throws IOException, StorageException, RptServerException {
        try {
            BVUtils.makeSecurityProvider(file);
        }
        catch (Throwable throwable) {
            throw new RptServerException(22221425, throwable);
        }
        String string = this.REALM(file.getName(), dynamicSecurityModel.getId());
        String string2 = ServerEnv.realmsPath + string;
        File file2 = new File(string2);
        if (file2.exists()) {
            file2.delete();
        }
        file2.getParentFile().mkdirs();
        IOUtil.copy(file, file2);
        file2.setLastModified(file.lastModified());
        this.SEDU.add(this.SEDU(string), null);
    }

    private void addDynamicSecurity(DynamicSecurityModel dynamicSecurityModel) throws StorageException, IOException {
        String string = dynamicSecurityModel.getSecurityFilePath();
        if (string != null && string.trim().length() > 0) {
            File file = new File(ServerEnv.realmsPath + string);
            if (file.exists()) {
                file.delete();
            }
            this.SEDU.delete(Storage.StorageRoot.REALM, string);
        }
    }

    private void append(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 2);
        }
    }

    private void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 2);
        }
    }

    private ExtDynamicSecurity convert(DynamicSecurityModel dynamicSecurityModel) throws UnavailableStorageException, IOException {
        if (dynamicSecurityModel == null) {
            return null;
        }
        ExtDynamicSecurity extDynamicSecurity = new ExtDynamicSecurity();
        extDynamicSecurity.setID(dynamicSecurityModel.getId());
        extDynamicSecurity.setDataVersion(dynamicSecurityModel.getDataVersion());
        extDynamicSecurity.setCatalogPath(dynamicSecurityModel.getCatalogPath());
        extDynamicSecurity.setSecurityFileName(dynamicSecurityModel.getSecurityFileName());
        extDynamicSecurity.setSecurityFilePath(dynamicSecurityModel.getSecurityFilePath());
        try {
            extDynamicSecurity.setSecurityFile(this.SEDU.get(Storage.StorageRoot.REALM, dynamicSecurityModel.getSecurityFilePath()));
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "Get dynamic security file occur error! filePath: %s", dynamicSecurityModel.getSecurityFilePath());
            extDynamicSecurity.setSecurityFile(null);
        }
        extDynamicSecurity.setDefault(dynamicSecurityModel.getType() == 1);
        return extDynamicSecurity;
    }

    private DynamicSecurityModel convert(DynamicSecurity dynamicSecurity) {
        if (dynamicSecurity == null) {
            return null;
        }
        DynamicSecurityModel dynamicSecurityModel = new DynamicSecurityModel();
        dynamicSecurityModel.setCatalogPath(dynamicSecurity.getCatalogPath());
        dynamicSecurityModel.setSecurityFileName(dynamicSecurity.getSecurityFileName());
        dynamicSecurityModel.setType(dynamicSecurity.isDefault() ? 1 : 0);
        if (dynamicSecurity instanceof ExtDynamicSecurity) {
            ExtDynamicSecurity extDynamicSecurity = (ExtDynamicSecurity)dynamicSecurity;
            dynamicSecurityModel.setId(extDynamicSecurity.getID());
            dynamicSecurityModel.setDataVersion(extDynamicSecurity.getDataVersion());
            dynamicSecurityModel.setSecurityFilePath(extDynamicSecurity.getSecurityFilePath());
        }
        return dynamicSecurityModel;
    }

    public List getDynamicSecurities(String string) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurities ......", new Object[0]);
        ArrayList<ExtDynamicSecurity> arrayList = new ArrayList<ExtDynamicSecurity>();
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            List list = this.REALM.listAll(connection);
            for (DynamicSecurityModel dynamicSecurityModel : list) {
                arrayList.add(this.convert(dynamicSecurityModel));
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.getDynamicSecurities: ERROR!", new Object[0]);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurities: return= %s", StringUtil.toString(arrayList));
        }
        return arrayList;
    }

    public List getDynamicSecurities(String string, String string2) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurities ...... catalogPath= %s", string);
        ArrayList<ExtDynamicSecurity> arrayList = new ArrayList<ExtDynamicSecurity>();
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            List list = this.REALM.getByCatalog(connection, string);
            for (DynamicSecurityModel dynamicSecurityModel : list) {
                arrayList.add(this.convert(dynamicSecurityModel));
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.getDynamicSecurities: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurities: return= %s", StringUtil.toString(arrayList));
        }
        return arrayList;
    }

    @Override
    public DynamicSecurity getDynamicSecurity(String string, String string2, String string3) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurity ...... catalogPath= %s, securityFileName= %s", string, string2);
        ExtDynamicSecurity extDynamicSecurity = null;
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            DynamicSecurityModel dynamicSecurityModel = this.REALM.getByCatalogAndFilename(connection, string, string2);
            extDynamicSecurity = this.convert(dynamicSecurityModel);
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.getDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurity: return= %s", StringUtil.toString(extDynamicSecurity));
        }
        return extDynamicSecurity;
    }

    @Override
    public DynamicSecurity getDynamicSecurity(int n, String string) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurity ...... id= %s", n);
        ExtDynamicSecurity extDynamicSecurity = null;
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            DynamicSecurityModel dynamicSecurityModel = this.REALM.get(connection, n);
            extDynamicSecurity = this.convert(dynamicSecurityModel);
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.getDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.getDynamicSecurity: return= %s", StringUtil.toString(extDynamicSecurity));
        }
        return extDynamicSecurity;
    }

    @Override
    public int addDynamicSecurity(DynamicSecurity dynamicSecurity, String string) throws RptServerException {
        return this.addDynamicSecurity(dynamicSecurity, string, false);
    }

    @Override
    public int addDynamicSecurity(DynamicSecurity dynamicSecurity, String string, boolean bl) throws RptServerException {
        DynamicSecurityModel dynamicSecurityModel;
        ServiceLogger.trace("JRDynamicSecurityManager.addDynamicSecurity ...... record= %s, operator= %s", dynamicSecurity, string);
        String string2 = dynamicSecurity.getCatalogPath();
        if (string2 == null || string2.trim().length() == 0) {
            throw new RptServerException(22221426);
        }
        File file = dynamicSecurity.getSecurityFile();
        if (file == null || !file.exists()) {
            throw new RptServerException(22221427);
        }
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            dynamicSecurityModel = this.convert(dynamicSecurity);
            DynamicSecurityModel dynamicSecurityModel2 = this.REALM.getByCatalogAndFilename(connection, string2, dynamicSecurity.getSecurityFileName());
            if (dynamicSecurityModel2 != null) {
                if (bl) {
                    dynamicSecurityModel = dynamicSecurityModel2;
                    this.add(file, dynamicSecurityModel2);
                }
            } else {
                dynamicSecurityModel = this.REALM.insert(connection, dynamicSecurityModel);
                dynamicSecurityModel.setSecurityFilePath(this.REALM(file.getName(), dynamicSecurityModel.getId()));
                dynamicSecurityModel = this.REALM.update(connection, dynamicSecurityModel);
                this.add(file, dynamicSecurityModel);
            }
            connection.commit();
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.error((Throwable)((Object)rptServerException), "JRDynamicSecurityManager.addDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw rptServerException;
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.addDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.addDynamicSecurity: return= %s", dynamicSecurityModel);
        }
        return dynamicSecurityModel.getId();
    }

    public int updateDynamicSecurity(DynamicSecurity dynamicSecurity, String string) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.updateDynamicSecurity ...... record= %s, operator= %s", dynamicSecurity, string);
        String string2 = dynamicSecurity.getCatalogPath();
        if (string2 == null || string2.trim().length() == 0) {
            throw new RptServerException(22221426);
        }
        DynamicSecurityModel dynamicSecurityModel = null;
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            dynamicSecurityModel = this.REALM.update(connection, this.convert(dynamicSecurity));
            File file = dynamicSecurity.getSecurityFile();
            if (file != null) {
                this.add(file, dynamicSecurityModel);
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.updateDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.updateDynamicSecurity: return= %s", dynamicSecurityModel);
        }
        if (dynamicSecurityModel == null) {
            return 0;
        }
        return dynamicSecurityModel.getId();
    }

    public int updateDynamicSecurity(String string, String string2, DynamicSecurity dynamicSecurity, String string3, List list) throws RptServerException {
        Object object;
        ServiceLogger.trace("JRDynamicSecurityManager.updateDynamicSecurity ...... oldCatalogPath= %s, oldSecurityFileName= %s, newDynamicSecurityObject= %s, operator= %s", string, string2, dynamicSecurity, string3);
        if (null != dynamicSecurity.getSecurityFile()) {
            object = dynamicSecurity.getSecurityFile().getName();
            if (null != string2 && !string2.equals(object)) {
                list.add(object);
                throw new RptServerException(22221567);
            }
        }
        object = null;
        Connection connection = null;
        try {
            DynamicSecurityModel dynamicSecurityModel;
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            String string4 = dynamicSecurity.getCatalogPath();
            String string5 = dynamicSecurity.getSecurityFileName();
            if (!(string4.equals(string) && string5.equals(string2) || (dynamicSecurityModel = this.REALM.getByCatalogAndFilename(connection, string4, string5)) == null)) {
                throw new RptServerException(22221428);
            }
            dynamicSecurityModel = this.REALM.getByCatalogAndFilename(connection, string, string2);
            if (dynamicSecurityModel == null) {
                throw new RptServerException(22221430);
            }
            DynamicSecurityModel dynamicSecurityModel2 = this.convert(dynamicSecurity);
            dynamicSecurityModel2.setSecurityFilePath(dynamicSecurityModel.getSecurityFilePath());
            if (dynamicSecurityModel2.getSecurityFilePath() == null || dynamicSecurityModel2.getSecurityFilePath().trim().length() == 0) {
                dynamicSecurityModel2.setSecurityFilePath(this.REALM(dynamicSecurityModel2.getSecurityFileName(), dynamicSecurityModel.getId()));
            }
            object = this.REALM.update(connection, string, string2, dynamicSecurityModel2);
            File file = dynamicSecurity.getSecurityFile();
            if (file != null) {
                this.add(file, (DynamicSecurityModel)object);
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.updateDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.updateDynamicSecurity: return= %s", object);
        }
        if (object == null) {
            return 0;
        }
        return ((DataVersionModel)object).getId();
    }

    @Override
    public int setDynamicSecurityDefault(String string, String string2, boolean bl, String string3) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.setDynamicSecurityDefault ...... catalogPath= %s, securityFileName= %s, isDefault= %b, operator= %s", string, string2, bl, string3);
        DynamicSecurityModel dynamicSecurityModel = null;
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            int n = bl ? 1 : 0;
            if (bl) {
                this.REALM.updateTypesByCatalog(connection, string, 0);
            }
            dynamicSecurityModel = this.REALM.updateTypeByCatalogAndFilename(connection, string, string2, n);
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.setDynamicSecurityDefault: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.setDynamicSecurityDefault: return= %s", dynamicSecurityModel);
        }
        if (dynamicSecurityModel == null) {
            return 0;
        }
        return dynamicSecurityModel.getId();
    }

    @Override
    public int setDynamicSecurityDefault(int n, boolean bl, String string) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.setDynamicSecurityDefault ...... id= %s, isDefault= %b, operator= %s", n, bl, string);
        DynamicSecurityModel dynamicSecurityModel = null;
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            int n2 = bl ? 1 : 0;
            dynamicSecurityModel = this.REALM.get(connection, n);
            if (bl) {
                this.REALM.updateTypesByCatalog(connection, dynamicSecurityModel.getCatalogPath(), 0);
            }
            dynamicSecurityModel = this.REALM.updateTypeByCatalogAndFilename(connection, dynamicSecurityModel.getCatalogPath(), dynamicSecurityModel.getSecurityFileName(), n2);
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.setDynamicSecurityDefault: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.setDynamicSecurityDefault: return= %s", dynamicSecurityModel);
        }
        if (dynamicSecurityModel == null) {
            return 0;
        }
        return dynamicSecurityModel.getId();
    }

    public int deleteDynamicSecurity(DynamicSecurity dynamicSecurity, String string) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.deleteDynamicSecurity ...... record= %s, operator= %s", dynamicSecurity, string);
        DynamicSecurityModel dynamicSecurityModel = null;
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            dynamicSecurityModel = this.REALM.delete(connection, this.convert(dynamicSecurity));
            if (dynamicSecurityModel != null) {
                this.addDynamicSecurity(dynamicSecurityModel);
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.deleteDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.deleteDynamicSecurity: return= %s", dynamicSecurityModel);
        }
        if (dynamicSecurityModel == null) {
            return 0;
        }
        return dynamicSecurityModel.getId();
    }

    @Override
    public int deleteDynamicSecurity(String string, String string2, String string3) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.deleteDynamicSecurity ...... catalogPath= %s, securityFileName= %s, operator= %s", string, string2, string3);
        DynamicSecurityModel dynamicSecurityModel = null;
        Connection connection = null;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            dynamicSecurityModel = this.REALM.delete(connection, string, string2);
            if (dynamicSecurityModel != null) {
                this.addDynamicSecurity(dynamicSecurityModel);
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.deleteDynamicSecurity: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.deleteDynamicSecurity: return= %s", dynamicSecurityModel);
        }
        if (dynamicSecurityModel == null) {
            return 0;
        }
        return dynamicSecurityModel.getId();
    }

    @Override
    public int deleteDynamicSecuritys(int[] nArray, String string) throws RptServerException {
        ServiceLogger.trace("JRDynamicSecurityManager.deleteDynamicSecuritys ...... idArray= %s, operator= %s", nArray, string);
        Connection connection = null;
        int n = 0;
        try {
            connection = this.REALM.getConnection();
            connection.setAutoCommit(false);
            for (int n2 : nArray) {
                DynamicSecurityModel dynamicSecurityModel = this.REALM.get(connection, n2);
                if (dynamicSecurityModel == null) continue;
                ++n;
                this.REALM.delete(connection, dynamicSecurityModel);
                this.addDynamicSecurity(dynamicSecurityModel);
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            ServiceLogger.error(throwable, "JRDynamicSecurityManager.deleteDynamicSecuritys: ERROR!", new Object[0]);
            this.append(connection);
            throw new RptServerException(throwable);
        }
        finally {
            this.close(connection);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JRDynamicSecurityManager.deleteDynamicSecuritys: ret=%s", n);
        }
        return n;
    }
}

