/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.util.List;
import jet.server.ServerEnv;
import jet.server.api.admin.OrganizationManager;
import jet.server.api.admin.security.JOrganization;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.OrganizationExistsException;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class JROrganizationManager
implements OrganizationManager {
    private boolean isAdminUser(String string, String string2) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            return false;
        }
        return securityService.isAdminUser(string2);
    }

    @Override
    public JOrganization getOrganization(String string, String string2, String string3) throws NoSuchOrganizationException, NoSuchRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityService.getOrganization(string2);
    }

    public List getOrganizations(String string) throws NoSuchRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityService.getOrganizations();
    }

    @Override
    public String createOrganization(String string, String string2, int n, String string3, String string4) throws NoSuchRealmException, OrganizationExistsException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string4)) {
            return "SVR_125";
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityService.addOrganization(string2, string3, n, string4);
        ServiceLogger.logDebug("Organization:: createOrganization: orgName=" + string2 + ", userAmount=" + n + ", desc=" + string3 + ", return=" + string6, 6);
        return string6;
    }

    @Override
    public String updateOrganization(String string, String string2, int n, String string3, String string4) throws NoSuchOrganizationException, NoSuchRealmException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string4)) {
            return "SVR_125";
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityService.updateOrganization(string2, string3, n, string4);
        ServiceLogger.logDebug("Organization:: updateOrganization: orgName=" + string2 + ", userAmount=" + n + ", desc=" + string3 + ", return=" + string6, 6);
        return string6;
    }

    @Override
    public String removeOrganization(String string, String string2, String string3) throws NoSuchOrganizationException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            return "SVR_125";
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string5 = securityService.removeOrganization(string2, string3);
        ServiceLogger.logDebug("Organization:: removeOrganization: " + string2 + ", return=" + string5, 6);
        return string5;
    }
}

