/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.Member;
import jet.server.api.http.HttpRptServer;
import jet.server.api.rmi.RemoteReportServerToolkit;
import jet.server.jrc.http.SystemPerformanceLoadDispatcher;
import jet.server.log.ServiceLogger;

public abstract class HttpRptServerDispatcher {
    protected final HttpRptServer bootstrapServer;
    protected final boolean isCluster;
    protected int localMemberId = -1;
    private final Map SEDU = new HashMap();

    public static HttpRptServerDispatcher createDispatcher(HttpRptServer httpRptServer) {
        return new SystemPerformanceLoadDispatcher(httpRptServer);
    }

    protected HttpRptServerDispatcher(HttpRptServer httpRptServer) {
        this.bootstrapServer = httpRptServer;
        this.isCluster = httpRptServer.isClusterEnable();
        if (this.isCluster) {
            this.localMemberId = httpRptServer.getClusterService().getLocalMember().getID();
        }
        ServiceLogger.logDebug(4650088, new Object[]{this.isCluster, this}, 4);
    }

    public void destroy() {
        this.SEDU.clear();
        ServiceLogger.logDebug(4650089, new Object[]{this}, 4);
    }

    protected HttpRptServer getRptServerByMember(Member member) {
        if (member.getID() == this.localMemberId) {
            return this.bootstrapServer;
        }
        return RemoteReportServerToolkit.getRemoteWrappedRptServer(member.getHost(), member.getPort());
    }

    protected List getMembers() {
        if (this.isCluster) {
            try {
                List<Member> list = Arrays.asList(this.bootstrapServer.getClusterService().getAllMembers());
                ServiceLogger.logDebug(5650090, list, 5);
                return list;
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }
        return Collections.emptyList();
    }

    public HttpRptServer dispatch(HttpServletRequest httpServletRequest) {
        HttpRptServer httpRptServer = this.doDispatch(httpServletRequest);
        String string = httpServletRequest.getSession() == null ? "" : httpServletRequest.getSession().getId();
        ServiceLogger.logDebug(6650091, new Object[]{httpRptServer, string, httpServletRequest}, 6);
        return httpRptServer;
    }

    protected abstract HttpRptServer doDispatch(HttpServletRequest var1);

    public boolean bindRptServer(HttpRptServer httpRptServer, String string) {
        ServiceLogger.logDebug(6650092, new Object[]{string, httpRptServer}, 6);
        HttpRptServer httpRptServer2 = this.SEDU.put(string, httpRptServer);
        if (httpRptServer2 == null) {
            return true;
        }
        if (httpRptServer == httpRptServer2) {
            ServiceLogger.logDebug(4650093, new Object[]{httpRptServer, string}, 4);
            return false;
        }
        ServiceLogger.logDebug(4650094, new Object[]{httpRptServer, string, httpRptServer2}, 4);
        return true;
    }

    public HttpRptServer getBindedRptServer(String string) {
        HttpRptServer httpRptServer = (HttpRptServer)this.SEDU.get(string);
        if (httpRptServer == null && this.isCluster) {
            List list = this.getMembers();
            ServiceLogger.logDebug(0x46F46F, string, 4);
            Pattern pattern = Pattern.compile(".*@(-?\\d+)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                int n = Integer.parseInt(matcher.group(1));
                for (Member member : list) {
                    if (member.getID() != n) continue;
                    httpRptServer = this.getRptServerByMember(member);
                    this.bindRptServer(httpRptServer, string);
                    break;
                }
            }
            if (httpRptServer == null) {
                ServiceLogger.logError("HttpRptServerDispatcher:: Binded RptServer not found for id " + string + ", members=" + list);
            }
        } else if (httpRptServer == null) {
            httpRptServer = this.bootstrapServer;
            ServiceLogger.logDebug("HttpRptServerDispatcher:: Binded RptServer not found, use default bootstrapServer for id " + string);
        }
        ServiceLogger.logDebug(6650096, new Object[]{string, httpRptServer}, 7);
        return httpRptServer;
    }

    public boolean unbindRptServer(String string) {
        HttpRptServer httpRptServer = (HttpRptServer)this.SEDU.remove(string);
        ServiceLogger.logDebug(6650097, new Object[]{string, httpRptServer}, 6);
        return httpRptServer != null;
    }
}

