/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.http;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jet.server.api.SystemPerformanceInfo;
import jet.server.api.cluster.Member;
import jet.server.api.http.HttpRptServer;
import jet.server.jrc.http.HttpRptServerDispatcher;
import jet.server.jrc.http.PerformanceLoad;
import jet.server.jrc.http.PerformanceSelector;
import jet.server.log.ServiceLogger;

class SystemPerformanceLoadDispatcher
extends HttpRptServerDispatcher {
    private PerformanceSelector SEDU = new PerformanceSelector();

    public SystemPerformanceLoadDispatcher(HttpRptServer httpRptServer) {
        super(httpRptServer);
    }

    @Override
    protected HttpRptServer doDispatch(HttpServletRequest httpServletRequest) {
        if (this.isCluster) {
            List list = super.getMembers();
            ArrayList<PerformanceLoad> arrayList = new ArrayList<PerformanceLoad>();
            for (Object object : list) {
                try {
                    SystemPerformanceInfo systemPerformanceInfo = super.getRptServerByMember((Member)object).getSystemPerformanceInfo();
                    PerformanceLoad performanceLoad = new PerformanceLoad(systemPerformanceInfo);
                    performanceLoad.setMember((Member)object);
                    arrayList.add(performanceLoad);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
            if (!arrayList.isEmpty()) {
                Object object;
                PerformanceLoad performanceLoad = this.SEDU.selectBestPerformance(arrayList);
                if (ServiceLogger.isLoggable(4, 7)) {
                    ServiceLogger.logDebug("HttpRptServerDispatcher::dispatch: performanceData=" + arrayList, 7);
                }
                ServiceLogger.logDebug("HttpRptServerDispatcher::dispatch : the best performance=" + performanceLoad, 6);
                object = super.getRptServerByMember(performanceLoad.getMember());
                if (object != null) {
                    return object;
                }
            }
        }
        return this.bootstrapServer;
    }
}

