/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.misc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
class InteractiveReportPrecisionMapping {
    private List<PrecisionMapping> mappings = new ArrayList<PrecisionMapping>();

    InteractiveReportPrecisionMapping() {
    }

    public String toString() {
        return this.mappings.toString();
    }

    @XmlElementRef
    public List<PrecisionMapping> getMappings() {
        return this.mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefault(File file) throws JAXBException, IOException {
        this.mappings.clear();
        this.mappings.add(new PrecisionMapping("Trident/7\\.0; rv:11\\.", true, "IE 11.x"));
        this.mappings.add(new PrecisionMapping("MSIE 10\\.", true, "IE 10.x"));
        this.mappings.add(new PrecisionMapping("MSIE 9\\.", true, "IE 9.x"));
        this.mappings.add(new PrecisionMapping("Linux.* Firefox/", true, "Firefox on Linux"));
        this.mappings.add(new PrecisionMapping("Linux.* Chrome/", true, "Chrome on Linux"));
        this.mappings.add(new PrecisionMapping("Chrome/4", true, "Chrome 4x.xxx"));
        this.mappings.add(new PrecisionMapping(".*", false, "Elsewhere Default LOW precision"));
        Marshaller mr = JAXBContext.newInstance((Class[])new Class[]{InteractiveReportPrecisionMapping.class}).createMarshaller();
        mr.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream out = new FileOutputStream(file);
        try {
            mr.marshal((Object)this, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public static InteractiveReportPrecisionMapping load(File file) throws JAXBException {
        return (InteractiveReportPrecisionMapping)JAXBContext.newInstance((Class[])new Class[]{InteractiveReportPrecisionMapping.class}).createUnmarshaller().unmarshal(file);
    }

    @XmlRootElement
    static class PrecisionMapping {
        private boolean highPrecision;
        private String description;
        private String userAgentPattern;
        private Pattern pattern;

        protected PrecisionMapping() {
        }

        protected PrecisionMapping(String userAgentPattern, boolean highPrecision, String description) {
            this.userAgentPattern = userAgentPattern;
            this.highPrecision = highPrecision;
            this.description = description;
        }

        @XmlElement
        public String getUserAgentPattern() {
            return this.userAgentPattern;
        }

        @XmlTransient
        public Pattern getPattern() {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.userAgentPattern, 2);
            }
            return this.pattern;
        }

        @XmlElement
        public boolean isHighPrecision() {
            return this.highPrecision;
        }

        @XmlElement
        public String getDescription() {
            return this.description;
        }

        public void setHighPrecision(boolean highPrecision) {
            this.highPrecision = highPrecision;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setUserAgentPattern(String userAgentPattern) {
            this.userAgentPattern = userAgentPattern;
        }

        public String toString() {
            return "{userAgentPattern=" + this.userAgentPattern + ", highPrecision=" + this.highPrecision + ", description=" + this.description + "}";
        }
    }
}

