/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.misc;

import java.io.File;
import java.util.regex.Pattern;
import jet.ReportEnv;
import jet.server.jrc.misc.InteractiveReportPrecisionMapping;
import jet.server.jrc.misc.ServerMiscConfig;
import jet.server.log.ServiceLogger;
import jet.server.rmi.rpc.util.RemotableObjectUtil;

public final class JRServerMiscConfig
extends RemotableObjectUtil
implements ServerMiscConfig {
    private static ServerMiscConfig miscConfig;
    private InteractiveReportPrecisionMapping interactiveReportPrecisionMapping;

    public static ServerMiscConfig getInstance() {
        if (miscConfig == null) {
            JRServerMiscConfig.init();
        }
        return miscConfig;
    }

    public static void init() {
        miscConfig = (ServerMiscConfig)new JRServerMiscConfig().proxyIfRemote();
    }

    private JRServerMiscConfig() {
    }

    @Override
    protected void initLoad() {
        ServiceLogger.logDebug("JRServerMiscConfig initLoad.");
        this.interactiveReportPrecisionMapping = new InteractiveReportPrecisionMapping();
        try {
            File file = new File(ReportEnv.binPath, "interactiveReportPrecisionMapping.xml");
            if (file.exists()) {
                this.interactiveReportPrecisionMapping = InteractiveReportPrecisionMapping.load(file);
                ServiceLogger.logDebug("JRServerMiscConfig load interactiveReportPrecisionMapping: " + this.interactiveReportPrecisionMapping);
            } else {
                this.interactiveReportPrecisionMapping.saveDefault(file);
                ServiceLogger.logDebug("JRServerMiscConfig save default interactiveReportPrecisionMapping: " + this.interactiveReportPrecisionMapping);
            }
        }
        catch (Exception e) {
            ServiceLogger.logError(e);
        }
    }

    @Override
    public int getInteractiveReportPrecision(String userAgentHeader) {
        int ret = 1;
        for (InteractiveReportPrecisionMapping.PrecisionMapping m : this.interactiveReportPrecisionMapping.getMappings()) {
            Pattern p = null;
            try {
                p = m.getPattern();
            }
            catch (Exception e) {
                ServiceLogger.logError(e, 3);
            }
            if (p == null || !p.matcher(userAgentHeader).find()) continue;
            ret = m.isHighPrecision() ? 2 : 1;
            break;
        }
        ServiceLogger.logDebug("JRServerMiscConfig getInteractiveReportPrecision: highPrecision=" + (ret == 2) + ", " + userAgentHeader, 6);
        return ret;
    }
}

