/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.quartz;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import jet.server.jrc.quartz.QuartzEnv;
import jet.server.log.ServiceLogger;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerConfigException;
import org.quartz.impl.jdbcjobstore.AttributeRestoringConnectionInvocationHandler;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.utils.DBConnectionManager;

public class JRJobStoreSupport
extends JobStoreSupport {
    private boolean SEDU = false;
    private boolean append = false;
    private boolean close = false;
    private boolean currentThread = false;
    private boolean equalsIgnoreCase = false;
    private boolean error = false;
    private boolean execute = false;

    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) throws SchedulerConfigException {
        super.initialize(classLoadHelper, schedulerSignaler);
        String string = QuartzEnv.getDatabase().getProductDBName();
        if (string.equalsIgnoreCase("Oracle") || string.startsWith("Oracle")) {
            this.SEDU = true;
        } else if (string.equalsIgnoreCase("Apache Derby") || string.startsWith("Apache Derby")) {
            this.append = true;
        } else if (string.equalsIgnoreCase("DB2") || string.startsWith("DB2")) {
            this.close = true;
        } else if (string.equalsIgnoreCase("MySQL") || string.startsWith("MySQL")) {
            this.currentThread = true;
        } else if (string.equalsIgnoreCase("Adaptive Server Enterprise") || string.startsWith("Adaptive Server Enterprise")) {
            this.equalsIgnoreCase = true;
        } else if (string.equalsIgnoreCase("Informix Dynamic Server") || string.startsWith("Informix")) {
            this.error = true;
        } else if (string.equalsIgnoreCase("Microsoft SQL Server") || string.startsWith("Microsoft SQL Server")) {
            this.execute = true;
        }
        Object[] objectArray = new Object[]{string, this.isDontSetAutoCommitFalse(), this.isTxIsolationLevelSerializable()};
        ServiceLogger.logDebug(6610022, objectArray, 6);
    }

    protected Connection getNonManagedTXConnection() throws JobPersistenceException {
        Connection connection = null;
        try {
            connection = DBConnectionManager.getInstance().getConnection(this.getDataSource());
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + sQLException.toString(), (Throwable)sQLException);
        }
        catch (Throwable throwable) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + throwable.toString(), throwable, 499);
        }
        if (connection == null) {
            throw new JobPersistenceException("Could not get connection from DataSource '" + this.getDataSource() + "'");
        }
        connection = this.getAttributeRestoringConnection(connection);
        try {
            if (this.SEDU || this.currentThread || this.equalsIgnoreCase || this.error || this.execute) {
                connection.setTransactionIsolation(2);
            } else if (this.append || this.close) {
                connection.setTransactionIsolation(4);
            } else if (this.isTxIsolationLevelSerializable()) {
                connection.setTransactionIsolation(8);
            }
            if (!this.isDontSetAutoCommitFalse()) {
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new JobPersistenceException("Failure setting up connection.", throwable);
        }
        return connection;
    }

    protected Connection getAttributeRestoringConnection(final Connection connection) {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new AttributeRestoringConnectionInvocationHandler(connection){

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (method.getName().equals("setAutoCommit")) {
                    this.setAutoCommit((Boolean)objectArray[0]);
                } else if (method.getName().equals("setTransactionIsolation")) {
                    this.setTransactionIsolation((Integer)objectArray[0]);
                } else if (method.getName().equals("close")) {
                    this.close();
                } else {
                    try {
                        return method.invoke((Object)connection, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                }
                return null;
            }
        });
    }

    protected Object executeInLock(String string, JobStoreSupport.TransactionCallback transactionCallback) throws JobPersistenceException {
        return this.executeInNonManagedTXLock(string, transactionCallback);
    }

    protected void rollbackConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                this.getLog().error((Object)("Couldn't rollback jdbc connection. " + sQLException.getMessage()), (Throwable)sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeInNonManagedTXLock(String string, JobStoreSupport.TransactionCallback transactionCallback) throws JobPersistenceException {
        boolean bl = false;
        Connection connection = null;
        try {
            if (string != null) {
                if (this.getLockHandler().requiresConnection()) {
                    connection = this.getNonManagedTXConnection();
                }
                bl = this.getLockHandler().obtainLock(connection, string);
            }
            if (connection == null) {
                connection = this.getNonManagedTXConnection();
            }
            Object object = transactionCallback.execute(connection);
            this.commitConnection(connection);
            Object object2 = object;
            return object2;
        }
        catch (JobPersistenceException jobPersistenceException) {
            ServiceLogger.logError(jobPersistenceException);
            this.rollbackConnection(connection);
            throw jobPersistenceException;
        }
        catch (RuntimeException runtimeException) {
            ServiceLogger.logError(runtimeException);
            this.rollbackConnection(connection);
            int n = 0;
            try {
                n = connection.getTransactionIsolation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new JobPersistenceException("TransactionIsolationLevel=" + n + ", lockName=" + string + ", unexpected runtime exception: " + runtimeException.getMessage(), (Throwable)runtimeException);
        }
        finally {
            try {
                this.releaseLock(connection, string, bl);
            }
            finally {
                this.cleanupConnection(connection);
            }
        }
    }
}

