/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.quartz;

import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.cluster.ClusterEnv;
import jet.server.intf.jrs.SchedulingService;
import jet.server.jrc.quartz.JRTriggerListener;
import jet.server.jrc.quartz.QuartzEnv;
import jet.server.lease.JRLeaseAction;
import jet.server.lease.JRLeaseBasicThread;
import jet.server.lease.JRLeaseImpl;
import jet.server.log.ServiceLogger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;

public class JRSchedulerManger
implements JRLeaseAction {
    private static JRSchedulerManger SEDU = null;
    private Scheduler activate = null;
    private SchedulingService addGlobalTriggerListener = null;
    private boolean addLease = ServerEnv.isClusterEnabled();

    public static synchronized JRSchedulerManger getInstance() throws Exception {
        if (SEDU == null) {
            SEDU = new JRSchedulerManger();
        }
        return SEDU;
    }

    public JRSchedulerManger() throws Exception {
        this.activate = QuartzEnv.createScheduler("JRReportScheduler", String.valueOf(ClusterEnv.getMemberID()));
    }

    public Scheduler getScheduler() {
        return this.activate;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.addGlobalTriggerListener = schedulingService;
    }

    public void start() throws Exception {
        JRTriggerListener jRTriggerListener = new JRTriggerListener();
        jRTriggerListener.setSchedulingService(this.addGlobalTriggerListener);
        this.activate.addGlobalTriggerListener((TriggerListener)jRTriggerListener);
        JRLeaseBasicThread jRLeaseBasicThread = null;
        boolean bl = false;
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.lease.enabled");
        if (null != string && string.length() > 0) {
            bl = Boolean.parseBoolean(string);
        }
        if (this.addLease && bl) {
            String string2;
            String string3;
            Properties properties = new Properties();
            String string4 = ServerEnv.getPropertyFromClusterRegistry("cluster.scheduler.lease.valid_time");
            if (null != string4 && string4.length() > 0) {
                properties.setProperty("valid_time", string4);
            }
            if (null != (string3 = ServerEnv.getPropertyFromClusterRegistry("cluster.scheduler.lease.active_time")) && string3.length() > 0) {
                properties.setProperty("max_lease_count", string3);
            }
            if (null != (string2 = ServerEnv.getPropertyFromClusterRegistry("cluster.scheduler.lease.check_interval")) && string2.length() > 0) {
                properties.setProperty("dead_lease_check_interval", string2);
            }
            jRLeaseBasicThread = new JRLeaseBasicThread(properties);
            String string5 = jRLeaseBasicThread.getConfig().getProperty("valid_time");
            long l = 300L;
            if (string5 != null) {
                try {
                    l = Long.valueOf(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    ServiceLogger.logError(numberFormatException);
                }
            }
            JRLeaseImpl jRLeaseImpl = JRLeaseImpl.generateSchedulerLease(l);
            jRLeaseBasicThread.addLease(jRLeaseImpl, true);
            jRLeaseBasicThread.registerAction(jRLeaseImpl.getType(), this);
            jRLeaseBasicThread.start();
        } else {
            boolean bl2 = this.activate();
            if (!bl2) {
                System.err.println("Failed to activate Quartz Scheduler.");
                throw new RuntimeException();
            }
        }
    }

    @Override
    public String getActionID() {
        return "Cluster_Scheduler_Action";
    }

    @Override
    public boolean activate() {
        try {
            if (!this.activate.isStarted() || this.activate.isInStandbyMode()) {
                this.activate.start();
                ServiceLogger.logDebug(6610013, this.activate.getSchedulerInstanceId(), 6);
            }
        }
        catch (SchedulerException schedulerException) {
            ServiceLogger.logError(schedulerException);
            return false;
        }
        return true;
    }

    @Override
    public boolean pause() {
        try {
            if (this.activate.isStarted()) {
                this.activate.standby();
                ServiceLogger.logDebug(6610014, this.activate.getSchedulerInstanceId(), 6);
            }
        }
        catch (SchedulerException schedulerException) {
            ServiceLogger.logError(schedulerException);
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof JRLeaseAction) {
            JRLeaseAction jRLeaseAction = (JRLeaseAction)object;
            return jRLeaseAction.getActionID().endsWith(this.getActionID());
        }
        return false;
    }
}

