/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.quartz;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.JCliResource;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.exception.InvalidParameterException;
import jet.server.ServerEnv;
import jet.server.api.PathInfo;
import jet.server.api.Permissions;
import jet.server.api.RptServerException;
import jet.server.api.crd.CRDInfo;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDManageException;
import jet.server.api.crd.CubeInfo;
import jet.server.api.crd.CubeInfoKey;
import jet.server.api.exception.NoLiveLicenseException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpUtil;
import jet.server.api.trigger.TriggerManager;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.cluster.core.ClusterServer;
import jet.server.intf.jrs.ScheduleControllerService;
import jet.server.intf.jrs.SchedulingService;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.JRTaskManager;
import jet.server.jrc.ScriptFileSubmit;
import jet.server.jrc.StartupContext;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.jrc.quartz.JRBasicTrigger;
import jet.server.jrc.quartz.JRCRDExpireJob;
import jet.server.jrc.quartz.JRCRDExpireQuartzTrigger;
import jet.server.jrc.quartz.JRRepeatQuartzTrigger;
import jet.server.jrc.quartz.JRSchedulerManger;
import jet.server.jrc.quartz.JRTaskJob;
import jet.server.jrc.quartz.JRTimeQuartzTrigger;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.jrc.quartz.QuartzEnv;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRParameterManager;
import jet.server.jrserver.JRResourceManager;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.crd.JRCRDManager;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.AccessSchedule;
import jet.server.schedule.ExeTimeInfo;
import jet.server.schedule.InternalTask;
import jet.server.schedule.JetLch;
import jet.server.schedule.JetSchds;
import jet.server.schedule.ParameterManager;
import jet.server.schedule.SchdTools;
import jet.server.schedule.ScheduleController;
import jet.server.schedule.ScheduledTask;
import jet.server.schedule.ScheduledTaskImpl;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.util.ConnectionInfo;
import jet.server.schedule.util.DatasourceInfo;
import jet.server.trigger.TriggerManagerImpl;
import jet.server.util.StringUtils;
import jet.util.WildcardMatcher;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import timer.Timer;

public class JRSchedulingServiceQuartzImpl
implements SchedulingService {
    private Scheduler P_READ = null;
    private JRTaskManager P_WRITE = null;
    private TriggerManager SEDU = null;
    private ScheduleController add = null;
    private ClusterMap addElement = null;
    private ClusterMap addListener = null;
    private ClusterMap addTask = null;
    private boolean addTaskToFire = false;
    private LinkedList addTaskToRemove = new LinkedList();
    private LinkedList addTriggerToReschedule = new LinkedList();
    private RemoveScheduledTaskThread after = null;
    private RescheduleTriggerThread append = null;
    private HashMap before = new HashMap();
    private String checkPermission = null;
    private String checkPublishingPermission = null;
    private JRResourceManager checkReportTaskProp;
    private boolean clear = false;
    private Vector clearMem = new Vector();
    private Vector clone = new Vector();
    private HashMap close = new HashMap();

    public JRSchedulingServiceQuartzImpl(JRTaskManager jRTaskManager, JRResourceManager jRResourceManager) throws RemoteException {
        this.P_WRITE = jRTaskManager;
        this.checkReportTaskProp = jRResourceManager;
        this.checkPermission = jRResourceManager.getRealm();
        this.checkPublishingPermission = jRResourceManager.getRealmDir();
        this.addTaskToFire = ServerEnv.isClusterEnabled();
        this.after = new RemoveScheduledTaskThread();
        this.append = new RescheduleTriggerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean bl) throws Exception {
        this.P_READ = JRSchedulerManger.getInstance().getScheduler();
        this.SEDU = TriggerManagerImpl.getInstance();
        this.add = new ScheduleController(this, this.P_READ);
        if (ServerEnv.shouldStartRMI()) {
            UnicastRemoteObject.exportObject((Remote)this.add, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        }
        this.add.start();
        RemoteObjectFactory.register("ScheduleController", this.add);
        QuartzEnv.setScheduleController(this.add);
        this.addElement = MapFactory.getMap(MapAttr.scheduledTaskMap);
        this.addElement.addListener(new MapListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterPut(String string, int n, String string2, ScheduledTaskImpl scheduledTaskImpl, ScheduledTaskImpl scheduledTaskImpl2, MapFlags mapFlags) {
                if (1.isLocalEvent(n)) {
                    return;
                }
                Object[] objectArray = new Object[]{string2, scheduledTaskImpl, scheduledTaskImpl2};
                ServiceLogger.logDebug(6610007, objectArray, 6);
                ScheduledTask scheduledTask = JRSchedulingServiceQuartzImpl.this.add.getTask(string2);
                if (null == scheduledTask) {
                    JRSchedulingServiceQuartzImpl.this.add.addTask(scheduledTaskImpl);
                } else if (!scheduledTask.equals(scheduledTaskImpl)) {
                    JRSchedulingServiceQuartzImpl.this.add.delTask(scheduledTask);
                    JRSchedulingServiceQuartzImpl.this.add.addTask(scheduledTaskImpl);
                }
                HashMap hashMap = JRSchedulingServiceQuartzImpl.this.before;
                synchronized (hashMap) {
                    if (JRSchedulingServiceQuartzImpl.this.before.containsKey(string2)) {
                        JRSchedulingServiceQuartzImpl.this.before.remove(string2);
                        ServiceLogger.logDebug(6610025, string2, 6);
                        JRSchedulingServiceQuartzImpl.this.add.fireTaskTimeReady(string2);
                    }
                }
            }

            public void afterRemove(String string, int n, String string2, ScheduledTaskImpl scheduledTaskImpl, MapFlags mapFlags) {
                if (1.isLocalEvent(n)) {
                    return;
                }
                Object[] objectArray = new Object[]{string2, scheduledTaskImpl};
                ServiceLogger.logDebug(6610008, objectArray, 6);
                ScheduledTask scheduledTask = JRSchedulingServiceQuartzImpl.this.add.getTask(string2);
                if (null != scheduledTask) {
                    boolean bl = JRSchedulingServiceQuartzImpl.this.add.setCausedByClusterMapSync(true);
                    JRSchedulingServiceQuartzImpl.this.add.delTask(scheduledTask);
                    JRSchedulingServiceQuartzImpl.this.add.setCausedByClusterMapSync(bl);
                }
            }
        });
        ScheduleController scheduleController = this.add;
        synchronized (scheduleController) {
            for (Object object2 : this.addElement.entrySet()) {
                String string = (String)object2.getKey();
                ScheduledTask scheduledTask = this.add.getTask(string);
                if (null != scheduledTask) {
                    this.add.delTask(scheduledTask);
                }
                this.add.addTask((ScheduledTask)object2.getValue());
            }
        }
        this.after.start();
        this.append.start();
        this.addListener = MapFactory.getMap(MapAttr.JRTriggersMap);
        this.addListener.addListener(new MapListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterPut(String string, int n, String string2, JRTrigger jRTrigger, JRTrigger jRTrigger2, MapFlags mapFlags) {
                if (2.isLocalEvent(n)) {
                    return;
                }
                Object[] objectArray = new Object[]{string2, jRTrigger, jRTrigger2};
                ServiceLogger.logDebug(6610009, objectArray, 6);
                ScheduledTask scheduledTask = JRSchedulingServiceQuartzImpl.this.add.getTask(string2);
                if (null != scheduledTask) {
                    ScheduledTask scheduledTask2 = scheduledTask;
                    synchronized (scheduledTask2) {
                        scheduledTask.setJRTrigger(jRTrigger);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRemove(String string, int n, String string2, JRTrigger jRTrigger, MapFlags mapFlags) {
                if (2.isLocalEvent(n)) {
                    return;
                }
                Object[] objectArray = new Object[]{string2, jRTrigger};
                ServiceLogger.logDebug(6610010, objectArray, 6);
                ScheduleController scheduleController = JRSchedulingServiceQuartzImpl.this.add;
                synchronized (scheduleController) {
                }
            }
        });
        this.addTask = MapFactory.getMap(MapAttr.flagsMap);
        this.addTask.addListener(new MapListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterPut(String string, int n, String string2, HashMap hashMap, HashMap hashMap2, MapFlags mapFlags) {
                if (3.isLocalEvent(n)) {
                    return;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = string2;
                objectArray[1] = hashMap;
                objectArray[1] = hashMap2;
                ServiceLogger.logDebug(6610011, objectArray, 6);
                ScheduledTask scheduledTask = JRSchedulingServiceQuartzImpl.this.add.getTask(string2);
                if (null != scheduledTask && !scheduledTask.getFlags().equals(hashMap)) {
                    ScheduledTask scheduledTask2 = scheduledTask;
                    synchronized (scheduledTask2) {
                        scheduledTask.setFlags(hashMap);
                    }
                }
            }

            public void afterRemove(String string, int n, String string2, HashMap hashMap, MapFlags mapFlags) {
                if (3.isLocalEvent(n)) {
                    return;
                }
                Object[] objectArray = new Object[]{string2, hashMap};
                ServiceLogger.logDebug(6610012, objectArray, 6);
            }
        });
        if (!bl || this.addElement.isEmpty() && ClusterServer.getMemberService().isCoordinator()) {
            this.loadSchedules();
            for (Object object : this.close.keySet()) {
                Object object2;
                object2 = this.getCRDTask((String)object);
                object2 = (Properties)((Properties)object2).clone();
                ((Properties)object2).remove("jrs.cache_BV");
                ((Properties)object2).remove("jrs.cache_aggregation");
                ((Properties)object2).putAll((Map<?, ?>)((Map)this.close.get(object)));
                try {
                    this.submit((Properties)object2, true, true);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
            this.close.clear();
        }
        this.clear = true;
    }

    public Scheduler getScheduler() {
        return this.P_READ;
    }

    public ClusterMap getScheduledTaskMap() {
        return this.addElement;
    }

    public ClusterMap getJRTriggersMap() {
        return this.addListener;
    }

    public ClusterMap getFlagsMap() {
        return this.addTask;
    }

    public ScheduleControllerService getScheduleControoler() {
        return this.add;
    }

    public JRResourceManager getResourceManager() {
        return this.checkReportTaskProp;
    }

    private boolean JRTriggersMap(JRTrigger jRTrigger) {
        String string = "JR_JOB_" + jRTrigger.getTaskID();
        JobDetail jobDetail = new JobDetail(string, "JR_DETAULT_GROUP", JRTaskJob.class);
        jobDetail.setRequestsRecovery(true);
        Properties properties = jRTrigger.getTask();
        jobDetail.getJobDataMap().put("jrs.uid", jRTrigger.getUid());
        jobDetail.getJobDataMap().put("jrs.task_id", jRTrigger.getTaskID());
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            jobDetail.getJobDataMap().put((Object)string2, properties.get(string2));
        }
        try {
            this.P_READ.scheduleJob(jobDetail, (Trigger)jRTrigger);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return true;
    }

    private void P_READ() {
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            ArrayList<CRDInfoKey> arrayList = new ArrayList<CRDInfoKey>();
            stringArray = this.P_READ.getJobGroupNames();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2 = this.P_READ.getJobNames(stringArray[i]);
                for (int j = 0; j < stringArray2.length; ++j) {
                    Trigger[] triggerArray = this.P_READ.getTriggersOfJob(stringArray2[j], stringArray[i]);
                    for (int k = 0; k < triggerArray.length; ++k) {
                        Serializable serializable;
                        block28: {
                            if (triggerArray[k] instanceof JRCRDExpireQuartzTrigger) continue;
                            if (triggerArray[k] instanceof JRTimeQuartzTrigger || triggerArray[k] instanceof JRRepeatQuartzTrigger) {
                                Object object;
                                serializable = ((JRTrigger)triggerArray[k]).getNextFireTime();
                                boolean bl = ((JRTrigger)triggerArray[k]).isEnable();
                                boolean bl2 = "jet.server.schedule.jrtasks.PublishCRDTask".equals(((JRTrigger)triggerArray[k]).getTask().getProperty("jrs.task_class"));
                                boolean bl3 = CSUtil.getBoolean(((JRTrigger)triggerArray[k]).getTask().getProperty("jrs.is_cube"), false);
                                if (bl && (null == serializable || ((Date)serializable).before(new Date()))) {
                                    object = ((JRTrigger)triggerArray[k]).getTask().getProperty("jrs.rerun_missed_task", "false");
                                    if (((String)object).equalsIgnoreCase("true")) {
                                        if (triggerArray[k] instanceof JRTimeQuartzTrigger) {
                                            ((JRTimeQuartzTrigger)triggerArray[k]).triggered(null);
                                        } else if (triggerArray[k] instanceof JRRepeatQuartzTrigger) {
                                            ((JRRepeatQuartzTrigger)triggerArray[k]).triggered(null);
                                        }
                                        this.runTask(SchdTools.toProperties((JRTrigger)triggerArray[k]));
                                        if (bl2 || triggerArray[k] instanceof JRRepeatQuartzTrigger) {
                                            if (triggerArray[k] instanceof JRRepeatQuartzTrigger) {
                                                ((JRRepeatQuartzTrigger)triggerArray[k]).setLastExeTime(System.currentTimeMillis());
                                            } else {
                                                ((JRTimeQuartzTrigger)triggerArray[k]).setLastExeTime(System.currentTimeMillis());
                                            }
                                            try {
                                                this.P_READ.rescheduleJob(triggerArray[k].getName(), triggerArray[k].getGroup(), triggerArray[k]);
                                            }
                                            catch (Throwable throwable) {
                                                ServiceLogger.logError(throwable);
                                            }
                                        }
                                    }
                                    if (!bl2 && triggerArray[k] instanceof JRTimeQuartzTrigger && !(triggerArray[k] instanceof JRBasicTrigger)) {
                                        try {
                                            this.P_READ.unscheduleJob(triggerArray[k].getName(), stringArray[i]);
                                        }
                                        catch (Exception exception) {
                                            ServiceLogger.logError(exception);
                                        }
                                        continue;
                                    }
                                }
                                if (bl2 && !bl3 && triggerArray[k] instanceof JRTimeQuartzTrigger && !((Date)(serializable = ((JRTrigger)triggerArray[k]).getNextFireTime())).before((Date)(object = new Date(399, 11, 31, 23, 59, 59)))) {
                                    Properties properties;
                                    int n;
                                    String string = ((JRTrigger)triggerArray[k]).getTaskID();
                                    String string2 = "JR_TRG_CRD_" + string;
                                    Trigger trigger = null;
                                    try {
                                        trigger = this.P_READ.getTrigger(string2, stringArray[i]);
                                    }
                                    catch (Exception exception) {
                                        ServiceLogger.logError(exception);
                                    }
                                    if (null == trigger && (2 == (n = CSUtil.parseInt((String)(properties = ((JRTimeQuartzTrigger)triggerArray[k]).getTask()).get("jrs.crd_expire"), 2)) || 1 == n)) {
                                        String string3 = (String)properties.get("jrs.catalog");
                                        String string4 = (String)properties.get("jrs.data_source_name");
                                        int n2 = CSUtil.parseInt((String)properties.get("jrs.query_type"), 0);
                                        String string5 = (String)properties.get("jrs.query_name");
                                        JRRptServer jRRptServer = (JRRptServer)((Object)HttpUtil.getHttpRptServer());
                                        JRCRDManager jRCRDManager = jRRptServer.getCRDManager();
                                        CRDInfoKey cRDInfoKey = new CRDInfoKey(string3, string4, n2, string5);
                                        arrayList.add(cRDInfoKey);
                                    }
                                }
                            }
                            if (!ReportEnv.isLive()) {
                                serializable = ((JRTrigger)triggerArray[k]).getTask();
                                String string = ((Properties)serializable).getProperty("jrs.uid");
                                String string6 = ((Properties)serializable).getProperty("jrs.report");
                                try {
                                    if (this.checkReportTaskProp.getPathInfo(string, string6).isLiveReport()) {
                                    }
                                    break block28;
                                }
                                catch (RptServerException rptServerException) {
                                    ServiceLogger.logError((Throwable)((Object)rptServerException), 3);
                                    if (!(rptServerException.getCause().getCause() instanceof NoLiveLicenseException)) break block28;
                                }
                                continue;
                            }
                        }
                        serializable = new ScheduledTaskImpl((JRTrigger)triggerArray[k]);
                        this.add.addTask((ScheduledTask)((Object)serializable));
                        this.addElement.put(((JRTrigger)triggerArray[k]).getTaskID(), serializable);
                    }
                }
            }
            if (arrayList.size() > 0) {
                StartupContext.put("expired_crdresult", arrayList);
            }
        }
        catch (SchedulerException schedulerException) {
            ServiceLogger.logError(schedulerException);
        }
    }

    public synchronized void loadSchedules() throws Exception {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        AccessSchedule accessSchedule;
        int n2;
        Hashtable<String[], Object> hashtable = new Hashtable<String[], Object>();
        String string2 = this.checkPublishingPermission;
        if (!string2.endsWith(CSUtil.fileSep)) {
            string2 = string2 + CSUtil.fileSep;
        }
        if ((n2 = (accessSchedule = new AccessSchedule(string = string2 + this.checkPermission + CSUtil.fileSep + this.checkPermission)).loadSum()) == 0) {
            ++n2;
        }
        for (int i = 0; i < n2; ++i) {
            String string3 = i == 0 ? string : string + String.valueOf(i);
            String string4 = string3 + ".tsk";
            File file = new File(string4);
            File file2 = new File(string4 + ".bak");
            boolean bl = false;
            boolean bl2 = false;
            if (file.exists()) {
                try {
                    object5 = new BufferedReader(new FileReader(file.getCanonicalPath()));
                    while (null != (object4 = ((BufferedReader)object5).readLine())) {
                        try {
                            object3 = CSUtil.parseQuery((String)object4);
                            object2 = (String)((Properties)object3).get("jrs.param_file");
                            if (object2 != null) {
                                ((Properties)object3).put("jrs.param_file", this.getResourceManager().getHistDir() + CSUtil.getFileNameOnly((String)object2));
                            }
                            if ((object = (String)((Properties)object3).get("jrs.task_id")) == null) continue;
                            hashtable.put((String[])object, object3);
                            bl2 = true;
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logError(throwable);
                        }
                    }
                    ((BufferedReader)object5).close();
                    if (!bl && bl2) {
                        file2.delete();
                        file.renameTo(file2);
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            string4 = string3 + "_int.tsk";
            file = new File(string4);
            file2 = new File(string4 + ".bak");
            bl = false;
            bl2 = false;
            if (file.exists()) {
                try {
                    object5 = new BufferedReader(new FileReader(file.getCanonicalPath()));
                    while (null != (object4 = ((BufferedReader)object5).readLine())) {
                        try {
                            object3 = CSUtil.parseQuery((String)object4);
                            object = (String)((Properties)object3).get("jrs.task_id");
                            if (object == null) continue;
                            hashtable.put((String[])object, object3);
                            bl2 = true;
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logError(throwable);
                        }
                    }
                    ((BufferedReader)object5).close();
                    if (!bl && bl2) {
                        file2.delete();
                        file.renameTo(file2);
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            string4 = string3 + ".sch";
            file = new File(string4);
            file2 = new File(string4 + ".bak");
            bl = false;
            bl2 = false;
            if (!file.exists()) continue;
            object5 = new File(string + ".idx");
            if (!((File)object5).exists()) {
                object3 = JetSchds.loadFromFile(file.getCanonicalPath());
                if (object3 != null) {
                    object4 = object3.getChildren();
                    object = null;
                    object2 = null;
                    n = ((Vector)object4).size();
                    for (int j = 0; j < n; ++j) {
                        object = (JetObject)((Vector)object4).elementAt(j);
                        if (!(object instanceof JetLch) || (object2 = ((JetLch)((Object)object)).createTrigger(hashtable)) == null) continue;
                        ((JRTrigger)((Object)object2)).setEnable(true);
                        bl2 = this.JRTriggersMap((JRTrigger)((Object)object2));
                    }
                    ((JetSchds)((Object)object3)).clearMem();
                }
                if (bl || !bl2) continue;
                file2.delete();
                file.renameTo(file2);
                continue;
            }
            try {
                object3 = new BufferedReader(new FileReader(file.getCanonicalPath()));
                while (null != (object = ((BufferedReader)object3).readLine())) {
                    try {
                        Object obj;
                        object4 = CSUtil.parseQuery((String)object);
                        object2 = (String)((Hashtable)object4).get("jrs.task_class");
                        JRTrigger jRTrigger = null;
                        if (object2 == null || !((obj = Class.forName(((String)object2).trim()).newInstance()) instanceof JetLch)) continue;
                        JetLch jetLch = (JetLch)((Object)obj);
                        jetLch.init((Hashtable)object4);
                        jRTrigger = jetLch.createTrigger(hashtable);
                        if (jRTrigger == null) continue;
                        bl2 = this.JRTriggersMap(jRTrigger);
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                    }
                }
                ((BufferedReader)object3).close();
                if (bl || !bl2) continue;
                file2.delete();
                file.renameTo(file2);
                continue;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        if (ServerEnv.isRestoreFromFile()) {
            String string5 = string2 + this.checkPermission + CSUtil.fileSep + "schedule" + CSUtil.fileSep;
            object5 = new File(string5);
            object3 = null;
            object4 = null;
            if (((File)object5).exists()) {
                object = ((File)object5).list((FilenameFilter)new WildcardMatcher("*.act", false));
                for (n = 0; n < ((String[])object).length; ++n) {
                    object2 = new BufferedReader(new FileReader(string5 + object[n]));
                    object3 = ((BufferedReader)object2).readLine();
                    ((BufferedReader)object2).close();
                    object4 = CSUtil.parseQuery((String)object3);
                    ((Properties)object4).put("jrs.launch_type", String.valueOf(0));
                    this.submit((Properties)object4, false);
                    object5 = new File(string5 + object[n]);
                    ((File)object5).delete();
                }
            }
        }
        if (!this.addTaskToFire || ClusterServer.getMemberService().isCoordinator()) {
            this.P_READ();
        }
    }

    private boolean P_WRITE(String string, String string2, String string3, String string4, int n, String string5) throws RemoteException {
        try {
            this.checkReportTaskProp.getPathInfo(string3, string4);
        }
        catch (Exception exception) {
            return string.equals(string3) || this.checkReportTaskProp.isAdminUser(string3);
        }
        return UserDataToolkit.securityAdapter.isPermissionOk(string2, string3, string4, n, string5);
    }

    private boolean SEDU(String string, String string2, String string3, String string4, String string5) {
        try {
            this.checkReportTaskProp.getPathInfo(string3, string4);
        }
        catch (Exception exception) {
            return string.equals(string3) || this.checkReportTaskProp.isAdminUser(string3);
        }
        return HttpUtil.getHttpRptServer().getHttpUserSessionManager().getAuthenticator().isPermissionOk(string2, string3, string4, string5);
    }

    public JRTrigger getTask(String string) {
        if (string == null) {
            return null;
        }
        ScheduledTask scheduledTask = this.add.getTask(string);
        return scheduledTask == null ? null : scheduledTask.getJRTrigger();
    }

    @Override
    public String copySchedules(String[] stringArray, String string) throws RemoteException {
        String string2 = null;
        String string3 = "jrs.submit_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return "SLT_PG_209";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRTrigger jRTrigger = this.getTask(stringArray[i]);
            if (jRTrigger == null) continue;
            try {
                Properties properties = SchdTools.toProperties(jRTrigger);
                properties.remove("jrs.task_id");
                properties.remove("jrs.engine_id");
                String string4 = (String)properties.get("jrs.report");
                if (string4 == null || this.SEDU(jRTrigger.getUid(), this.checkPermission, string, string4, string3)) {
                    this.submit(properties);
                    continue;
                }
                if (string2 == null) {
                    string2 = stringArray[i];
                    continue;
                }
                string2 = string2 + ";" + stringArray[i];
                continue;
            }
            catch (Throwable throwable) {
                string2 = string2 == null ? stringArray[i] : string2 + ";" + stringArray[i];
                ServiceLogger.logError(throwable);
            }
        }
        return string2;
    }

    @Override
    public void delScriptFile(String string) throws RemoteException {
        File file = new File(this.checkReportTaskProp.getSchedulePath() + string + ".script");
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public String deleteSchedules(String[] stringArray, String string) throws RemoteException {
        String string2 = null;
        String string3 = "jrs.del_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return "SLT_PG_209";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRTrigger jRTrigger = this.getTask(stringArray[i]);
            if (jRTrigger == null) continue;
            try {
                Properties properties = SchdTools.toProperties(jRTrigger);
                properties.remove("jrs.task_id");
                String string4 = (String)properties.get("jrs.report");
                if ((string4 == null || this.SEDU(jRTrigger.getUid(), this.checkPermission, string, string4, string3)) && this.removeScheduledTask(stringArray[i])) continue;
                if (string2 == null) {
                    string2 = stringArray[i];
                    continue;
                }
                string2 = string2 + ";" + stringArray[i];
                continue;
            }
            catch (Throwable throwable) {
                string2 = string2 == null ? stringArray[i] : string2 + ";" + stringArray[i];
                ServiceLogger.logError(throwable);
            }
        }
        return string2;
    }

    @Override
    public String deleteCRDSchedules(Vector vector, String string) {
        return this.add(vector, string, true);
    }

    private synchronized String add(Vector vector, String string, boolean bl) {
        if (vector == null || vector.size() == 0) {
            return "SLT_PG_209";
        }
        String string2 = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)vector.elementAt(i);
            JRTrigger jRTrigger = this.getTask(string3);
            if (jRTrigger == null) continue;
            try {
                Properties properties = SchdTools.toProperties(jRTrigger);
                properties.remove("jrs.task_id");
                if (this.removeScheduledTask(string3) && bl) {
                    String string4;
                    try {
                        String string5 = (String)properties.get("jrs.catalog");
                        string4 = (String)properties.get("jrs.data_source_name");
                        int n2 = CSUtil.parseInt((String)properties.get("jrs.query_type"), 0);
                        String string6 = (String)properties.get("jrs.query_name");
                        String string7 = (String)properties.get("jrs.bv_name");
                        boolean bl2 = CSUtil.getBoolean((String)properties.get("jrs.is_cube"), false);
                        JRRptServer jRRptServer = (JRRptServer)((Object)HttpUtil.getHttpRptServer());
                        JRCRDManager jRCRDManager = jRRptServer.getCRDManager();
                        CRDInfoKey cRDInfoKey = null;
                        cRDInfoKey = bl2 ? new CubeInfoKey(string5, string4, n2, string6, string7) : new CRDInfoKey(string5, string4, n2, string6);
                        if (jRCRDManager.getCRD(string, cRDInfoKey) != null) {
                            CRDInfo cRDInfo = jRCRDManager.getCRD(string, cRDInfoKey);
                            String string8 = cRDInfo.getParamFile();
                            jRCRDManager.deleteCRD(string, cRDInfoKey);
                            if (string8 != null && string8.length() > 0 && new File(HttpUtil.getHttpRptServer().getResourceManager().getHistDir() + string8).exists()) {
                                ParameterFileManager.getInstance().delete(HttpUtil.getHttpRptServer().getResourceManager().getHistDir() + string8);
                            }
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    int n3 = CSUtil.parseInt((String)properties.get("jrs.crd_expire"), 2);
                    if (2 != n3 && 1 != n3) continue;
                    string4 = "JR_TRG_CRD_" + string3;
                    try {
                        this.P_READ.unscheduleJob(string4, "JR_DETAULT_GROUP");
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    continue;
                }
                if (string2 == null) {
                    string2 = string3;
                    continue;
                }
                string2 = string2 + ";" + string3;
                continue;
            }
            catch (Throwable throwable) {
                string2 = string2 == null ? string3 : string2 + ";" + string3;
                ServiceLogger.logError(throwable);
            }
        }
        return string2;
    }

    @Override
    public boolean disableScheduledTask(String string) throws RemoteException {
        JRTrigger jRTrigger = this.getTask(string);
        if (null == jRTrigger || !jRTrigger.isEnable()) {
            return false;
        }
        jRTrigger.setEnable(false);
        this.addListener.put(jRTrigger.getTaskID(), (Object)jRTrigger);
        try {
            this.P_READ.rescheduleJob(jRTrigger.getName(), jRTrigger.getGroup(), (Trigger)jRTrigger);
        }
        catch (SchedulerException schedulerException) {
            ServiceLogger.logError(schedulerException);
            return false;
        }
        return true;
    }

    @Override
    public String disableSchedules(String[] stringArray, String string) throws RemoteException {
        String string2 = null;
        String string3 = "jrs.disable_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return "SLT_PG_209";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRTrigger jRTrigger = this.getTask(stringArray[i]);
            if (jRTrigger == null) continue;
            try {
                Properties properties = SchdTools.toProperties(jRTrigger);
                properties.remove("jrs.task_id");
                String string4 = (String)properties.get("jrs.report");
                if ((string4 == null || this.P_WRITE(jRTrigger.getUid(), this.checkPermission, string, string4, -1, string3)) && this.disableScheduledTask(stringArray[i])) continue;
                if (string2 == null) {
                    if ((String)properties.get("jrs.is_enabled") == "false") continue;
                    string2 = stringArray[i];
                    continue;
                }
                if ((String)properties.get("jrs.is_enabled") == "false") continue;
                string2 = string2 + ";" + stringArray[i];
                continue;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return string2;
    }

    @Override
    public boolean enableScheduledTask(String string) throws RemoteException {
        Date date;
        JRTrigger jRTrigger = this.getTask(string);
        if (jRTrigger == null || jRTrigger.isEnable()) {
            return false;
        }
        if (!(!(jRTrigger instanceof JRTimeQuartzTrigger) || jRTrigger instanceof JRBasicTrigger || null != (date = ((JRTimeQuartzTrigger)jRTrigger).getNextFireTime()) && date.getTime() >= System.currentTimeMillis() && date.before(new Date(399, 11, 31, 23, 59, 59)))) {
            this.removeScheduledTask(string);
            return true;
        }
        jRTrigger.setEnable(true);
        this.addListener.put(jRTrigger.getTaskID(), (Object)jRTrigger);
        try {
            this.P_READ.rescheduleJob(jRTrigger.getName(), jRTrigger.getGroup(), (Trigger)jRTrigger);
        }
        catch (SchedulerException schedulerException) {
            ServiceLogger.logError(schedulerException);
            return false;
        }
        return true;
    }

    @Override
    public String enableSchedules(String[] stringArray, String string) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string2 = "jrs.enable_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return "SLT_PG_209";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRTrigger jRTrigger = this.getTask(stringArray[i]);
            if (jRTrigger == null) continue;
            long l = 0L;
            if (jRTrigger instanceof JRTimeQuartzTrigger && !(jRTrigger instanceof JRBasicTrigger) && (l = ((JRTimeQuartzTrigger)jRTrigger).getNextFireTime().getTime()) < System.currentTimeMillis()) {
                stringBuffer2.append(stringArray[i]).append(";");
            }
            try {
                Properties properties = SchdTools.toProperties(jRTrigger);
                properties.remove("jrs.task_id");
                String string3 = (String)properties.get("jrs.report");
                if ((string3 == null || this.P_WRITE(jRTrigger.getUid(), this.checkPermission, string, string3, -1, string2)) && this.enableScheduledTask(stringArray[i]) || properties.get("jrs.is_enabled") == "true") continue;
                stringBuffer3.append(stringArray[i]).append(";");
                continue;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        stringBuffer.append(stringBuffer2).append("|").append(stringBuffer3);
        if (stringBuffer.length() == 1) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public String exportScripts(String string, String[] stringArray) throws RemoteException, RptServerException {
        String string2 = "";
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRTrigger jRTrigger = this.getTask(stringArray[i]);
            if (jRTrigger == null) continue;
            Properties properties = jRTrigger.getTask();
            String string3 = (String)properties.get("jrs.report");
            if (string3 != null) {
                try {
                    boolean bl = this.checkReportTaskProp.checkPermission(string, string3, Permissions.P_READ);
                    if (!bl && !this.checkReportTaskProp.isAdminUser(string)) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                    throw new RptServerException(exception);
                }
            }
            string2 = string2 + SchdTools.getSortedScript(jRTrigger);
        }
        return string2;
    }

    @Override
    public Vector getActiveScheduledTasks() throws RemoteException {
        return this.P_WRITE.getScheduleTaskManager().getActiveTasks();
    }

    @Override
    public Vector getActiveScheduledTasksByUser(String string) throws RemoteException {
        return this.P_WRITE.getScheduleTaskManager().getActiveTasksByUser(string);
    }

    private byte addElement(String string, String string2) {
        try {
            PathInfo pathInfo = this.checkReportTaskProp.getPathInfo(string, string2);
            return pathInfo.getStatus();
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
            return 2;
        }
    }

    @Override
    public Properties getScheduledTask(String string) throws RemoteException {
        JRTrigger jRTrigger = this.getTask(string);
        if (jRTrigger == null) {
            return null;
        }
        Properties properties = SchdTools.toProperties(jRTrigger);
        return properties;
    }

    public static boolean isInternalTaskIntf(Properties properties) {
        String string = (String)properties.get("jrs.task_class");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        try {
            return InternalTask.class.isAssignableFrom(Class.forName(string.trim()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean addListener(JRTrigger jRTrigger, String string) {
        boolean bl;
        if (StringUtils.equals(string, jRTrigger.getUid())) {
            return true;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(ServerEnv.getActiveRealm());
        boolean bl2 = bl = securityService.isAdminUser(string) || securityService.isOrganizationAdminUser(string);
        if (bl) {
            return StringUtils.equals(CSUtil.parsePrincipalDisplayName(string)[0], CSUtil.parsePrincipalDisplayName(jRTrigger.getUid())[0]);
        }
        return false;
    }

    @Override
    public Vector getScheduledTasks() throws RemoteException {
        Vector<Properties> vector = new Vector<Properties>();
        for (ScheduledTask scheduledTask : this.add.getAllTasks()) {
            Properties properties;
            JRTrigger jRTrigger = scheduledTask.getJRTrigger();
            Properties properties2 = jRTrigger.getTask();
            if (JRSchedulingServiceQuartzImpl.isInternalTaskIntf(properties2) || "jet.server.schedule.jrtasks.PublishCRDTask".equals((properties = SchdTools.toProperties(jRTrigger)).getProperty("jrs.task_class"))) continue;
            vector.addElement(properties);
        }
        return vector;
    }

    @Override
    public Vector getScheduledTasksByUser(String string) throws RemoteException {
        Vector<Properties> vector = new Vector<Properties>();
        for (ScheduledTask scheduledTask : this.add.getAllTasks()) {
            Properties properties;
            JRTrigger jRTrigger = scheduledTask.getJRTrigger();
            if (!this.addListener(jRTrigger, string)) continue;
            Properties properties2 = jRTrigger.getTask();
            Properties properties3 = (Properties)properties2.get("jrs.schd_props");
            if (properties3 != null) {
                properties3.remove("jrs.schd_props");
            }
            if (JRSchedulingServiceQuartzImpl.isInternalTaskIntf(properties2) || "jet.server.schedule.jrtasks.PublishCRDTask".equals((properties = SchdTools.toProperties(jRTrigger)).getProperty("jrs.task_class"))) continue;
            vector.addElement(properties);
        }
        return vector;
    }

    private static FilenameFilter filter(final String string) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string3) {
                String string2 = new File(string3).getName();
                return string2.endsWith(string);
            }
        };
    }

    @Override
    public String[] getScriptsList() throws RemoteException {
        String string = ".script";
        File file = new File(this.checkReportTaskProp.getSchedulePath());
        String[] stringArray = file.list(JRSchedulingServiceQuartzImpl.filter(string));
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].substring(0, stringArray[i].indexOf(".script"));
        }
        return stringArray2;
    }

    @Override
    public boolean isScriptFileExist(String string) throws RemoteException {
        File file = new File(this.checkReportTaskProp.getSchedulePath() + string + ".script");
        return file.exists();
    }

    @Override
    public String loadScheduledFromFile(String string) throws RemoteException {
        String string2;
        String string3;
        File file;
        String string4 = "";
        if (string == null || string.length() == 0) {
            return "SLT_PG_211";
        }
        if (string.lastIndexOf(".") >= 0) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        if ((file = new File(string3 = (string2 = this.checkReportTaskProp.getSchedulePath() + string) + ".sch")).exists()) {
            try {
                String string5;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getCanonicalPath()));
                while (null != (string5 = bufferedReader.readLine())) {
                    try {
                        Properties properties = CSUtil.parseQuery(string5);
                        properties.remove("jrs.task_id");
                        String string6 = this.submit(properties);
                        if (string6 == null || string6.trim().length() <= 0) continue;
                        string4 = "All loaded";
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                    }
                }
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        string4 = string4 == null || string4.equals("") ? "SLT_PG_211" : "SLT_PG_214";
        return string4;
    }

    @Override
    public String loadScriptFromFile(String string) throws RemoteException {
        File file = new File(this.checkReportTaskProp.getSchedulePath() + string + ".script");
        return CSUtil.readStringFromFile(file);
    }

    @Override
    public Properties[] parseScripts(String string) throws RemoteException, RptServerException {
        ScriptFileSubmit scriptFileSubmit = new ScriptFileSubmit(string);
        Object[] objectArray = scriptFileSubmit.getResults().toArray();
        Properties[] propertiesArray = null;
        if (objectArray != null) {
            propertiesArray = new Properties[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                propertiesArray[i] = (Properties)objectArray[i];
            }
        }
        return propertiesArray;
    }

    @Override
    public boolean removeScheduledTask(String string) throws RemoteException {
        JRTrigger jRTrigger = this.getTask(string);
        if (null == jRTrigger) {
            return false;
        }
        ScheduledTask scheduledTask = this.add.getTask(string);
        this.add.delTask(scheduledTask);
        this.addElement.remove(jRTrigger.getTaskID());
        try {
            return this.P_READ.unscheduleJob(jRTrigger.getName(), jRTrigger.getGroup());
        }
        catch (SchedulerException schedulerException) {
            ServiceLogger.logError(schedulerException);
            return false;
        }
    }

    @Override
    public String saveScheduledToFile(String[] stringArray, String string, boolean bl) throws RemoteException {
        String string2 = "";
        if (stringArray == null || stringArray.length == 0) {
            return "SLT_PG_209";
        }
        if (string == null || string.length() == 0) {
            return "SLT_PG_211";
        }
        if (string.lastIndexOf(".") >= 0) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        String string3 = this.checkReportTaskProp.getSchedulePath() + string;
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string3 + ".sch", false)));
            String string4 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                JRTrigger jRTrigger = this.getTask(stringArray[i]);
                if (jRTrigger == null || (string4 = CSUtil.makeNoHeadQuery(SchdTools.toProperties(jRTrigger))) == null || string4.trim().length() == 0) continue;
                printWriter.println(string4);
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        string2 = "SLT_PG_212";
        return string2;
    }

    @Override
    public String saveScheduledToScriptFile(String[] stringArray) throws RemoteException {
        String string = null;
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRTrigger jRTrigger = this.getTask(stringArray[i]);
            if (jRTrigger == null) continue;
            string = string == null ? CSUtil.makeQueryToRow(SchdTools.toProperties(jRTrigger), "<task>", "</task>") : string + CSUtil.makeQueryToRow(SchdTools.toProperties(jRTrigger), "<task>", "</task>");
        }
        return string;
    }

    @Override
    public boolean saveScriptToFile(String string, String string2) throws RemoteException {
        File file = new File(this.checkReportTaskProp.getSchedulePath() + string2 + ".script");
        return CSUtil.writeStringToFile(string, file);
    }

    @Override
    public void setLastSuccess(String string, boolean bl) throws RemoteException {
        JRTrigger jRTrigger = this.getTask(string);
        if (jRTrigger != null) {
            jRTrigger.setLastSuccessful(bl);
            this.addTriggerToReschedule(jRTrigger);
            this.getJRTriggersMap().put(jRTrigger.getTaskID(), (Object)jRTrigger);
        }
    }

    @Override
    public boolean stopActiveScheduledTask(String string) throws RemoteException {
        return this.P_WRITE.getScheduleTaskManager().stopActiveTask(string);
    }

    @Override
    public boolean stopActiveScheduledTaskByUser(String string, String string2) throws RemoteException {
        return this.P_WRITE.getScheduleTaskManager().stopActiveTaskByUser(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public String submitScheduledTask(String var1_1, Properties var2_2) throws RemoteException, RptServerException {
        if (var1_1 != null) {
            var2_2.put("jrs.uid", var1_1);
        }
        if (!(var3_3 = "jet.server.schedule.jrtasks.PublishCRDTask".equals(var2_2.getProperty("jrs.task_class")))) {
            var4_4 = CSUtil.parseInt((String)var2_2.get("jrs.archive_location"), 0);
            var5_7 = CSUtil.getBoolean((String)var2_2.get("jrs.to_version"), false);
            if (var5_7 != 0) {
                switch (var4_4) {
                    case 0: {
                        var7_10 = (String)var2_2.get("jrs.report");
                        try {
                            if (var7_10 != null && HttpUtil.isSecure() && !this.checkReportTaskProp.checkPermission(var1_1, var7_10, Permissions.P_WRITE)) {
                                var6_14 = "Can not add result version of report " + var7_10;
                                throw new RptServerException((Throwable)new NoPrivilegeException(var6_14));
                            }
                            break;
                        }
                        catch (Exception var8_21) {
                            throw new RptServerException(var8_21);
                        }
                    }
                    case 2: 
                    case 3: {
                        var8_22 = var4_4 == 2 ? (String)var2_2.get("jrs.archive_public_destination") : (String)var2_2.get("jrs.archive_organization_destination");
                        var9_26 = CSUtil.getLogicalFolderAndName((String)var8_22);
                        if (var9_26[1] == null || var9_26[1].length() == 0) {
                            var6_15 = "Can not add result doc " + (String)var8_22;
                            throw new RptServerException((Throwable)new UnknownResource(var6_15));
                        }
                        try {
                            if (!this.checkReportTaskProp.checkPermission(var1_1, (String)var8_22, Permissions.P_WRITE)) {
                                var6_16 = "Can not add version of result doc " + (String)var8_22;
                                throw new RptServerException((Throwable)new NoPrivilegeException(var6_16));
                            }
                        }
                        catch (Exception var10_27) {
                            var11_29 = var9_26[0];
                            if (var11_29 == null || var11_29.length() == 0) {
                                var11_29 = "/";
                            } else if (var11_29.endsWith(">")) {
                                var11_29 = var11_29 + "/";
                            }
                            try {
                                if (!this.checkReportTaskProp.checkPermission(var1_1, var11_29, Permissions.P_WRITE)) {
                                    var6_17 = "Can not add result doc in folder " + var11_29;
                                    throw new RptServerException((Throwable)new NoPrivilegeException(var6_17));
                                }
                            }
                            catch (NoSuchUserException var12_31) {
                                throw new RptServerException((Throwable)var12_31);
                            }
                            catch (UnknownResource var12_32) {
                                ServiceLogger.logError(JSvrResource.getDebug(3610008, var9_26[0]), 3);
                            }
                        }
                        break;
                    }
                }
            }
            this.checkPublishingPermission(var1_1, var2_2);
            try {
                if (JRSchedulingServiceQuartzImpl.isInternalTaskIntf(var2_2)) ** GOTO lbl74
                JRTUtil.checkReportTaskProp(var1_1, var2_2);
                JRTUtil.validateParameter(var2_2, 2, this.getResourceManager(), null, null);
            }
            catch (InvalidParameterException var7_11) {
                throw new RptServerException(var7_11);
            }
            catch (Exception var7_12) {
                ServiceLogger.logError(var7_12);
                throw new RptServerException(var7_12);
            }
        } else {
            var4_5 = (String)var2_2.get("jrs.catalog");
            var5_8 = (String)var2_2.get("jrs.data_source_name");
            var6_18 = (String)var2_2.get("jrs.query_name");
            var7_10 = (String)var2_2.get("jrs.uid");
            try {
                var8_22 = (JRParameterManager)HttpUtil.getHttpRptServer().getCatalogInfo(var7_10, var4_5, APIUtil.parseInt(var2_2.getProperty("jrs.cat_version"))).getParameterManager(var5_8, new String[]{var6_18});
                try {
                    var8_22.validateParameters(var2_2);
                }
                finally {
                    var8_22.clear();
                }
            }
            catch (InvalidParameterException var8_23) {
                throw new RptServerException(var8_23);
            }
            catch (Exception var8_24) {
                ServiceLogger.logError(var8_24);
                throw new RptServerException(var8_24);
            }
        }
        var4_6 = null;
        SchdTools.removeUnusedTaskProps(var2_2);
        this.addTriggerToReschedule(var1_1, var2_2);
        if (!var3_3 && (var5_7 = CSUtil.parseInt((String)var2_2.get("jrs.auto_delete_method"), -1)) == 1) {
            var6_19 = CSUtil.parseInt((String)var2_2.get("jrs.auto_delete_year"), 1900) - 1900;
            var7_13 = CSUtil.parseInt((String)var2_2.get("jrs.auto_delete_month"), 1) - 1;
            var8_25 = CSUtil.parseInt((String)var2_2.get("jrs.auto_delete_date"), 0);
            var9_26 = new Date(var6_19, var7_13, var8_25);
            var10_28 = new Date(System.currentTimeMillis());
            var11_30 = (var9_26.getTime() - new Date(var10_28.getYear(), var10_28.getMonth(), var10_28.getDate()).getTime()) / 86400000L;
            var2_2.put("jrs.expire_days", String.valueOf(var11_30));
        }
        if ((var5_9 = (String)var2_2.get("jrs.submit_time")) == null || var5_9.trim().length() == 0) {
            var2_2.put("jrs.submit_time", String.valueOf(System.currentTimeMillis()));
        }
        try {
            var4_6 = this.submit(var2_2);
        }
        catch (Exception var6_20) {
            ServiceLogger.logError(var6_20);
            throw new RptServerException(var6_20);
        }
        return var4_6;
    }

    public void updateLastExeTime(String string, long l) {
    }

    private void addTask(Properties properties) throws Exception {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        String string = (String)properties.get("jrs.catalog");
        String string2 = (String)properties.get("jrs.data_source_name");
        int n = CSUtil.parseInt((String)properties.get("jrs.query_type"), 0);
        String string3 = (String)properties.get("jrs.query_name");
        boolean bl = CSUtil.getBoolean((String)properties.get("jrs.is_cube"), false);
        String string4 = (String)properties.get("jrs.bv_name");
        String string5 = this.after(properties);
        long l = CSUtil.parseLong((String)properties.get("jrs.submit_time"), -1L);
        Date date = new Date(l);
        boolean bl2 = CSUtil.getBoolean((String)properties.get("jrs.run_task_when_needed"), false);
        String string6 = (String)properties.get("jrs.datasources");
        HashMap<String, String> hashMap = null;
        HashMap<String, String> hashMap2 = null;
        ArrayList arrayList = DatasourceInfo.parseJSonStr(string6);
        DatasourceInfo datasourceInfo = null;
        if (arrayList != null) {
            object4 = arrayList.iterator();
            while (object4.hasNext()) {
                object3 = (DatasourceInfo)object4.next();
                if (!((DatasourceInfo)object3).getName().equals(string2)) continue;
                datasourceInfo = object3;
                break;
            }
        }
        if (datasourceInfo != null && (object4 = datasourceInfo.getConnectionInfos()) != null && object4.size() > 1) {
            hashMap = new HashMap<String, String>();
            hashMap2 = new HashMap<String, String>();
            for (Object object22 : object4.values()) {
                if (((ConnectionInfo)object22).isUseDefaultUser()) continue;
                hashMap.put(((ConnectionInfo)object22).getName(), ((ConnectionInfo)object22).getUser());
                hashMap2.put(((ConnectionInfo)object22).getName(), ((ConnectionInfo)object22).getPassword());
            }
        }
        object4 = null;
        object3 = null;
        object22 = null;
        if (!CSUtil.getBoolean((String)properties.get("jrs.use_def_db_user"), false)) {
            object4 = (String)properties.get("jrs.db_user");
            object3 = (String)properties.get("jrs.db_pswd");
            if (CSUtil.getBoolean((String)properties.get("jrs.use_new_db_pswd"), false)) {
                object3 = (String)properties.get("jrs.new_db_pswd");
            }
        }
        object22 = (String)properties.get("jrs.task_id");
        String string7 = (String)properties.get("jrs.uid");
        int n2 = 1;
        CRDInfo cRDInfo = null;
        if (bl) {
            n2 = CSUtil.getBoolean((String)properties.get("jrs.cache_detail_on_disk"), false) ? 3 : 2;
            object = new CubeInfo(string, string2, n, string3, string4, n2);
            ((CubeInfo)object).setMaxAllowMemory(CSUtil.parseFloat((String)properties.get("jrs.max_memory_allowed")));
            ((CubeInfo)object).setCanSwaptoDisk(CSUtil.getBoolean((String)properties.get("jrs.swap_to_disk"), false));
            cRDInfo = object;
        } else {
            n2 = 1;
            cRDInfo = new CRDInfo(string, string2, n, string3, n2);
        }
        if (string5 != null && string5.length() > 0) {
            cRDInfo.setParamFile(string5.substring(string5.lastIndexOf(File.separator) + 1));
        }
        cRDInfo.setLastModified(date);
        cRDInfo.setLazy(bl2);
        cRDInfo.setLoginUser(string7);
        cRDInfo.setUserNames(hashMap);
        cRDInfo.setPasswords(hashMap2);
        cRDInfo.setUserName((String)object4);
        cRDInfo.setPassword((String)object3);
        cRDInfo.setTaskId((String)object22);
        object = (JRRptServer)((Object)HttpUtil.getHttpRptServer());
        JRCRDManager jRCRDManager = ((JRRptServer)object).getCRDManager();
        CRDInfoKey cRDInfoKey = null;
        cRDInfoKey = bl ? new CubeInfoKey(string, string2, n, string3, string4) : new CRDInfoKey(string, string2, n, string3);
        if (jRCRDManager.getCRD(string7, cRDInfoKey) != null) {
            jRCRDManager.updateCRD(string7, cRDInfo);
        } else {
            jRCRDManager.createCRD(string7, cRDInfo);
        }
    }

    @Override
    public Properties getCRDTask(String string) {
        if (string == null) {
            return null;
        }
        ScheduledTask scheduledTask = this.add.getTask(string);
        return scheduledTask == null ? null : SchdTools.toProperties(scheduledTask.getJRTrigger());
    }

    @Override
    public Vector getSchedCRDTasks(boolean bl) {
        Vector<Properties> vector = new Vector<Properties>();
        for (ScheduledTask scheduledTask : this.add.getAllTasks()) {
            Date date;
            int n;
            boolean bl2;
            Properties properties;
            JRTrigger jRTrigger = scheduledTask.getJRTrigger();
            Properties properties2 = jRTrigger.getTask();
            if (JRSchedulingServiceQuartzImpl.isInternalTaskIntf(properties2) || !"jet.server.schedule.jrtasks.PublishCRDTask".equals((properties = SchdTools.toProperties(jRTrigger)).getProperty("jrs.task_class")) || bl != (bl2 = CSUtil.getBoolean(properties.getProperty("jrs.is_cube"), false)) || (n = CSUtil.parseInt(properties.getProperty("jrs.launch_type"))) == 0 || (!(jRTrigger instanceof JRTimeQuartzTrigger) || jRTrigger instanceof JRBasicTrigger) && !(jRTrigger instanceof JRRepeatQuartzTrigger) || (date = jRTrigger.getNextFireTime()) == null || !date.after(new Date()) || date.equals(new Date(399, 11, 31, 23, 59, 59))) continue;
            vector.addElement(properties);
        }
        return vector;
    }

    @Override
    public Vector getSchedCRDTasksByUser(String string, boolean bl) throws RemoteException {
        Vector<Properties> vector = new Vector<Properties>();
        for (ScheduledTask scheduledTask : this.add.getAllTasks()) {
            Date date;
            int n;
            boolean bl2;
            Properties properties;
            JRTrigger jRTrigger = scheduledTask.getJRTrigger();
            if (!this.addListener(jRTrigger, string)) continue;
            Properties properties2 = jRTrigger.getTask();
            Properties properties3 = (Properties)properties2.get("jrs.schd_props");
            if (properties3 != null) {
                properties3.remove("jrs.schd_props");
            }
            if (JRSchedulingServiceQuartzImpl.isInternalTaskIntf(properties2) || !"jet.server.schedule.jrtasks.PublishCRDTask".equals((properties = SchdTools.toProperties(jRTrigger)).getProperty("jrs.task_class")) || bl != (bl2 = CSUtil.getBoolean(properties.getProperty("jrs.is_cube"), false)) || (n = CSUtil.parseInt(properties.getProperty("jrs.launch_type"))) == 0 || (!(jRTrigger instanceof JRTimeQuartzTrigger) || jRTrigger instanceof JRBasicTrigger) && !(jRTrigger instanceof JRRepeatQuartzTrigger) || (date = jRTrigger.getNextFireTime()) == null || !date.after(new Date()) || date.equals(new Date(399, 11, 31, 23, 59, 59))) continue;
            vector.addElement(properties);
        }
        return vector;
    }

    private String submit(Properties properties, boolean bl) throws Exception {
        return this.submit(properties, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String submit(Properties properties, boolean bl, boolean bl2) throws Exception {
        int n;
        String string;
        int n2;
        Object object;
        String string2 = null;
        if (properties == null) {
            return null;
        }
        boolean bl3 = "jet.server.schedule.jrtasks.PublishCRDTask".equals(properties.getProperty("jrs.task_class"));
        boolean bl4 = CSUtil.getBoolean((String)properties.get("jrs.is_cube"), false);
        String string3 = (String)properties.get("jrs.uid");
        String string4 = (String)properties.get("jrs.task_id");
        if (!bl3) {
            object = new Vector<String>();
            ((Vector)object).addElement("jrs.rst_dir");
            ((Vector)object).addElement("jrs.rst");
            ((Vector)object).addElement("jrs.html_dir");
            ((Vector)object).addElement("jrs.html");
            ((Vector)object).addElement("jrs.pdf_dir");
            ((Vector)object).addElement("jrs.pdf");
            ((Vector)object).addElement("jrs.text_dir");
            ((Vector)object).addElement("jrs.text");
            ((Vector)object).addElement("jrs.excel_dir");
            ((Vector)object).addElement("jrs.excel");
            ((Vector)object).addElement("jrs.ps_dir");
            ((Vector)object).addElement("jrs.ps");
            ((Vector)object).addElement("jrs.rtf_dir");
            ((Vector)object).addElement("jrs.rtf");
            ((Vector)object).addElement("jrs.xml_dir");
            ((Vector)object).addElement("jrs.xml");
            for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                String string5 = (String)((Vector)object).elementAt(n2);
                String string6 = (String)properties.get(string5);
                if (string6 == null || string6.trim().length() != 0) continue;
                properties.remove(string5);
            }
        }
        n2 = (object = properties.getProperty("jrs.triggers", "")) != null && ((String)object).trim().length() > 0 ? 1 : 0;
        boolean bl5 = false;
        if (n2 != 0) {
            bl5 = properties.getProperty("jrs.triggers.logic").equalsIgnoreCase("ONLY");
        }
        if ((string = properties.getProperty("jrs.task_id")) == null || string.trim().length() == 0) {
            string = SchdTools.getIdBase();
            properties.setProperty("jrs.task_id", string);
        }
        Object object2 = null;
        try {
            Object object3;
            GregorianCalendar gregorianCalendar;
            Object object4;
            int n3;
            Object object5;
            Object object6;
            String string7 = (String)properties.get("jrs.launch_type");
            int n4 = n = string7 == null ? 0 : CSUtil.parseInt(string7);
            if (n == -1) {
                throw new Exception(JCliResource.getMessage("CS_ERR_55") + ": " + string7);
            }
            String string8 = (String)properties.get("jrs.task_id");
            if (!(bl3 && n == 0 || string8 == null)) {
                Vector vector = this.clearMem;
                synchronized (vector) {
                    if (!this.clearMem.contains(string8)) {
                        this.clearMem.addElement(string8);
                    }
                }
            }
            long l = -1L;
            int[] nArray = null;
            String string9 = null;
            switch (n) {
                case 0: {
                    if (bl3 && (object6 = (String)properties.get("jrs.task_id")) != null) {
                        object5 = this.clone;
                        synchronized (object5) {
                            if (!this.clone.contains(object6)) {
                                this.clone.addElement(object6);
                            }
                        }
                    }
                    if (!bl3) {
                        if (n2 == 0 || properties.getProperty("jrs.triggers.logic").equalsIgnoreCase("OR")) {
                            return this.runTask(properties);
                        }
                        object6 = "JR_BASIC_TRG_" + properties.getProperty("jrs.task_id");
                        object5 = new JRBasicTrigger((String)object6, "JR_DETAULT_GROUP");
                        ((JRTrigger)((Object)object5)).setType(0);
                        n3 = CSUtil.parseInt((String)properties.get("jrs.ileie")) == 1 ? 1 : 0;
                        ((JRTimeQuartzTrigger)((Object)object5)).init(properties, new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, n3 != 0));
                        ((JRTrigger)((Object)object5)).setTask(properties);
                        ((JRTrigger)((Object)object5)).setUid(properties.getProperty("jrs.uid"));
                        ((JRTrigger)((Object)object5)).setTaskID(string);
                        ((JRTrigger)((Object)object5)).getTask().setProperty("jrs.only_wait_trigger", "true");
                        object2 = object5;
                        break;
                    }
                    l = -1L;
                    object6 = "JR_BASIC_TRG_" + properties.getProperty("jrs.task_id");
                    object5 = new JRBasicTrigger((String)object6, "JR_DETAULT_GROUP");
                    ((JRTrigger)((Object)object5)).setType(0);
                    n3 = CSUtil.parseInt((String)properties.get("jrs.ileie")) == 1 ? 1 : 0;
                    ((JRTimeQuartzTrigger)((Object)object5)).init(properties, new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, n3 != 0));
                    ((JRTrigger)((Object)object5)).setTask(properties);
                    ((JRTrigger)((Object)object5)).setUid(properties.getProperty("jrs.uid"));
                    ((JRTrigger)((Object)object5)).setTaskID(string);
                    ((JRTrigger)((Object)object5)).getTask().setProperty("jrs.only_wait_trigger", "true");
                    object2 = object5;
                    break;
                }
                case 1: {
                    if (!bl5) {
                        nArray = SchdTools.getExeTime(properties);
                        object6 = (String)properties.get("jrs.timezone");
                        object5 = object6 != null && ((String)object6).trim().length() > 0 ? new GregorianCalendar(TimeZone.getTimeZone((String)object6)) : new GregorianCalendar();
                        ((Calendar)object5).set(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
                        l = ((Calendar)object5).getTime().getTime();
                        n3 = CSUtil.parseInt((String)properties.get("jrs.ileie")) == 1 ? 1 : 0;
                        object4 = new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, n3 != 0);
                        gregorianCalendar = ((ExeTimeInfo)object4).getGC();
                        object3 = new GregorianCalendar();
                        if (!bl2) {
                            if (((Calendar)object3).getTime().after(gregorianCalendar.getTime())) {
                                throw new Exception(string + " " + gregorianCalendar.getTime() + " expired!");
                            }
                        } else {
                            properties.put("isTransCRDToCube", "true");
                        }
                        String string10 = "JR_TRG_" + properties.getProperty("jrs.task_id");
                        JRTimeQuartzTrigger jRTimeQuartzTrigger = new JRTimeQuartzTrigger(string10, "JR_DETAULT_GROUP");
                        jRTimeQuartzTrigger.init(properties, (ExeTimeInfo)object4);
                        jRTimeQuartzTrigger.setUid(properties.getProperty("jrs.uid"));
                        jRTimeQuartzTrigger.setTaskID(string);
                        jRTimeQuartzTrigger.setTask(properties);
                        object2 = jRTimeQuartzTrigger;
                        break;
                    }
                    object6 = "JR_BASIC_TRG_" + properties.getProperty("jrs.task_id");
                    object5 = new JRBasicTrigger((String)object6, "JR_DETAULT_GROUP");
                    ((JRTrigger)((Object)object5)).setType(0);
                    n3 = CSUtil.parseInt((String)properties.get("jrs.ileie")) == 1 ? 1 : 0;
                    ((JRTimeQuartzTrigger)((Object)object5)).init(properties, new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, n3 != 0));
                    ((JRTrigger)((Object)object5)).setTask(properties);
                    ((JRTrigger)((Object)object5)).setUid(properties.getProperty("jrs.uid"));
                    ((JRTrigger)((Object)object5)).setTaskID(string);
                    ((JRTrigger)((Object)object5)).getTask().setProperty("jrs.only_wait_trigger", "true");
                    object2 = object5;
                    break;
                }
                case 8: {
                    if (!bl5) {
                        object6 = "JR_TRG_" + properties.getProperty("jrs.task_id");
                        object5 = new JRRepeatQuartzTrigger((String)object6, "JR_DETAULT_GROUP");
                        ((JRRepeatQuartzTrigger)((Object)object5)).setSchedule(properties);
                        ((JRTrigger)((Object)object5)).setUid(properties.getProperty("jrs.uid"));
                        ((JRTrigger)((Object)object5)).setTaskID(string);
                        ((JRTrigger)((Object)object5)).setTask(properties);
                        object2 = object5;
                        break;
                    }
                    object6 = "JR_BASIC_TRG_" + properties.getProperty("jrs.task_id");
                    object5 = new JRBasicTrigger((String)object6, "JR_DETAULT_GROUP");
                    ((JRTrigger)((Object)object5)).setType(0);
                    n3 = CSUtil.parseInt((String)properties.get("jrs.ileie")) == 1 ? 1 : 0;
                    ((JRTimeQuartzTrigger)((Object)object5)).init(properties, new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, n3 != 0));
                    ((JRTrigger)((Object)object5)).setTask(properties);
                    ((JRTrigger)((Object)object5)).setUid(properties.getProperty("jrs.uid"));
                    ((JRTrigger)((Object)object5)).setTaskID(string);
                    ((JRTrigger)((Object)object5)).getTask().setProperty("jrs.only_wait_trigger", "true");
                    object2 = object5;
                }
            }
            if (object2 == null) {
                if (string9 == null) {
                    throw new Exception(JCliResource.getMessage("CS_ERR_56") + "! " + properties);
                }
                throw new Exception(JCliResource.getMessage("CS_ERR_56") + "! " + string9);
            }
            object2.setUid(string3);
            if (bl3) {
                if (!bl2) {
                    this.addTask(properties);
                }
                if (string4 != null && bl) {
                    object6 = new Vector();
                    ((Vector)object6).addElement(string);
                    this.add((Vector)object6, string3, false);
                    object5 = "JR_TRG_CRD_" + string;
                    this.P_READ.unscheduleJob((String)object5, "JR_DETAULT_GROUP");
                }
                if (!bl4) {
                    object6 = null;
                    object5 = "JR_TRG_CRD_" + string;
                    n3 = CSUtil.parseInt((String)properties.get("jrs.crd_expire"), 2);
                    if (n3) {
                        object4 = (String)properties.get("jrs.timezone");
                        gregorianCalendar = object4 != null && ((String)object4).trim().length() > 0 ? new GregorianCalendar(TimeZone.getTimeZone((String)object4)) : new GregorianCalendar();
                        nArray = SchdTools.getExpireTime(properties);
                        gregorianCalendar.set(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
                        l = gregorianCalendar.getTime().getTime();
                        object6 = new JRCRDExpireQuartzTrigger((String)object5, "JR_DETAULT_GROUP");
                        ((JRCRDExpireQuartzTrigger)((Object)object6)).init(properties, new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, false));
                        ((JRTrigger)((Object)object6)).setTask(properties);
                    } else if (n3 == 2) {
                        object4 = (String)properties.get("jrs.timezone");
                        gregorianCalendar = object4 != null && ((String)object4).trim().length() > 0 ? new GregorianCalendar(TimeZone.getTimeZone((String)object4)) : new GregorianCalendar();
                        object3 = new Timer(false);
                        int n5 = CSUtil.parseInt((String)properties.get("jrs.expire_after_days"), 0);
                        int n6 = CSUtil.parseInt((String)properties.get("jrs.expire_after_hours"), 0);
                        int n7 = CSUtil.parseInt((String)properties.get("jrs.expire_after_minutes"), 0);
                        long l2 = CSUtil.parseLong((String)properties.get("jrs.submit_time"), -1L);
                        gregorianCalendar.setTimeInMillis(l2);
                        gregorianCalendar.add(5, n5);
                        gregorianCalendar.add(11, n6);
                        gregorianCalendar.add(12, n7);
                        l = gregorianCalendar.getTime().getTime();
                        object6 = new JRCRDExpireQuartzTrigger((String)object5, "JR_DETAULT_GROUP");
                        ((JRCRDExpireQuartzTrigger)((Object)object6)).init(properties, new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, false));
                        ((JRTrigger)((Object)object6)).setTask(properties);
                    }
                    if (object6 != null) {
                        object4 = "JR_JOB_CRD_" + string;
                        gregorianCalendar = new JobDetail((String)object4, "JR_DETAULT_GROUP", JRCRDExpireJob.class);
                        this.P_READ.scheduleJob((JobDetail)gregorianCalendar, (Trigger)object6);
                    }
                }
            } else if (string4 != null && bl) {
                this.removeScheduledTask(string);
            }
            this.submit((JRTrigger)((Object)object2));
            string2 = object2.getTaskID();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        if (n == 0 && bl3 && (n2 == 0 || properties.getProperty("jrs.triggers.logic").equalsIgnoreCase("OR"))) {
            if (!bl2) {
                string2 = this.runTask(properties);
            }
            object2.triggered(null);
            ((JRBasicTrigger)((Object)object2)).setLastExeTime(System.currentTimeMillis());
            try {
                this.P_READ.rescheduleJob(object2.getName(), object2.getGroup(), (Trigger)object2);
            }
            catch (SchedulerException schedulerException) {
                ServiceLogger.logError(schedulerException);
            }
        }
        return string2;
    }

    public String submit(Properties properties) throws Exception {
        return this.submit(properties, true);
    }

    public void transCRDToCubeTask(String string, String string2, int n, double d) {
        Properties properties = new Properties();
        properties.put("jrs.is_cube", "true");
        properties.put("jrs.bv_name", string2);
        properties.put("jrs.max_memory_allowed", String.valueOf(d));
        if (n == 3) {
            properties.put("jrs.cache_detail_on_disk", "true");
        }
        this.close.put(string, properties);
    }

    public void runTaskAfterStartCube(Properties properties) {
        boolean bl;
        int n = CSUtil.parseInt((String)properties.get("jrs.launch_type"), 0);
        String string = (String)properties.get("jrs.triggers.logic");
        String string2 = properties.getProperty("jrs.triggers", "");
        boolean bl2 = bl = string2 != null && string2.trim().length() > 0;
        if (n == 0 && (!bl || string.equalsIgnoreCase("OR"))) {
            String string3 = (String)properties.get("jrs.task_id");
            this.runTask(properties);
            JRTrigger jRTrigger = this.getTask(string3);
            jRTrigger.triggered(null);
            ((JRBasicTrigger)jRTrigger).setLastExeTime(System.currentTimeMillis());
            try {
                this.P_READ.rescheduleJob(jRTrigger.getName(), jRTrigger.getGroup(), (Trigger)jRTrigger);
            }
            catch (SchedulerException schedulerException) {
                ServiceLogger.logError(schedulerException);
            }
        }
    }

    public String runTask(Properties properties) {
        try {
            return this.P_WRITE.getScheduleTaskManager().runTask(properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public synchronized boolean submit(JRTrigger jRTrigger) throws Exception {
        boolean bl = false;
        if (jRTrigger != null) {
            Object object;
            try {
                object = "JR_JOB_" + jRTrigger.getTaskID();
                JobDetail jobDetail = new JobDetail((String)object, "JR_DETAULT_GROUP", JRTaskJob.class);
                Properties properties = jRTrigger.getTask();
                jobDetail.getJobDataMap().put("jrs.uid", jRTrigger.getUid());
                jobDetail.getJobDataMap().put("jrs.task_id", jRTrigger.getTaskID());
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    jobDetail.getJobDataMap().put((Object)string, properties.get(string));
                }
                this.P_READ.scheduleJob(jobDetail, (Trigger)jRTrigger);
                bl = true;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw exception;
            }
            if (bl) {
                object = new ScheduledTaskImpl(jRTrigger);
                this.add.addTask((ScheduledTask)object);
                this.addElement.put(jRTrigger.getTaskID(), object);
            }
        }
        return bl;
    }

    private void addTaskToFire(String string, Properties properties) throws RptServerException {
        boolean bl = CSUtil.getBoolean((String)properties.get("jrs.to_disk"), false);
        if (!bl) {
            return;
        }
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            Object object;
            Object object2;
            boolean bl8;
            boolean bl9;
            boolean bl10 = CSUtil.getBoolean((String)properties.get("jrs.to_rsd"), false);
            if (bl10) {
                String string2 = (String)properties.get("jrs.rsd_dir");
                if (null == string2) {
                    String string3 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                    throw new RptServerException(string3, (Throwable)((Object)new NoPrivilegeException(string3)));
                }
                int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_rsd_path_type"), 0);
                if (n == 0 && string2.length() > 0 && !this.checkReportTaskProp.checkPermission(string, string2, Permissions.P_WRITE)) {
                    String string4 = "Can not write Rsd file to path: " + string2;
                    throw new RptServerException(string4, (Throwable)((Object)new NoPrivilegeException(string4)));
                }
            }
            if (bl9 = CSUtil.getBoolean((String)properties.get("jrs.to_rst"), false)) {
                String string5 = (String)properties.get("jrs.rst_dir");
                if (null == string5) {
                    String string6 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                    throw new RptServerException(string6, (Throwable)((Object)new NoPrivilegeException(string6)));
                }
                int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_rst_path_type"), 0);
                if (n == 0 && string5.length() > 0 && !this.checkReportTaskProp.checkPermission(string, string5, Permissions.P_WRITE)) {
                    String string7 = "Can not write Result file to path: " + string5;
                    throw new RptServerException(string7, (Throwable)((Object)new NoPrivilegeException(string7)));
                }
            }
            if (bl8 = CSUtil.getBoolean((String)properties.get("jrs.to_html"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    if (!((String)object2).startsWith("jrs.html_dir")) continue;
                    object = (String)properties.get(object2);
                    if (null == object) {
                        String string8 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string8, (Throwable)((Object)new NoPrivilegeException(string8)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_html_path_type"), 0);
                    if (n != 0 || ((String)object).length() <= 0 || this.checkReportTaskProp.checkPermission(string, (String)object, Permissions.P_WRITE)) continue;
                    String string9 = "Can not write Html file to path: " + (String)object;
                    throw new RptServerException(string9, (Throwable)((Object)new NoPrivilegeException(string9)));
                }
            }
            if (bl7 = CSUtil.getBoolean((String)properties.get("jrs.to_pdf"), false)) {
                object2 = properties.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (!((String)object).startsWith("jrs.pdf_dir")) continue;
                    String string10 = (String)properties.get(object);
                    if (null == string10) {
                        String string11 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string11, (Throwable)((Object)new NoPrivilegeException(string11)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_pdf_path_type"), 0);
                    if (n != 0 || string10.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string10, Permissions.P_WRITE)) continue;
                    String string12 = "Can not write Pdf file to path: " + string10;
                    throw new RptServerException(string12, (Throwable)((Object)new NoPrivilegeException(string12)));
                }
            }
            if (bl6 = CSUtil.getBoolean((String)properties.get("jrs.to_text"), false)) {
                object = properties.keys();
                while (object.hasMoreElements()) {
                    String string13 = (String)object.nextElement();
                    if (!string13.startsWith("jrs.text_dir")) continue;
                    String string14 = (String)properties.get(string13);
                    if (null == string14) {
                        String string15 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string15, (Throwable)((Object)new NoPrivilegeException(string15)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_text_path_type"), 0);
                    if (n != 0 || string14.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string14, Permissions.P_WRITE)) continue;
                    String string16 = "Can not write Text file to path: " + string14;
                    throw new RptServerException(string16, (Throwable)((Object)new NoPrivilegeException(string16)));
                }
            }
            if (bl5 = CSUtil.getBoolean((String)properties.get("jrs.to_excel"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string17 = (String)enumeration.nextElement();
                    if (!string17.startsWith("jrs.excel_dir")) continue;
                    String string18 = (String)properties.get(string17);
                    if (null == string18) {
                        String string19 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string19, (Throwable)((Object)new NoPrivilegeException(string19)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_excel_path_type"), 0);
                    if (n != 0 || string18.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string18, Permissions.P_WRITE)) continue;
                    String string20 = "Can not write Excel file to path: " + string18;
                    throw new RptServerException(string20, (Throwable)((Object)new NoPrivilegeException(string20)));
                }
            }
            if (bl4 = CSUtil.getBoolean((String)properties.get("jrs.to_ps"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string21 = (String)enumeration.nextElement();
                    if (!string21.startsWith("jrs.ps_dir")) continue;
                    String string22 = (String)properties.get(string21);
                    if (null == string22) {
                        String string23 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string23, (Throwable)((Object)new NoPrivilegeException(string23)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_ps_path_type"), 0);
                    if (n != 0 || string22.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string22, Permissions.P_WRITE)) continue;
                    String string24 = "Can not write PostScript file to path: " + string22;
                    throw new RptServerException(string24, (Throwable)((Object)new NoPrivilegeException(string24)));
                }
            }
            if (bl3 = CSUtil.getBoolean((String)properties.get("jrs.to_rtf"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string25 = (String)enumeration.nextElement();
                    if (!string25.startsWith("jrs.rtf_dir")) continue;
                    String string26 = (String)properties.get(string25);
                    if (null == string26) {
                        String string27 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string27, (Throwable)((Object)new NoPrivilegeException(string27)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_rtf_path_type"), 0);
                    if (n != 0 || string26.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string26, Permissions.P_WRITE)) continue;
                    String string28 = "Can not write Rich Text Format file to path: " + string26;
                    throw new RptServerException(string28, (Throwable)((Object)new NoPrivilegeException(string28)));
                }
            }
            if (bl2 = CSUtil.getBoolean((String)properties.get("jrs.to_xml"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string29 = (String)enumeration.nextElement();
                    if (!string29.startsWith("jrs.xml_dir")) continue;
                    String string30 = (String)properties.get(string29);
                    if (null == string30) {
                        String string31 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string31, (Throwable)((Object)new NoPrivilegeException(string31)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.to_disk_xml_path_type"), 0);
                    if (n != 0 || string30.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string30, Permissions.P_WRITE)) continue;
                    String string32 = "Can not write xml file to path: " + string30;
                    throw new RptServerException(string32, (Throwable)((Object)new NoPrivilegeException(string32)));
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            if (exception instanceof RptServerException) {
                throw (RptServerException)((Object)exception);
            }
            throw new RptServerException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void addTaskToRemove(String string, Properties properties) throws RptServerException {
        boolean bl = CSUtil.getBoolean((String)properties.get("jrs.to_disk"), false);
        if (!bl) {
            return;
        }
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            Object object;
            Object object2;
            boolean bl8;
            boolean bl9;
            boolean bl10 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_rsd"), false);
            if (bl10) {
                String string2 = (String)properties.get("jrs.nonbursting$jrs.rsd_dir");
                if (null == string2) {
                    String string3 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                    throw new RptServerException(string3, (Throwable)((Object)new NoPrivilegeException(string3)));
                }
                int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_rsd_path_type"), 0);
                if (n == 0 && string2.length() > 0 && !this.checkReportTaskProp.checkPermission(string, string2, Permissions.P_WRITE)) {
                    String string4 = "Can not write Rsd file to path: " + string2;
                    throw new RptServerException(string4, (Throwable)((Object)new NoPrivilegeException(string4)));
                }
            }
            if (bl9 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_rst"), false)) {
                String string5 = (String)properties.get("jrs.nonbursting$jrs.rst_dir");
                if (null == string5) {
                    String string6 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                    throw new RptServerException(string6, (Throwable)((Object)new NoPrivilegeException(string6)));
                }
                int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_rst_path_type"), 0);
                if (n == 0 && string5.length() > 0 && !this.checkReportTaskProp.checkPermission(string, string5, Permissions.P_WRITE)) {
                    String string7 = "Can not write Result file to path: " + string5;
                    throw new RptServerException(string7, (Throwable)((Object)new NoPrivilegeException(string7)));
                }
            }
            if (bl8 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_html"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    if (!((String)object2).startsWith("jrs.nonbursting$jrs.html_dir")) continue;
                    object = (String)properties.get(object2);
                    if (null == object) {
                        String string8 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string8, (Throwable)((Object)new NoPrivilegeException(string8)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_html_path_type"), 0);
                    if (n != 0 || ((String)object).length() <= 0 || this.checkReportTaskProp.checkPermission(string, (String)object, Permissions.P_WRITE)) continue;
                    String string9 = "Can not write Html file to path: " + (String)object;
                    throw new RptServerException(string9, (Throwable)((Object)new NoPrivilegeException(string9)));
                }
            }
            if (bl7 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_pdf"), false)) {
                object2 = properties.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (!((String)object).startsWith("jrs.nonbursting$jrs.pdf_dir")) continue;
                    String string10 = (String)properties.get(object);
                    if (null == string10) {
                        String string11 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string11, (Throwable)((Object)new NoPrivilegeException(string11)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_pdf_path_type"), 0);
                    if (n != 0 || string10.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string10, Permissions.P_WRITE)) continue;
                    String string12 = "Can not write Pdf file to path: " + string10;
                    throw new RptServerException(string12, (Throwable)((Object)new NoPrivilegeException(string12)));
                }
            }
            if (bl6 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_text"), false)) {
                object = properties.keys();
                while (object.hasMoreElements()) {
                    String string13 = (String)object.nextElement();
                    if (!string13.startsWith("jrs.nonbursting$jrs.text_dir")) continue;
                    String string14 = (String)properties.get(string13);
                    if (null == string14) {
                        String string15 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string15, (Throwable)((Object)new NoPrivilegeException(string15)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_text_path_type"), 0);
                    if (n != 0 || string14.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string14, Permissions.P_WRITE)) continue;
                    String string16 = "Can not write Text file to path: " + string14;
                    throw new RptServerException(string16, (Throwable)((Object)new NoPrivilegeException(string16)));
                }
            }
            if (bl5 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_excel"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string17 = (String)enumeration.nextElement();
                    if (!string17.startsWith("jrs.nonbursting$jrs.excel_dir")) continue;
                    String string18 = (String)properties.get(string17);
                    if (null == string18) {
                        String string19 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string19, (Throwable)((Object)new NoPrivilegeException(string19)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_excel_path_type"), 0);
                    if (n != 0 || string18.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string18, Permissions.P_WRITE)) continue;
                    String string20 = "Can not write Excel file to path: " + string18;
                    throw new RptServerException(string20, (Throwable)((Object)new NoPrivilegeException(string20)));
                }
            }
            if (bl4 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_ps"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string21 = (String)enumeration.nextElement();
                    if (!string21.startsWith("jrs.nonbursting$jrs.ps_dir")) continue;
                    String string22 = (String)properties.get(string21);
                    if (null == string22) {
                        String string23 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string23, (Throwable)((Object)new NoPrivilegeException(string23)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_ps_path_type"), 0);
                    if (n != 0 || string22.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string22, Permissions.P_WRITE)) continue;
                    String string24 = "Can not write PostScript file to path: " + string22;
                    throw new RptServerException(string24, (Throwable)((Object)new NoPrivilegeException(string24)));
                }
            }
            if (bl3 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_rtf"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string25 = (String)enumeration.nextElement();
                    if (!string25.startsWith("jrs.nonbursting$jrs.rtf_dir")) continue;
                    String string26 = (String)properties.get(string25);
                    if (null == string26) {
                        String string27 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string27, (Throwable)((Object)new NoPrivilegeException(string27)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_rtf_path_type"), 0);
                    if (n != 0 || string26.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string26, Permissions.P_WRITE)) continue;
                    String string28 = "Can not write Rich Text Format file to path: " + string26;
                    throw new RptServerException(string28, (Throwable)((Object)new NoPrivilegeException(string28)));
                }
            }
            if (bl2 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_xml"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string29 = (String)enumeration.nextElement();
                    if (!string29.startsWith("jrs.nonbursting$jrs.xml_dir")) continue;
                    String string30 = (String)properties.get(string29);
                    if (null == string30) {
                        String string31 = "When publishing to server disk path, the path must be valid to the OS where JReport Server has been installed.";
                        throw new RptServerException(string31, (Throwable)((Object)new NoPrivilegeException(string31)));
                    }
                    int n = CSUtil.parseInt((String)properties.get("jrs.nonbursting$jrs.to_disk_xml_path_type"), 0);
                    if (n != 0 || string30.length() <= 0 || this.checkReportTaskProp.checkPermission(string, string30, Permissions.P_WRITE)) continue;
                    String string32 = "Can not write xml file to path: " + string30;
                    throw new RptServerException(string32, (Throwable)((Object)new NoPrivilegeException(string32)));
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            if (exception instanceof RptServerException) {
                throw (RptServerException)((Object)exception);
            }
            throw new RptServerException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void checkPublishingPermission(String string, Properties properties) throws RptServerException {
        boolean bl = CSUtil.getBoolean((String)properties.get("jrs.is_bursting_task"), false);
        boolean bl2 = CSUtil.getBoolean((String)properties.get("jrs.has_nonbursting_result"), false);
        if (bl) {
            boolean bl3;
            if (bl2 && (bl3 = CSUtil.getBoolean((String)properties.get("jrs.nonbursting$jrs.to_disk"), false))) {
                this.addTaskToRemove(string, properties);
            }
        } else {
            boolean bl4 = CSUtil.getBoolean((String)properties.get("jrs.to_disk"), false);
            if (bl4) {
                this.addTaskToFire(string, properties);
            }
        }
    }

    private void addTriggerToReschedule(String string, Properties properties) throws RptServerException {
        int n = 128;
        String string2 = properties.getProperty("jrs.schedule_name", properties.getProperty("jrs.task_name"));
        if (string2 != null && string2.length() > n) {
            ServiceLogger.logError(string2);
            throw new RptServerException(600057, new Object[]{"Schedule Name", n}, null);
        }
    }

    public void stop() {
        if (this.clear) {
            AccessSchedule.setRestart();
            try {
                this.P_READ.shutdown();
            }
            catch (SchedulerException schedulerException) {
                ServiceLogger.logError(schedulerException);
            }
            this.after.shutdown();
            this.append.shutdown();
            ((TriggerManagerImpl)this.SEDU).destroy();
            this.add.stop();
            this.clear = false;
        }
    }

    public void quit() {
        this.stop();
        this.P_READ = null;
        this.P_WRITE = null;
        this.checkReportTaskProp = null;
        try {
            this.add.finalize();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        this.add = null;
    }

    private String after(Properties properties) throws Exception {
        String string = "";
        if (JRTUtil.hasParameter(properties)) {
            String string2 = (String)properties.get("jrs.query_name");
            String string3 = (String)properties.get("jrs.bv_name");
            String string4 = null;
            string4 = ParameterManager.usedParamGen(properties) ? ".dparam" : ".param";
            string = JRTUtil.createCrdParamFile(SchdTools.createTempFile(this.getResourceManager().getHistDir(), (string3 == null ? string2 : string3) + "_", string4), properties);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskToRemove(String string) {
        LinkedList linkedList = this.addTaskToRemove;
        synchronized (linkedList) {
            this.addTaskToRemove.add(string);
            this.addTaskToRemove.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTriggerToReschedule(JRTrigger jRTrigger) {
        LinkedList linkedList = this.addTriggerToReschedule;
        synchronized (linkedList) {
            this.addTriggerToReschedule.add(jRTrigger);
            this.addTriggerToReschedule.notify();
        }
    }

    @Override
    public void handleMisfire(JRTrigger jRTrigger) {
        if (jRTrigger instanceof JRCRDExpireQuartzTrigger) {
            Properties properties = jRTrigger.getTask();
            String string = (String)properties.get("jrs.catalog");
            String string2 = (String)properties.get("jrs.data_source_name");
            int n = CSUtil.parseInt((String)properties.get("jrs.query_type"), 0);
            String string3 = (String)properties.get("jrs.query_name");
            JRRptServer jRRptServer = (JRRptServer)((Object)HttpUtil.getHttpRptServer());
            JRCRDManager jRCRDManager = jRRptServer.getCRDManager();
            CRDInfoKey cRDInfoKey = new CRDInfoKey(string, string2, n, string3);
            try {
                jRCRDManager.deleteCRDResult(cRDInfoKey);
            }
            catch (CRDManageException cRDManageException) {
                ServiceLogger.logError(cRDManageException.getMessage());
            }
            return;
        }
        String string = jRTrigger.getName();
        ScheduledTaskImpl scheduledTaskImpl = (ScheduledTaskImpl)this.add.getTask(jRTrigger.getTaskID());
        if (scheduledTaskImpl.getJRTrigger().getMisfired()) {
            return;
        }
        scheduledTaskImpl.getJRTrigger().setMisfired(true);
        if (jRTrigger instanceof JRTimeQuartzTrigger) {
            Properties properties = jRTrigger.getTask();
            boolean bl = "jet.server.schedule.jrtasks.PublishCRDTask".equals(properties.getProperty("jrs.task_class"));
            if (bl && CSUtil.getBoolean((String)properties.get("isTransCRDToCube"), false)) {
                properties.remove("isTransCRDToCube");
                try {
                    this.P_READ.rescheduleJob(jRTrigger.getName(), jRTrigger.getGroup(), (Trigger)jRTrigger);
                }
                catch (SchedulerException schedulerException) {
                    ServiceLogger.logError(schedulerException);
                }
            } else {
                this.add.addTaskToFire(jRTrigger.getTaskID());
                Object[] objectArray = new Object[]{string, new Date()};
                ServiceLogger.logDebug(2610019, objectArray, 2);
            }
            return;
        }
        if (null == jRTrigger.getNextFireTime()) {
            this.addTaskToRemove(jRTrigger.getTaskID());
            this.addListener.remove(jRTrigger.getTaskID());
            if (scheduledTaskImpl.getFlags().size() > 1) {
                this.addTask.remove(jRTrigger.getTaskID());
            }
        } else {
            Date date = new Date();
            Date date2 = jRTrigger.getNextFireTime();
            while (null != date2 && date.after(date2)) {
                date2 = jRTrigger.getFireTimeAfter(date2);
            }
            Object[] objectArray = new Object[]{string, ((JRRepeatQuartzTrigger)scheduledTaskImpl.getJRTrigger()).getNextFireTime(), new Date(), date2};
            ServiceLogger.logError(3610020, objectArray, 3);
            ((JRRepeatQuartzTrigger)scheduledTaskImpl.getJRTrigger()).setNextFireTime(date2);
            scheduledTaskImpl.getJRTrigger().setMisfired(false);
            this.addListener.put(jRTrigger.getTaskID(), (Object)scheduledTaskImpl.getJRTrigger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskToRefire(String string) {
        HashMap hashMap = this.before;
        synchronized (hashMap) {
            this.before.put(string, new Long(System.currentTimeMillis()));
        }
    }

    class RescheduleTriggerThread
    extends Thread {
        private boolean SEDU;

        RescheduleTriggerThread() {
            super(Thread.currentThread().getThreadGroup(), "RescheduleTriggerThread");
            this.SEDU = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            RescheduleTriggerThread rescheduleTriggerThread = this;
            synchronized (rescheduleTriggerThread) {
                this.SEDU = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                JRTrigger jRTrigger = null;
                Object object = JRSchedulingServiceQuartzImpl.this.addTriggerToReschedule;
                synchronized (object) {
                    try {
                        jRTrigger = (JRTrigger)((Object)JRSchedulingServiceQuartzImpl.this.addTriggerToReschedule.removeFirst());
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        try {
                            JRSchedulingServiceQuartzImpl.this.addTriggerToReschedule.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (null != jRTrigger) {
                    try {
                        JRSchedulingServiceQuartzImpl.this.P_READ.rescheduleJob(jRTrigger.getName(), jRTrigger.getGroup(), (Trigger)jRTrigger);
                    }
                    catch (SchedulerException schedulerException) {
                        ServiceLogger.logError(schedulerException);
                    }
                }
                object = this;
                synchronized (object) {
                    bl = !this.SEDU;
                }
            }
        }
    }

    class RemoveScheduledTaskThread
    extends Thread {
        private boolean SEDU;

        RemoveScheduledTaskThread() {
            super(Thread.currentThread().getThreadGroup(), "RemoveScheduledTaskThread");
            this.SEDU = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            RemoveScheduledTaskThread removeScheduledTaskThread = this;
            synchronized (removeScheduledTaskThread) {
                this.SEDU = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                String string = null;
                Object object = JRSchedulingServiceQuartzImpl.this.addTaskToRemove;
                synchronized (object) {
                    try {
                        string = (String)JRSchedulingServiceQuartzImpl.this.addTaskToRemove.removeFirst();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        try {
                            JRSchedulingServiceQuartzImpl.this.addTaskToRemove.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (null != string) {
                    try {
                        JRSchedulingServiceQuartzImpl.this.removeScheduledTask(string);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                object = this;
                synchronized (object) {
                    bl = !this.SEDU;
                }
            }
            ServiceLogger.logDebug(6610015, Thread.currentThread().getName(), 6);
        }
    }
}

