/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.quartz;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import jet.ReportEnv;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.Dbs;
import jet.server.intf.jrs.ScheduleControllerService;
import jet.server.log.ServiceLogger;
import jet.server.util.CreateDefExProperties;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzEnv {
    public static final String PROPERTIES_FILE = "org.quartz.properties";
    private static final String SEDU = "connectionProvider.class";
    public static final String PROP_JOB_STORE_TABLE_PREFIX = "JR_QRTZ_";
    public static final String TRIGGER_PREFIX = "JR_TRG_";
    public static final String BASIC_TRIGGER_PREFIX = "JR_BASIC_TRG_";
    public static final String JOB_PREFIX = "JR_JOB_";
    public static final String DETAULT_TRIGGER_GROUP = "JR_DETAULT_GROUP";
    public static final String LOCKS_TRIGGER_ACCESS = "TRIGGER_ACCESS";
    public static final String LOCKS_JOB_ACCESS = "JOB_ACCESS";
    public static final String LOCKS_CALENDAR_ACCESS = "CALENDAR_ACCESS";
    public static final String LOCKS_STATE_ACCESS = "STATE_ACCESS";
    public static final String LOCKS_MISFIRE_ACCESS = "MISFIRE_ACCESS";
    private static DatabaseImpl append = null;
    private static ScheduleControllerService buildDefaultEnv = null;

    public static String getQuartzPropName() {
        String string = ReportEnv.homePath;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + "bin" + File.separator + "quartz.properties";
    }

    public static Scheduler createScheduler(String string, String string2) throws SchedulerException {
        String string3 = QuartzEnv.getQuartzPropName();
        CreateDefExProperties createDefExProperties = new CreateDefExProperties(true);
        try {
            createDefExProperties.load(string3);
        }
        catch (IOException iOException) {
            throw new SchedulerException((Throwable)iOException);
        }
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        Properties properties = QuartzEnv.buildDefaultEnv(createDefExProperties);
        properties.setProperty("org.quartz.scheduler.instanceName", string);
        properties.setProperty("org.quartz.scheduler.instanceId", string2);
        stdSchedulerFactory.initialize(properties);
        return stdSchedulerFactory.getScheduler();
    }

    public static Properties buildDefaultEnv(ExProperties exProperties) throws SchedulerException {
        if (null == exProperties) {
            throw new SchedulerException("The properites of quartz.properties is null");
        }
        Properties properties = new Properties();
        int n = exProperties.getProperty("org.quartz.threadPool.threadCount", 10);
        properties.setProperty("org.quartz.threadPool.threadCount", String.valueOf(n));
        n = exProperties.getProperty("org.quartz.scheduler.idleWaitTime", 2000);
        properties.setProperty("org.quartz.scheduler.idleWaitTime", String.valueOf(n));
        properties.setProperty("org.quartz.threadPool.threadPriority", "5");
        properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        properties.setProperty("org.quartz.jobStore.isClustered", String.valueOf(ServerEnv.isClusterEnabled()));
        n = exProperties.getProperty("org.quartz.jobStore.clusterCheckinInterval", 15000);
        properties.setProperty("org.quartz.jobStore.clusterCheckinInterval", String.valueOf(n));
        n = exProperties.getProperty("org.quartz.jobStore.maxMisfiresToHandleAtATime", 20);
        properties.setProperty("org.quartz.jobStore.maxMisfiresToHandleAtATime", String.valueOf(n));
        n = exProperties.getProperty("org.quartz.jobStore.misfireThreshold", 10000);
        properties.setProperty("org.quartz.jobStore.misfireThreshold", String.valueOf(n));
        String string = exProperties.getProperty("org.quartz.jobStore.driverDelegateClass", "");
        ServiceLogger.logDebug(4610021, string, 6);
        String string2 = append.getProductDBName();
        if (null == string || 0 == string.length()) {
            string = string2.equalsIgnoreCase("DB2") || string2.startsWith("DB2") ? "org.quartz.impl.jdbcjobstore.DB2v8Delegate" : (string2.equalsIgnoreCase("Oracle") || string2.startsWith("Oracle") ? "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate" : (string2.equalsIgnoreCase("HSQL Database Engine") || string2.startsWith("HSQL Database Engine") ? "org.quartz.impl.jdbcjobstore.HSQLDBDelegate" : (string2.equalsIgnoreCase("Microsoft SQL Server") || string2.startsWith("Microsoft SQL Server") || string2.equalsIgnoreCase("SQL Server") || string2.startsWith("SQL Server") || string2.equalsIgnoreCase("Adaptive Server Enterprise") || string2.startsWith("Adaptive Server Enterprise") ? "org.quartz.impl.jdbcjobstore.MSSQLDelegate" : "org.quartz.impl.jdbcjobstore.StdJDBCDelegate")));
        }
        ServiceLogger.logDebug(4610021, string, 4);
        properties.setProperty("org.quartz.jobStore.driverDelegateClass", string);
        properties.setProperty("org.quartz.jobStore.class", "jet.server.jrc.quartz.JRJobStoreSupport");
        String string3 = Dbs.fullTableName(append.getProperty("schema"), PROP_JOB_STORE_TABLE_PREFIX);
        ServiceLogger.logDebug(4610026, string3, 4);
        properties.setProperty("org.quartz.jobStore.tablePrefix", string3);
        properties.setProperty("org.quartz.jobStore.useProperties", "false");
        properties.setProperty("org.quartz.jobStore.dontSetAutoCommitFalse", "false");
        properties.setProperty("org.quartz.jobStore.txIsolationLevelSerializable", "true");
        properties.setProperty("org.quartz.jobStore.dataSource", "quartzDS");
        properties.setProperty("org.quartz.dataSource.quartzDS.connectionProvider.class", "jet.server.jrc.quartz.JRConnectionProvider");
        String string4 = null;
        string4 = string2.equalsIgnoreCase("Microsoft SQL Server") || string2.startsWith("Microsoft SQL Server") ? "SELECT * FROM JR_QRTZ_LOCKS WITH(ROWLOCK, UPDLOCK) WHERE LOCK_NAME = ?" : "SELECT * FROM JR_QRTZ_LOCKS WHERE LOCK_NAME = ? FOR UPDATE";
        properties.setProperty("org.quartz.jobStore.selectWithLockSQL", string4);
        return properties;
    }

    public static void setDatabase(DatabaseImpl databaseImpl) {
        append = databaseImpl;
    }

    public static DatabaseImpl getDatabase() {
        return append;
    }

    public static ScheduleControllerService getScheduleController() {
        return buildDefaultEnv;
    }

    public static void setScheduleController(ScheduleControllerService scheduleControllerService) {
        buildDefaultEnv = scheduleControllerService;
    }
}

