/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import jet.server.api.RemoteFileService;
import jet.server.api.RptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.resource.AdhocResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;
import jet.server.storage.StoragePathInfo;

public class AdhocResourceManagerImpl
implements AdhocResourceManager {
    public static final String UPLOAD_FOLDER = "upload";
    private String HISTORY;
    private String REALM;
    private String SEDU;
    private RemoteFileService add;
    private Storage append;

    public AdhocResourceManagerImpl(RptServer rptServer) {
        try {
            this.HISTORY = HttpUtil.getRealmDir();
            this.REALM = rptServer.getAdminService().getSecurityAdminService().getActiveRealm();
            this.append = StorageEnv.getStorage(rptServer);
            this.add = rptServer.getRemoteFileService();
            this.SEDU = this.add.getRemoteFileSeparator();
        }
        catch (StorageException storageException) {
            ServiceLogger.logError((Throwable)((Object)storageException));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private String HISTORY(String string, String string2, boolean bl) {
        return this.REALM(string, string2, null, bl);
    }

    private String REALM(String string, String string2, String string3, boolean bl) {
        ServiceLogger.logDebug("AdhocResourceManager.getUploadPath: user=" + string + ", folder=" + string2 + ", fileName=" + string3 + ", isRelative=" + bl, 6);
        String string4 = "";
        if (!bl) {
            string4 = string4 + this.HISTORY;
        }
        string4 = string4 + this.REALM + this.SEDU + (string == null || string.isEmpty() ? "" : string + this.SEDU) + UPLOAD_FOLDER;
        if (string2 != null && string2.length() > 0) {
            if (!string2.startsWith(this.SEDU) && !string2.startsWith("/")) {
                string4 = string4 + this.SEDU;
            }
            string4 = string4 + string2;
        }
        if (string3 != null && string3.length() > 0) {
            if (!string4.endsWith(this.SEDU)) {
                string4 = string4 + this.SEDU;
            }
            string4 = string4 + string3;
        }
        return string4;
    }

    @Override
    public String[] listFiles(String string, String string2) throws Exception {
        ServiceLogger.logDebug("AdhocResourceManager.listFiles: user=" + string + ", folder=" + string2, 6);
        try {
            ArrayList arrayList = this.append.list(Storage.StorageRoot.REALM, this.HISTORY(string, string2, true));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                StoragePathInfo storagePathInfo = (StoragePathInfo)arrayList.get(i);
                if (storagePathInfo.isDir()) continue;
                String string3 = storagePathInfo.getPath();
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                arrayList2.add(string3);
            }
            return arrayList2.toArray(new String[0]);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new Exception(throwable);
        }
    }

    public String[] listFolders(String string, String string2) throws Exception {
        ServiceLogger.logDebug("AdhocResourceManager.listFolders: user=" + string + ", parentFolder=" + string2, 6);
        try {
            ArrayList arrayList = this.append.list(Storage.StorageRoot.REALM, this.HISTORY(string, string2, true));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                StoragePathInfo storagePathInfo = (StoragePathInfo)arrayList.get(i);
                if (!storagePathInfo.isDir()) continue;
                String string3 = storagePathInfo.getPath();
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                arrayList2.add(string3);
            }
            return arrayList2.toArray(new String[0]);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new Exception(throwable);
        }
    }

    @Override
    public void delete(String string, String string2, String string3) throws Exception {
        ServiceLogger.logDebug("AdhocResourceManager.delete: user=" + string + ", folder=" + string2 + ", fileName=" + string3, 6);
        try {
            this.deleteFile(this.REALM(string, string2, string3, true));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new Exception(throwable);
        }
    }

    private void deleteFile(String string) throws Exception {
        this.append.delete(Storage.StorageRoot.REALM, string);
    }

    @Override
    public InputStream readFile(String string, String string2, String string3) throws Exception {
        ServiceLogger.logDebug("AdhocResourceManager.readFile: user=" + string + ", folder=" + string2 + ", fileName=" + string3, 6);
        try {
            File file = this.append.get(Storage.StorageRoot.REALM, this.REALM(string, string2, string3, true));
            return this.add.readFile(this.REALM(string, string2, string3, false));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new Exception(throwable);
        }
    }

    @Override
    public void saveFile(String string, String string2, String string3, InputStream inputStream) throws Exception {
        ServiceLogger.logDebug("AdhocResourceManager.saveFile: user=" + string + ", folder=" + string2 + ", fileName=" + string3, 6);
        try {
            this.add.mkdirs(this.HISTORY(string, string2, false));
            this.add.writeFile(inputStream, this.REALM(string, string2, string3, false));
            this.append.add(Storage.StorageRoot.REALM, this.REALM(string, string2, string3, true), null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new Exception(throwable);
        }
    }

    @Override
    public void removeUpload(String string, String string2) {
        ServiceLogger.logDebug("AdhocResourceManager.removeUpload: realm=" + string + ", user=" + string2, 6);
        if (!string.equals(this.REALM)) {
            return;
        }
        String string3 = this.HISTORY(string2, null, true);
        try {
            ArrayList arrayList = this.append.listAll(Storage.StorageRoot.REALM, string3);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.append.delete(((StoragePathInfo)arrayList.get(i)).getPath());
            }
        }
        catch (StorageException storageException) {
            ServiceLogger.logError((Throwable)((Object)storageException));
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    @Override
    public void copyTo(String string, String string2, String string3, String string4) throws Exception {
        ServiceLogger.logDebug("AdhocResourceManager.copyTo: user=" + string + ", folder=" + string2 + ", fileName=" + string3 + ", destPath=" + string4, 6);
        try {
            if (!string4.endsWith(this.SEDU)) {
                string4 = string4 + this.SEDU;
            }
            string4 = string4 + string3;
            this.add.copy(this.REALM(string, string2, string3, false), string4);
            String string5 = this.append.map(Storage.StorageRoot.HISTORY, "").getCanonicalPath();
            if (!this.SEDU.equals(File.separator)) {
                string5 = string5.replace(File.separator, this.SEDU);
            }
            if (string4.startsWith(string5)) {
                String string6 = string4.substring(string5.length() + 1);
                string6 = this.append.getStorageEnv().relativeStoragePath(Storage.StorageRoot.HISTORY, string6, 2);
                this.append.add(Storage.StorageRoot.HISTORY, string6, null);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new Exception(throwable);
        }
    }
}

