/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.db.resource.FolderRecord;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.security.User;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.PathInfoImpl;

public class FolderImpl
extends NodeImpl
implements Folder {
    private FolderRecord SEDU;
    private Hashtable addElement;
    private boolean append = false;

    public FolderImpl() {
        this(new FolderRecord());
        this.fakeNode = true;
    }

    public FolderImpl(String string) {
        super(string);
        this.setNodeType((byte)1);
    }

    public FolderImpl(FolderRecord folderRecord) {
        super(folderRecord);
        this.SEDU = folderRecord;
        this.addElement = new Hashtable();
    }

    @Override
    public void remove() {
        this.SEDU = null;
        this.addElement.clear();
        super.remove();
    }

    @Override
    public String getRealPath() {
        return this.SEDU.getRealPath();
    }

    public void setRealPath(String string) {
        this.SEDU.setRealPath(string);
    }

    @Override
    public void addChild(Node node) {
        if (this.append) {
            this.addElement.put(node.getName(), node);
        } else {
            this.addElement.put(node.getName().toUpperCase(), node);
        }
    }

    @Override
    public Vector getChildren(User user) {
        Vector vector = new Vector();
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public synchronized Vector getChildren() {
        Vector vector = new Vector();
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public boolean removeChild(Node node) {
        if (this.addElement.containsKey(node.getName().toUpperCase())) {
            this.addElement.remove(node.getName().toUpperCase());
            return true;
        }
        return false;
    }

    @Override
    public String getOwnerName() {
        return this.SEDU.getOwnerName();
    }

    @Override
    public void setOwnerName(String string) {
        this.SEDU.setOwnerName(string);
    }

    @Override
    public boolean checkPermission(User user, Permission permission) {
        String string = this.getOwnerName();
        return string != null && string.equals(user.getName()) || this.isValidAdminUser(user);
    }

    @Override
    public String toString() {
        return "FolderImpl@" + this.hashCode() + "[" + super.toString() + ", childNum=" + this.addElement.size() + ", isRoot=" + this.isRoot() + "]";
    }

    @Override
    public boolean hasChild(String string) {
        return this.addElement.containsKey(string.toUpperCase());
    }

    @Override
    public Node getChild(String string) {
        if (this.append) {
            return (Node)this.addElement.get(string);
        }
        return (Node)this.addElement.get(string.toUpperCase());
    }

    @Override
    public void setParent(Node node) {
        super.setParent(node);
        String string = node.getAbsolutePath();
        if (node == this && node.getOrganization() != null) {
            string = "/<" + node.getOrganization() + ">" + string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.setAbsolutePath(string + this.SEDU.getName());
    }

    @Override
    public PathInfo toPathInfo(String string) {
        PathInfoImpl pathInfoImpl = super.getPathInfo(string);
        pathInfoImpl.setRealPath(this.getRealPath());
        pathInfoImpl.setArchiveNewVersion(this.isArchiveNewVersion());
        pathInfoImpl.setMaxVersionAmount(this.getMaxVersionAmount());
        pathInfoImpl.setEnableArchivePolicy(this.isEnableArchivePolicy());
        pathInfoImpl.setShared(this.isShared());
        pathInfoImpl.setEnableDynamicResource(this.isEnableDynamicResource());
        return pathInfoImpl;
    }

    public Vector getPublicChildren() {
        Vector vector = new Vector();
        String string = "/USERFOLDERPATH".substring(1).toUpperCase();
        String string2 = "/COMPONENT_LIB".substring(1).toUpperCase();
        Enumeration enumeration = this.addElement.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.equals(string) || string3.equals(string2)) continue;
            vector.addElement(this.addElement.get(string3));
        }
        return vector;
    }

    @Override
    public boolean setProperties(Hashtable hashtable) {
        int n = CSUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.archive_new_version"), false);
        String string = (String)hashtable.get("jrs.node_real_path");
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_archive_policy"), false);
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.node_share"), false);
        boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_dynamic_resource"), false);
        boolean bl5 = false;
        if (n != this.SEDU.getMaxVersionAmount() || bl != this.SEDU.isArchiveNewVersion() || string == null && this.SEDU.getRealPath() != null || string != null && !string.equalsIgnoreCase(this.SEDU.getRealPath()) || bl2 != this.SEDU.isEnableArchivePolicy() || bl3 != this.SEDU.isShared() || bl4 != this.SEDU.isEnableDynamicResource()) {
            bl5 = true;
            this.SEDU.setMaxVersionAmount(n);
            this.SEDU.setArchiveNewVersion(bl);
            this.SEDU.setRealPath(string);
            this.SEDU.setEnableArchivePolicy(bl2);
            this.SEDU.setShared(bl3);
            this.SEDU.setEnalbeDynamicResource(bl4);
        }
        return bl5;
    }

    @Override
    public boolean isArchiveNewVersion() {
        if (this.isEnableArchivePolicy()) {
            return this.SEDU.isArchiveNewVersion();
        }
        return true;
    }

    @Override
    public boolean isEnableArchivePolicy() {
        return this.SEDU.isEnableArchivePolicy();
    }

    @Override
    public int getMaxVersionAmount() {
        if (this.isArchiveNewVersion()) {
            return this.SEDU.getMaxVersionAmount();
        }
        return 0;
    }

    public void setMaxVersionAmount(int n) {
        this.SEDU.setMaxVersionAmount(n);
    }

    public boolean isShared() {
        return this.SEDU.isShared();
    }

    public void setShared(boolean bl) {
        this.SEDU.setShared(bl);
    }

    public void replaceChildName(String string, String string2) {
        Object v = this.addElement.remove(string.toUpperCase());
        if (v != null) {
            this.addElement.put(string2.toUpperCase(), v);
        }
    }

    @Override
    public boolean isEnableDynamicResource() {
        return this.SEDU.isEnableDynamicResource();
    }

    public void setEnableDynamicResource(boolean bl) {
        this.SEDU.setEnalbeDynamicResource(bl);
    }

    @Override
    public boolean isFakeFolder() {
        return this.fakeNode;
    }

    @Override
    public void setAbsolutePath(String string) {
        super.setAbsolutePath(string);
        if (this.getAbsolutePath().equals("/USERFOLDERPATH")) {
            this.append = true;
        }
    }
}

